#!/usr/bin/rexx
/*
   Name:    "ShowSize.rex"

   Invoke:  "java org.apache.bsf.Main -lang rexx -in ShowSize.rex"
                or
            "java org.apache.bsf.Main            -in ShowSize.rex"
                or
             "rexxj ShowSize.rex" (Windows)
                or
             "rexxj ShowSize.rex" (Unix)
                or
             "rexx ShowSize.rex"

   Purpose:  create a little resizable window with a push button to reveal the actual
             size; adds EventListeners in order for Rexx to be notified, if a button
             is pressed or the Window closed (by pressing the System close button)

             ===> This version uses the ability to prioritize requests, by using
                  the text "/*2*/" as the very first text in the string sent in case
                  an event took place.

             This version works also, if called from the command line, as it is able
             to load Java and the bsf4rexx support by itself.

   Needs:    IBM's "Bean Scripting Framework" (BSF)
             (cf. "http://oss.software.ibm.com/developerworks/projects/bsf")

             and the package "bsf4rexx", the "Augsburg version" as of 2003
             (cf. "http://nestroy.wi-inf.uni-essen.de/Forschung/rgf/Entwicklung.html")

   Date:    2001-04-18, 2003-01-23, 2003-05-10, 2005-06-05
            2005-12-28, added Apache license

   Author:   Rony G. Flatscher, University of Essen, WU Wien University,
             derived from Peter Kalender's work for the "Essener Ski Seminar",
             University of Essen (Oct 2000 to Feb 2001)

   last change: $Revision: 266 $ $Author: rony $ $Date: 2008-07-19 16:41:58 +0200 (Sat, 19 Jul 2008) $

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

.bsf~bsf.import("java.awt.Frame" , "awtFrame" )    -- bsf.import Java class
.bsf~bsf.import("java.awt.Button", "awtButton")    -- bsf.import Java class
.bsf~bsf.import("java.awt.Label" , "awtLabel" )    -- bsf.import Java class

window = .awtFrame~new("Show Size")
-- window~bsf.addEventListener('window', 'windowClosing', 'call BSF "exit"')
   -- this event-adapter message prioritizes this particular message
window~bsf.addEventListener('window', 'windowClosing', '/*2*/call BSF "exit"')

button = .awtButton~new('Press me!')
button ~ bsf.addEventListener('action', '', 'call ShowSize window, label')

label = .awtLabel~new
label~setAlignment(label~bsf.getFieldValue("CENTER"))

window ~~add("Center", label) ~~add("South", button) ~~pack
window ~~setSize(250, 150) ~~setLocation(100, 100) ~~show ~~toFront

secs=3
info="sleeping" secs  "seconds ..."
label~setText(info)
say info
call bsf 'sleep', secs  /* sleep i seconds using bsf4rexx       */

do i=100 to 300 by 10   -- animate the window a little bit
   call bsf 'sleep', .1         /* sleep i seconds using bsf4rexx       */
   window  ~setLocation(i, (i/3)%1)
   window ~~setSize((i*.9)%1, 100+i%3 ) ~~show
   call showSize window, label
end
call showSize window, label

do forever
        /* using the OO-version a Java "null" string will be translated automatically
        into the Object Rexx equivalent, i.e. .nil        */
   a = .bsf~bsf.pollEventText(1000) /* wait for an eventText to be sent,
                                   after 1 second return anyway */
   if a=.nil then say "Rexx: no eventText so far ..."
   else
   do
      say "received the following eventText: ["a"]"
      interpret a               /* execute as a Rexx program            */
      if result= "SHUTDOWN, REXX !" then leave  /* JVM will be shutdown */
      say "Rexx: sleeping" secs "secs"
      call bsf 'sleep', secs    /* sleep i seconds using bsf4rexx       */
      say "Rexx: awakened!"
   end
end

exit


ShowSize: procedure
   use arg window, label                        /* get proxy objects    */

   parse value (window~getSize~toString) with "width=" width ",height=" height "]"
   label~setText(width "/" height )
   return

::requires BSF.CLS    -- include direct Object Rexx BSF support

