#!/usr/bin/rexx
/*
    name:      Snippet108.rex
    purpose:   Transcribe the swt Java example 'Snippet108' to ooRexx using BSF4Rexx
    author:    Rony G. Flatscher
    date:      2006-02-03

    url:       ooRexx:         <http://www.ooRexx.org>
               swt:            <http://www.eclipse.org/swt/>
               Snippet108.java <http://dev.eclipse.org/viewcvs/index.cgi/%7Echeckout%7E/org.eclipse.swt.snippets/src/org/eclipse/swt/snippets/Snippet108.java>
               Java source:    <http://java.sun.com>

    directions:   - download ooRexx and install it
                  - make sure Java is installed on your machine
                  - download BSF4Rexx and install it
                  - download the standalone version of swt ("Standard Widget Toolkit"), a fast set of
                    Java classes, replacing awt/swing, available for all major platforms (Linux,
                    MacOS, Windows), cf. <http://www.eclipse.org/swt/>

   last change: $Revision: 266 $ $Author: rony $ $Date: 2008-07-19 16:41:58 +0200 (Sat, 19 Jul 2008) $

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------

*/

   -- get easy access to static fields, wrap them up in an ooRexx directory proxy, new BSF4Rexx feature as of 2006-02-02
swt=bsf.wrapStaticFields("org.eclipse.swt.SWT")

display=.bsf~new("org.eclipse.swt.widgets.Display")
shell  =.bsf~new("org.eclipse.swt.widgets.Shell", display)

label  =.bsf~new("org.eclipse.swt.widgets.Label", shell, swt~none)
label~setText("Enter your name:")

text   =.bsf~new("org.eclipse.swt.widgets.Text", shell, swt~border)
rowData=.bsf~new("org.eclipse.swt.layout.RowData", 100, swt~default)
text~setLayoutData(rowData)
   -- event listener to read content of text field, if it got modified
text~bsf.addEventListener("modify", "", 'say "So far you have entered:" pp(text~getText)')

   -- we need the Button class more than once, hence importing it into ooRexx under the name "swtButton"
.bsf~bsf.import("org.eclipse.swt.widgets.Button", "swtButton")
ok=.swtButton~new(shell, swt~push)
ok~setText("OK")
ok~bsf.addEventListener("selection", "widgetSelected", "say 'OK'")

cancel=.swtButton~new(shell, swt~push)
cancel~setText("Cancel")
cancel~bsf.addEventListener("selection", "widgetSelected", "say 'Cancel'")

shell~setDefaultButton(cancel)
shell~setLayout(.bsf~new("org.eclipse.swt.layout.RowLayout"))
shell~~pack~~open

do while shell~isDisposed=.false
   if display~readAndDispatch=.false then
   do
      rexxCode=bsf.pollEventText(1) -- come back after 1/1000 second
      if .nil<>rexxCode then
         interpret rexxCode         -- execute as Rexx program
      display~sleep
   end
end

::requires BSF.CLS      -- get Java support

