/* A silly little calculator implemented in Rexx using
   Java components for the UI. 2001-05-02, 2003-01-23, ---rgf, 2003-05-10
   ("bsf\samples\bsh\calculator.js" served as an example)

   2008-09-09, rgf, changed "registerBean" and "registerBeanStrict" to their synonyms
                    "new" and "newStrict" which better describe the semantics of
                    these subfunctions

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."


f =  bsf("new", "", "java.awt.Frame", "BSH Calculator (REXX)")
call bsf "addEventListener", f, "window", "windowClosing", "call bsf 'exit'"

-- f1 = bsf("new", "", "java.awt.TextField", 20)
f1 = bsf("newStrict", "", "java.awt.TextField", "int", 20)
call bsf "addEventListener", f1, "action", "", "call doMath /*action*/"

-- f2 = bsf("new", "", "java.awt.TextField", 20)
f2 = bsf("newStrict", "", "java.awt.TextField", "int", 20)
call bsf "addEventListener", f2, "text", "", "call doMath /*text*/"

p  = bsf("new", "", "java.awt.Panel")
call bsf "invoke", p, "setLayout", bsf("new", "", "java.awt.GridLayout", 2, 2)

call bsf "invoke", p, "add", bsf("new", "", "java.awt.Label", "Enter Operand")
call bsf "invoke", p, "add", f1

call bsf "invoke", p, "add", bsf("new", "", "java.awt.Label", "Enter Operand")
call bsf "invoke", p, "add", f2

call bsf "invoke", f, "add", "North",  p
call bsf "invoke", f, "add", "Center", bsf("new", "", "java.awt.Label", "Results:")


p =  bsf("new", "", "java.awt.Panel")
call bsf "invoke", p, "setLayout", bsf("new", "", "java.awt.GridLayout", 4, 2)

call bsf "invoke", p, "add", bsf("new", "", "java.awt.Label", "Sum")
sum = bsf("new", "", "java.awt.TextField", 20)
call bsf "invoke", p, "add", sum

call bsf "invoke", p, "add", bsf("new", "", "java.awt.Label", "Difference")
diff= bsf("new", "", "java.awt.TextField", 20)
call bsf "invoke", p, "add", diff

call bsf "invoke", p, "add", bsf("new", "", "java.awt.Label", "Product")
prod= bsf("new", "", "java.awt.TextField", 20)
call bsf "invoke", p, "add", prod

call bsf "invoke", p, "add", bsf("new", "", "java.awt.Label", "Quotient")
quo = bsf("new", "", "java.awt.TextField", 20)
call bsf "invoke", p, "add", quo

call bsf "invoke", f, "add", "South", p

call bsf "invoke", f, "pack"
call bsf "invoke", f, "show"
call bsf "invoke", f, "toFront"

do forever
   a=bsf("pollEventText")
   say "... received: ["a"]"
   interpret a
end
exit

getField: procedure
   parse arg f
   t=bsf("invoke", f, "getText")
   if t="" then return 0
   return t

doMath:
   n1 = getField(f1); if n1="-" then n1=-1;else if n1="+" then n1=1
   n2 = getField(f2); if n2="-" then n2=-1;else if n2="+" then n2=1
   call bsf "invoke", sum, "setText", n1+n2
   call bsf "invoke", diff,"setText", n1-n2
   call bsf "invoke", prod,"setText", n1*n2
   if n2 = 0 then call bsf "invoke", quo, "setText", "DIVISION by 0 !!"
             else call bsf "invoke", quo, "setText", n1/n2
   return

