/* This is a simple demo of a Rexx (modelled after the JavaScript) script that
   uses the Java URL class to download some content from some URL. rgf, 2003-02-17, 2003-05-10

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2003-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

URL_ADDR = "http://www.ooRexx.org/";
say "connecting to:" URL_ADDR
url=.bsf~new("java.net.URL", URL_ADDR)    -- create a java.net.URL instance
content = url~getContent                  /* get the content object, a <java.io.FilterInputStream> */
say "Downloading .. "

size=8*1024    -- use chunks of maximum 8 KB
byteArray=.bsf4rexx~array.class~newInstance(.bsf4rexx~byte, size)

len=""
do until len=-1
   len=content~read(byteArray, 0, size)   -- read the content into the byte array
               -- create a Java String off the byte-array, use the read bytes as its length
   if len>0 then .output~charout(left(.bsf~new("java.lang.String", byteArray)~toString, len))
end

::requires BSF.CLS    -- Object Rexx wrapper classes
