/*
   Name:    "EuroCalcJava.rex"

   Invoke:  "java org.apache.bsf.Main -lang rexx -in EuroCalcJava.rex"
                or
            "java org.apache.bsf.Main            -in EuroCalcJava.rex"
                or
             "rexxj EuroCalcJava.rex"
                or
             "rexx EuroCalcJava.rex"


   Purpose:  a Java solution using Java's "awt" (abstract window toolkit) matching
             the Windows OODialog-based "Euro3Calc" application, portable

   Needs:    IBM's "Bean Scripting Framework" (BSF)
             (cf. "http://oss.software.ibm.com/developerworks/projects/bsf")

             and the package "bsf4rexx"
             (cf. "http://nestroy.wi-inf.uni-essen.de/Forschung/rgf/Entwicklung.html")

   Date:    2001-11-14
            2003-01-23 (on the way from Augsburg to Vienna), 2003-05-10
            2003-09-05 creating java.awt.Color with giving strict types for arguments
            2005-12-28 rgf, changed license
            2008-09-09, rgf, changed "registerBean" and "registerBeanStrict" to their synonyms
                             "new" and "newStrict" which better describe the semantics of
                             these subfunctions


   Author:   Rony G. Flatscher, University of Augsburg, WU Wien University,
             (cf. "http://nestroy.wi-inf.uni-essen.de/Lv/seminare/ws0001/index-e.html");

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2006 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/
if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

say "...arrived in Rexx!"
call time "r"
numeric digits 10

call setup_euro_infos   /* setup Euro-currency information      */
call setup_java_awt_gui /* setup awt-GUI        */

say "...finished with setting up, time needed:" time("e")

do forever      /* wait and fetch the text to be sent by Java           */
   a = bsf("pollEventText")     /* wait for an eventText to be sent     */
   say "debug: eventText from Java: ["a"]"
   interpret a                  /* execute as a Rexx program    */
   if result= "SHUTDOWN, REXX !" then leave     /* JVM will be shutdown in 1/10sec      */
end

exit



     /* action handler, if any key was typed in the input test-field */
key_Typed : procedure expose euro.
  parse arg input
  call dothework input  /* now do the work ...  */
  return


    /* make choice and return appropriate argument      */
choose:procedure
  if arg(1)=1 then return arg(2)
              else return arg(3)


        /* set a stem-array with the rates of exchanges */
setup_euro_infos : PROCEDURE EXPOSE euro.     /* expose stem, i.e. belongs to caller  */
    euro.ats =    13.760300;  euro.ATS.eCountry = "ATS: Austria (Schilling)"
    euro.bef =    40.339900;  euro.BEF.eCountry = "BEF: Belgium (Franc)"
    euro.dem =     1.955830;  euro.DEM.eCountry = "DEM: Germany (Mark)"
    euro.eur =     1.000000;  euro.EUR.eCountry = "EUR: Europe (Euro)"
    euro.fim =     5.945730;  euro.FIM.eCountry = "FIM: Finnland (Mark)"
    euro.frf =     6.559570;  euro.FRF.eCountry = "FRF: France (Franc)"
    euro.iep =     0.787564;  euro.IEP.eCountry = "IEP: Ireland (Pound)"
    euro.itl =  1936.270000;  euro.ITL.eCountry = "ITL: Italy (Lire)"
    euro.luf =    40.339900;  euro.LUF.eCountry = "LUF: Luxembourg (Franc)"
    euro.nlg =     2.203710;  euro.NLG.eCountry = "NLG: Netherland (Gulden)"
    euro.pte =   200.482000;  euro.PTE.eCountry = "PTE: Portugal (Escudo)"
    euro.esp =   166.386000;  euro.ESP.eCountry = "ESP: Spain (Peseta)"
    euro.grd =   340.750000;  euro.GRD.eCountry = "GRD: Greece (Drachmen)"

        /* determine processing order of currencies, will also be used as index
           into "euro."-stem, hence UPPERCASE (!) spelling     */
    euro.eOrder = "EUR ATS BEF DEM ESP FIM FRF GRD IEP ITL LUF NLG PTE"
    RETURN


        /* whenever a keytype occurred recalc values    */
DoTheWork : procedure expose euro.
  parse arg input

  /* parse first three words, translate them into uppercase       */
        /* bug in OS/2's JRE 1.1.8: value of a TextField only set after first
           call which retrieves the value of the TextField, hence a dummy call first */
call bsf 'invoke', input, 'getText'

  PARSE UPPER VALUE bsf('invoke', input, 'getText') WITH Amount InputCurrency .

        /* RGF - clear message fields */
  call bsf 'invoke', "label."401,  "setText", date("S") time()
  call bsf 'invoke', "label."402,  "setText", ""

  IF Amount = "" | Amount = 1 THEN      /* nothing given, show exchange rates  */
  DO
     call display 1     /* display value for 1 Euro     */
     call bsf 'invoke', "label."402,  "setText", "(Exchange rates)"
     return
  END

  IF DATATYPE(Amount, "Number") = 0 THEN
  DO
     call bsf 'invoke', "label."402,  "setText", "Input Currency not a number!"
     call beep 500, 10
     RETURN
  END

  IF InputCurrency = "" THEN InputCurrency = "EUR"      /* default      */
  ELSE IF wordpos(InputCurrency, euro.eOrder) = 0 THEN
  DO
     call bsf 'invoke', "label."402, "setText", "Unknown currency given!"
     call beep 200, 10
     RETURN
  END
  call display amount/euro.InputCurrency        /* display values       */
  return


  /* display currency values for given euro-amount      */
display : procedure expose euro.
  parse arg euro_betrag


  betrag_id=201
  do i=201 to 201+words(euro.eOrder)-1

     tmpEuro = word(euro.eOrder, i-201+1)
     IF euro_betrag = 1 THEN stellen=6  /* rate of exchange ? */
                        ELSE stellen=2

     call bsf 'invoke', "label."i, "setText", FORMAT(euro_betrag*euro.tmpEuro,,stellen)
  END
  return


    /* create and setup up awt-objects (a frame window, a button, labels and
       an input text field; add event listeners for interesting events  */
setup_java_awt_gui : procedure expose euro.
        /* create a color       */
/*
  bgColour =BSF( 'new', '',    'java.awt.Color', '150', '150', '250')
*/
         /* 2003-09-05, changed to strict-form which allows indicating the type of the arguments;
                        reason: there are two Color-constructors which could match, one with three
                                float args in the range of 0.0-1.0, one with three int args in the
                                range of 0-255 */
  bgColour =BSF( 'newStrict', '',    'java.awt.Color', 'int', '150', 'int', '150', 'int', '250')

        /* create and size frame window */
  frame  = BSF( 'new', '',    'java.awt.Frame', 'EuroCalculator')
  Call BSF 'invoke', frame, 'setBackground', bgColour

        /* remove layout manager or *strange* things happen ... */
  call bsf 'invoke', frame, 'setLayout', '.NIL'

  call BSF 'invoke', frame, 'show'     /* now insets are known  */
  call BSF 'invoke', frame, 'hide'     /* hide frame            */
  insets= bsf('invoke', frame, 'getInsets')     /* get and parse them   */
  parse value bsf('invoke', insets, 'toString') with . "top=" top "," "left=" left "," "bottom=" bottom "," "right=" right "]" .

  w_width =660
  w_col1  = 10
  w_col2  = w_width/2+w_col1
  w_height=300

  tot_width =w_width +left+right
  tot_height=w_height+top +bottom

  call BSF 'invoke', frame, 'setSize',       tot_width, tot_height
  call BSF 'invoke', frame, 'setResizable',  0

        /* get physical screen dimensions and center window */
  dim       = bsf('invoke', bsf('invoke', frame, 'getToolkit'), 'getScreenSize')
  scr_height= bsf('getFieldValue', dim, 'height')
  scr_width = bsf('getFieldValue', dim, 'width')

  call bsf 'invoke', frame, 'setLocation', (scr_width-tot_width)%2 , 0

        /* create and set labels, then add them to the frame    */
        /* get constant frame values                            */
  label_left  =bsf('getStaticValue', 'java.awt.Label', 'LEFT'  )
  label_right =bsf('getStaticValue', 'java.awt.Label', 'RIGHT' )
  label_center=bsf('getStaticValue', 'java.awt.Label', 'CENTER')

  do id=201 to 213      /* id of amount-label, appropriate currency-label       */
     if id=201 | id=208 then y=10 /* reset y-coordinate   */
     do j=0 to 100 by 100
        label=BSF( 'new', "label."id+j, 'java.awt.Label')

        call bsf 'invoke', label, 'setAlignment', choose(j=0, label_right, label_left)
        call bsf 'invoke', label, 'setSize',      choose(j=0, 115, 175), 16

                /* first eight currencies on left column      */
        x=choose(id<208, w_col1, w_col2) + choose(j=0, 0, 120)  /* add offset if necessary */
        call bsf 'invoke', label, 'setLocation',  x+left, y+top

                /* set values (exchange rates)  */
        idx=word(euro.eOrder, right(id,2)) /* get appropriate index        */
        call bsf 'invoke', label, 'setText',      choose(j=0, euro.idx, euro.idx.eCountry)
                /* add label to window  */
        call bsf 'invoke', frame, 'add',         label
     end

     y=y+20
  end

        /* create and set the two message labels        */
  do id=401 to 402
     label=bsf('new', "label."id, 'java.awt.Label')
     call bsf 'invoke', label, 'setAlignment', label_center
     call bsf 'invoke', label, 'setSize',      w_width-w_col1-left-right, 16
     call bsf 'invoke', label, 'setLocation',  w_col1+left, 170+choose(id=401,0,20)+top
     call bsf 'invoke', frame, 'add',          label
  end



        /* create and set the input field       */
  input=bsf('new', , 'java.awt.TextField')
  inp_width=200
  call bsf 'invoke', input, 'setSize',     inp_width, 20
  call bsf 'invoke', input, 'setLocation', (w_width-inp_width)/2+left, 220+top
  call bsf 'invoke', frame, 'add',         input


        /* create the leave push-button         */
  leave = BSF( 'new', '',      'java.awt.Button', 'Leave' )
  call bsf 'invoke', leave, 'setSize',     60, 20
  call bsf 'invoke', leave, 'setLocation', w_col2-40+left, 260+top
  call bsf 'invoke', frame, 'add',         leave

        /* make sure, window is on the front    */
  call bsf 'invoke', frame, 'show'      /* make sure frame-window is shown      */
  call bsf 'invoke', input, 'requestFocus'      /* set focus to input field     */

        /* define the events we are interested in and the text to be
             sent to us by Java , retrievable via "BSFPollEvents()"       */
  call BSF 'addEventListener', input,  'key',    'keyTyped',      'call key_typed "' || input || '"'
        /* get all action events        */
  call BSF 'addEventListener', leave,  'action', '',              'call BSF "exit"'
  call BSF 'addEventListener', frame, 'window', 'windowClosing', 'call BSF "exit"'

  return


