/*
   Name:    "Greetings.rex"

   Invoke:  "java org.apache.bsf.Main -lang rexx -in Greetings.rex"
                or
            "java org.apache.bsf.Main            -in Greetings.rex"
                or
            "rexxj Greetings.rex"
                or
            "rexx Greetings.rex"

   Purpose:  create a window with a choice-object and two text-fields and buttons;
             if the ok-button is pressed then popup another window and display what
             was chosen and entered.

   Needs:    IBM's "Bean Scripting Framework" (BSF)
             (cf. "http://oss.software.ibm.com/developerworks/projects/bsf")

             and the package "bsf4rexx"
             (cf. "http://nestroy.wi-inf.uni-essen.de/Forschung/rgf/Entwicklung.html")

   Date:    2001-04-18, 2003-01-23, 2003-05-10
            2003-09-05 creating java.awt.Color with giving strict types for arguments
            2005-12-28, added Apache license
            2008-09-09, rgf, changed "registerBean" and "registerBeanStrict" to their synonyms
                             "new" and "newStrict" which better describe the semantics of
                             these subfunctions

   Author:   Rony G. Flatscher, University of Essen, WU Wien University,
             derived from Peter Kalender's work for the "Essener Ski Seminar",
             University of Essen (Oct 2000 to Feb 2001)
             (cf. "http://nestroy.wi-inf.uni-essen.de/Lv/seminare/ws0001/index-e.html");

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2006 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

        /* create labels                */
label1 =  BSF( 'new', '',        'java.awt.Label', 'Gender: ')
label2 =  BSF( 'new', 'Label2',  'java.awt.Label', 'First Name: ' )
label3 =  BSF( 'new', 'Label3',  'java.awt.Label', 'Surname: ' )

        /* create a drop down list      */
DropDown= BSF( 'new', 'DropDown','java.awt.Choice' )
call BSF 'invoke', DropDown, 'addItem', 'male'
call BSF 'invoke', DropDown, 'addItem', 'female'

        /* create text fields           */
Surname = BSF( 'new', '',      'java.awt.TextField')
Name    = BSF( 'new', '',      'java.awt.TextField')

        /* create a button              */
ok      = BSF( 'new', '',      'java.awt.Button', 'OK')
cancel  = BSF( 'new', '',      'java.awt.Button', 'Cancel' )

        /* create a color, gridLayout and window        */
bgColour =BSF( 'newStrict', '', 'java.awt.Color', "int", 150, "int", 150, "int", 250)
GLayout = BSF( 'new', '',      'java.awt.GridLayout', 4, 2)
window  = BSF( 'new', '',      'java.awt.Frame', 'Greetings!')

        /* now add controls to window, change some settings of it       */
call BSF 'invoke', Window, 'setLayout', GLayout
call BSF 'invoke', Window, 'add',       Label1
call BSF 'invoke', Window, 'add',       DropDown
call BSF 'invoke', Window, 'add',       Label2
call BSF 'invoke', Window, 'add',       Name
call BSF 'invoke', Window, 'add',       Label3
call BSF 'invoke', Window, 'add',       Surname
call BSF 'invoke', Window, 'add',       OK
call BSF 'invoke', Window, 'add',       Cancel
call BSF 'invoke', Window, 'setSize',   200, 200
call BSF 'invoke', Window, 'setBackground', bgColour

        /* pack the elements, show the window, bring it to the front    */
call BSF 'invoke', Window, 'pack'
call BSF 'invoke', Window, 'show'
call BSF 'invoke', Window, 'toFront'

        /* define the events we are interested in and the text to be
           sent to us by Java , retrievable via "BSFPollEvents()"       */
call BSF 'addEventListener', ok, 'action', '', 'call Greetings DropDown, Name, Surname'
call BSF 'addEventListener', Cancel, 'action', '', 'call BSF "exit"'
call BSF 'addEventListener', Window, 'window', 'windowClosing', 'call BSF "exit"'

do forever      /* wait and fetch the text to be sent by Java           */
   a = bsf("pollEventText")     /* wait for an eventText to be sent     */
   say "received the following eventText: ["a"]"
   interpret a                  /* execute as a Rexx program    */
   if result= "SHUTDOWN, REXX !" then leave     /* JVM will be shutdown in 1/10sec      */
end

exit

Greetings: procedure
    parse arg DropDown, Name, Surname

        /* create a new window, label and button                        */
    window2 = BSF( 'new', '',  'java.awt.Frame')
    greet   = BSF( 'new', '',  'java.awt.Label')
    bye     = BSF( 'new',   ,  'java.awt.Button', 'Bye!')

        /* fill the window, pack and show it, move it to the front      */
    call BSF 'invoke', Window2, 'add', 'North', Greet
    call BSF 'invoke', Window2, 'add', 'South', Bye
    call BSF 'invoke', Window2, 'pack'
    call BSF 'invoke', Window2, 'show'
    call BSF 'invoke', Window2, 'toFront'

        /* get information from the controls of the first window        */
    Text1 = BSF( 'invoke', DropDown,    'getSelectedItem')
    Text2 = BSF( 'invoke', Name,        'getText')
    Text3 = BSF( 'invoke', Surname,     'getText')

    if Text1="male" then tmpString="Hello Mr."
                    else tmpString="Hello Mrs."

    if Text2 <> "" then tmpString= tmpString Text2
    tmpString=tmpString Text3

        /* set the greeting label to the derived string                 */
    call BSF 'invoke', Greet, 'setText', tmpString

        /* make sure we get the code for closing down the JVM sent      */
    call BSF 'addEventListener', Window2, 'window', 'windowClosing', 'call BSF "exit"'
    call BSF 'addEventListener', Bye, 'action', '', 'call BSF "exit"'
    return


