/*
   Name:    "HelloWorld.rex"

   Invoke:  "java org.apache.bsf.Main -lang rexx -in HelloWorld.rex"
                or
            "java org.apache.bsf.Main            -in HelloWorld.rex"
                or
             "rexxj HelloWorld.rex"
                or
             "rexx HelloWorld.rex"

   Purpose:  create a window with a choice-object and two text-fields and buttons;
             if the ok-button is pressed then popup another window and display what
             was chosen and entered.

   Needs:    IBM's "Bean Scripting Framework" (BSF)
             (cf. "http://oss.software.ibm.com/developerworks/projects/bsf")

             and the package "bsf4rexx"
             (cf. "http://nestroy.wi-inf.uni-essen.de/Forschung/rgf/Entwicklung.html")

   Date:    2001-04-18, 2003-01-23, 2003-05-10
            2005-12-28, added Apache license
            2008-09-09, rgf, changed "registerBean" and "registerBeanStrict" to their synonyms
                             "new" and "newStrict" which better describe the semantics of
                             these subfunctions

   Author:   Rony G. Flatscher, University of Essen, WU Wien University,
             derived from Peter Kalender's work for the "Essener Ski Seminar",
             University of Essen (Oct 2000 to Feb 2001)
             (cf. "http://nestroy.wi-inf.uni-essen.de/Lv/seminare/ws0001/index-e.html");

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2006 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."


        /* create a Java awt window and a Java awt button       */
window = BSF( 'new', '', 'java.awt.Frame' , '*** Hello World! ***' )
button = BSF( 'new', '', 'java.awt.Button', 'Press me!' )

        /* prepare window and show it   */
call BSF 'invoke', Window, 'add', Button
call BSF 'invoke', Window, 'pack'
call BSF 'invoke', Window, 'show'
call BSF 'invoke', Window, 'toFront'

        /* now let Java notify us of the following events, sending us the defined string*/
call BSF 'addEventListener', Window, 'window', 'windowClosing', 'call BSF "exit"'
call BSF 'addEventListener', Button, 'action', '',              'call BSF "exit"'

        /* run the event loop, otherwise this instance of Rexx gets shut down   */
        /* dispatch the strings received as a result of the registered events   */
do forever
     res=BSF("pollEventText")
     say "(in Rexx), polled: ["res"]"
     INTERPRET res              /* interpret received text as a Rexx program    */
     if result= "SHUTDOWN, REXX !" then leave     /* JVM will be shutdown in 1/10sec      */
end
say "Now exiting Rexx."

