/*
   Name:    "ShootOut.rex"

   Invoke:  "java org.apache.bsf.Main -lang rexx -in ShootOut.rex"
                or
            "java org.apache.bsf.Main            -in ShootOut.rex"
                or
            "rexxj ShootOut.rex"
                or
            "rexx ShootOut.rex"

   Purpose:  create a window with a choice-object and two text-fields and buttons;
             if the ok-button is pressed then popup another window and display what
             was chosen and entered.

   Needs:    IBM's "Bean Scripting Framework" (BSF)
             (cf. "http://oss.software.ibm.com/developerworks/projects/bsf")

             and the package "bsf4rexx"
             (cf. "http://nestroy.wi-inf.uni-essen.de/Forschung/rgf/Entwicklung.html")

   Date:    2001-04-21, 2003-01-23, 2003-05-10
            2005-12-28, added Apache license
            2008-09-09, rgf, changed "registerBean" and "registerBeanStrict" to their synonyms
                             "new" and "newStrict" which better describe the semantics of
                             these subfunctions

   Author:   Rony G. Flatscher, WU Wien University

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2006 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

        /* create labels                */
label1 =  BSF( 'new', '',        'java.awt.Label', 'Your question?')
label2 =  BSF( 'new', 'Label2',  'java.awt.Label', 'Well, consider this answer:' )

        /* get static values from class */
scrNone   = bsf('getStaticValue', 'java.awt.TextArea', 'SCROLLBARS_NONE')
scrVert   = bsf('getStaticValue', 'java.awt.TextArea', 'SCROLLBARS_VERTICAL_ONLY')

        /* create text area objects     */
taQuery   = bsf('new', '', 'java.awt.TextArea', "", 5, 80, scrNone)
taAnswer  = bsf('new', '', 'java.awt.TextArea', "" , 15, 80, scrVert)

        /* make the answer text area non-editable       */
call bsf 'invoke', taAnswer, 'setEditable', 0

        /* create the buttons           */
butAnswer = BSF( 'new', '',      'java.awt.Button', ' Please answer me! ')
butLeave  = BSF( 'new', '',      'java.awt.Button', ' Let us stop for dooday, o.k.? ' )

        /* create gridBagLayout and window      */
lay    = BSF( 'new', '', 'java.awt.GridBagLayout')
layCon = BSF( 'new', '', 'java.awt.GridBagConstraints')

        /* now define details of the GridBagLayout      */
call BSF 'setFieldValue', layCon, 'fill',      bsf('getFieldValue', layCon, 'HORIZONTAL')
call BSF 'setFieldValue', layCon, 'gridwidth', bsf('getFieldValue', layCon, 'REMAINDER')
inset  = BSF( 'new', '', 'java.awt.Insets', 5, 5, 5, 5)
call BSF 'setFieldValue', layCon, 'insets', inset

        /* register the constraints with the layout manager     */
call bsf 'invoke', lay, 'setConstraints', label1,    layCon
call bsf 'invoke', lay, 'setConstraints', taQuery,   layCon
call bsf 'invoke', lay, 'setConstraints', butAnswer, layCon
call bsf 'invoke', lay, 'setConstraints', label2,    layCon
call bsf 'invoke', lay, 'setConstraints', taAnswer,  layCon
call bsf 'invoke', lay, 'setConstraints', butLeave,  layCon

        /* create the frame window                              */
Window = BSF( 'new', '',      'java.awt.Frame', 'ShootOut!')

        /* now add controls to window, change some settings of it       */
call BSF 'invoke', Window, 'setLayout', lay
call BSF 'invoke', Window, 'add',  label1
call BSF 'invoke', Window, 'add',  taQuery
call BSF 'invoke', Window, 'add',  butAnswer
call BSF 'invoke', Window, 'add',  Label2
call BSF 'invoke', Window, 'add',  taAnswer
call BSF 'invoke', Window, 'add',  butLeave

        /* pack the elements, show the window, bring it to the front    */
call BSF 'invoke', Window, 'pack'
call BSF 'invoke', Window, 'show'
call BSF 'invoke', Window, 'toFront'

        /* define the events we are interested in and the text to be sent to us */
call BSF 'addEventListener', Window,    'window', 'windowClosing', 'call BSF "exit"'
call BSF 'addEventListener', butAnswer, 'action', '', 'call answer taQuery, taAnswer'
call BSF 'addEventListener', butLeave , 'action', '', 'call BSF "exit"'

call get_answers        /* read answers from file       */

do forever      /* wait and fetch the text to be sent by Java           */
   a = bsf("pollEventText")     /* wait for an eventText to be sent     */
   interpret a                  /* execute as a Rexx program    */
   if result= "SHUTDOWN, REXX !" then leave     /* JVM will be shutdown */
end

exit

        /* read the file with the answers       */
get_answers: procedure expose answers.
   filename ="ShootAnswers.txt"

   i=1
   do i=1 to 9999 while chars(filename)> 0
      answers.i=linein(filename)        /* get line             */
   end                                  /* save number of items */
   answers.0=i-1
   return

        /* react to pressing the answer button  */
answer : procedure expose answers.
   parse arg taQuery, taAnswer          /* get names of TextAreas       */
   txt=bsf('invoke', taQuery, 'getText')        /* get text             */

   txt = strip( space(translate(txt, "  ", "0d0a"x))   ,'T')

   if right(txt, 1) = "?" then          /* a question in hand?          */
   do
      newLine = "0a0a"x
      tmp     =        newLine || "*** your question: ***" || newLine || txt
      tmp     = tmp || newLine || "--- my answer to you! ---" || newLine
      pick    = random(1, answers.0)    /* pick a number        */
      tmp     = tmp || answers.pick

      call bsf 'invoke', taAnswer, 'append',  tmp /* append to answer text area   */
      call bsf 'invoke', taQuery,  'setText', ""
   end
   return

