/* rgf, 2005-06-18, demo to show how one can use Java as a huge external function library */
/*
   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2006 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/
parse arg filename      /* get the name of a file/directory */
say "received filename: --->" pp(filename) "<---"
say

      /* load the BSF4Rexx functions and start a JVM, if necessary */
if rxFuncQuery("BSF") = 1 then   /* BSF() support not loaded yet ? */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs
   call BsfLoadJava              /* load Java         */
end

f=bsf("new", /*empty*/ ,"java.io.File", filename) /* create and get a Java file object   */

say "Separator on this system:     " pp(bsf("getStaticValue", f, "separator"))     /* get field value and show it */
say "Path separator on this system:" pp(bsf("getStaticValue", f, "pathSeparator")) /* get field value and show it */
say

      /* define an array with two elements (strings) */
infos.1="isDirectory isFile isHidden canRead canWrite getName getPath isAbsolute" -
        "getAbsolutePath getCanonicalPath"

infos.2="getAbsoluteFile getCanonicalFile toURI toURL"


do j=1 to 2             /* iterate over the two array elements          */
   tmp=infos.j          /* get array-element (a string)                 */
   do i=1 to words(tmp)
      w=word(tmp, i)        /* could have been: "word(infos,i)"         */

      if j=1 then          /* these methods return a string already     */
         val=bsf("invoke", f, w) /* execute the function/method on the Java side */
      else                 /* these methods return a Java object, hence get string off of it */
      do
         o  =bsf("invoke", f, w) /* returns a Java object*/
         val=bsf("invoke", o, "toString") /* get the string value of the Java object */
      end

      /* show results */
      say "   " right(w,20)":" pp(val)  /* run the method and display result   */
   end
   say "---"
end
exit


pp: procedure        /* "pretty print" ;)    */
  return "[" || arg(1) || "]"

