/* classic Rexx version, ---rgf, 2003-02, 2003-05-10, 2003-09-04, 2005-12-28, 2006-01-06 */
/*
   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2001-2006 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/
/* this version works on Java 1.1 too (because using "wrapEnumeration()") */

      /* load the BSF4Rexx functions and start a JVM, if necessary */
if rxFuncQuery("BSF") = 1 then   /* BSF() support not loaded yet ? */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs          /* load all BSF*() functions  */
   call BsfLoadJava           /* load Java                  */
end

   /* 'Class.class' is pre-registered for Rexx, cf. docs */
system=bsf('loadClass', 'java.lang.System')

properties=bsf('invoke', system, "getProperties")  /* get the System properties  */

enum=bsf('invoke', properties, 'propertyNames')    /* get an enumeration of the property names */

   /* wrap the Enumeration object, so Java 1.1 can handle this too (overcome Java inner class access restriction) */
   /* the following statement is *not* necessary for Java >= 1.2 */
enum=bsf('wrapEnumeration', enum)

say copies("=", 70)

do while bsf('invoke', enum, 'hasMoreElements') /* loop over enumeration   */
   key=bsf('invoke', enum, 'nextElement')       /* get next element        */
   say "key:    " "["key"]"
   Say "         ["||bsf('invoke', properties, 'getProperty', key)"]"
   say
end

