#!/usr/bin/rexx
/*
   Name:    setupJava.rex
   Purpose: On some Linux installations, Java may be present, but not installed such that it
            could be activated via the commandline. In such a case, first try to find the
            documentation for your Java installation to learn how to set it up such that it
            can be used via the commandline.

            Short of such an alternative, you can try to use this program which sets up
            symbolic links to point to a Java installation, which it searches in /usr/java/;
            if multiple Javas are installed in '/usr/java' then a list will be
            presented that allows the user to pick an installed Java; if running
            with the switch "/q" (quiet, for unattended installations), then the last Java
            installation according to that list will be picked
            (only installations containing the directory '/jre/' will be presented)
   Author:  Rony G. Flatscher
   Date:    2006-01-03
   Usage:   rexx setupJava.rex [/s]
            ... /s  optional switch for unattended install ("silent")

   Changed: 2006-01-18, ---rgf, changed switch from "/q(uiet)" to "/s(ilent)" as the latter
                                seems to be wellknown
            2007-10-13, ---rgf, thanks to Steve Oswald to pointing out that some installations
                                of Java use variations of "/jre/" (e.g. "java/jre1.5.0_11/lib");
                                applying Steve Oswald's changes

   Contributor: 2007-10-10: Steve Oswald via the RexxLA listserver

   last svn check-in: $Revision: 217 $ $Author: rony $ $Date: 2008-05-18 14:12:15 +0200 (Sun, 18 May 2008) $

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2006-2007 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

parse upper arg "/" +1 switch +1    /* extract first letter after "/" in uppercase     */
parse upper source s +1    /* get capital letter of operating system, "W"indows, "O"s2 */

if pos(s, "WO")>0 then
do
   say "This script is meant for Linux/Unix only, aborting..."
   say
   exit -1
end



cmd.=""                          /* default value for stem        */
nl="0a"x                      /* Unix new-line character sequence (\n)  */
cmd.eLeadIn="#!/bin/sh"nl     /* command to execute this file           */
cmd.eEcho="echo"


ldlib=value("LD_LIBRARY_PATH", , "ENVIRONMENT") /* defined?             */
cmd.eSetLIB  = "export LD_LIBRARY_LIB="          /* make sure local dir is searched!       */

if ldlib<>"" then
   cmd.eSetLIB  = cmd.eSetLIB || ldlib || ":"

cmd.eSetScriptName="setEnvironment4BSF4Rexx_LD_LIBRARY_PATH.sh"
cmd.eSetExecutable="chmod 755"   /* set executable for all (user, group, other)  */
cmd.eLineComment="#"

   /* try to find Java binaries  */
call sysFileTree "/usr/java/libjvm.so", "libFile.", "FOS"

files.0=0
m=0
do k=1 to libFile.0
   m=m+1                    /* increase couter                */
   files.m=libfile.k        /* contains path to 'java' binary */
      /* if path contains subdir 'client' or we have the last entry in hand   */
   if pos("/client/", libFile.k)>0 | k=libFile.0 then
   do
      files.m.eLibPath=libFile.k

      parse var libFile.k strTmp "libjvm.so"    /* extract base path       */
         /* remove trailing "client/" or "server/" */
      if wordpos(right(strTmp, 7), "client/ server/")>0 then
         strTmp=substr(strTmp, 1, length(strTmp)-7)

      files.m.eLibPathClientAll = strTmp || "client"
      files.m.eLibPathServerAll = strTmp || "server"
      files.m.eLibPathAll       = strTmp

      architecture=""
      lpos=lastpos("/", strTmp, length(strTmp)-1)
      if lpos>0 then
      do
         parse var strTmp +(lpos) "/" architecture "/"
         say "===> architecture=["architecture"]"
      end

      files.m.eLibPathMisc      = strTmp || "../../lib/"architecture
   end
end
files.0=m   /* save number of elements */

if files.0=0 then
do
   say "No 'jvm' found under '/usr/java/*/jre/', aborting..."
   call usage
   exit -2
end

pick=files.0      /* default to last found java (mostlikely a /jre/) */

if switch<>"S" then     /* not a silent (unattended) run, ask user   */
do
   say
   l=length(files.0)
   do i=1 to files.0
      say right(i, l)":" files.i
   end
   say
   say "Please enter the number of the Java installation you wish to use by default (0 to quit):"
   pull pick .

   if pick=0 then exit -99 /* user chose to abort  */

   if pick<1 | pick>files.0 then
   do
      say pick "is not in the valid range of: 1 through" files.0", aborting..."
      exit -3
   end
end

   /* now symbolic link to '/usr/bin', find 'libjvm.so' and symbolic link it to '/usr/lib'   */
say "creating symbolic links ..."
a="ln -svf" files.pick          '/usr/bin'
say a
a

/* an alternative would be to set LD_LIBRARY_PATH to point to ".../jre/lib/i386/"
   and ".../jre/lib/i386/client" or maybe even ".../jre/lib/i386/server"                     */

a="ln -svf" files.pick.eLibPath '/usr/lib/libjvm.so' /* not enough, need access to all JNIs! */
say a
a

/* ---> this would link all java-JNI-libs to /usr/lib, cluttering it, hence
        preferring to use LD_LIBRARY_PATH instead

/* keep sequence such, that latter links to JNI libs overwrite earlier ones; eg. using
   client's 'libjvm.so', if available, rather than server's                                  */
a="ln -svf" files.pick.eLibPathServerAll '/usr/lib'    /* link all server JNI's into /usr/lib */
say a
a
say

a="ln -svf" files.pick.eLibPathClientAll '/usr/lib'    /* link all client JNI's into /usr/lib */
say a
a
say

a="ln -svf" files.pick.eLibPathAll       '/usr/lib'    /* link all JNI's into /usr/lib        */
say a
a
say
   <---     */

say "... done."
say

say "now testing access to Java, querying the Java version..."
a="java -version"
say a
a
exit 0

usage:
   say "usage: rexx setupJava [/s]"
   say
   say "        /s ... silent installation (unattended installation)"
   return




/* create the test script which sets up all needed parameters to run Rexx programs from
   this directory */
createScript: procedure expose cmd.
  fn=cmd.eSetEnvironmentScriptName

  call stream fn, "c", "open replace"
  call lineout fn, cmd.eLeadIn
  call lineout fn, ""
  call lineout fn, cmd.eLineComment "created:" q(date("S") time())
  call lineout fn, cmd.eEcho qe("setting the CLASSPATH environment variable to point to the OpenOffice.org/StarOffice jar files ...")
  call lineout fn, cmd.eLineComment "just run it, before invoking a Rexx program that addresses OpenOffice.org/StarOffice ..."
  call lineout fn, ""

  call lineout fn, cmd.eLineComment "set OOo/SO directory that contains the needed jars..."
  call lineout fn, cmd.eSetOOo
  call lineout fn, ""

  call lineout fn, cmd.eLineComment "set CLASSPATH environment variable ..."
  call lineout fn, cmd.eLineComment "please note: if using OOo/SO version 2.0 or greater, you do not need ""sandbox.jar"""
  call lineout fn, cmd.eSetCP          /* set CLASSPATH        */
  call lineout fn, cmd.eSetCP2         /* export it on Unix    */
  call lineout fn, ""

  call lineout fn, cmd.eEcho qe(".")
  call lineout fn, cmd.eEcho qe("It is advised to add this environment setting to your system's profile!")

  call lineout fn, cmd.eEcho qe("(This way it is always assured, that Rexx can find the OOo Java classes.)")
  call lineout fn, ""


  call stream fn, "c", "close"

  if cmd.eSetExecutable<>"" then       /* set file executable (Unix)    */
     cmd.eSetExecutable cmd.eSetEnvironmentScriptName

  return


