#!/usr/bin/rexx
/*
   Name:    setupOOo.rex
   Purpose: create a shell script which sets the environment variable CLASSPATH
            to point to the Java archives needed to drive/automate OpenOffice.org
            resp. StarOffice
   Author:  Rony G. Flatscher
   Version: 1.10
   Date:    2006-01-04
   Changed:
            2008-08-20, ---rgf, changed PATH such that OOO-dir is now appended
            2008-08-10, ---rgf, changed cmd.eCopy from "-plfv" to "-fv" to allow successful
                                execution from Ubuntu on a Windows NTFS-system;
                                on Unix: adding full path to setEnvironmentOOO.sh
            2006-01-16, ---rgf, make sure CLASSPATH is used in any case
            2006-01-22, ---rgf, on Linux hint the user how to enter "setEnvironment4BSF4Rexx.sh"
            2006-01-24, ---rgf, now OOo-Reflection support unbundled, needs to be copied to
                                "OOo/program/classes" and then put into CLASSPATH
            2006-02-25, ---rgf, removed a quirk in a Unix string (delimiter part of string!),
                                "setEnvironment4OOo.*" is now copied to a PATH directory
            2007-07-07, ---rgf, changed hint-text for pointing to the OO directory 2.2
            2007-09-16, ---rgf, changed hint-text for pointing to the OO directory 2.3
            2008-05-17, ---rgf, now only runs on ooRexx due to usage of directives and OLEObject;
                                adds path to OOo-program-directory and jars to registry; uses
                                hive into which OOo got installed to (HKCU=user or HKLM=system);
                                supports OOo 2.x only
            2008-07-06, ---rgf, added path to soffice to CLASSPATH on Unix (now needed for OOo 2.4
                                e.g. on Ubuntu; fixed a typo in chmod; corrected an error in the
                                Unix-branch where home of soffice is looked for, if no argument
                                is given
            2008-07-12, ---rgf, changed sequence of OOo-jars to match what "unoinfo" of OOo 3.x shows,
                                added the routine "getClassPath4OOo()" which uses JavaInfo4BSF4RexxInstallation.java
                                to query and edit the necessary CLASSPATH string for interacting
                                with OOo
            2008-08-14, ---rgf, using USERID()-BIF

   last svn check-in: $Revision: 279 $ $Author: rony $ $Date: 2008-08-31 14:46:17 +0200 (Sun, 31 Aug 2008) $

   license:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2006-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

/*

Ubuntu 6.10 (as of 2007-02-03):

OOO_pgms=/usr/lib/openoffice/program

# hndisch:
export LD_LIBRARY_PATH=$OOO_pgms:$LD_LIBRARY_PATH

OOO_jars=/usr/share/java/openoffice

*/

cmd.=""                          /* default value for stem        */
parse upper source s +1          /* get first character of operating system in uppercase */
cmd.eIsUnix=(pos(s, "WO")=0)

/* for debugging: force Unix-mode
   cmd.eIsUnix=1
*/

if cmd.eIsUnix=0 then
do
   cmd.eIsUnix=0                 /* Windows/OS2 style       */
   cmd.eFile.sep="\"
   cmd.ePath.sep=";"
end
else
do
   cmd.eIsUnix=1                 /* Unix style              */
   cmd.eFile.sep="/"
   cmd.ePath.sep=":"
end

                                 /* paths to Java and desired bin-dir given?  */
parse arg path2OOo               /* get path to OpenOffice.org/StarOffice     */
hive=""                    -- relevant for Windows registry

-- say "path2OOo=["path2OOo"]"

if path2OOo="" then        -- no path to OOo given
do
      -- cf.  <http://wiki.services.openoffice.org/wiki/Documentation/DevGuide/ProUNO/Java/Transparent_Use_of_Office_UNO_Components>
    if cmd.eIsUnix=1 then  -- Unix
    do
       cmd.ePath2OOoBase=getOOoHomeDirUnix() -- try to get OOo's home directory (works for OOo 2.x)
    end
    else                   -- Windows: get path to OOo from registry, use that hive to add PATH and CLASSPATH additions
    do
       parse value getOOoHomeDirWindows() with hive cmd.ePath2OOoBase
    end

      -- remove trailing "program"-directory
    lpos=lastPos(cmd.eFile.sep,cmd.ePath2OOoBase) -- get last occurrence of file separator
    if lpos>1 then
       cmd.ePath2OOoBase=substr(cmd.ePath2OOoBase, 1, lpos-1)  -- remove last directory ("program")
end
else  -- path was given: needs to point to OOo base directory from which "program/soffice" can be derived
do
   /* check, whether correct directory given: */
   tmpPath=path2OOo~strip('Both')~strip("Both",'"') -- remove white space, quotes

      -- stream() returns canonical path
   if cmd.eIsUnix then
      tmpPath=stream(tmpPath || cmd.eFile.sep || "program" || cmd.eFile.sep || "soffice"    , "C", "QUERY EXISTS")
   else                 -- Windows
      tmpPath=stream(tmpPath || cmd.eFile.sep || "program" || cmd.eFile.sep || "soffice.exe", "C", "QUERY EXISTS")

   if tmpPath<>"" then           -- office executable found, extract path to it from stream()'s canonical path
   do
      lpos=lastPos(cmd.eFile.sep,tmpPath) -- get last occurrence of file separator
      if lpos>1 then
         lpos=lastPos(cmd.eFile.sep,tmpPath, lpos-1) -- get the second to last occurrence of the file separator

      if lpos>1 then             -- Bingo!
         cmd.ePath2OOoBase=substr(tmpPath,1,lpos-1)
   end
end
cmd.ePath2OOoBase=canonizePath(cmd.ePath2OOoBase)

/*
oldDir=directory()               /* memorize actual directory                 */
cmd.ePath2OOoBase=directory(strip(path2OOo, 'B', '"'))   -- remove quotes, if any; change to directory
call directory oldDir            /* reset directory                           */
*/

-- temp
-- cmd.ePath2OOoBase="/opt/openoffice.org2.2

if cmd.ePath2OOoBase="" then         /* not found, give a message and abort ...   */
do
   say "path to OpenOffice.org/StarOffice directory" pp(path2OOo) "could not be found!"
   say
   say "     usage: rexx setupOOo [path-to-OpenOffice-directory]"
   say

   if cmd.eIsUnix=0 then
   do
      say '   example: rexx setupOOo d:\Programme\OpenOffice.org 2.4'
   end
   else
   do
      say '   example: rexx setupOOo /opt/openoffice.org.2.4'
      /* say '        or: rexx setupOOo /usr/lib/openoffice' */
   end
   exit -1
end

   -- on Windows: determine hive to use for "un/installOOo.cmd":
if cmd.eIsUnix=.false then    -- o.k. Windows, no hive given, determine hive to install to
do
/*
      -- remove trailing "\program" directory
    lpos=path2OOo~lastpos("\")         -- find last backslash
    if lpos>0 then
       path2OOo=path2OOo~left(lpos-1)  -- extract home-dir
*/

    if hive="HKLM" then    -- ooRexx in system hive (HKLM: local machine)
    do
       cmd.eRegistryPath     ="HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\Path"
       cmd.eRegistryClassPath="HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\CLASSPATH"
    end
    else                   -- ooRexx in user hive (HKCU: current user)
    do
       cmd.eRegistryPath     ="HKCU\Environment\Path"
       cmd.eRegistryClassPath="HKCU\Environment\CLASSPATH"
    end
end


cmd.ePath2OOoPrograms=cmd.ePath2OOoBase     || cmd.eFile.sep || "program"
cmd.ePath2OOoJars    =cmd.ePath2OOoPrograms || cmd.eFile.sep || "classes"

cmd.eThisDirectory=directory() || cmd.eFile.sep -- save this directory


/* for forcing testing Unix on Windows
j.cmd.eFile.separator="/" -- rgf, debug
j.cmd.ePath.separator=":" -- rgf, debug
*/

   /* parse path, put directories into the stem variable */
path.=""
call parsePath

cp=value("CLASSPATH", , "ENVIRONMENT") /* try to get the CLASSPATH value   */
/* cmd.eRgfReflectUNO="oorexx-uno.jar"  ---rgf, 2007-02-02: not needed anymore as part of "bsf-rexx-engine.jar" */
cmd.eSupportInfos=qc("Support: Internet newsgroup <news:comp.lang.rexx>, <http://www.OpenOffice.org> or via <http://www.RexxLA.org>")

if cmd.eIsUnix then
do
   nl="0a"x                      /* Unix new-line character sequence (\n)  */
   cmd.eLeadIn="#!/bin/sh"nl     /* command to execute this file           */
   cmd.eEcho="echo"
   -- cmd.eCopy="cp -plfv"          /* preserve, hard-link, force, verbose: source target(dir)  */
   cmd.eCopy="cp -fv"            /* force, verbose: source target(dir) [works on FAT32/NTFS systems from Linux as well] */
   cmd.eDelete="rm -fv"
   cmd.eSetOOoHome = 'OOO_pgms='cmd.ePath2OOoPrograms
   cmd.eSetOOoJars = 'OOO_jars=$OOO_pgms' || cmd.eFile.sep || "classes"
   cmd.eJarVar = cmd.ePath.sep"$OOO_jars"cmd.eFile.sep   /* variable to use                        */

   cmd.eDLL="libBSF4Rexx.so"     /* define name of dynamic link library    */

   cmd.eSetOOoPgms = "OOoPgm=" || cmd.ePath2OOoPrograms

   if cp="" then
      cmd.eSetCP  = "CLASSPATH=."            /* make sure local dir is searched!       */
   else
      cmd.eSetCP  = "CLASSPATH=$CLASSPATH"

   cmd.eSetCP2 = "export CLASSPATH"

   cmd.eSetPath="export PATH="   || "$PATH" || cmd.ePath.sep || "$OOO_pgms"

   cmd.eInstallScriptName="installOOo.sh"
   cmd.eUninstallScriptName="uninstallOOo.sh"

   if cmd.eBinDir="" then
      cmd.eBinDir="/usr/bin"     /* directory where executables reside     */

   -- cmd.eSetEnvironmentScriptName="setEnvironment4OOo.sh"
   cmd.eSetEnvironmentScriptName=cmd.eThisDirectory || "setEnvironment4OOo.sh"

   cmd.eExecuteEnvironmentScript=". "cmd.eSetEnvironmentScriptName
   cmd.eSetExecutable    ="chmod 755"   /* set executable for all (user, group, other)  */
   cmd.eLineComment="#"

   cmd.eAdd2BashRc   = "~/.bashrc"   /* bash profile to add entry to        */
   cmd.eAdd2BashRc.0 = 3
   cmd.eAdd2BashRc.1 = "    # allow BSF4Rexx to find OOo and the OOo jars"
   cmd.eAdd2BashRc.2 = "    ." cmd.eSetEnvironmentScriptName ">/dev/null"


end
else  /* Windows, OS/2 (eCS), ... */
do
   nl="0d0a"x                    /* Windows/OS2 new-line character sequence (\n) */
   cmd.eEcho="@echo"
   cmd.eEchoOff="@echo off"
   cmd.eCopy="copy /y"
   cmd.eDelete="del /f"
   cmd.eSetOOoHome = 'set OOO_pgms='cmd.ePath2OOoPrograms
   cmd.eSetOOoJars = 'set OOO_jars=%OOO_pgms%'   || cmd.eFile.sep || "classes"

   cmd.eJarVar = cmd.ePath.sep"%OOO_Jars%"cmd.eFile.sep  /* variable to use                        */

   cmd.eDLL="BSF4Rexx.dll"       /* define name of dynamic link library    */

   cmd.eSetOOoPgms = "set OOoPgm=" || cmd.ePath2OOoPrograms

   if cp="" then
      cmd.eSetCP  = "set CLASSPATH=."        /* make sure local dir is searched!       */
   else
      cmd.eSetCP  = "set CLASSPATH=%CLASSPATH%"

   cmd.eSetPath="set PATH="      || "%PATH%" || cmd.ePath.sep || "%OOO_pgms%"

   cmd.eInstallScriptName="installOOo.cmd"
   cmd.eUninstallScriptName="uninstallOOo.cmd"

   if cmd.eBinDir="" then
      cmd.eBinDir=getRexxDir()   /* directory where executables reside     */

   cmd.eSetEnvironmentScriptName="setEnvironment4OOo.cmd"
   cmd.eExecuteEnvironmentScript="  " cmd.eSetEnvironmentScriptName
   cmd.eLineComment="@REM "
end


   /* create necessary CLASSPATH    */

-- rgf, 2008-07-12: check whether "unoinfo" executable exists (starting with OOo 3.x), if so, use it
if cmd.eIsUnix then
   tmpPath=stream(cmd.ePath2OOoPrograms || cmd.eFile.sep || "unoinfo", "C", "QUERY EXISTS")
else                 -- Windows
   tmpPath=stream(cmd.ePath2OOoPrograms || cmd.eFile.sep || "unoinfo.exe", "C", "QUERY EXISTS")

if tmpPath<>"" then
do
   cmd.eSetCPWithFullPath=getClassPath4OOo(tmpPath)
end
else  -- assume pre OOo 3.0 setup configuration, create CLASSPATH string accordingly
do
   -- jars="jurt.jar unoil.jar ridl.jar juh.jar" cmd.eRgfReflectUNO, ---rgf, 2007-02-03: not needed anymore
   -- jars="jurt.jar unoil.jar ridl.jar juh.jar"
   -- use sequence of OOo 3.*
   jars="juh.jar ridl.jar jurt.jar unoil.jar"
        -- "sandbox.jar"               /* only needed for OOo < 2.0              */

   cmd.eSetCPWithFullPath=""
   do i=1 to words(jars)            /* loop over words                        */
      jar=word(jars, i)             /* extract word */
--      cmd.eSetCP=cmd.eSetCP || cmd.eJarVar || jar  /* append it */

      if cmd.eSetCPWithFullPath<>"" then
         cmd.eSetCPWithFullPath=cmd.eSetCPWithFullPath || cmd.ePath.sep

      cmd.eSetCPWithFullPath=cmd.eSetCPWithFullPath || cmd.ePath2OOoJars || cmd.eFile.sep || jar
   end

      -- make sure path to executable is also given in CLASSPATH (e.g. needed for OOo 2.4 on Unix)
   cmd.eSetCPWithFullPath=cmd.eSetCPWithFullPath || cmd.ePath.sep || cmd.ePath2OOoPrograms
end

/*
if cmd.eIsUnix=1 then
   cmd.eSetCP=cmd.eSetCP || cmd.ePath.sep || "$OOO_pgms"
else
   cmd.eSetCP=cmd.eSetCP || cmd.ePath.sep || "%OOO_pgms%"
*/


/* determine files to copy to "OOo/program": needed for macros, we can point PATH there too!  */
cmd.e4OOoPrograms=cmd.eDLL "BSF.CLS UNO.CLS UNO_XINTERFACES.REX UNO_CREATE_INTERFACE_LIST.REX"

/* make sure that CLASSPATH is used in case this script runs at a time, when other programs have set
   the classpath environment variable
*/
if cp="" then
do
  if cmd.eIsUnix=1 then
     cmd.eSetCP=cmd.eSetCP || cmd.ePath.sep || "$OOO_pgms" || cmd.ePath.sep || "$CLASSPATH"
  else
     cmd.eSetCP=cmd.eSetCP || cmd.ePath.sep || "%CLASSPATH%"
end

   /* create the scripts   */
call createEnvironmentScript


call createInstallScript

call info         /* tell the user what to do with it */

exit


/* create the install script: this will copy the BSF4Rexx jar-file and dynamic link library
   to the appropriate Java extension directory
*/
createInstallScript: procedure expose j. cmd. path.
  fn=cmd.eInstallScriptName            /* name of install script              */
  ui=cmd.eUninstallScriptName          /* name of uninstall script            */

   /* copying setEnvironment4* to a PATH-directory */
  tgtDir=cmd.eBinDir       /* Windows: Rexx-home directory, Unix: /usr/bin  */

  call stream fn, "c", "open replace"
  call stream ui, "c", "open replace"

  -- hintString="created:" q(date("S") time()) "by user" q(value("USER",,"ENVIRONMENT"))
  hintString="created:" q(date("S") time()) "by user" q(userid())

  call lineout fn, cmd.eEcho qe("created:" q(date("S") time()))
  call lineout fn, cmd.eEcho qe("installing BSF4Rexx ""OpenOffice.org"" support...")
  call lineout fn, cmd.eEcho qe(".")
  call lineout fn, cmd.eEchoOff
  call lineout fn, ""

     /* uninstall: */
  call lineout ui, cmd.eEcho qe("created:" q(date("S") time()))
  call lineout ui, cmd.eEchoOff
  call lineout ui, cmd.eEcho qe("uninstalling BSF4Rexx ""OpenOffice.org"" support...")
  call lineout ui, cmd.eEcho qe(".")
  call lineout ui, ""
  call lineout ui, cmd.eEcho qe("(make sure that no instances of ""OpenOffice.org"" are running!)")
  call lineout ui, ""

  /* rgf, 2006-07-11: add package to OOo via Rexx and the now established OOo-support */
  call lineout ui, cmd.eEcho qe("Removing package ScriptProviderForooRexx.jar from OpenOffice/StarOffice:")
  if cmd.eIsUnix=1 then
     call lineout ui, "."    cmd.eSetEnvironmentScriptName ">/dev/null;rexx add_ooRexxPackage.rex remove >/dev/null"
  else
     call lineout ui, "call" cmd.eSetEnvironmentScriptName ">nul && rexx add_ooRexxPackage.rex remove 2>nul"

  call lineout ui, ""

/*  ---rgf, 2007-02-03: no need to copy as it is now part of "bsf-rexx-engine.jar"
     /* copying jar-file to OOo classes-directory */
  tgtDir=cmd.ePath2OOoJars
  tgtFile=stream(cmd.eRgfReflectUNO, "C","Query EXISTS")

  call lineout fn, cmd.eEcho qe("copying UNO reflection jar" q(cmd.eRgfReflectUNO) "to" q(tgtDir) "...")
  call lineout fn, cmd.eCopy qw(cmd.eRgfReflectUNO) qw(tgtDir)
  call lineout fn, ""

  call lineout ui, cmd.eEcho qe("deleting" q(cmd.eRgfReflectUNO)  "from directory" q(tgtDir) "...")
  call lineout ui, cmd.eDelete qw(tgtDir || cmd.eFile.sep || cmd.eRgfReflectUNO)
  call lineout ui, ""
*/

   /* 2007-02-03, ---rgf: copy OOo-Files to OOo directory; this way macros work without any
                          global changes to the environment */
  iw=words(cmd.e4OOoPrograms)
  if iw>0 then       /* if programs to copy to the appropriate OOo directory */
  do
     call lineout fn, cmd.eEcho qe("copying Rexx programs to the OOo program directory:" q(cmd.ePath2OOoPrograms) "...")
     /* call lineout fn, cmd.eCopy qw(cmd.eRgfReflectUNO) qw(tgtDir) -- 2007-02-03, rgf: not needed anymore, part of "bsf-rexx-engine.jar" */

     do i=1 to iw
        pgm=word(cmd.e4OOoPrograms, i)

        call lineout fn, cmd.eEcho qe("copying" q(pgm) "to" q(cmd.ePath2OOoPrograms) "...")
        call lineout fn, cmd.eCopy qw(pgm) qw(cmd.ePath2OOoPrograms)
        call lineout fn, ""

        call lineout ui, cmd.eEcho qe("deleting" q(pgm)  "from directory" q(cmd.ePath2OOoPrograms) "...")
        call lineout ui, cmd.eDelete qw(cmd.ePath2OOoPrograms || cmd.eFile.sep || pgm)
        call lineout ui, ""
     end
  end

/*
   /* tgtFile=stream(cmd.eSetEnvironmentScriptName, "C","Query EXISTS") */
  tgtFile=cmd.eSetEnvironmentScriptName
  call lineout fn, cmd.eEcho qe("copying"  q(tgtFile) "to" q(tgtDir) "...")
  call lineout fn, cmd.eCopy qw(tgtFile) qw(tgtDir)
  call lineout fn, ""

  call lineout ui, cmd.eEcho qe("deleting" q(tgtFile)  "from directory" q(tgtDir) "...")
  call lineout ui, cmd.eDelete qw(tgtDir || cmd.eFile.sep || cmd.eSetEnvironmentScriptName)
  call lineout ui, ""
*/

   -- 2008-05-17, ---rgf: now add necessary path and classpath values to registry
  call lineout ui, ""
  call lineout fn, ""
  if cmd.eIsUnix=1 then          /* Unix only, append ". setEnvironment..." to .bashrc  */
  do
     call lineout fn, ""
     call lineout fn, cmd.eEcho qc("Adding entries to the end of" cmd.eAdd2BashRc "...")

     appendTo=">>" cmd.eAdd2BashRc

     call lineout fn, cmd.eEcho qc(" ") appendTo
     call lineout fn, cmd.eEcho qc("#" hintString":") appendTo

     do i=1 to cmd.eAdd2BashRc.0
        call lineout fn, cmd.eEcho qc(cmd.eAdd2BashRc.i) appendTo
     end
     call lineout fn, ""
  end
  else      -- add statements to incorporate paths into registry
  do
      -- TODO
      cmd="call rexx orx2reg.rex"      -- invoke utility to interact with Windows registry

      hint="Creating a backup of PATH and CLASSPATH registry values..."
      call lineout fn, cmd.eEcho qc(hint)
      call lineout ui, cmd.eEcho qc(hint)

      bkpFile="registryValues-"||date("S")"T"time("N")~changestr(":","")
      call lineout fn, cmd ">" bkpFile"-beforeAddOOoPathValues.bat"
      call lineout ui, cmd ">" bkpFile"-beforeDelOOoPathValues.bat"

      call lineout ui, ""
      call lineout fn, ""

         -- add OOo path to PATH
      arg="/key:"q(cmd.eRegistryPath) "/path:"q(cmd.ePath2OOoPrograms)
      tmpStr1=cmd "/add"    arg
      tmpStr2=cmd "/remove" arg
         -- inform user
      call lineout fn, cmd.eEcho qc(tmpStr1)
      call lineout ui, cmd.eEcho qc(tmpStr2)

         -- carry out operation
      call lineout fn, tmpStr1
      call lineout ui, tmpStr2

      call lineout ui, ""
      call lineout fn, ""

         -- add bsf-jars to CLASSPATH

         -- make sure the current directory is searched as well
      arg="/key:"q(cmd.eRegistryClassPath) "/path:"q(cmd.eSetCPWithFullPath)

      tmpStr1=cmd "/add"    arg
      tmpStr2=cmd "/remove" arg
         -- inform user
      call lineout fn, cmd.eEcho qc(tmpStr1)
      call lineout ui, cmd.eEcho qc(tmpStr2)

         -- carry out operation
      call lineout fn, tmpStr1
      call lineout ui, tmpStr2

      call lineout ui, ""
      call lineout fn, ""
  end


  call lineout ui, cmd.eEcho qe("done.")
  call lineout ui, ""
  call lineout ui, cmd.eEcho cmd.eSupportInfos

/*
  call lineout fn, cmd.eEcho qe("If addressing OOo from the command line, then setup the environment beforehand using:")
  call lineout fn, ""
  call lineout fn, cmd.eEcho qe("   " cmd.eExecuteEnvironmentScript)
  call lineout fn, ""
  call lineout fn, cmd.eEcho qe("done.")
  call lineout fn, ""
*/

   /* rgf, 2006-07-11: add package to OOo via Rexx and the now established OOo-support */
  call lineout fn, cmd.eEcho qe("Adding package ScriptProviderForooRexx.jar to OpenOffice/StarOffice:")
  if cmd.eIsUnix=1 then
     call lineout fn, "."    cmd.eSetEnvironmentScriptName ">/dev/null;rexx add_ooRexxPackage.rex >/dev/null"
  else
     call lineout fn, "call" cmd.eSetEnvironmentScriptName ">nul && rexx add_ooRexxPackage.rex 2>nul"

  call lineout fn, cmd.eEcho qe("done.")
  call lineout fn, ""
  call lineout fn, cmd.eEcho qe("/// Please close ALL instances of OpenOffice/StarOffice and the quickstarter.")
  call lineout fn, cmd.eEcho qe("(This will allow OpenOffice/StarOffice to fully initialize and find ooRexx!)")
  call lineout fn, ""
  call lineout fn, cmd.eEcho cmd.eSupportInfos



  call stream fn, "c", "close"
  call stream ui, "c", "close"

  if cmd.eSetExecutable<>"" then       /* set file executable (Unix)    */
  do
     cmd.eSetExecutable cmd.eInstallScriptName
     cmd.eSetExecutable cmd.eUninstallScriptName
  end
  return




/* create the test script which sets up all needed parameters to run Rexx programs from
   this directory */
createEnvironmentScript: procedure expose cmd. path.
  fn=cmd.eSetEnvironmentScriptName

  call stream fn, "c", "open replace"
  call lineout fn, cmd.eEchoOff
  call lineout fn, cmd.eLineComment "created:" q(date("S") time())
  call lineout fn, cmd.eLineComment "(allows running OOo scripts from the commandline)"
  call lineout fn, cmd.eEcho qe("setting the CLASSPATH environment variable to point to the OpenOffice.org/StarOffice jar files")
  call lineout fn, cmd.eEcho qe("(make sure that the environment is set for BSF4Rexx as well)...")
  call lineout fn, ""

--  call lineout fn, cmd.eLineComment "make sure we use the same OOo-BSF4Rexx programs the OOo macros do (hence" q("OOo_pgms") "listed first)"
  call lineout fn, cmd.eLineComment "define and lookup OOo's program directory first"
  call lineout fn, cmd.eSetOOoHome
-- call lineout fn, cmd.eSetOOoJars
--  call lineout fn, ""

--   call lineout fn, cmd.eLineComment "make sure only BSF4Rexx files from the installation are used, hence listing first"
  call lineout fn, cmd.eSetPath        /* set PATH        */
  call lineout fn, ""

/*
  call lineout fn, cmd.eLineComment "copy UNO-reflection jar to OOo/SO program/classes directory..."
  call lineout fn, cmd.eCopy qw(stream(cmd.eRgfReflectUNO, "C","Query EXISTS")) qw(cmd.ePath2OOoJars)
  call lineout fn, ""
*/

  call lineout fn, cmd.eLineComment "set CLASSPATH environment variable ..."
--  call lineout fn, cmd.eLineComment "please note: if using OOo/SO version 2.0 or greater, you do not need ""sandbox.jar"""

--   call lineout fn, cmd.eSetCP          /* set CLASSPATH        */
  call lineout fn, cmd.eSetCP || cmd.ePath.Sep || cmd.eSetCPWithFullPath   /* set CLASSPATH        */

  call lineout fn, cmd.eSetCP2         /* export it on Unix    */
  call lineout fn, ""

  call lineout fn, cmd.eEcho qe(".")
  call lineout fn, cmd.eEcho qe("It is advised to add these environment settings to your systems profile!")

  call lineout fn, cmd.eEcho qe("(This way it is always assured, that Rexx can find the OOo Java classes.)")

  if cmd.eIsUnix=1 then
  do
     call lineout fn, cmd.eEcho qe("E.g. add the following entries to your '~/.bashrc':")
     call lineout fn, cmd.eEcho qe(" ")
     call lineout fn, cmd.eEcho qe("   # allow using OpenOffice.org via its Java interface classes")
     call lineout fn, cmd.eEcho qe("   ." cmd.eSetEnvironmentScriptName ">/dev/null")
  end

  call lineout fn, ""


  call stream fn, "c", "close"

  if cmd.eSetExecutable<>"" then       /* set file executable (Unix)    */
     cmd.eSetExecutable cmd.eSetEnvironmentScriptName

  return



pp: procedure                    /* poor man's "pretty" print     */
  return "[" || arg(1) || "]"


q: procedure                     /* enclose string into apostrophes  */
  return """" || arg(1) || """"

   /* "qe": quote echo string: enquote entire string on Unix only */
qe: procedure expose j. cmd. path.
  if  cmd.eIsUnix=1 then return "'" || arg(1) || "'"
                    else return arg(1)


   /* "qe": quote fully-qualified paths in Windows as they may contain a blank */
qw: procedure expose j. cmd. path.
  if  cmd.eIsUnix=0 then return '"' || arg(1) || '"'
                    else return arg(1)


   /* "qc": quote string in apostrophes, if Unix, in quotes, if Windows (for support infos that contain <, >) */
qc: procedure expose j. cmd. path.
  if  cmd.eIsUnix=0 then return '"' || arg(1) || '"'     /* Windows  */
                    else return "'"  || arg(1) || "'"    /* Unix     */


iif: procedure                   /* VBasic-like function          */
  if arg(1)=1 then return arg(2)
  return arg(3)


info:                            /* tell user what has happened   */
  say
  say "the following scripts have been created:"
  say
  say " " pp(cmd.eInstallScriptName)": install ooRexx-UNO support for OpenOffice"
  if cmd.eIsUnix=0 then
     say "       usage:" cmd.eInstallScriptName
  else
     say "       usage:" q("./"cmd.eInstallScriptName)
  say

  say " " pp(cmd.eUninstallScriptName)": uninstall ooRexx-UNO support for OpenOffice"
  if cmd.eIsUnix=0 then
     say "       usage:" cmd.eUninstallScriptName
  else
     say "       usage:" q("./"cmd.eUninstallScriptName)
  say
  say " " pp(cmd.eSetEnvironmentScriptName)": use to set the environment variable 'CLASSPATH' to"
  say "              point to the OpenOffice.org (OOo)/StarOffice (SO) jar-files"
  say
  if cmd.eIsUnix=0 then
     say "       usage:" cmd.eSetEnvironmentScriptName
  else
     say "       usage:" q(". ./"cmd.eSetEnvironmentScriptName)

  say
  say "     remarks: - After running this script you may invoke any BSF4Rexx-program"
  say "                automating OOo/SO via BSF4Rexx', e.g. (try it!)"
  say
  if cmd.eIsUnix=0 then
     say "                  " cmd.eSetEnvironmentScriptName
  else
     say "                  " q(". ./"cmd.eSetEnvironmentScriptName)

  say "                  " "rexx testOOo.rex"
  say
  say "Good luck! :-)  [You may also want to take a look at this generated script.]"
  exit 0

/* Get path to Rexx or Regina from PATH environment variable and return it;
   Windows/OS2
*/
getRexxDir: procedure expose j. cmd. path.
     /* use this precedence order to locate a path where to copy Rexx-files to  */
  dir=findPath("\ooREXX \regina rexx")
  if dir<>"" then return dir

  eyeCatcher="?!no-rexx-path-found!?"
  say "PROBLEM: could not find explicit path to a Rexx-directory!"
  say "         Please adjust the created scripts to point to any one directory listed"
  say "         with the environment variable ""PATH"", ie. replace" pp(eyecatcher) "with"
  say "         any of the listed PATH directory, and then run the scripts."
  return eyecatcher              /* indicate that not found       */



/* parse path into stem path. */
parsePath: procedure expose j. cmd. path.
/*
say "... j.path.separator=["j.path.separator"]"
say "... j.file.separator=["j.file.separator"]"
*/

  p=value("PATH", , "ENVIRONMENT")
  i=0
  do while p<>""
     parse var p chunk (cmd.ePath.sep) p
     i=i+1

     if cmd.eIsUnix=1 then
        path.i=chunk
     else
        path.i=changestr('"', chunk, "")  /* remove any quotes from any part of the Windows path */

     path.i.upperCase=translate(chunk)  /* uppercase version */
/*
say "... i="i "chunk="pp(chunk)
*/

     path.0=i
  end

  return

/* find needle in path and return it   */
findPath: procedure expose j. cmd. path.
   parse upper arg needles    /* blank delimited, translated into uppercase   */
   do i=1 to words(needles)   /* iterate over needles                         */
      n=word(needles, i)
      do k=1 to path.0        /* iterate over paths      */
         if pos(word(needles,i), path.k.upperCase)>0 then
            return path.k
      end
   end
   return ""



/* Returns the received path in canonized form, i.e. removes "." and "..", wherever possible */
canonizePath: procedure expose j. cmd. path.
   parse arg p

   sep=cmd.eFile.sep             -- get file separator
   tmpArr=p~makeArray(sep)       -- split string
   newArr=.array~new

   k=0      -- index into new array
   do i=1 to tmpArr~items
      w=tmpArr[i]
      if w="." then iterate      -- no need to keep "current directory"
      if w="..", k>0 then        -- can we remove super directory (not if it is ".." already!)
      do
         if newArr[k]<>".." then -- a directory, removing it would be o.k.
         do
               -- on Windows make sure first word is not a drive letter! (leave that untouched)
            if k=1, cmd.eIsUnix=.false, length(newArr[k]=2), substr(newArr[k],2,1)=":" then
               nop
            else
            do
               newArr~remove(k)  -- remove directory
               k=k-1             -- adjust k
               iterate           -- process next chunk
            end

         end
      end
      k=k+1                         -- increment index
      newArr[k]=w                   -- save
   end

   return newArr~makeString("LINE",sep)




/*  2008-05-17, ---rgf
    where is OOo-installed in HKCU or HKLM (we install into the same hive) ?

    returns HKCU or HKLM as first word delimited with a blank from the path
    to OOo's program directory
*/
::routine getOOoHomeDirWindows
  key="Software\OpenOffice.org\UNO\InstallPath\"
  wsh=.OleObject~new("WScript.Shell")

  signal on syntax name syntax1           -- gets triggered if key does not exist in registry
  return "HKCU" wsh~regRead("HKCU\"key)   -- stored in HKCU (user) ?

syntax1:
  signal on syntax name syntax2
  return "HKLM" wsh~regRead("HKLM\"key)   -- stored in HKLM (system) ?

syntax2:                   -- no OOo-entry
  return ""


/* Look for "soffice" on environment variable PATH. If a link, find link's target.
*/
::routine getOOoHomeDirUnix
  val=value("PATH", , "environment")   -- get PATH environment variable's value
  paths=val~makeArray(":")       -- create array from string, use Unix path delimiter (":")

  do p over paths                -- iterate over individual paths
     fn= p"/soffice"
     call sysFileTree fn, "files.", "F"

     if files.0>0 then           -- found!
     do
        parse var files.1 . "->" +3 fullPath    -- try to parse target, if a link in hand

        if fullPath="" then      -- nope, seems to be not a link
        do
           "ls -al" fn "| rxqueue"   -- address shell, let output be queued to us
           if queued()>0 then    -- found, try to get linked path
              parse pull . '->' +3 fullPath

           if fullPath<>"" then
           do
              if left(fullPath,1)="." then	-- path relative, if so prepend original path
                 fullPath=p||'/'||fullPath  -- prepend
           end
           else  -- no link available, use fn
              fullPath=fn
        end

            -- remove trailing "/soffice"
        lpos=fullPath~lastPos("/")           -- get last "/"
        fullPath=fullPath~left(lpos-1)     -- remove trailing "/soffice"

        return fullPath          -- return path to OOo
     end
  end
  return ""                      -- not found


   -- queries needed OOo configuration using "unoinfo" (available starting with OOo 3.x)
::routine getClassPath4OOo
   parse arg path2unoinfo

      -- if path given, and has a blank, make sure it is enquoted so to not have the shell break it up!
   if path2unoinfo<>"", pos(" ",path2unoinfo)>0, path2unoinfo~left(1)<>'"' then
      path2unoinfo='"'path2unoinfo'"'

   java "-cp . JavaInfo4BSF4RexxInstallation getClassPath4OOo" path2unoinfo "| rxqueue"

   parse pull "CLASSPATH " classPath2OOo  -- parse classpath string from return value

   do while queued()>0           -- make sure queue is empty (in case of an error)
      parse pull .
   end

   return classPath2OOo
