@rem 2005-01-17, 2006-07-11, 2006-08-09, 2006-10-07, 2008-06-13, Rony G. Flatscher

@echo createDistribution.cmd (for BSF4Rexx)
@echo .
@echo You need Java 1.4 (for Javadoc because of switch "-subpackages") and
@echo CLASSPATH point to the OOo jars...
@echo .
@pause

set runDate=20080913
set doc_date=2008-09-13

@rem values to use for creating the BSF jarfile
set bsfDate=20080704
set bsfVersion=v244
set bsfJarNameBin=bsf-%bsfVersion%-%bsfDate%.jar
set bsfJarNameSource=bsf-%bsfVersion%-%bsfDate%-source.jar

set oorexx-uno=oorexx-uno.jar


@rem -----------------------------------------------------------------------------------
@echo deleting old jar-files...
del BSF4Rexx-apache-bsf.jar BSF4Rexx-apache-bsf-source.jar bsf-*.jar

@echo creating %bsfJarNameBin% ...
@rem jar cvMf %bsfJarNameBin% org/apache/bsf/
jar cvMf %bsfJarNameBin% org/apache/bsf org/apache/taglibs
zip -d %bsfJarNameBin% *.svn* *bkp* *tmp*

rem rgf, 20070917, not needed, we have BSF4Rexx-apache-bsf-source.jar instead
@rem @echo creating %bsfJarNameSource% ...
rem copy %bsfJarNameBin% %bsfJarNameSource%

@rem now remove sources from bin
zip -dr %bsfJarNameBin% *.java *.txt *.cmd *~
zip -9  %bsfJarNameBin% ApacheLicense2.0.txt

@rem remove compiled classes from source
rem zip -d %bsfJarNameSource% *.class  *~
rem zip -9 %bsfJarNameSource% ApacheLicense2.0.txt


goto after1
rem 2007-01-31, rgf: do not process anymore, will be part of bsf-rexx-engine.jar
rem (the following is superceeded by the copy on drive e:.\com\sun\star\script ...)
@echo creating jar for OOo reflection ...
del %oorexx-uno%
jar cvMf %oorexx-uno% org/oorexx/uno
zip -d %oorexx-uno% *.svn* *bkp/* *.txt *.cmd *halbVersion* *.rex *.cmd  *~
copy org\oorexx\uno\RgfReflectUNO.* F:\work\ooo\ScriptProvider\org\oorexx\uno\

setlocal
f:
cd F:\work\ooo\ScriptProvider\
zip -9 ScriptProviderForooRexx.jar org/oorexx/uno/RgfReflectUNO.*
endlocal

copy F:\work\ooo\ScriptProvider\ScriptProviderForooRexx.jar .\bin\


:after1
call createScriptProviderForooRexx.cmd

@echo creating BSF Rexx engine jar file, containing the OOo support and datergf...
jar cvMf bsf-rexx-engine.jar org/rexxla/ org/oorexx/
rem zip -d bsf-rexx-engine.jar *.svn* *.html *.css *.txt
zip -d bsf-rexx-engine.jar *.svn*
zip -d bsf-rexx-engine.jar *.html
zip -d bsf-rexx-engine.jar *.css
zip -d bsf-rexx-engine.jar *.cmd
zip -d bsf-rexx-engine.jar *bkp*
zip -d bsf-rexx-engine.jar *tmp*
zip -d bsf-rexx-engine.jar *.java
zip -d bsf-rexx-engine.jar *.txt
zip -d bsf-rexx-engine.jar *~
rem make sure the ApacheLicense2.0.txt file is available
zip -9r bsf-rexx-engine.jar ApacheLicense2.0.txt

@echo creating main-jar file...
jar cvMf BSF4Rexx-apache-bsf.jar org/

@echo removing unneeded entries
zip -d BSF4Rexx-apache-bsf.jar org/apache/commons
zip -d BSF4Rexx-apache-bsf.jar *.svn*
zip -d BSF4Rexx-apache-bsf.jar *bkp*
zip -d BSF4Rexx-apache-bsf.jar *tmp*
zip -d BSF4Rexx-apache-bsf.jar *~

rem make sure the ApacheLicense2.0.txt file is available
zip -9r BSF4Rexx-apache-bsf.jar ApacheLicense2.0.txt
@pause

@echo creating the binary and source jar-files ...
copy BSF4Rexx-apache-bsf.jar BSF4Rexx-apache-bsf-source.jar

zip -9r BSF4Rexx-apache-bsf-source.jar com/sun/

zip -d BSF4Rexx-apache-bsf-source.jar *.svn*
zip -d BSF4Rexx-apache-bsf-source.jar *bkp*
zip -d BSF4Rexx-apache-bsf-source.jar *tmp*
zip -d BSF4Rexx-apache-bsf-source.jar *~

zip -d BSF4Rexx-apache-bsf-source.jar *.class
zip -d BSF4Rexx-apache-bsf-source.jar *~

rem 2007-01-31, rgf: not needed anymore!
rem zip -d BSF4Rexx-apache-bsf.jar        *.java
rem zip -d BSF4Rexx-apache-bsf.jar        *.cmd
rem zip -d BSF4Rexx-apache-bsf.jar        *.txt
rem zip -d BSF4Rexx-apache-bsf-source.jar *.class

del BSF4Rexx-apache-bsf.jar

dir *.jar
@echo finished.
@pause


@rem -----------------------------------------------------------------------------------
@echo creating Javadocs ...
@echo [use at least Java 1.5 (5.0) and make OOo class files available via classpath!]
call make-docs-apache.cmd
@echo deleting old zip-archives for Javadocs ...
del docs_apache_bsf.zip docs_bsf4rexx.zip

@echo creating zip-archives for Javadocs
zip -9r docs_apache_bsf docs.apache.bsf/*
zip -9r docs_apache_bsf ApacheLicense2.0.txt

zip -9r docs_bsf4rexx docs.bsf4rexx/*
zip -9r docs_bsf4rexx ApacheLicense2.0.txt
@echo finished.
@pause


@rem -----------------------------------------------------------------------------------
@echo deleting install directory
rm -rf bsf4rexx

@echo creating install directory and populating it ...
md bsf4rexx
copy *.txt                              bsf4rexx\
copy bsf-*.jar                          bsf4rexx\
copy ScriptProviderForooRexx.jar        bsf4rexx\
copy bin\add*.rex                       bsf4rexx\
copy bin\BSF.CLS                        bsf4rexx\
copy bin\BSF4*dll                       bsf4rexx\
copy bin\BSF4*rex                       bsf4rexx\
copy bin\info*.rex                      bsf4rexx\
copy bin\Java*                          bsf4rexx\
copy bin\orx2reg.rex                    bsf4rexx\
copy bin\rexxj2*                        bsf4rexx\
copy bin\setup*.rex                     bsf4rexx\
copy bin\libBS*                         bsf4rexx\
copy bin\testOOo.rex                    bsf4rexx\
copy bin\testOOo2.rex                   bsf4rexx\
copy bin\oooReflectionUtil.cls          bsf4rexx\
copy bin\UNO*                           bsf4rexx\
copy refcard*.pdf                       bsf4rexx\

del bsf4rexx\*bkp*

del samples\OOo\*.jpg
del samples\OOo\*.pdf
xcopy samples\*                         bsf4rexx\samples\   /s/e/i/r/k/y

del BSF4Rexx_install.zip
zip -9r BSF4Rexx_install bsf4rexx/*
zip -d  BSF4Rexx_install *.svn* *bkp* *tmp* *cachedir* *~
zip -9r BSF4Rexx_install ApacheLicense2.0.txt

@echo finished.
@pause

@rem @rem -----------------------------------------------------------------------------------
@rem  as of 2006-01-17: part of the binary distribution
@rem @echo creating sample archive ...
@rem del BSF4Rexx_samples.zip
@rem del samples\OOo\*.jpg
@rem del samples\OOo\*.pdf
@rem zip -9r BSF4Rexx_samples samples/*
@rem zip -9r BSF4Rexx_samples ApacheLicense2.0.txt
@rem zip -dr BSF4Rexx_samples *.svn*
@rem @pause


@rem -----------------------------------------------------------------------------------
@echo creating test archive ...
del BSF4Rexx_tests.zip
zip -9r BSF4Rexx_tests test/*
zip -9r BSF4Rexx_tests ApacheLicense2.0.txt
zip -dr BSF4Rexx_tests *.svn* *bkp* *_bkp* *tmp*  *~
@pause


@rem -----------------------------------------------------------------------------------
@echo creating source archive ...
del BSF4Rexx_sources.zip
zip -9 BSF4Rexx_sources ApacheLicense2.0.txt
zip -9 BSF4Rexx_sources *.txt
zip -9 BSF4Rexx_sources *.cmd
zip -9 BSF4Rexx_sources *.mf
zip -9 BSF4Rexx_sources com/sun/*
zip -9 BSF4Rexx_sources source_cc/BSF4Rexx.cc
zip -9 BSF4Rexx_sources source_cc/*.def
zip -9 BSF4Rexx_sources source_cc/*.cmd
zip -9 BSF4Rexx_sources source_cc/*.txt
zip -9 BSF4Rexx_sources source_cc/*mak*
zip -9 BSF4Rexx_sources source_cc/*.h
zip -9 BSF4Rexx_sources source_cc/*.dll
zip -9 BSF4Rexx_sources source_cc/*.so
zip -9 BSF4Rexx_sources source_java/*
zip -9 BSF4Rexx_sources source_java/apache-rexxla/*
zip -9 BSF4Rexx_sources source_java/ibm-rexxla/*
zip -dr BSF4Rexx_sources *.svn*  *~
@pause

dir *.jar *.zip











