/*
   last change: $Revision: 281 $ $Author: rony $ $Date: 2008-09-04 09:17:35 +0200 (Thu, 04 Sep 2008) $

        ------- cut here -------
        bsf4rexx.def

; -----------------------------------------------------------------------------

; 2001-06-01, ---rgf, definition file for creating the "BSF4Rexx.dll" with
; 2003-04-16, ---rgf, definition file for creating the "BSF4Rexx.dll" for Apache's BSF (2.3) with
;             the linker under OS/2 (IBM's VACPP) and Windows (MS's VS-CPP)
; 2004-04-04, ---rgf, created BSF-neutral Rexx engine

; 'INITINSTANCE' important for OS/2 (IBM's VACPP)
LIBRARY BSF4Rexx INITINSTANCE
HEAPSIZE  40960
STACKSIZE 40960
DESCRIPTION 'BSF4Rexx-rexxla/rgf 2008-07-14'

; 'DATA' statement as is important for OS/2 (IBM's VACPP)
; on Windows, MSVACPP will warn, but ignore the statement
DATA MULTIPLE NONSHARED READWRITE

; functions in the DLL to be made available to other programs
EXPORTS BSF
EXPORTS Java_org_rexxla_bsf_engines_rexx_RexxAndJava_jniRexxStart
EXPORTS Java_org_rexxla_bsf_engines_rexx_RexxAndJava_jniRegisterBSF

; 2003-01-21, support for calling & registering from Rexx
EXPORTS BSFINVOKEDBY                = BsfInvokedBy
EXPORTS BSFLOADFUNCS                = BsfLoadFuncs
EXPORTS BSFDROPFUNCS                = BsfDropFuncs

EXPORTS BSFLOADJAVA                 = BsfLoadJava
EXPORTS BSFUNLOADJAVA               = BsfUnloadJava

; 2003-01-26, support for informational functions
EXPORTS BSFVERSION                  = BsfVersion
EXPORTS BSFQUERYALLFUNCTIONS        = BsfQueryAllFunctions
EXPORTS BSFQUERYREGISTEREDFUNCTIONS = BsfQueryRegisteredFunctions

; 2003-08-06, support for threads
EXPORTS BSFATTACHTOTID              = BsfAttachToTID
EXPORTS BSFGETTID                   = BsfGetTID

; 2006-11-19, new function
EXPORTS BSFSHOWERRORMESSAGE         = BsfShowErrorMessage

; 2008-07-26
EXPORTS BSFDETACH                   = BsfDetach



  * This DLL registers the function "BSF" with Rexx;
  * it allows Java to call into Rexx using the fine RexxSAA-interface
  * conventions and JNI ("Java Native Interface").
  *
  * last change: $Revision: 281 $ $Author: rony $ $Date: 2008-09-04 09:17:35 +0200 (Thu, 04 Sep 2008) $
  *
                    2.8.0 2008-09-03: - if nested invocation (invoking a new Rexx interpreter in the same
                                        thread where an instance of a Rexx interpreter is already running)
                                        of the Rexx interpreter, do not wait for termination in the nested
                                        invocation (ooRexx 3.2.0 waits forever)

                          2008-09-01: - removed superfluous variables in BsfUnloadJava()

                    2.7.9 2008-08-20: - added RexxDidRexxTerminate() and RexxWaitForTermination()
                                        to jni...RexxStart(), such that concurrently running ooRexx
                                        threads can continue to run
                                      - RXSIO buffer is now not globally allocated/freed

                    2.7.8 2008-08-14: - added ability to nest jniRexxStart()-calls with the restriction
                                        that only one ooRexx thread may be using the nested one, otherwise
                                        a Java exception will be raised

                    2.7.7 2008-08-10: - fixed error (prematurely freeing rsb.-buffer)
                                      - cleaned up a little bit (removing most of the obsolete code)

  *                 2.7.6 2008-08-06: - RgfFreeMemory() of RXSIO buffer upon successful deregistration
  *
  *                 2.7.5 2008-07-23 bis 2008-08-06:
  *

  *                 -- major revamp of JNI management (new structs, new data structures,
  *                    new inline functions, new flow of control) for calling back into Java

                    -- now possible to call into Java from different ooRexx threads, giving, that
                       they attach to the ooRexx thread that established the BSF4Rexx bridge
  *
  *                2.7.4 2008-07-13 bis 2008-07-14:
  *                --- CLEANUP: getting rid of JNI 1.1 & OS/2 support
  *                                 - BSFUnloadJava: now uses JNI to unload Java, oldGlobal-vars removed
  *                                 - changed to C++ syntax "(env*)." to "env->"
  *                                 - using ExceptionCheck() in lieu of ExceptionOccurred() to test for pending exceptions
  *                                 - activating (and debugging) DetachThread()
  *
  *
  *                2.7.3 2008-07-01, rgf, experimental: using Throwable.toString() instead of
  *                                  Throwable.getMessage() to get not only the message, but also
                                     the type of Exception
  *
                   2.7.2 2008-06-14, rgf, honoring source-location argument for script from Java
  *                      2008-06-09, rgf, found an argument sequence error in commented code (rgfDetachCurrentThread())

  *                2.7.1 2007-09-26, rgf, corrected tests for DEBUG level, such that compilation
  *                                  is possible with all DEBUG levels (DEBUG, DEBUG1, DEBUG2,
  *                                  DEBUG3, DEBUG_THREADS); pointed out by Rene Jansen
  *
  *                2.7.0 2006-11-19, rgf, added function BsfDoNotShowErrorString()
  *
  *                2.6.0 2006-02-xx, removed all JNI 1.1 code
  *
  *                2.5.9 2006-01-28, changed logic for RXSIO exit to allow compiling under Linux [of min() function
  *                                  not available on gcc], also inserted an elipsis (...) if truncating a Rexx
  *                                  stderr string to fit into 512 bytes per line);
  *                                  fixed conversion omission: now converts JavaString in Java-passed-in arguments
  *                                  to a native string (byte array translated according to local codepage) for the
  *                                  Rexx arguments
  *
  *                2.5.8 2006-01-27, created a RXSIO exit, which memorizes stderr-outputs from Rexx; in case of
  *                                  an execution error, the last three lines (containing the Rexx error message)
  *                                  are used to create a Java exception (org.apache.bsf.BSFException)
  *
  *                2.5.7 2006-01-22, BSF() now returns the result translated to a native string using the current
  *                                  codepage
  *
  *                2.5.6 2006-01-06, if Rexx arguments do not set java.class.path and the CLASSPATH environment
  *                                  variable is set, then use that value for starting up the JVM
  *
  *                2.5.6 2006-01-04, changed loading JVM, with JNI >= 1_2 now all Rexx arguments are passed through,
  *                                  started to enclose JNI_1_1 code in "#ifdef SUPPORT_JNI_1_1" to eventually
  *                                  get rid of it
  *
  *                2.5.4 2005-08-30, changed license to Apache v2.0, CPLv1.0;
  *                                  adjusted version number to match the Java support program ones
  *
  *                2.1.3 2005-06-02, moved RexxEngine to 'org.rexxla.bsf.engines', code adopted,
  *                                  removed dependency on "com.ibm.bsf" and "org.apache.bsf": will be addressed by the Rexx engine
  *
  *                2.1.2 2003-08-14, Linux-version works (with Java 1.4); needed to
  *                                  remove DetachCurrentThread() to prohibit exceptions
  *                                  in Sun's native "java" code; also removes occassional traps
  *                                  on Windows for Java 1.3 and 1.4
  *
  *                2.1.1 2003-08-11, started to adapt to Linux and OS/2 (eComStation)
  *
  *                2.1.1 2003-08-09, started to add ability to use this DLL for JNI 1.1 (Java 1.1) *and* 1.2 (Java 1.2, 1.3, 1.4)
  *                                  (some remarks: on Java 1.1 - global references in Hashtable will return *local* references;
  *                                  on Java 1.2 - UTF-strings need to be pinned down with global references;
  *                                  on Java 1.2, 1.3, 1.4 - sometimes JNI looses thread-infox it seems; "healed"
  *                                  by attaching again, although env was received by JNI!)
  *
  *                2.1.0 2003-08-08, takes care of threaded Object Rexx programs calling
  *                                  back at the same time, but potentially using different physical
  *                                  threads (under control of the Object Rexx thread-dispatcher)
  *
  *                2.0.0 2003-04-30, as BSFManager caches the RexxEngine it is important to make
  *                                  sure that the BSF-functions are registered before the Rexx
  *                                  script gets executed by the Rexx interpreter, ---rgf
  *                                  now lists the BSFFunctions in alphabetical order
  *
  *                2.0.0 2003-04-16, final version to be introduced at the 2003 International Rexx Symposium
  *                                  caters for IBM (BSF 2.2) and Apache (BSF 2.3 and higher)
  *
  *                1.9.4 2003-04-14, adjusted Rexx memory to what it is supposed to be, ie.:
  *                                  - never release memory allocated by Rexx
  *                                  - if allocating memory, then freeing it is o.k.
  *                                  - Rexx creates RXSTRINGS with a buffer size of 256L (RXAUTOBUFLEN)
  *                                    if size is not sufficient, create a larger buffer, but do
  *                                    NOT free Rexx'
  *
  *                1.9.3 2003-04-05, adjusted for Linux (RH 7.2)
  *                1.9.2 2003-02-19, switched arguments for BsfLoadJava, now arg(1)=classpath,
  *                     arg(2)=Append/Prepend;
  *                1.9.1 2003-02-12, adjusting for JNI 1.1 *and* 1.2 (as starting with
  *                     Java 1.4 the JNI 1.1 interface does not work anymore (just bombs)
  *
  *                1.9.0 2003-01-27, ---rgf, added ability to load JVM from the Rexx side,
  *                     initializing BSF4Rexx from the Java side as well, such that all of
  *                     BSF4Rexx' functionality is available to Rexx programs started by Rexx
  *
  *                1.2.1 2003-01-06, ---rgf, finally found bug causing Object Rexx to bomb (but also Regina, it turned out!)
  *                               reason: freeing memory for Rexx-code with wrong method !
  *
  *                2003-01-05, ---rgf, adapted to Mark Hessling's great "Rexx/Trans"
  *                      (cf. <http://rexxtrans.sourceforge.net/>), which allows for
  *                      generic support for any supported Rexx interpreter, e.g.:
  *
  *                         Regina <http://regina-rexx.sourceforge.net/>,
  *                         IBM Object Rexx <http://www.software.ibm.com/ad/obj-rexx/>,
  *                         Quercus Systems Personal Rexx <http://www.quercus-sys.com/>,
  *                         Enterprise Rexx <http://www.WinREXX.com/>
  *
  *                 2001-06-11, ---rgf, runs with JNI 1 (does *not* need JRE 1.2 or higher
  *                         anymore, so OS/2 users with 1.1.8 can use this package as well)
  *
  * author:  (c) 2001-2008 Rony G. Flatscher, WU (pronounced: "vey-u") Vienna University of Economics
  *                          and Business Administration
  *
  *  LICENSE:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright 2001-2008 Rony G. Flatscher

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------

*/




#ifdef __cplusplus
extern "C" {            // make sure no C++ name mangling comes into the way
#endif




// Java 1.1 o.k., Java 1.2 trap-popup-window, Java 1.3 shows DLLs does NOT create log-file,
// Java 1.4 just shows there is "Another exception while handling last error ..

// #define DEBUG
// #define DEBUG1
// #define DEBUG2
// #define DEBUG3
// #define DEBUG_THREADS

// #define RGF_INFO    // 2008-07-23, for debugging new JNI-interface implementation
// #define RGF_INFO_1  // 2008-07-23, for debugging new JNI-interface implementation

// #define RGF_ATTACH  // 2008-08-05, for debugging Attaching
// #define RGF_DETACH  // 2008-08-05, for debugging Detaching
// #define RGF_BIT     // 2008-08-06, for debugging individual points; use JPane-popups

// #define RGF_BIT2    // 2008-08-24


// #define RGF_MUTEX4RXSIOTRC  // 2008-08-06, testing RXSIOTRC in multithreading mode, undefine for production
// #define RGF_INVALID_ROUTINE     // 2008-08-12

// #define RXSIO_USE_RGF_ALLOC     // 2008-08-14, rgf


#define INCL_RXSYSEXIT          // ---rgf, 2006-01-27: include Rexx exit definitions

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>


#ifdef WINDOWS                  //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
   #define ALLOW_LOADING_JVM
#endif


#ifdef UNIX
   #include <dlfcn.h>       // use the dynamic link functions

    // Object Rexx 2.3.3 (2002-11-26) under Unix sometimes looses track of the registered external BSF-functions
    // Object Rexx 2.1.? seems to "forget" registered external functions in its threads
//   #define CHECK_4_FORGOTTEN_BSF_FUNCTIONS  // ---rgf, 2008-08-06, deactivated

   #ifndef __APPLE__    // not for Apple (would need to split off the JVM loading part)
       #define ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
   #endif
#endif

#define INCL_RXSHV
#define INCL_RXFUNC

#ifdef USE_REXXTRANS
# include <rexxtrans.h>

#elif defined USE_OREXX
# include <rexx.h>

#else
# include <rexxsaa.h>
#endif




      // under Linux gcc RH 7.3 not defined, ---rgf, 2003-04-05
#ifndef FALSE
    #define FALSE 0
#endif

#ifndef INT
    #define INT int
#endif
    // end (Linux RH 7.2)


#ifdef _MSC_VER
# pragma warning(disable:4100)
#endif



// -------------------- JNI-interface related
#include "org_rexxla_bsf_engines_rexx_RexxAndJava.h" // rgf, 2005-06-02

#define USE_DEFINED_JNI_VERSION     JNI_VERSION_1_2 //  JNI_VERSION_1_4

// typedef jint (JNICALL *rgf_AttachCurrentThread)  (JavaVM  *, void **, void *);
typedef jint (JNICALL *rgf_JNI_CreateJavaVM)             (JavaVM **, void **, void *);
typedef jint (JNICALL *rgf_JNI_GetDefaultJavaVMInitArgs) (void    *);


#define BSF_VERSION     "280.20080903 org/rexxla/bsf/engines/rexx"  // version: "MajorNumber"."YYYYMMDD"
#define JAVA_4_REXX     "org/rexxla/bsf/engines/rexx/Java4Rexx"     // 2005-06-02, supportive Java4Rexx-class

#define RGF_RXSIO_EXIT_NAME         Rgf_RXSIO_Exit     // ---rgf, 2006-01-27
#define RGF_RXSIO_EXIT_NAME_STRING "Rgf_RXSIO_Exit"    // ---rgf, 2006-01-27

typedef struct {
   PCHAR strBuffer ;        // buffer to contain the last four lines to stderr (< 512bytes)
   PINT  intBuffer ;        // [0] ... present count, [1] ... points to next entry (0...3)
} RGF_STDERR_BUFFER ;



#define DLLNAME         "BSF4Rexx"      // name of DLL and name for "PARSE SOURCE"
#define JAVA_CALL_BSF   "javaCallBSF"   // name of the Java method that carries out the BSF()-call

#define  INVALID_ROUTINE 40            /* Rexx: raise Rexx error # 40   */
#define  VALID_ROUTINE    0            /* Rexx: successful completion   */

int       JNI_RUNTIME_VERSION = 0;     // Java versions: 1=1.1, 2=1.2, 4=1.4, ...


// rgf, 2008-08-01
JavaVM    *currentJVM=NULL;     // JVM to use
int       bsfInvokedBy = 0;     // 0=noJVM, 1=byJava, 2=byRexx

    // calculate the needed bytes for representing a pointer as hex-string with trailing \0
const int CONST_LENGTH_OF_POINTER_0 = sizeof( PVOID )*2+1;

    // ---rgf, 2006-11-19: define boolean and maximum length for Java's event trace
int       bShowErrorString = 1;         // default to showing (dumping) Java traceback in case of an error
#define BSF_ERROR_STRING  "BSF_ERROR_MESSAGE"    // variable name to use to save Java error message in Rexx variable
const int lenBsfErrorString = strlen(BSF_ERROR_STRING);   // calc length once and forever




// 2008-07-23, rgf >------------------------------------------------------------------------------------
// 2008-07-23: new structures for revamped logic
//
//  JRST    thread of jniRexxStart
//  RT      main thread of Rexx instance
//  BSFT    thread of current BSF() invocation
//  BLJT    thread of Rexx instance in which LoadJava() is invoked
//
//  RAJO    RexxAndJava instance (used to communicate with the Java side as well)

#ifdef UNIX
   #define PATH_SEPARATOR ':'
   pthread_mutex_t JRST_lock = PTHREAD_MUTEX_INITIALIZER;   // rgf, 2008-07-23
   pthread_mutex_t RXSIO_lock = PTHREAD_MUTEX_INITIALIZER;  // rgf, 2008-08-06

#elif defined WIN32
   #define PATH_SEPARATOR ';'
   CRITICAL_SECTION JRST_lock;                              // rgf, 2008-07-23
   CRITICAL_SECTION RXSIO_lock;                             // rgf, 2008-08-06
#endif

    // JRST: memorizes the JNI env, the RAJO and sets up important objects
typedef struct _STRUCT_JRST {
    struct _STRUCT_JRST        *dependsOn;          // if NULL, this creates global refs, else links to JRST that created global refs
#ifdef UNIX
    pthread_t                   tid;                // TID of this JRST
#else
    TID                         tid;                // TID of this JRST
#endif
    JavaVM                     *pjvm;               // JVM in use
    JNIEnv                     *penv;               // JNI environment pointer
    jobject                     rajo;               // RexxAndJava instance to communicate with
    jmethodID                   mid_javaCallFromBSF;// method 'javaCallBSF' TODO: rename method name to "javaCallFromBSF" in RexxAndJava ?
    jclass                      clz_String;         // java.lang.String class object
    jstring                     emptyUTFString;     // Java empty string
    jmethodID                   mid_initFromByteArray;  // <init> with byte-array
    jmethodID                   mid_getBytes;       // "getBytes"-method
}  STRUCT_JRST;

typedef STRUCT_JRST *PSTRUCT_JRST;                  // pointer to structure
long size_STRUCT_JRST=sizeof(STRUCT_JRST);          // get and memorize size of structure


    // documents the mapping between TID <-> JRST
typedef struct _STRUCT_TID2JRST {
    struct _STRUCT_TID2JRST     *next;  // pointer to next block
    int                         counter;               // counter, indicating how many different TID are using this JRST block
#ifdef UNIX
    pthread_t                   tid;
#else
    TID                         tid;    // current TID
#endif
    PSTRUCT_JRST                jrst;   // associated with JRST
}  STRUCT_TID2JRST;

typedef STRUCT_TID2JRST *PSTRUCT_TID2JRST;          // pointer to structure
long size_STRUCT_TID2JRST=sizeof(STRUCT_TID2JRST);  // get and memorize size of structure
PSTRUCT_TID2JRST pRoot_TID2JRST=NULL;               // root of TID2JRST list


    // rgf, 2008-08-14: list of nested TID2JRSTs (used as LIFO/stack)
    //                  nesting is only allowed, if for the nesting TID's JRST no other ooRexx
    //                  threads exist (tested by RgfCountUsageOfJRST() ), hence this
    //                  list only needs to save the (only) TID2JRST node
typedef struct _STRUCT_SAVE_NESTED_JRST {
    struct _STRUCT_SAVE_NESTED_JRST  *next; // pointer to next SAVE_NESTED_JRST
#ifdef UNIX
    pthread_t                   tid;
#else
    TID                         tid;        // current TID
#endif
    PSTRUCT_TID2JRST            tid2jrst;   // save its TID2JRST node
}  STRUCT_SAVE_NESTED_JRST;

typedef STRUCT_SAVE_NESTED_JRST *PSTRUCT_SAVE_NESTED_JRST;        // pointer to structure
long size_STRUCT_SAVE_NESTED_JRST=sizeof(STRUCT_SAVE_NESTED_JRST);// get and memorize size of structure
PSTRUCT_SAVE_NESTED_JRST pRoot_SAVE_NESTED_JRST=NULL;             // root of list SAVE_NESTED_JRST



// forward prototypes
    PVOID RgfAllocateMemory(long size);
    void  RgfFreeMemory (void * memory);
    VOID  RgfAcquireLock();
    VOID  RgfReleaseLock();
    int   RgfRemoveTID2JRST_node(PSTRUCT_JRST jrst, int bAllDependent);
    int   RgfRemoveTID2JRST(PSTRUCT_JRST jrst, int bForce);
    void  JNU_MessageBox (JNIEnv *env, const char *msg);

    PSTRUCT_JRST RgfGetJRST_by_TID(
    #ifdef UNIX
        pthread_t
    #else
        TID
    #endif
                  tid);



// INLINE definitions

    // get toString value from Java object, copy it into supplied buffer
    //
    //          // example of using JAVA_TO_STRING
    //      char b1[512]="";
    //      JAVA_TO_STRING(env,  obj, b1);
    //      fprintf(stderr, "b1=[%s]\n", b1);
    //
    //          // or (employing the RexxAndJava object) maybe:
    //      char * b2=(char *) RgfAllocateMemory(512);
    //      JAVA_TO_STRING(a_JRST->penv, a_JRST->rajo, b2);
    //      fprintf(stderr, "b2=[%s]\n", b2);
    //      RgfFreeMemory(b2);
    //
inline VOID JAVA_TO_STRING (JNIEnv *env, jobject jo, char * buffer)
{
    jclass         joc=env->GetObjectClass(jo);
    jmethodID jmidName=env->GetMethodID(joc, "toString", "()Ljava/lang/String;");
    jobject       jobj=env->CallObjectMethod(jo, jmidName, NULL);

    if ( env->ExceptionCheck() )    // lighter (jboolean: JNI_TRUE, if pending exception), does not create exception object
    {
        env->ExceptionDescribe();
        env->ExceptionClear();
        fprintf(stderr, "!!!    JAVA_TO_STRING_ENV(), exception: jo=[%p], joc[%p]\n", jo, joc);
        fflush(stderr);
    }

    const char *tmpStr=env->GetStringUTFChars( (jstring) jobj, JNI_FALSE);
    strcpy(buffer, tmpStr);
    env->ReleaseStringUTFChars( (jstring) jobj, tmpStr);
}



    // query current TID and return it
inline
#ifdef UNIX
    pthread_t
#else   // WIN32
    TID
#endif
              RgfGetTID()
{
    return
    #ifdef UNIX
        pthread_self();
    #else // if defined WIN32
        GetCurrentThreadId();
    #endif
}




    // create a string showing the TID2JRST-list
    // (caller is responsible for having a MUTEX set)
inline void RgfShowTID2JRSTlist(const char * title, char * val)
{
    PSTRUCT_TID2JRST i=NULL;
    int n=0;
    const char *pattern="        # %2d: node=[%p] tid=[%lu], counter=[%d], jrst=[%p/%p::%p] (jrst->dependent=[%p]), next=[%p]\n";
    char str[256]="";

    sprintf(val, "    [%s]:\n", title);

    if (pRoot_TID2JRST==NULL) {
        strcat(val, "        # 0: -> EMPTY TID2JRST (pRoot_TID2JRST==NULL) <-");
    }

    for (i=pRoot_TID2JRST,n=1; i!=NULL && n<20; i=i->next, n++) {
        sprintf(str, pattern, n, i, i->tid, i->counter,
                        i->jrst,
                        (i->jrst==NULL ? NULL : i->jrst->penv),
                        (i->jrst==NULL ? NULL : i->jrst->rajo),
                     i->jrst->dependsOn, i->next);
        strcat(val, str);
    }
}



    // rgf, 2008-08-14, count and return total number of JRST usages
    // (caller is responsible for having a MUTEX set)
inline int RgfCountUsageOfJRST (
    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
                  tid
#ifdef RGF_BIT
    , JNIEnv *env
#endif
                  )
{
#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: RgfCountUsageOfJRST 1 ...\n");
         fflush(stderr);
#endif

         int                iCount=0;
         PSTRUCT_TID2JRST       i=NULL;
         PSTRUCT_JRST     tmpJrst=NULL;

#ifdef RGF_BIT
     {
         char title2  [512]="";
         sprintf(title2, "BSF4Rexx.cc: \n... RgfCountUsageOfJRST(), 1: tid=[%lu]\n",
                        (unsigned long) tid);
         JNU_MessageBox(env, title2);
     }
#endif



         // find TID2JRST node
         for (i=pRoot_TID2JRST; i!=NULL; i=i->next) {
             if (i->tid==tid) {
                 tmpJrst=i->jrst;          // save JRST
                 break;
             }
         }

#ifdef RGF_BIT
     {
         char title2  [512]="";
         sprintf(title2, "BSF4Rexx.cc: \n... RgfCountUsageOfJRST(), 2: tid=[%lu], i=[%p], tmpJrst=[%p]\n",
                        (unsigned long) tid, i, tmpJrst);
         JNU_MessageBox(env, title2);
     }
#endif

         if (tmpJrst==NULL) {          // no entry for given tid found in TID2JRST list


#ifdef RGF_BIT
     {
         char title2  [512]="";
         sprintf(title2, "BSF4Rexx.cc: \n... RgfCountUsageOfJRST(), 2a: tid=[%lu], i=[%p], tmpJrst=[%p]\n",
                        (unsigned long) tid, i, tmpJrst);
         JNU_MessageBox(env, title2);
     }
#endif

#if defined (RGF_INFO_1)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfCountUsageOfJRST 2a - returning iCount=[%d]\n", iCount);
         fflush(stderr);
#endif
             return 0;
         }

         // iCount all JRST-usages
         for (i=pRoot_TID2JRST; i!=NULL; i=i->next) {
             if ((i->jrst==tmpJrst) || (i->jrst->dependsOn==tmpJrst)) {
                 iCount++;
             }
#ifdef RGF_BIT
     {
         char title2  [512]="";
         sprintf(title2, "BSF4Rexx.cc: \n... RgfCountUsageOfJRST(), 2b: tid=[%lu], i=[%p], i->next=[%p] -> iCount=[%d]\n",
                        (unsigned long) tid, i, i->next, iCount);
         JNU_MessageBox(env, title2);
     }
#endif
         }

#ifdef RGF_BIT
     {
         char title2  [512]="";
         sprintf(title2, "BSF4Rexx.cc: \n... RgfCountUsageOfJRST(), 3: tid=[%lu], i=[%p], tmpJrst=[%p] -> iCount=[%d]\n",
                        (unsigned long) tid, i, tmpJrst, iCount);
         JNU_MessageBox(env, title2);
     }
#endif

#if defined (RGF_INFO_1)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfCountUsageOfJRST 2b - returning iCount=[%d]\n", iCount);
         fflush(stderr);
#endif
         return iCount;
}



    // rgf, 2008-08-14, save TID2JRST node (and thereby reference to its JRST node)
    //                  created for given "tid" // (caller is responsible for having a MUTEX set)
inline int RgfSaveTID2JRST (
    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
                  tid)
{
#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: RgfSaveTID2JRST 1 ...\n");
         fflush(stderr);
#endif

         PSTRUCT_TID2JRST    i=NULL, old=NULL;

         // find TID2JRST node
         for (i=pRoot_TID2JRST; i!=NULL; i=i->next) {
             if (i->tid==tid) {
                 break;             // found, leave loop
             }
             old=i;                 // save
         }

         if (i==NULL) {             // not found!
#if defined (RGF_INFO_1)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfSaveTID2JRST 2a - NO TID2JRST node matching tid=[%lu] found!\n",
                                  (unsigned long) tid);
         fflush(stderr);
#endif
             return FALSE;
         }

         // create a SAVE_NESTED_JRST node, push it into list
         PSTRUCT_SAVE_NESTED_JRST newNode=(PSTRUCT_SAVE_NESTED_JRST) RgfAllocateMemory(size_STRUCT_SAVE_NESTED_JRST);
         memset(newNode,0,size_STRUCT_SAVE_NESTED_JRST);     // set everything to 0

         newNode->tid2jrst=i;       // save TID2JRST node
         newNode->tid     =tid;     // save TID

         if (pRoot_SAVE_NESTED_JRST!=NULL) {
             newNode->next=pRoot_SAVE_NESTED_JRST;  // let newNode point to existing next
         }
         pRoot_SAVE_NESTED_JRST=newNode;    // let root now point to newNode

         // remove saved TID2JRST node from TID2JRST list
         if (old!=NULL) {           // let previous node now point to i's next node
             old->next=i->next;
         }
         else {                     // next node is new root
             pRoot_TID2JRST=i->next;
         }
         i->next=NULL;              // make sure, that next pointer on saved TID2JRST node is deleted


#if defined (RGF_INFO_1)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfSaveTID2JRST 2b - success!");
         fflush(stderr);
#endif
         return TRUE;          // return TID2JRST node
}



    // rgf, 2008-08-14, restore saved TID2JRST node, make sure to delete current TID2JRST and JRST first,
    //                  returns # of deleted (waning) TID2JRST nodes (caller is responsible for having a MUTEX set)
inline int RgfRestoreTID2JRST (
    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
                  tid)
{
#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: RgfRestoreTID2JRST 1 ...\n");
         fflush(stderr);
#endif

         PSTRUCT_TID2JRST           i=NULL;
         PSTRUCT_SAVE_NESTED_JRST snj=NULL, snjOld=NULL;

         // locate SAVE node, if not found return false
         for (snj=pRoot_SAVE_NESTED_JRST; snj!=NULL; snj=snj->next) {
             if (snj->tid==tid) {       // matching node found ?
                 break;
             }
             snjOld=snj;        // save
         }

         if (snj==NULL) {       // not found!
#if defined (RGF_INFO_1)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfRestoreTID2JRST 2a - NO SAVE_NESTED_JRST node matching tid=[%lu] found!\n",
                                  (unsigned long) tid);
         fflush(stderr);
#endif
             return FALSE;
         }


/* ---> TID2JRST node and all references to its JRST as well as the JRST node itself got already taken care at the end of ...jniRexxStart
         // locate current TID2JRST node, if any
            // if TID2JRST node exists, make sure it and its JRST (plus its usages) gets removed

         // find TID2JRST node

         int                   iCount=0;
         for (i=pRoot_TID2JRST; i!=NULL; i->next) {
             if (i->tid==tid) {
                 break;             // found, leave loop
             }
         }

         if (i!=NULL) {             // TID2JRST node exists
             // delete all TID2JRST nodes that use/dependOn "i->jrst" and "i->jrst" node itself
             iCount=RgfRemoveTID2JRST(i->jrst,TRUE);  // save count of TID2JRST removals
         }
---> */

         // always insert SAVE node at head of TID2JRST list
         if (pRoot_TID2JRST!=NULL) {
             snj->tid2jrst->next=pRoot_TID2JRST; // let saved node point to root's next node
         }
         pRoot_TID2JRST=snj->tid2jrst;  // new root is restored TID2JRST node (LIFO)

         // remove SAVE node
         if (snjOld!=NULL) {        // let previous node point to next one
             snjOld->next=snj->next;
         }
         else {                     // next node is new root
             pRoot_SAVE_NESTED_JRST=snj->next;
         }
         RgfFreeMemory(snj);        // free SAVE_NESTED_JRST node


#if defined (RGF_INFO_1)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfRestoreTID2JRST 2b - success!");
         fflush(stderr);
#endif
         return TRUE;
}






    // create and initialize a new JRST node, push it into the JRST list (becomes first node)
    // (caller is responsible for having a MUTEX set)
inline PSTRUCT_JRST RgfNewJRST (
    #ifdef UNIX
        pthread_t
    #else
        TID
    #endif
                  tid, JNIEnv *penv, jobject jo, PSTRUCT_JRST useJRST)
{

#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: RgfNewJRST - 1, tid=[%lu] ...\n", (unsigned long) tid);
         fflush(stderr);
#endif

    PSTRUCT_JRST newNode=(PSTRUCT_JRST) RgfAllocateMemory(size_STRUCT_JRST);
    memset(newNode,0,size_STRUCT_JRST);     // set everything to 0

        // fill-in arguments
    newNode->tid      =tid;     // save this TID
    penv->GetJavaVM(& newNode->pjvm);   // get and save the JavaVM for this env
    newNode->penv     =penv;    // save this thread's JNIEnv

        // get and set global references to repeatedly needed Java objects (this is the first=main thread of the thread group)
    if (useJRST==NULL) {

#if defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
    fprintf(stderr, "*** *** RGF_INFO_1: RgfNewJRST - 3a, tid=[%lu]: new thread group ...\n",
                      (unsigned long) tid);
    fflush(stderr);
#endif

        newNode->rajo   =jo;        // save RexxAndJava object/instance

            // get MID for the interface method in rajo
        jclass tmpClz=penv->GetObjectClass(jo);     // get class object
        newNode->mid_javaCallFromBSF=penv->GetMethodID( tmpClz, JAVA_CALL_BSF,
                                              "([Ljava/lang/String;)Ljava/lang/String;" );

            // get java.lang.String related objects
        tmpClz                  =penv->FindClass("java/lang/String");
        newNode->clz_String     =tmpClz;
        newNode->emptyUTFString =penv->NewStringUTF("");  // was: (jstring) env->NewGlobalRef( env->NewStringUTF("") );

        newNode->mid_initFromByteArray=penv->GetMethodID(tmpClz, "<init>", "([B)V");    // get constructor
        newNode->mid_getBytes   =penv->GetMethodID(tmpClz, "getBytes", "()[B");         // getBytes()

            // create global references for these important objects
        jobject newRef;
        newRef=penv->NewGlobalRef(newNode->clz_String);
        newNode->clz_String=(jclass) newRef;

        newRef=penv->NewGlobalRef(newNode->emptyUTFString);
        newNode->emptyUTFString=(jstring) newRef;

        newRef=penv->NewGlobalRef(newNode->rajo);
        newNode->rajo=newRef;
    }
    else {  // re-use global references created in the first=main thread of this thread group

#if defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
    fprintf(stderr, "*** *** RGF_INFO_1: RgfNewJRST - 3b, tid=[%lu]: reusing thread group with JRST=[%p] ...\n",
                      (unsigned long) tid, useJRST);
    fflush(stderr);
#endif
        // save JRST that holds the global refs (main thread of thread group)
        newNode->dependsOn= useJRST->dependsOn==NULL ? useJRST : useJRST->dependsOn;

        newNode->rajo               =useJRST->rajo;
        newNode->mid_javaCallFromBSF=useJRST->mid_javaCallFromBSF;

        newNode->clz_String         =useJRST->clz_String;
        newNode->emptyUTFString     =useJRST->emptyUTFString;

        newNode->mid_initFromByteArray=useJRST->mid_initFromByteArray;
        newNode->mid_getBytes       =useJRST->mid_getBytes;
    }

    return newNode;
}



    // create and initialize a new TID2JRST node, push it into the TID2JRST list (becomes first node)
    // (caller is responsible for having a MUTEX set)
inline PSTRUCT_TID2JRST RgfNewTID2JRST (
    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
                  tid, PSTRUCT_JRST jrst)
{
#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: RgfNewTID2JRST 1 ...\n");
         fflush(stderr);
#endif
        // create TID2JRST node
    PSTRUCT_TID2JRST newNode=(PSTRUCT_TID2JRST) RgfAllocateMemory(size_STRUCT_TID2JRST);
    memset(newNode,0,size_STRUCT_TID2JRST); // set everything to 0

    newNode->counter=0;         // set to 0
    newNode->tid=tid;           // save tid
    newNode->jrst=jrst;         // save pointer to JRST node

#if defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfNewTID2JRST 2 - pRoot_TID2JRST=[%p], newNode=[%p], newNode->next=[%p]\n",
                                                        pRoot_TID2JRST, newNode, newNode->next);
         fflush(stderr);
#endif

        // push node into list
    if (pRoot_TID2JRST != NULL) {
        newNode->next=pRoot_TID2JRST; // insert newNode at head, hence point to old start
    }
    pRoot_TID2JRST=newNode;     // new root (i.e. inserting at head of list)

#if defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
    fprintf(stderr, "*** *** RGF_INFO_1: RgfNewTID2JRST 3 - pRoot_TID2JRST=[%p] | newNode=[%p], newNode->next=[%p] .\n",
                                                   pRoot_TID2JRST, newNode, newNode->next);
    fflush(stderr);

    char str[4096]="";
    RgfShowTID2JRSTlist("RgfNewTID2JRST", str);
    fprintf(stderr, str);
    fflush(stderr);

#endif


    return newNode;
}


    // determine whether we have a JRST node defined serving given "tid", if so, return it;
    //     if not, then create a JRST node and add it to the JRST list, also maintain the
    //     TID2JRST list
inline PSTRUCT_JRST RgfGetJRST_for_new_jniRexxStart (
    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
                  tid, JNIEnv *penv, jobject jo)
{
#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: RgfGetJRST_for_new_jniRexxStart 1, tid=[%lu], pRoot_TID2JRST=[%p] ...\n",
                 (unsigned long) tid, (unsigned long) tid, pRoot_TID2JRST);
         fflush(stderr);
#endif

    PSTRUCT_JRST k=RgfGetJRST_by_TID(tid);      // try to get JRST, if tid in table

#ifdef RGF_INFO_1
         fprintf(stderr, "*** *** RGF_INFO_1: RgfGetJRST_for_new_jniRexxStart 3 - tid=[%lu], k=[%p]\n",
                         (unsigned long) tid, k);
         fflush(stderr);
#endif

    if (k!=NULL) {      // pointer to JRST node found?
        return k;
    }

        // not found, create a new JRST node and save it in the TID2JRST list
    RgfAcquireLock();           // block other threads from accessing this

    k=RgfNewJRST(tid, penv, jo, NULL);    // create a new JRST node & create global references

#ifdef RGF_INFO_1
         fprintf(stderr, "*** *** RGF_INFO_1: RgfGetJRST_for_new_jniRexxStart 4 - tid=[%lu], k=[%p]\n",
                         (unsigned long) tid, k);
         fflush(stderr);
#endif

    RgfNewTID2JRST(tid,k);          // create a new TID2JRST node

#ifdef RGF_INFO_1
         fprintf(stderr, "*** *** RGF_INFO_1: RgfGetJRST_for_new_jniRexxStart 5 - tid=[%lu], pRoot_TID2JRST=[%p].\n",
                         (unsigned long) tid, pRoot_TID2JRST);
         fflush(stderr);
#endif

    RgfReleaseLock();           // release lock
    return k;                   // return pointer to new JRST node
}




    // find TID's JRST in TID2JRST list and return it; if not found return NULL
    //    if argument is NULL, then query current TID and use that
    // caller is responsible for setting (and removing) the lock
inline PSTRUCT_JRST RgfGetJRST_by_TID(
    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
                  tid)
{
#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: RgfGetJRST_by_TID 1, tid=[%lu], find tid=[%lu] ...\n",
                 (unsigned long) RgfGetTID(),
                 (unsigned long) tid);
         fflush(stderr);
#endif
    if (tid==NULL) {
        tid=RgfGetTID();
    }

    PSTRUCT_TID2JRST i=NULL;
    PSTRUCT_JRST     k=NULL;

    for (i=pRoot_TID2JRST; i!=NULL; i=i->next) {
        if (i->tid==tid) {      // TID found ?
            k=i->jrst;          // save pointer to JRST node
            return k;           // return pointer to JRST node
        }
    }
    return NULL;
}



    // Remove the node from TID2JRST which uses "jrst" (bAllDependent=FALSE) *or*
    // remove all nodes from TID2JRST that are dependent on "jrst" (bAllDependent<>FALSE)
    //
    // jvm->DetachingCurrentThread() needs to be done, before entering this routine
inline int RgfRemoveTID2JRST_node(PSTRUCT_JRST jrst, int bAllDependent)
{
    PSTRUCT_TID2JRST i=NULL, prev=NULL;
    int count=0;


#if defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
    #ifdef UNIX
       pthread_t
    #else // WIN32
       TID
    #endif
       tid=RgfGetTID();

    fprintf(stderr, "*** *** RGF_INFO_1: RgfRemoveTID2JRST_node 1, tid=[%lu], jrst=[%p], pRoot_TID2JRST=[%p], bAllDependent=[%d] (1=dependent TID2JRST first) ...\n",
                         (unsigned long) tid, jrst, pRoot_TID2JRST, bAllDependent);
    fflush(stderr);
#endif
        // process TID2JRST list
    for (i=pRoot_TID2JRST; i!=NULL;  ) {
        // either delete a single TID2JRST node with "jrst", or
        //        delete all nodes which dependOn "jrst" (also delete their individual JRSTs)
        if ((bAllDependent==FALSE ? i->jrst : i->jrst->dependsOn) == jrst) {    // found, let's remove it!
            if (prev != NULL) {
                prev->next=i->next; // let previous node point to next
            }
            else {                  // no previous, hence adjust root node
                pRoot_TID2JRST=i->next; // let root point to next
            }

#if defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfRemoveTID2JRST_node 2a, tid=[%p], about to memfree: i->jrst=[%p], i=[%d/%p->next=%p]; now pRoot_TID2JRST=[%p] ...\n",
                         (unsigned long) tid, i->jrst, i->tid, i, i->next, pRoot_TID2JRST);
         fflush(stderr);
#endif

            RgfFreeMemory(i->jrst); // free JRST node

            PSTRUCT_TID2JRST tmpMem=i;  // save pointer to memory
            i=i->next;      // advance by hand, now it is safe to free the node's memory
            count++;        // increase counter

#if defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfRemoveTID2JRST_node 2b, tid=[%p], about to memfree: i=[%p]; now pRoot_TID2JRST=[%p] ...\n",
                         (unsigned long) tid, i, pRoot_TID2JRST);
         fflush(stderr);
#endif

            RgfFreeMemory(tmpMem);  // free TID2JRST node

            if (bAllDependent==FALSE) {
                return count;
            }
            continue;       // iterate
        }

        prev=i;             // memorize this node
        i=i->next;          // advance by hand // rgf 2008-08-06
    }
    return count;
}



    // Remove given 'jrst' from JRST list and all nodes referring to it from the TID2JRST list.
    // if bForce is set, then main=first thread of a thread group can be removed: remove all dependent
    //                        TID2JRST (dependsOn==jrst) too
    // caller is responsible for setting (and removing) the lock
inline int RgfRemoveTID2JRST(PSTRUCT_JRST jrst, int bForce)
{
    PSTRUCT_TID2JRST t2j=NULL, prev_t2j=NULL;
    PSTRUCT_JRST     j  =NULL, prev_j  =NULL;
    int            count=0;     // count will return total number of deleted nodes

#if defined (RGF_INFO) || defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
    #ifdef UNIX
       pthread_t
    #else // WIN32
       TID
    #endif
       tid=RgfGetTID();

         fprintf(stderr, "*** RGF_INFO: RgfRemoveTID2JRST 1, tid=[%lu], jrst=[%p], bForce=[%d] (1=force) ...\n",
                         (unsigned long) tid, jrst, bForce);
         fflush(stderr);
#endif

    if (jrst==NULL) {
        return 0;
    }

         // if JRST of main=first thread of a thread group and no bForce set, don't do anything
    if (jrst->dependsOn==NULL) {    // received main=first thread's JRST
        if (bForce==FALSE) {        // do not force removal
#if defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfRemoveTID2JRST 2 - tid=[%lu]: main=first thread, bForce=FALSE, hence NOT removing it!\n", (unsigned long) tid  );
         fflush(stderr);
#endif

            return 0;
        }
            // remove all dependent TID2JRST nodes first
        count += RgfRemoveTID2JRST_node(jrst, TRUE);

#if defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfRemoveTID2JRST 3 - tid=[%lu]: jrst=[%p], before DeleteGlobalRef(...) ...\n",
                                  (unsigned long) tid, jrst);
         fflush(stderr);
#endif
            // remove jrst's global references
        jrst->penv->DeleteGlobalRef (jrst->clz_String);
        jrst->penv->DeleteGlobalRef (jrst->emptyUTFString);
        jrst->penv->DeleteGlobalRef (jrst->rajo);
    }

        // remove given TID2JRST node
    count += RgfRemoveTID2JRST_node(jrst, FALSE);


#if defined (RGF_INFO_1) || defined (RGF_ATTACH) || defined (RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfRemoveTID2JRST 4 - tid=[%lu]: pRoot_TID2JRST=[%p].\n",
                                                      (unsigned long) tid, pRoot_TID2JRST);
         fflush(stderr);

         char str[4096]="";
         RgfShowTID2JRSTlist("RgfRemoveTID2JRST", str);
         fprintf(stderr, str);
         fflush(stderr);
#endif

    return count;
}



    // new logic: 2008-08-03, ---rgf
    // Find pointer to JRST node for 'targetTID' in TID2JRST list;
    //      - (a) if 'targetTID' does not exist in TID2JRST:  return NULL
    //      - (b) if 'myTid' exists and its JVM is the same as 'targetTID's JVM, then return JRST (already attached)
    //      - (c) if 'myTid' exists and it points to a different JVM, then
    //                          a) detach from JVM, remove JRST
    //                          b) attach to 'targetTID's JVM, create a new JRST, return JRST
    //      - (d) if 'myTid' does not exist, then attach to 'targetTID's JVM, create a new JRST,
    //                          return newly created JRST
inline PSTRUCT_JRST RgfNewAttachToTID(
    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
                  targetTID)
{
#ifdef UNIX
    pthread_t
#else   // WIN32
    TID
#endif
        myTid=RgfGetTID();  // get current TID

#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: RgfNewAttachToTID 1, myTid=[%lu], targetTID=[%lu], ...\n",
                 (unsigned long) myTid,
                 (unsigned long) targetTID);
         fflush(stderr);
#endif


        // does targetTID exist?
    RgfAcquireLock();           // block other threads from accessing this
    PSTRUCT_JRST tgtJRST=RgfGetJRST_by_TID(targetTID);    // try to get JRST, if tid in table

    PSTRUCT_JRST tmpJRST=NULL;

    if (tgtJRST==NULL) {                // (a): targetTID does not exist, we cannot attach !
#if defined(RGF_INFO_1) || defined(RGF_ATTACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfNewAttachToTID 2, cannot attach, targetTID [%lu] does NOT EXIST, returning NULL (PANIC!) ...\n",
                 (unsigned long) targetTID);
         fflush(stderr);
#endif
        RgfReleaseLock();
        return NULL;
    }


        // do we have an entry already for myTid, if so, let it point to k!
    PSTRUCT_TID2JRST i=NULL;
    for (i=pRoot_TID2JRST; i!=NULL; i=i->next) {
        if (i->tid==myTid) {    // TID found !
                // check whether both use the same JVM, if so, we are attached already, return JRST
            tmpJRST=i->jrst;

            if (
                 (tmpJRST->dependsOn==tgtJRST->dependsOn)                  ||  // both from same thread group
                 (tgtJRST->dependsOn==NULL && tgtJRST==tmpJRST->dependsOn) ||  // tgtJRST: main=first thread
                 (tmpJRST->dependsOn==NULL && tmpJRST==tgtJRST->dependsOn)     // tmpJRST: main=first thread
            )
            {

                i->counter++;           // increase counter
                RgfReleaseLock();       // release lock

#if defined (RGF_INFO_1) || defined (RGF_ATTACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfNewAttachToTID 3a, found current tid=[%lu] already in same thread group and attached, counter now=[%d], returning JRST=[%p], ...\n",
                         (unsigned long) myTid, i->counter, tmpJRST);
         fflush(stderr);
#endif
                return tmpJRST;         // same thread group & already attached to JVM, return it
            }

                // if current thread's JRST is a main thread, do not re-attach, but return an error
            if (tmpJRST->dependsOn==NULL) {
                // TODO: create Rexx-error
#if defined(RGF_INFO_1) || defined(RGF_ATTACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfNewAttachToTID 3b, cannot change main=first thread's JRST!, targetTID [%lu], returning NULL (PANIC!) ...\n",
                 (unsigned long) targetTID);
         fflush(stderr);
#endif
                return NULL;
            }


            // TODO: check logic
#if defined(RGF_INFO_1) || defined(RGF_ATTACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfNewAttachToTID 3c, about detaching from JVM, deleting JRST=[%p]\n",
                         tmpJRST);
         fflush(stderr);
#endif
                // detach from JVM, remove JRST
            tmpJRST->pjvm->DetachCurrentThread();
            RgfRemoveTID2JRST(tmpJRST, TRUE);
            break;
        }
    }


#if defined(RGF_INFO_1) || defined(RGF_ATTACH)
         fprintf(stderr, "*** *** RGF_INFO_1:  RgfNewAttachToTID 4, about attaching thread [%lu] to JVM...\n",
                 (unsigned long) myTid);
         fflush(stderr);
#endif

        // attach to JVM, create a JRST, insert it into TID2JRST
    JNIEnv *tmpEnv=NULL;
    tgtJRST->pjvm->AttachCurrentThread((void **) &tmpEnv, NULL);    // attach to JVM
    tmpJRST=RgfNewJRST(myTid, tmpEnv, tgtJRST->rajo, tgtJRST);      // create new JRST
    i=RgfNewTID2JRST(myTid, tmpJRST);   // create new TID2JRST node
    i->counter=1;                       // set TID2JRST node counter to 2, such that
                                        // only an explicit BSFDetach() can decrement counter to 0

    RgfReleaseLock();           // release lock

#if defined(RGF_INFO_1) || defined(RGF_ATTACH)
         fprintf(stderr, "*** *** RGF_INFO_1:  RgfNewAttachToTID 5, attached to thread [%lu] to JVM, returnin JRST=[%p]...\n",
                 (unsigned long) myTid,
                 tmpJRST
                 );
         fflush(stderr);
#endif

    return tmpJRST;             // return newly created JRST
}



    // Find 'tid's TID2JRST node; if it is not the JRST 'tid' (main=first thread), then
    // delete the node from the TID2JRST list and return .true; otherwise return .false
inline int  RgfNewDetach()
{
    #ifdef UNIX
    pthread_t
    #else
    TID
    #endif
              myTid=RgfGetTID();  // get current "myTid"

#if defined (RGF_INFO) || defined (RGF_INFO_1) ||  defined (RGF_ATTACH) || defined (RGF_DETACH)
    int tmpCounter=0;
    fprintf(stderr, "*** RGF_INFO: RgfNewDetach 1, myTid=[%lu]...\n", (unsigned long) myTid);
    fflush(stderr);
#endif


    // only remove from TID2JRST table, if TID is not JRST's TID!
    PSTRUCT_TID2JRST i=NULL, prev=NULL;

    RgfAcquireLock();           // block other threads from accessing this
    for (i=pRoot_TID2JRST; i!=NULL; i=i->next) {
        if (i->tid==myTid) {      // a TID2JRST node found for given 'tid' ?
            i->counter--;           // decrease counter

#if defined(RGF_INFO_1) || defined(RGF_DETACH)
         tmpCounter=i->counter;
         fprintf(stderr, "*** *** RGF_INFO_1: RgfNewDetach 2a, a TID2JRST node found, i->tid=[%lu], i=[%p], i->jrst=[%p], counter=[%d]; pRoot_TID2JRST=[%p] ...\n",
                 (unsigned long) i->tid, i, i->jrst, i->counter, pRoot_TID2JRST);
         fflush(stderr);
#endif
            if (i->counter>0) {     // not yet removable
                break;              // leave
            }

            // remove TID2JSR node
            if (i->jrst->dependsOn != NULL) {   // JRST's is not the main=first thread of a thread group?

#if defined(RGF_INFO_1) || defined(RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfNewDetach 2b, before DetachCurrentThread() from JVM! for TID=[%lu]\n",
                 (unsigned long) myTid);
         fflush(stderr);
#endif
                // detach from JVM
                i->jrst->pjvm->DetachCurrentThread();

#if defined(RGF_INFO_1) || defined(RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfNewDetach 2c, successfully DETACHED from JVM! for TID=[%lu], about to remove i=[%p], i->jrst=[%p]\n",
                 (unsigned long) myTid, i, i->jrst);
         fflush(stderr);
#endif

                int count=RgfRemoveTID2JRST(i->jrst, FALSE);   // remove JRST


#if defined(RGF_INFO_1) || defined(RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfNewDetach 2d, DETACHED from JVM! for TID=[%lu], # TID2JRST nodes removed: [%d]; pRoot_TID2JRST=[%p] \n",
                 (unsigned long) myTid, count, pRoot_TID2JRST);
         fflush(stderr);
#endif

                RgfReleaseLock();   // release lock
                return TRUE;
            }
            else {                  // JRST's 'myTid', we do not remove this one as this is the founding one

                i->counter++;       // increase counter (re-establish previous value)

#if defined(RGF_INFO_1) || defined(RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: RgfNewDetach 2e, NOT removing main=first thread node TID2JRST for TID=[%lu], counter reset to: [%d] ...\n",
                 (unsigned long) myTid, i->counter);
         fflush(stderr);
#endif

                RgfReleaseLock();   // release lock
                return FALSE;
            }
        }
        prev=i;                 // remember visited node
    }

        // hmm, no node with given 'myTid' found
#if defined(RGF_INFO_1) || defined(RGF_DETACH)
         if (tmpCounter!=0) {
             fprintf(stderr, "*** *** RGF_INFO_1:  RgfNewDetach 3a, counter [%d] NOT 0 yet for TID=[%lu], ...\n",
                     tmpCounter, (unsigned long) myTid);
         }
         else {
             fprintf(stderr, "*** *** RGF_INFO_1:  RgfNewDetach 3b, TID2JRST NOT FOUND for TID=[%lu] !! ...\n",
                     (unsigned long) myTid);
         }
         fflush(stderr);
#endif

    RgfReleaseLock();           // release lock
    return FALSE;               // node not found, hence cannot remove it
}




    // ===> 2008-07-23: MUTEX, blocking invocation, waits until lock was successfully acquired
    //                  - initializing/setting up of 'JRST_lock' is done in JNI_OnLoad()
inline VOID RgfAcquireLock()
{

#if defined (RGF_INFO) || defined (RGF_ATTACH) || defined (RGF_DETACH)
    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
            tid=RgfGetTID();

    fprintf(stderr, "*** RGF_INFO: RgfAcquireLock(): tid=[%lu] ... \n", (unsigned long) tid);
    fflush(stderr);
#endif

#ifdef WIN32
    EnterCriticalSection (&JRST_lock);

#elif defined UNIX
    pthread_mutex_lock(&JRST_lock);    // TODO: potentially deadlock on nested invocation right before return ?
#endif


#if defined (RGF_INFO) || defined (RGF_ATTACH) || defined (RGF_DETACH)
    fprintf(stderr, "*** RGF_INFO: RgfAcquireLock(): tid=[%lu] ... now ACQUIRED !\n", (unsigned long) tid);
    fflush(stderr);
#endif

}



    // ===> 2008-07-23: MUTEX, release lock
inline VOID RgfReleaseLock()
{
#if defined (RGF_INFO) || defined (RGF_ATTACH) || defined (RGF_DETACH)
    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
            tid=RgfGetTID();
    fprintf(stderr, "*** RGF_INFO: RgfReleaseLock(): tid=[%lu] ...\n", (unsigned long) tid);
    fflush(stderr);
#endif

#if defined WIN32
    LeaveCriticalSection (&JRST_lock);
#else
    pthread_mutex_unlock(&JRST_lock);
#endif

#if defined (RGF_INFO) || defined (RGF_ATTACH) || defined (RGF_DETACH)
    fprintf(stderr, "*** RGF_INFO: RgfReleaseLock(): tid=[%lu] ... now RELEASED !\n", (unsigned long) tid);
    fflush(stderr);
#endif
}


    // just for testing/debugging, ===> 2008-08-06:
    // MUTEX, blocking RXSIO exit handler manipulation of global buffer
    //        - initializing/setting up of 'RXSIO_lock' is done in JNI_OnLoad()
#ifdef RGF_MUTEX4RXSIOTRC
    inline VOID RgfAcquireLockRXSIO()
    {

    #if defined (RGF_INFO) // || defined (RGF_BIT)
        #ifdef UNIX
            pthread_t
        #else   // WIN32
            TID
        #endif
                tid=RgfGetTID();

        fprintf(stderr, "*** RGF_INFO: RgfAcquireLockRXSIO(): tid=[%lu] ... \n", (unsigned long) tid);
        fflush(stderr);
    #endif

    #ifdef WIN32
        EnterCriticalSection (&RXSIO_lock);

    #elif defined UNIX
        pthread_mutex_lock(&RXSIO_lock);
    #endif


    #if defined (RGF_INFO) // || defined (RGF_BIT)
        fprintf(stderr, "*** RGF_INFO: RgfAcquireLockRXSIO(): tid=[%lu] ... now ACQUIRED !\n", (unsigned long) tid);
        fflush(stderr);
    #endif

    }



    // ===> 2008-07-23: MUTEX, release lock
    inline VOID RgfReleaseLockRXSIO()
    {
    #if defined (RGF_INFO) // || defined (RGF_BIT)
        #ifdef UNIX
            pthread_t
        #else   // WIN32
            TID
        #endif
                tid=RgfGetTID();
        fprintf(stderr, "*** RGF_INFO: RgfReleaseLockRXSIO(): tid=[%lu] ...\n", (unsigned long) tid);
        fflush(stderr);
    #endif

    #if defined WIN32
        LeaveCriticalSection (&RXSIO_lock);
    #else
        pthread_mutex_unlock(&RXSIO_lock);
    #endif

    #if defined (RGF_INFO) // || defined (RGF_BIT)
        fprintf(stderr, "*** RGF_INFO: RgfReleaseLockRXSIO(): tid=[%lu] ... now RELEASED !\n", (unsigned long) tid);
        fflush(stderr);
    #endif
    }
#endif


    // inline function for reserving memory disposable for Rexx (guessing how Rexx is allocating it)
            // usage, e.g.: PSZ mem = (PSZ) RgfAllocateMemory(3451l);
inline PVOID RgfAllocateMemory(long size)
{

#if defined (USE_REGINA) || defined (USE_REXXTRANS)     // 2003-01-04, ---rgf, added defined (USE_REXXTRANS)
    #ifdef DEBUG2       // ---rgf, 2003-04-30
        fprintf(stderr, ">>> RgfAllocateMemory(): 'USE_REGINA' or 'USE_REXXTRANS' defined, RexxFreeMemory()\n");
    #endif
    return RexxAllocateMemory( size );       // RexxAllocMemory( nrOfBytes );

#elif defined WIN32
    #ifdef DEBUG2       // ---rgf, 2003-04-30
        fprintf(stderr, ">>> RgfAllocateMemory(): 'WIN32' defined, GlobalFree()\n");
    #endif

    // #define GMEM_FIXED 0x0000       // according to docs: if GMEM_FIXED is set, then a pointer to memory is returned
    return GlobalLock( GlobalAlloc( GMEM_FIXED, size) );

#else       // o.k., use malloc()
    #ifdef DEBUG2       // ---rgf, 2003-04-30
        fprintf(stderr,">>> RgfAllocateMemory():  using malloc()\n");
    #endif
    return malloc( size );
#endif
}




        // inline function for taking care of the different ways of freeing Rexx-allocated memory
inline void RgfFreeMemory (void * memory)
{

#if defined (USE_REGINA) || defined (USE_REXXTRANS)     // 2003-01-04, ---rgf, added defined (USE_REXXTRANS)
    #ifdef DEBUG2       // ---rgf, 2003-04-30
       fprintf(stderr, ">>> RgfFreeMemory(): 'USE_REGINA' or 'USE_REXXTRANS' defined, RexxFreeMemory()\n");
    #endif
    RexxFreeMemory( memory );

#elif defined WIN32
    #ifdef DEBUG2       // ---rgf, 2003-04-30
       fprintf(stderr, ">>> RgfFreeMemory(): 'WIN32' defined, GlobalFree()\n");
    #endif
    GlobalFree( memory );

#else       // o.k., use free()
    #ifdef DEBUG2       // ---rgf, 2003-04-30
       fprintf(stderr, ">>> RgfFreeMemory():  using free()\n");
    #endif
    free( memory );
#endif

}




    // cf. "The Java Native Interface Programmers Guide and Specification"
    // by Sheng Lian, downloaded from java.sun.org in July 2003 as PDF
    // code edited to make it runnable under this DLL
    // =======================
    // cf. "6.1.2 A Utility Function"
void JNU_ThrowByName(JNIEnv *env, const char *clzName, const char *msg)
{
    jclass clz = env->FindClass(clzName);

    if (clz != NULL)    // if clz is NULL, an exception has already been thrown
    {
        env->ThrowNew(clz, msg);    // create the exception for the Java side
        env->DeleteLocalRef(clz);   // free the local ref
    }
}



    // =======================
    // cf "8.2.2 Translating jstrings to Native Strings"
    // char *JNU_GetStringNativeChars(PSTRUCT_JRST jrst  JNIEnv *env, jstring jstr)
char *JNU_GetStringNativeChars(PSTRUCT_JRST a_JRST, jstring jstr)  // JNIEnv *env, jstring jstr)
{
#ifdef DEBUG
   fprintf(stderr, "JNU_GetStringNativeChars(): just arrived, a_JRST=[%p], jstr=[%p]\n", a_JRST, jstr);
#endif

    char *result = 0;
    jbyteArray bytes = (jbyteArray) a_JRST->penv->CallObjectMethod(jstr, a_JRST->mid_getBytes);

    if ( a_JRST->penv->ExceptionCheck()==JNI_FALSE )    // lighter (jboolean: JNI_TRUE, if pending exception), does not create exception object
    {
        jint len = a_JRST->penv->GetArrayLength(bytes);
        result   = (char *)malloc(len + 1);
        if (result == 0)
        {
            JNU_ThrowByName(a_JRST->penv, "java/lang/OutOfMemoryError", 0);
            a_JRST->penv->DeleteLocalRef(bytes);
            return 0;
        }
        a_JRST->penv->GetByteArrayRegion(bytes, 0, len, (jbyte *)result);
        result[len] = 0; /* NULL-terminate */
    }
    a_JRST->penv->DeleteLocalRef(bytes);

    return result;
}
// ------------- the end of copy & pasted functions form the above JNI Guide and Specification book



    // rgf, 2008-08-06: use Java for popup message box (available on every opsys)
void JNU_MessageBox (JNIEnv *env, const char *msg)
{
    jclass    clz = env->FindClass("javax/swing/JOptionPane");
    jmethodID mid = env->GetStaticMethodID(clz, "showMessageDialog", "(Ljava/awt/Component;Ljava/lang/Object;)V");
    env->CallStaticVoidMethod(clz, mid, NULL, env->NewStringUTF(msg));
}



   // declare functions (define signatures)
APIRET APIENTRY BSF                         ( PSZ name, ULONG argc, PRXSTRING argv, PSZ queuename, PRXSTRING retstr);

   // same entries, slightly different signature than above
APIRET APIENTRY BsfDropFuncs                ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );
APIRET APIENTRY BsfInvokedBy                ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );
APIRET APIENTRY BsfLoadFuncs                ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );
APIRET APIENTRY BsfLoadJava                 ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );
APIRET APIENTRY BsfQueryAllFunctions        ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );
APIRET APIENTRY BsfQueryRegisteredFunctions ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );
APIRET APIENTRY BsfShowErrorMessage          ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );
APIRET APIENTRY BsfUnloadJava               ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );
APIRET APIENTRY BsfVersion                  ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );

    // ---rgf, 2003-08-06: allow Rexx to retrieve its TID (i.e. Java's "JNIEnv" object)
APIRET APIENTRY BsfGetTID                   ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );
    // ---rgf, 2003-08-06: allow Rexx to use the Java environment of another Rexx thread
APIRET APIENTRY BsfAttachToTID              ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );
    // ---rgf, 2008-07-26
APIRET APIENTRY BsfDetach                   ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr );

    // ---rgf, 2006-01-27: allow catching Rexx error messages to be used as the error text in a Java exception
    //                     this way the Java side can parse and locate the cause, line# and col# (if given) of the error
LONG APIENTRY RGF_RXSIO_EXIT_NAME           ( LONG exitNumber, LONG subFunction, PEXIT parmBlock );



/*********************************************************************/
/* ApiFncTable                                                       */
/*   Array of names of the REXXASP1 functions.                       */
/*   This list is used for registration and deregistration.          */
/*********************************************************************/
PSZ ApiFncTableOrdered[] =  // table containing the external Rexx function order to be used if displaying them
{
    "BSF"                         ,
    "BsfAttachToTID"              , // ---rgf, 2003-08-06
    "BsfDetach"                   , // ---rgf, 2008-07-26
    "BsfDropFuncs"                ,
    "BsfGetTID"                   , // ---rgf, 2003-08-06
    "BsfInvokedBy"                ,
    "BsfLoadFuncs"                ,
#ifdef ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
    "BsfLoadJava"                 ,
#endif
    "BsfQueryAllFunctions"        ,
    "BsfQueryRegisteredFunctions" ,
    "BsfShowErrorMessage"          ,  // rgf, 2006-11-19

#ifdef ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
    "BsfUnloadJava"               , // ---rgf, 2005-06-02, JNI would not unload
#endif
    "BsfVersion"
};

PSZ  ApiFncTable[] =     // table of functions to be registered with Rexx
   {
       "BSF",                        // interface for Rexx to Java
       "BsfDropFuncs",               // unregister all of these functions
       "BsfInvokedBy",               // allows querying for invocation type of this DLL

#ifdef ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
       "BsfLoadJava",                // load the JVM by creating a new instance of BSFManager, if loaded by Rexx, using JNI's NewGlobalRef()
#endif

       "BsfQueryAllFunctions",       // fills in a stem with the names of all functions;
                                     // this *MUST* be the last listed function; it does not get registered;
                                     // as this was done already on the Rexx side;
       "BsfQueryRegisteredFunctions",// fills in a stem with the names of all functions;
                                     // this *MUST* be the last listed function; it does not get registered;
                                     // as this was done already on the Rexx side;

       "BsfShowErrorMessage"         ,  // rgf, 2006-11-19

#ifdef ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
       "BsfUnloadJava",  // ---rgf, 2005-06-02, JNI would not unload             // unload the JVM, if loaded by Rexx, calling JNI's DeleteGlobalRef()
#endif
       "BsfVersion",                 // returns the version number in the form "MajorNumber"."YYYYMMDD"

       "BsfAttachToTID",             // ---rgf, 2003-08-06, attaches a Rexx thread to the Java environment of another running Rexx thread
       "BsfDetach",                  // ---rgf, 2008-07-26
       "BsfGetTID",                  // ---rgf, 2003-08-06, returns the Java environment pointer which serves as the TID as far as Java is concerned

       "BsfLoadFuncs"                // (*MUST* be last!) already loaded (registered) by the Rexx programmer
   };

   // 2003-01-20, pointer to functions (for registering: *MUST* be same sequence as above!)
PFN  PApiFncTable[] =
   {
       (PFN) BSF,                       // interface for Rexx to Java
       (PFN) BsfDropFuncs,              // unregister all of these functions
       (PFN) BsfInvokedBy,              // returns "0" (no invocation, hence no Java present),
                                        //   "1" (bsf4rexx loaded via Java), "2" (bsf4rexx loaded via Rexx)

#ifdef ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
       (PFN) BsfLoadJava,               // load the JVM by creating a new instance of BSFManager, if loaded by Rexx,
#endif

       (PFN) BsfQueryAllFunctions,       // fills in a stem with the names of the BSF functions
       (PFN) BsfQueryRegisteredFunctions,// fills in a stem with the names of the BSF functions

       (PFN) BsfShowErrorMessage,  // ---rgf, 2006-11-19

#ifdef ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
       (PFN) BsfUnloadJava,  // ---rgf, 2005-06-02, JNI would not unload           // unload the JVM, if loaded by Rexx, calling JNI's DeleteGlobalRef()
#endif
       (PFN) BsfVersion,                // returns the version number of this package

       (PFN) BsfAttachToTID,   // ---rgf, 2003-08-06, attaches a Rexx thread to the Java environment of another running Rexx thread
       (PFN) BsfDetach,        // ---rgf, 2008-07-26, detaches a Rexx thread from the Java environment
       (PFN) BsfGetTID,        // ---rgf, 2003-08-06, returns the Java environment pointer which serves as the TID as far as Java is concerned

       (PFN) BsfLoadFuncs           // already loaded (registered) by the Rexx programmer, must be last in list!

   };


   // 2003-01-26, array of functions to be loaded, if BSF4Rexx is invoked/loaded by Java
PSZ  ApiFncTable4Java[] =     // table of functions to be registered with Rexx
   {
       "BSF",                           // interface for Rexx to Java
       "BsfInvokedBy",                  // allows querying for invocation type of this DLL
       "BsfVersion",                    // returns the version number in the form "MajorNumber"."YYYYMMDD"
       "BsfQueryAllFunctions",           // fills in a stem with the names of all functions

       "BsfShowErrorMessage"         ,  // rgf, 2006-11-19

       "BsfAttachToTID"              , // ---rgf, 2003-08-06, attaches a Rexx thread to the Java environment of another running Rexx thread
       "BsfDetach"                   , // ---rgf, 2008-07-26, detaches a Rexx thread from the Java environment
       "BsfGetTID"                   , // ---rgf, 2003-08-06, returns the Java environment pointer which serves as the TID as far as Java is concerned

       "BsfQueryRegisteredFunctions"     // fills in a stem with the names of all functions
   };

   // 2003-01-26, pointer to functions (for registering: *MUST* be same sequence as above!)
PFN  PApiFncTable4Java[] =
   {
       (PFN) BSF,                       // interface for Rexx to Java
       (PFN) BsfInvokedBy,              // returns "0" (no invocation, hence no Java present), //   "1" (bsf4rexx loaded via Java), "2" (bsf4rexx loaded via Rexx)
       (PFN) BsfVersion,                // unregister all of these functions
       (PFN) BsfQueryAllFunctions,       // fills in a stem with the names of the BSF functions

       (PFN) BsfShowErrorMessage,  // ---rgf, 2006-11-19

       (PFN) BsfAttachToTID,   // ---rgf, 2003-08-06, attaches a Rexx thread to the Java environment of another running Rexx thread
       (PFN) BsfDetach,        // ---rgf, 2008-07-26, detaches a Rexx thread from the Java environment
       (PFN) BsfGetTID,        // ---rgf, 2003-08-06, returns the Java environment pointer which serves as the TID as far as Java is concerned


       (PFN) BsfQueryRegisteredFunctions // fills in a stem with the names of the BSF functions
   };




/* ---rgf, 20080809: probably not needed with ooRexx 3.2 and later
#ifdef CHECK_4_FORGOTTEN_BSF_FUNCTIONS
   // 2003-04-30: register external Rexx functions, if "BSF" is not registered and
   //             Java is about to have a Rexx program executed; this makes sure that
   //             every such Rexx program has the ApiFncTable4Java[] external functions registered
inline void makeSureBSF_isRegistered ()
{
    // "BSF" must be loaded, if not yet, load the
//    if (RexxQueryFunction("BSF") == RXFUNC_NOTREG )     // "BSF" *not* registered !

#ifdef DEBUG2        // ---rgf, 2003-04-30
   fprintf(stderr, "\n    makeSureBSF_isRegistered(): just arrived...\n");
#endif

        INT    entries;                      // Num of entries
        INT    j;                            // Counter
        entries = sizeof(ApiFncTable4Java)/sizeof(PSZ);    // table with function names to be registered

        long res=0l, resTmp=0l;                  // initialize to 0l
        for (j = 0; j < entries; j++)
        {
#ifdef DEBUG
    fprintf(stderr, "    ===> BsfLoadFuncs(): testing j=%d, resTmp=%d, '%s' (makeSure_BSF_isRegistered)\n", j, RexxQueryFunction(ApiFncTable4Java[j]), ApiFncTable4Java[j]);
#endif
            if (RexxQueryFunction(ApiFncTable4Java[j])==RXFUNC_NOTREG)
            {
                // 2003-01-20, making functions process-local by using RexxRegisterFunctionExe() instead of ...Dll()
                resTmp = RexxRegisterFunctionExe(ApiFncTable4Java[j], PApiFncTable4Java[j]);

#ifdef RGF_INFO // DEBUG
    fprintf(stderr, "    ===> makeSureBSF_isRegistered () ['FORGOTTEN' registered function]:\n         need to load BsfLoadFuncs(): testing j=%d, resTmp=%d, '%s' (makeSure_BSF_isRegistered)\n", j, RexxQueryFunction(ApiFncTable4Java[j]), ApiFncTable4Java[j]);
#endif
            }
        }

      #ifdef DEBUG2        // ---rgf, 2003-04-30
         fprintf(stderr, "makeSureBSF_isRegistered():(): about to leave...\n\n");
      #endif
}
#endif
*/



    // short of a make_upper macro/function, this is a little hack, ---rgf, 2003-01-27
inline void make_upper (char * string)
{
    for (; *string; string++)   // loop over characters
    {
        *string=toupper(*string);   // translate characters to uppercase
    }
}


    /*-----------------------------------------------------------------------------
     * Create a REXX variable of the specified name and bind the value to it.
     *
     * [Thanks to Mark Hessling (2003-01-27) !!]
     *----------------------------------------------------------------------------*/
int SetRexxVariable
   ( char *name, int namelen, char *value, int valuelen )
{
   ULONG  rc=0L;
   SHVBLOCK       shv;

   // already done elsewhere ( void )make_upper( name ); /* upper-case the variable name */
   shv.shvnext = ( SHVBLOCK* )NULL;
   shv.shvcode = RXSHV_SET;
   MAKERXSTRING( shv.shvname,  name,  ( ULONG ) namelen  );
   MAKERXSTRING( shv.shvvalue, value, ( ULONG ) valuelen );
   shv.shvnamelen = shv.shvname.strlength;
   shv.shvvaluelen = shv.shvvalue.strlength;
   rc = RexxVariablePool( &shv );
   if ( rc == RXSHV_OK
   ||   rc == RXSHV_NEWV )
      return( 0 );
   else
      return( 1 );
}


    /*-----------------------------------------------------------------------------
     * Drop the specified REXX variable from the variable pool.
     *----------------------------------------------------------------------------*/
int DropRexxVariable ( char *name, int namelen)
{
   ULONG  rc=0L;
   SHVBLOCK       shv;

   shv.shvnext = ( SHVBLOCK* )NULL;
   shv.shvcode = RXSHV_DROPV;
   MAKERXSTRING( shv.shvname, name, ( ULONG )namelen );
   shv.shvnamelen = shv.shvname.strlength;
   rc = RexxVariablePool( &shv );
   if ( rc == RXSHV_OK
   ||   rc == RXSHV_NEWV )
      return( 0 );
   else
      return( 1 );
}



    /*********************************************************************/
    /* Queries how BSF4Rexx was invoked and whether JVM is present       */
    /*    returns: 0 ... no JVM present                                  */
    /*             1 ... JVM present, bsf4rexx invoked by Java           */
    /*             2 ... JVM present, bsf4rexx invoked by Rexx as an     */
    /*                   external function package                       */
    /*                                                                   */
    /* ---rgf, 2003-01-21                                                */
    /*********************************************************************/
APIRET APIENTRY BsfInvokedBy(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{
#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: BsfInvokedBy() 1, bsfInvokedBy=[%d] ...\n", bsfInvokedBy);
    fflush(stderr);
#endif

    switch (bsfInvokedBy) {
        case  0:  strcpy(retstr->strptr, "0"); break;
        case  1:  strcpy(retstr->strptr, "1"); break;
        default:  strcpy(retstr->strptr, "2"); break;
    }

    retstr->strlength = strlen(retstr->strptr); // set proper string length

#ifdef RGF_INFO_1
   fprintf(stderr, "*** *** RGF_INFO_1: BsfInvokedBy() 2, res=[%s] ...\n", retstr->strptr);
   fflush(stderr);
#endif

  return VALID_ROUTINE;
}




#ifdef ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
    // do the "gory" work: this way unloading can be done from any part of the program
    inline long RgfUnloadJava()
    {
        // remove all TID2JRST (and JRST) nodes, disattach from JVM
#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: RgfUnloadJava() 1, pRoot_TID2JRST=[%p]...\n", pRoot_TID2JRST);
    fflush(stderr);
#endif
        if (pRoot_TID2JRST!=NULL) {     // cleanup before destroying JVM
            RgfAcquireLock();
            while (pRoot_TID2JRST!=NULL) {

#ifdef RGF_INFO_1
    fprintf(stderr, "*** *** RGF_INFO_1: RgfUnloadJava() 2, removing pRoot_TID2JRST->jrst=[%p]...\n", pRoot_TID2JRST->jrst);
    fflush(stderr);
#endif
                RgfRemoveTID2JRST(pRoot_TID2JRST->jrst, TRUE); // make sure, JRST and all dependents get removed
            }
            RgfReleaseLock();
        }

        long ret=currentJVM->DestroyJavaVM ( ); // destroy JVM
        currentJVM  =NULL;                      // set pointer to NULL
        bsfInvokedBy=0;                         // invoked by Rexx !

        return ret;
    }


    /*********************************************************************/
    /* unload Java, according to tutorial: does not really work on       */
    /*              Java 1.1, will always return an error                */
    /*                                                                   */
    /* returns:                                                          */
    /*         0    ... indicate everything o.k.                         */
    /*         -999 ... JVM was not loaded by Rexx, aborting             */
    /*         -998 ... JVM is not loaded at all, hence cannot unload    */
    /*         -997 ... this thread cannot attach to a JVM               */
    /*                                                                   */
    /* ---rgf, 2003-01-15,21, 26                                         */
    /*********************************************************************/
    APIRET APIENTRY BsfUnloadJava(
      PSZ       name,                      /* Function name              */
      LONG      numargs,                   /* Number of arguments        */
      RXSTRING  args[],                    /* Argument array             */
      PSZ       queuename,                 /* Current queue              */
      PRXSTRING retstr )                   /* Return RXSTRING            */
    {
#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: BsfUnloadJava() 1 ...\n");
         fflush(stderr);
#endif

        if (currentJVM == NULL) // JVM was not loaded by Rexx, hence show error
        {
            fprintf(stderr, "BSFUnloadJava(): no JVM loaded, aborting!\n");
            strcpy(retstr->strptr, "-999"); // indicate no JVM loaded
            retstr->strlength = strlen(retstr->strptr); // set proper string length
            return INVALID_ROUTINE;
        }


        if (pRoot_TID2JRST == NULL) // JVM is not loaded, error!
        {
            fprintf(stderr, "BSFUnloadJava(): no JVM to unload, aborting!\n");
            strcpy(retstr->strptr, "-998");             // indicate JVM is not loaded
            retstr->strlength = strlen(retstr->strptr); // set proper string length
            return INVALID_ROUTINE;
        }


        PSTRUCT_JRST tmpJRST=RgfNewAttachToTID(RgfGetTID());
        if (tmpJRST == NULL) // no JRST associated with this thread !
        {
            fprintf(stderr, "BSFUnloadJava(): this thread cannot attach to Java, aborting!\n");
            strcpy(retstr->strptr, "-997");             // indicate JVM is not loaded
            retstr->strlength = strlen(retstr->strptr); // set proper string length
            return INVALID_ROUTINE;
        }

        // remove all JRST (and its TID2JRST nodes)
#ifdef RGF_INFO_1
         fprintf(stderr, "*** *** RGF_INFO_1: BsfUnloadJava() 2 - pRoot_TID2JRST=[%p]\n",
                                  pRoot_TID2JRST);
         fflush(stderr);
#endif

         // main thread that attached JVM, hence no need to explicitly jvm->DetachCurrentThread()
         RgfAcquireLock();
         int tmpRes=RgfRemoveTID2JRST(tmpJRST, TRUE); // make sure, JRST and all dependents get removed
         RgfReleaseLock();

#ifdef RGF_INFO_1
         fprintf(stderr, "*** *** RGF_INFO_1: BsfUnloadJava() 3 - # TID2JRST nodes removed=[%d], pRoot_TID2JRST=[%p]\n",
                                  tmpRes, pRoot_TID2JRST);
         fflush(stderr);
#endif

        // now destroy the JVM
#ifdef ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
        long ret=RgfUnloadJava();   // unload the JVM (pseudo unload due to JNI 1.1 restrictions)
#endif

        char tmpStr [32] = "";
        sprintf(tmpStr, "%ld%c", ret, 0);    // create return value

        strcpy(retstr->strptr, tmpStr);
        retstr->strlength = strlen(retstr->strptr); // set proper string length

    #ifdef DEBUG        // ---rgf, 2003-04-30
        fprintf(stderr, "BsfUnloadJava(): about to leave...\n\n");
    #endif

        return VALID_ROUTINE;
    }
#endif




    /*********************************************************************/
    /* load (register) all BSF-functions                                 */
    /*                                                                   */
    /* returns:                                                          */
    /*                                                                   */
    /*            0 ... registering went o.k.                            */
    /*         -999 ... 'BSF' already loaded, hence abort                */
    /*         -998 ... at least one registered function caused a        */
    /*                  non-zero return code, hence abort                */
    /*                                                                   */
    /*********************************************************************/
APIRET APIENTRY BsfLoadFuncs(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{
  INT    entries;                      /* Num of entries             */
  INT    j;                            /* Counter                    */

#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: BsfLoadFuncs() 1 ...\n");
    fflush(stderr);
#endif

  if (RexxQueryFunction("BSF") != RXFUNC_NOTREG )     // "BSF" already registered!
  {
      fprintf(stderr, "BsfLoadFuncs(): 'BSF' already registered, aborting!\n");
      strcpy(retstr->strptr, "-999"); // indicate BSF already loaded (probably by Java)
      retstr->strlength = strlen(retstr->strptr); // set proper string length
      return INVALID_ROUTINE;
  }

  entries = sizeof(ApiFncTable)/sizeof(PSZ);    // table with function names to be registered
  entries--;        // make sure BsfLoadFuncs() is not registered (already happened at the Rexx side)

  long res=0l, resTmp=0l;                  // initialize to 0l
  for (j = 0; j < entries; j++)
  {
      // 2003-01-20, making functions process-local by using RexxRegisterFunctionExe() instead of ...Dll()
      resTmp = RexxRegisterFunctionExe(ApiFncTable[j], PApiFncTable[j]);

#ifdef DEBUG2        // ---rgf, 2003-04-30
   fprintf(stderr, "    ===> BsfLoadFuncs(): j=%d, resTmp=%d, '%s'\n", j, resTmp, ApiFncTable[j]);
#endif

      if (resTmp != 0l)     // something went wrong with registering this function
      {
          fprintf(stderr,"BsfLoadFuncs(): error '%d' while registering function '%s'\n", resTmp, ApiFncTable[j]);
      }
      res+=resTmp;      // just add them up
  }


  if (res != 0l)          // at least one of the functions could not be registerd, abort
  {
      strcpy(retstr->strptr, "-998"); // indicate that registering caused at least one problem
      retstr->strlength = strlen(retstr->strptr); // set proper string length
      return INVALID_ROUTINE;
  }

  strcpy(retstr->strptr, "0");     // registering went o.k.
  retstr->strlength = strlen(retstr->strptr); // set proper string length

  return VALID_ROUTINE;
}


    /*********************************************************************/
    /* unregisters all BSF-functions                                     */
    /*                                                                   */
    /* returns:                                                          */
    /*                                                                   */
    /*            0 ... deregistering went o.k.                          */
    /*         -998 ... at least one deregistering function caused a     */
    /*                  non-zero return code, hence abort                */
    /*                                                                   */
    /*********************************************************************/

APIRET APIENTRY BsfDropFuncs(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{

#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: BsfDropFuncs() 1 ...\n");
    fflush(stderr);
#endif


  INT    entries;                      /* Num of entries             */
  INT    j;                            /* Counter                    */
  long res=0l, resTmp=0l;               // initialize to 0l

  entries = sizeof(ApiFncTable)/sizeof(PSZ);

#ifdef ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
  long ret=RgfUnloadJava();     // unload the JVM (pseudo unload due to JNI 1.1 restrictions)
#endif

  for (j = 0; j < entries; j++)
  {
      resTmp=RexxDeregisterFunction(ApiFncTable[j]);

#ifdef DEBUG2        // ---rgf, 2003-04-30
   fprintf(stderr, "    ===> BsfDropFuncs(), 2) resTmp=%d, function: '%s'\n", resTmp, ApiFncTable[j]);
#endif

      if (resTmp != 0l)                 // something went wrong
      {
          fprintf(stderr,"BsfDropFuncs(): error '%d' while deregistering function '%s'\n", resTmp, ApiFncTable[j]);
      }
      res+=resTmp;

            // hmm, Object Rexx returns "0", Regina returns "30" ("function not registered") ???
            // if registering thereafter, Regina returns "10" ("function already registered") !
  }

  if (res != 0l)          // at least one of the functions could not be deregistered, abort
  {
      strcpy(retstr->strptr, "-998"); // indicate something went wrong while deregistering
      retstr->strlength = strlen(retstr->strptr); // set proper string length
      return INVALID_ROUTINE;
  }

  strcpy(retstr->strptr, "0");                  // deregistering went o.k.
  retstr->strlength = strlen(retstr->strptr);   // set proper string length

  return VALID_ROUTINE;
}


    /*********************************************************************/
    /* returns the version number                                        */
    /*                                                                   */
    /* returns:                                                          */
    /*                                                                   */
    /*            x.YYYYMMDD "MajorNumber"."Date"                        */
    /*                                                                   */
    /*********************************************************************/
APIRET APIENTRY BsfVersion(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{

#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: BsfVersion() 1, version=[%s] ...\n", BSF_VERSION);
    fflush(stderr);
#endif

  strcpy(retstr->strptr, BSF_VERSION);          // version number
  retstr->strlength = strlen(retstr->strptr);   // set proper string length

  return VALID_ROUTINE;
}


    /*********************************************************************/
    /* fills in a stem with the function names                           */
    /*                                                                   */
    /* returns:                                                          */
    /*                                                                   */
    /*            0 ... function executed o.k.                           */
    /*         -999 ... supplied stem name too long, hence abort         */
    /*                                                                   */
    /*********************************************************************/
APIRET APIENTRY BsfQueryAllFunctions(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{

#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: BsfQueryAllFunctions() 1 ...\n");
    fflush(stderr);
#endif

    char varname[255], value[10];
    char stem_name[255];
    int entries = sizeof(ApiFncTableOrdered)/sizeof(PSZ), rc;  // table with function names to be registered
    int j=0; // --rgf, 2003-04-03/2003-04-14: keeping gcc happy


    if (numargs==0 || args[0].strlength==0)     // no stem-name given, use "BSFLISTFUNCTIONS." as default
    {
        strcpy( stem_name, "BsfQueryAllFunctions.");  // default name for this stem
    }

    else if (args[0].strlength>244)             // variable name too long 244+dot(1char)+max_digits(=10)+string_end_char(x00)
    {
        fprintf(stderr, "BsfQueryAllFunctions(): supplied stem name ('%s') too long ('%p' characters exceed the maximum of 244 characters), aborting!\n", args[0].strptr, args[0].strlength);
        strcpy(retstr->strptr, "-999");         // indicate stem-name too long
        retstr->strlength = strlen(retstr->strptr); // set proper string length
        return INVALID_ROUTINE;
    }

    else
    {
        strcpy( stem_name, args[0].strptr);       // use whatever the user supplied
    }

    make_upper(stem_name);      // uppercase the stem-name

    for (j = 0; j < entries; j++)
    {
            (void)sprintf(varname, "%s%u", stem_name, j+1);
            rc = SetRexxVariable( varname, strlen(varname), ApiFncTableOrdered[j] , strlen(ApiFncTableOrdered[j]) );
    }

    sprintf(value, "%u", j);                    // give number of elements in stem array
    (void)sprintf(varname, "%s0", stem_name);
    rc = SetRexxVariable( varname, strlen(varname), value, strlen(value));


  strcpy(retstr->strptr, "0");                  // return value
  retstr->strlength = strlen(retstr->strptr);   // set proper string length

  return VALID_ROUTINE;
}



    /*********************************************************************/
    /* fills in a stem with the function names                           */
    /*                                                                   */
    /* returns:                                                          */
    /*                                                                   */
    /*            0 ... function executed o.k.                           */
    /*         -999 ... supplied stem name too long, hence abort         */
    /*                                                                   */
    /*********************************************************************/
APIRET APIENTRY BsfQueryRegisteredFunctions(
  PSZ       name,                      /* Function name              */
  LONG      numargs,                   /* Number of arguments        */
  RXSTRING  args[],                    /* Argument array             */
  PSZ       queuename,                 /* Current queue              */
  PRXSTRING retstr )                   /* Return RXSTRING            */
{

#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: BsfQueryRegisteredFunctions() 1 ...\n");
    fflush(stderr);
#endif

    char varname[255], value[10];
    char stem_name[255];
    int entries, rc;

    if (numargs==0 || args[0].strlength==0)     // no stem-name given, use "BSFLISTFUNCTIONS." as default
    {
        strcpy( stem_name, "BsfQueryRegisteredFunctions.");  // default name for this stem
    }

    else if (args[0].strlength>244)             // variable name too long 244+dot(1char)+max_digits(=10)+string_end_char(x00)
    {
        fprintf(stderr, "BsfQueryRegisteredFunctions(): supplied stem name ('%s') too long ('%p' characters exceed the maximum of 244 characters), aborting!\n", args[0].strptr, args[0].strlength);
        strcpy(retstr->strptr, "-999");         // indicate stem-name too long
        retstr->strlength = strlen(retstr->strptr); // set proper string length
        return INVALID_ROUTINE;
    }

    else
    {
        strcpy( stem_name, args[0].strptr);       // use whatever the user supplied
    }

    make_upper(stem_name);      // uppercase the stem-name

    entries=sizeof(ApiFncTableOrdered)/sizeof(PSZ);

    int i=0, j=0;

    for (i=0; i<entries; i++) {             // loop over all functions
        if (! RexxQueryFunction(ApiFncTableOrdered[i]))    // is the function registered at the moment?
        {
            (void)sprintf(varname, "%s%u", stem_name, ++j);
            rc = SetRexxVariable( varname, strlen(varname), ApiFncTableOrdered[i] , strlen(ApiFncTableOrdered[i]) );
        }
    }

    sprintf(value, "%u", j);                    // give number of elements in stem array
    (void)sprintf(varname, "%s0", stem_name);
    rc = SetRexxVariable( varname, strlen(varname), value, strlen(value));

  strcpy(retstr->strptr, "0");                  // return value
  retstr->strlength = strlen(retstr->strptr);   // set proper string length

  return VALID_ROUTINE;
}


    // ---rgf, 2006-11-19: allow to query and set behaviour in case of a Java exception
    //                     "1" (default)...show error string,
    //                     "0": do not show error string, instead place it as "BSF_ERROR_STRING" into the variable pool
    //                     if nor argument, only setting is returned
APIRET APIENTRY BsfShowErrorMessage
     ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr )
{

#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: BsfShowErrorMessage() 1 ...\n");
    fflush(stderr);
#endif

   if (numargs>1)       // zero or one argument expected
   {
       return INVALID_ROUTINE;      // we only accept numbers!
   }
   else if (numargs==1)
   {
       int value = 0;
       if (sscanf(args[0].strptr, "%d", &value)!=0)
       {
           if (value < 0 || value > 1)    // we only accept "0" (.false), or "1" (.true)
           {
               return INVALID_ROUTINE;
           }
           bShowErrorString = value;
       }
       else // nothing assigned: 0, or string with no parseable content: -1
       {
           return INVALID_ROUTINE;      // we only accept numbers!
       }
   }

   strcpy(retstr->strptr, bShowErrorString==0 ? "0" : "1");    // determine current value
   retstr->strlength = strlen(retstr->strptr);   // set proper string length

   return VALID_ROUTINE;
}



    // ---rgf, 2003-08-06: allow Rexx to retrieve its TID (i.e. Java's "JNIEnv" object)
APIRET APIENTRY BsfGetTID
     ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr )
{
#ifdef UNIX
    pthread_t
#else   // WIN32
    TID
#endif
        tid=RgfGetTID();

#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: BsfGetTID() 1, tid=[%lu] ...\n", (unsigned long) tid);
    fflush(stderr);
#endif

   char strTid[32]="";         // define a string long enough to receive an integer
   sprintf(strTid, "%lu%c", ((unsigned long) tid), 0);  // create decimal number

   strcpy(retstr->strptr, strTid);              // copy TID number
   retstr->strlength = strlen(retstr->strptr);  // set proper string length

   return VALID_ROUTINE;
}




    // ---rgf, 2003-08-06: allow Rexx to use the Java environment of another Rexx thread
APIRET APIENTRY BsfAttachToTID ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr )
{

#ifdef RGF_INFO
    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
            tid=RgfGetTID();

    fprintf(stderr, "*** RGF_INFO: BsfAttachToTID() 1, tid=[%lu], # args=[%ld], argv[0]=[%s] ...\n",
            (unsigned long) tid, numargs, (numargs>0l ? args[0].strptr : "")
            );
    fflush(stderr);
#endif

   if ( ! RXVALIDSTRING(args[0]))    // nothing there to do
   {
       fprintf(stderr, "BSF4Rexx.BsfAttachToTID: TID argument not supplied, aborting...\n");
       return INVALID_ROUTINE;
   }

        // extract "tid" value from Rexx string; TODO: check for MacOSX
   #if defined (WIN32) || defined(UNIX)
   unsigned long  i=0;
   sscanf(args[0].strptr, "%lu", &i);    // get integer value from string
   #endif

   char strTid[32]="";         // define a string long enough to receive an integer
   sprintf(strTid, "%d%c", (RgfNewAttachToTID(
                               #ifdef UNIX
                                   (pthread_t)
                               #else    // WIN32
                                   (TID)
                               #endif
                            i)
                           !=NULL), 0);

   strcpy(retstr->strptr, strTid);              // copy result ("0" or "1")
   retstr->strlength = strlen(retstr->strptr);  // set proper string length

   return VALID_ROUTINE;
}



    // rgf, 2008-07-26
/* Removes the TID2JRST entry with current TID. If removal was possible, return .true,
   else .false (indicating that no Java environment was attached to this TID).
*/
APIRET APIENTRY BsfDetach      ( PSZ name, LONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr )
{


#ifdef RGF_INFO
    #ifdef UNIX
        pthread_t
    #else
        TID
    #endif
            tid=RgfGetTID();    // current thread

    fprintf(stderr, "*** RGF_INFO: BsfDetach() 1, tid=[%lu], # args=[%ld], argv[0]=[%s] ...\n",
            (unsigned long) tid, numargs, (numargs>0l ? args[0].strptr : "")
            );
    fflush(stderr);
#endif

//   if ( RXVALIDSTRING(args[0]))    // nothing there to do
   if ( numargs!= 0l )    // nothing there to do
   {
       fprintf(stderr, "BSF4Rexx.BsfDetach: no argument allowed, aborting...\n");
       return INVALID_ROUTINE;
   }

   strcpy(retstr->strptr, RgfNewDetach()==TRUE ? "1" : "0");   // indicate success
   retstr->strlength = strlen(retstr->strptr);  // set proper string length

   return VALID_ROUTINE;
}




/*
 * External Rexx function "BSF". This function allows Rexx programs to call into Java.
 */
APIRET APIENTRY
BSF  (  PSZ name,
        ULONG argc,
        PRXSTRING argv,
        PSZ queuename,
        PRXSTRING retstr)
{
#ifdef UNIX
    pthread_t
#else   // WIN32
    TID
#endif
        tid=RgfGetTID();

#if defined(RGF_INFO) || defined (RGF_BIT2)
    fprintf(stderr, "*** RGF_INFO: BSF() 1, tid=[%lu], ", (unsigned long) tid);
    fflush(stderr);

    if (argc==0l) {
        fprintf(stderr, "# args=[%lu] ... \n",
                argc);
    }
    else if (argc==1l) {
        fprintf(stderr, "# args=[%lu], argv[0]=[%s] ... \n",
                argc, (argc>0l ? argv[0].strptr : "")
                );
    }
    else if (argc==2l) {
        fprintf(stderr, "# args=[%lu], argv[0]=[%s], argv[1]=[%s] ... \n",
                      argc, (argc>0l ? argv[0].strptr : ""),
                            (argc>1l ? argv[1].strptr : "")
                );
    }
    else {
        fprintf(stderr, "# args=[%lu], argv[0]=[%s], argv[1]=[%s], argv[2]=[%s] ... \n",
                      argc, (argc>0l ? argv[0].strptr : ""),
                            (argc>1l ? argv[1].strptr : ""),
                            (argc>2l ? argv[2].strptr : "")
                );
    }

         fflush(stderr);
#endif
    // test new attaching
    PSTRUCT_JRST a_JRST=RgfNewAttachToTID(tid);


#if defined (RGF_BIT) || defined (RGF_BIT2)
    fprintf(stderr, "*** *** RGF_INFO_1: BSF()  - after RgfNewAttachToTID(): tid=[%lu] --> a_JRST=[%p/%p::%p] ...\n",
                                         (unsigned long) tid,
                                         a_JRST,
                                         (a_JRST==NULL ? NULL : a_JRST->penv),
                                         (a_JRST==NULL ? NULL : a_JRST->rajo));
    fflush(stderr);
#endif

    // the following may happen, if BsfUnloadJava() was called and UNINIT operations on BSF proxies
    // get triggered, which would unregister the counterpart Java objects from the BSFRegistry;
    // this lets Rexx shutdown gracefully
    // also: if invoking BSF() from a thread that was not attached to JVM beforehand

    if (a_JRST==NULL){  // thread is not attached to a JVM

        if (currentJVM==NULL || pRoot_TID2JRST==NULL ) {     // no JVM available
            strcpy(retstr->strptr, "0");                        // return .false
            retstr->strlength = strlen(retstr->strptr);         // set proper string length
            // return VALID_ROUTINE;
            return INVALID_ROUTINE;  // rgf, 20080824
        }

        // JVM there, so indicate error to Rexx that no JRST is retrievable for this thread!
            // set a variable in the callers Variable pool and save Java message to it
        char errMsg[128]="";
        sprintf(errMsg, "Thread [%lu] is not attached to the existing JVM (Java Virtual Machine), aborting ...",
                             (unsigned long) tid);
        SetRexxVariable( BSF_ERROR_STRING,  lenBsfErrorString, //  strlen(BSF_ERROR_STRING),
                          errMsg, strlen(errMsg));

#ifdef RGF_INFO_1
    fprintf(stderr, "*** *** RGF_INFO_1: BSF() ***ERROR***, errmsg=[%s]\n        currentJVM=[%p], pRoot_TID2JRST=[%p]\n",
                    errMsg,
                    currentJVM,
                    pRoot_TID2JRST
                    );

    fflush(stderr);
#endif

        return INVALID_ROUTINE;
    }


#ifdef RGF_INFO_1
    fprintf(stderr, "*** *** RGF_INFO_1: BSF() 2 - tid=[%lu], a_JRST->penv=[%p]\n",
                                     (unsigned long) tid, (a_JRST==NULL ? NULL : a_JRST->penv) );
    fflush(stderr);
#endif

    //convert arguments array to Java format
    jobjectArray arr = a_JRST->penv->NewObjectArray (
                              argc,
                              a_JRST->clz_String,   // (*env).FindClass("java/lang/String"),
                              a_JRST->emptyUTFString// (*env).NewStringUTF("")
                              );

#ifdef RGF_INFO_1
    fprintf(stderr, "*** *** RGF_INFO_1: BSF() 3a, tid=[%lu], argc=[%d], 'clz_string'=[%p], 'emptyUTFString=[%p] - <==> \n",
                                                   (unsigned long) tid, argc, a_JRST->clz_String, a_JRST->emptyUTFString);
    fflush(stderr);
#endif


        // RXSTRINGs passed from Rexx have an additional \0 appended according Object Rexx 2.1 docs
        for(ULONG i=0; i<argc; i++)
        {
            if (argv[i].strptr==NULL)   // NULL (argument missing) ?
            {
               a_JRST->penv->SetObjectArrayElement(arr, i, NULL);
            }
            else                        // argument as a string in hand
            {
               a_JRST->penv->SetObjectArrayElement(arr, i, a_JRST->penv->NewStringUTF(argv[i].strptr));
            }
        }




    // rgf, 2008-07-28: TODO check whether needed, if test-phase over
// a_JRST->penv->MonitorEnter(a_JRST->rajo);    // make sure other threads accessing the same object are blocked

#if defined(RGF_INFO_1) // || defined (RGF_BIT2)
    fprintf(stderr, "*** *** RGF_INFO_1: BSF() 4 - <==> (BEFORE -> CallObjectMethod(), tid=[%lu] ...\n", (unsigned long) tid);
    fflush(stderr);
#endif

// RgfAcquireLock();
        // call Java method and create Rexx return value
        jstring ReturnValue = (jstring) a_JRST->penv->CallObjectMethod(// obj, globMid, arr);
                                 a_JRST->rajo,
                                 a_JRST->mid_javaCallFromBSF,
                                 arr);
// RgfReleaseLock();

#if defined(RGF_INFO_1) // || defined (RGF_BIT2)
    fprintf(stderr, "*** *** RGF_INFO_1: BSF() 5 - <==> (AFTER  -> CallObjectMethod(), tid=[%lu], returned NULL? [%d] ...)\n", (unsigned long) tid, (ReturnValue==NULL));
    fflush(stderr);
#endif
// a_JRST->penv->MonitorExit(a_JRST->rajo);


            // checking return value from Java
        if (ReturnValue!=NULL)          // value returned from Java?
        {
 //               const char *str = env->GetStringUTFChars(ReturnValue, 0);  // rgf, 2006-01-22

            // this will convert the jstring to a local single-byte string using the current locale of the session
            const char *str=JNU_GetStringNativeChars(a_JRST, ReturnValue);                // rgf, 2006-01-22
            int         len = strlen(str);

            // o.k. not enough space available, free Rexx-allocated memory, re-allocate new chunk
            if (len>=RXAUTOBUFLEN)  // if not enough space available, get a larger chunk and use it
                                    // do *not* free memory allocated by the interpreter!
            {
               retstr->strptr = (char *) RgfAllocateMemory(len+1) ; // allocate new buffer
            }

            strcpy(retstr->strptr, str);
            retstr->strlength = len;
//                env->ReleaseStringUTFChars(ReturnValue, str); // rgf, 2006-01-22
        }
        else    // o.k. Java returned null
        {
            retstr->strptr    = NULL;   // set string pointer to NULL (as if no value was returned)
            retstr->strlength = 0;      // indicate no chars available
        }

                // pending exception ?
        if ( a_JRST->penv->ExceptionCheck() )    // lighter (jboolean: JNI_TRUE, if pending exception), does not create exception object
        {
             jthrowable jo=a_JRST->penv->ExceptionOccurred();    // get the Exception object

             if (bShowErrorString==1)       // print the stack?
             {
                 a_JRST->penv->ExceptionDescribe();  // print the stack
             }

             a_JRST->penv->ExceptionClear();     // clear exception in the JVM

             jclass joc=a_JRST->penv->GetObjectClass(jo);     // get Throwable's class object
                // get method ID
             jmethodID jmidName=a_JRST->penv->GetMethodID(joc, "toString", "()Ljava/lang/String;");
             jobject   jobj=a_JRST->penv->CallObjectMethod(jo, jmidName, NULL);  // invoke the method

             if ( a_JRST->penv->ExceptionCheck() )    // lighter (jboolean: JNI_TRUE, if pending exception), does not create exception object
             {
                 a_JRST->penv->ExceptionDescribe();
                 a_JRST->penv->ExceptionClear();
             }

             const char *aha=a_JRST->penv->GetStringUTFChars( (jstring) jobj, JNI_FALSE);

                // set a variable in the callers Variable pool and save Java message to it
             SetRexxVariable( BSF_ERROR_STRING,  lenBsfErrorString, //  strlen(BSF_ERROR_STRING),
                              (char *)aha, strlen(aha));

#ifdef RGF_INVALID_ROUTINE
    char tmpStr[512]="BSF(...): ExceptionCheck(), exception occurred:\n\n[%511s]";
    sprintf(tmpStr, aha);
    JNU_MessageBox(a_JRST->penv, tmpStr);
#endif

             a_JRST->penv->ReleaseStringUTFChars( (jstring) jobj, aha);


             int rndRes=RgfNewDetach();  // detach from thread
#ifdef RGF_INFO_1
    // test new detaching
    fprintf(stderr, "*** *** RGF_INFO_1: BSF() 6  - RgfNewDetach()=[%d]\n", rndRes);
    fflush(stderr);
#endif

             return INVALID_ROUTINE;    // interrupt Rexx with "Incorrect call to routine!"
        }


#ifdef RGF
// ------------>
fprintf(stderr, "0 ----     PID=[%d]d,TID=[%d]d BEFORE DetachCurrentThread(); env=[%d]d/[%p]p==globEnv=[%d]d/[%p]p\n",
#ifdef WINDOWS
        GetCurrentProcessId(), GetCurrentThreadId(),
#else
        getpid(), pthread_self(),   // Unix
#endif
        env,     env,
        globEnv, globEnv );
// <------------
#endif


     int rndRes=RgfNewDetach();  // detach from thread

#ifdef RGF_INFO_1
    // test new detaching
    fprintf(stderr, "*** *** RGF_INFO_1: BSF() 7  - RgfNewDetach()=[%d]\n", rndRes);
    fflush(stderr);
#endif
     return VALID_ROUTINE;
}





/*
 * This will be called from Java at initialization time and makes sure
 * that the external Rexx functions named &quot;BsfInvokedBy()&quot; and
 * &quot;BSF()&quot; will get
 * registered. This way, Rexx programs being invoked from the Java side
 * have &quot;BSF&quot; available already (no need to register this function by
 * called Rexx program). Changed to "jint" on 2001-05-25.
 */
JNIEXPORT jint JNICALL

Java_org_rexxla_bsf_engines_rexx_RexxAndJava_jniRegisterBSF (JNIEnv *env, jobject obj)

     {
#if defined( RGF_INFO ) || defined (RGF_INFO_1)  // || defined (RGF_BIT)
         fprintf(stderr, "*** RGF_INFO: 1 ..._jniRegisterBSF() 1 ... \n");
         fflush(stderr);

    #ifdef UNIX
        pthread_t
    #else   // WIN32
        TID
    #endif
            tid=RgfGetTID();   // get current TID
         // char msg[4096]="";  // define a buffer, big enough
         char title[512]="";
         sprintf(title, "...jniRegisterBSF(): 1 - tid=[%lu], currentJVM=[%p], bsfInvokedBy=[%d], pRoot_TID2JRST=[%p], about to setup stuff ...",
                        (unsigned long) tid, currentJVM, bsfInvokedBy, pRoot_TID2JRST);

    #ifdef RGF_BIT
         JNU_MessageBox(env, title);
    #endif
#endif


        if (currentJVM==NULL)       // invoked by Java, save JVM-pointer
        {
           env->GetJavaVM( & currentJVM );   // get and save JVM-pointer
           bsfInvokedBy=1;     // invoked by Java
        }

        else if (bsfInvokedBy==2)   // Rexx loaded Java, we need to set up the new structures (rgf, 2008-07-24)
        {
            // 2008-07-24, ---rgf
#if defined( RGF_INFO_1 ) // || defined (RGF_BIT)
    fprintf(stderr, "--- --- RGF_INFO_1: _jniRegisterBSF(): 2a tid=[%lu], invoked by Rexx, needing a new JRST env=[%p], obj=[%p]\n",
                                                            (unsigned long) tid, env, obj);
    fflush(stderr);

#endif

           PSTRUCT_JRST jrst=RgfGetJRST_for_new_jniRexxStart (RgfGetTID(), env, obj); // 2008-07-23, rgf

#if defined( RGF_INFO_1 ) // || defined (RGF_BIT)
          fprintf(stderr, "*** *** RGF_INFO_1: _jniRegisterBSF(): 2b tid=[%lu], jrst=[%p]\n", tid, jrst);
          fflush(stderr);


          sprintf(title, "...jniRegisterBSF(): 2b - tid=[%lu], currentJVM=[%p], bsfInvokedBy=[%d], pRoot_TID2JRST=[%p], jrst=[%p] ...",
                         (unsigned long) tid, currentJVM, bsfInvokedBy, pRoot_TID2JRST, jrst);

    #ifdef RGF_BIT
         JNU_MessageBox(env, title);
    #endif
 #endif
        }


#if defined( RGF_INFO_1 ) // || defined (RGF_BIT)
          fprintf(stderr, "*** *** RGF_INFO_1: _jniRegisterBSF(): 3a tid=[%lu], BSF function [%s] registered? res=[%d] (RXFUNC_OK=='%d')\n",
                                               (unsigned long) tid, ApiFncTable4Java[0], (int) RexxQueryFunction(ApiFncTable4Java[0]), (int) RXFUNC_OK);
          fflush(stderr);

#endif


        if (RexxQueryFunction(ApiFncTable4Java[0])!=RXFUNC_OK) { // rgf, 2008-08-06: function not registered yet?

#if defined( RGF_INFO_1 ) // || defined (RGF_BIT)
          fprintf(stderr, "*** *** RGF_INFO_1: _jniRegisterBSF(): 3b tid=[%lu], BSF function [%s] NOT registered, hence registering all BSF-functions...\n",
                                               (unsigned long) tid, ApiFncTable4Java[0]);
          fflush(stderr);

#endif
                // 2003-01-26
            int entries = sizeof(ApiFncTable4Java)/sizeof(PSZ);    // table with function names to be registered

                // register
            long res=0l, resTmp=0l;                  // initialize to 0l
            for (int j = 0; j < entries; j++)
            {
                 // 2003-01-20, making functions process-local by using RexxRegisterFunctionExe() instead of ...Dll()
                 resTmp = RexxRegisterFunctionExe(ApiFncTable4Java[j], PApiFncTable4Java[j]);

    #if defined (DEBUG2) || defined (RGF_INFO_1)        // ---rgf, 2003-04-30
       fprintf(stderr, "    ... tried to register: j=%d, resTmp=%d, '%s'\n", j, resTmp, ApiFncTable4Java[j]);
    #endif
            }
        }

#ifdef DEBUG2        // ---rgf, 2003-04-30
   fprintf(stderr, "..._bsf_engines_rexx_RexxAndJava_jniRegisterBSF(): about to leave...\n\n");
#endif


#if defined( RGF_INFO_1 ) // || defined (RGF_BIT)
          fprintf(stderr, "*** *** RGF_INFO_1: _jniRegisterBSF(): 4 tid=[%lu], about to return 1...\n",
                                               (unsigned long) tid);
          fflush(stderr);

#endif
         return (jint) 1;   // always return true
     }


/*
 * This may be called from Java, pertains to Object Rexx only (as of 2003-01-04);
 * should wait until all cleanup within Object Rexx has been done. ---rgf, 2002-12-07, 2003-01-04
 */
JNIEXPORT jint JNICALL

Java_org_rexxla_bsf_engines_rexx_RexxAndJava_jniRexxWaitForTermination

  (JNIEnv *env, jobject obj)
     {

#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: ..._jniRexxWaitForTermination() 1 ... \n");
    fflush(stderr);
#endif

#ifdef DEBUG        // ---rgf, 2003-04-30
     fprintf(stderr, "..._jniRexxWaitForTermination(), just arrived\n");
#endif


#if defined (USE_OREXX) || defined( USE_REXXTRANS )
    #ifdef DEBUG2        // ---rgf, 2003-04-30
        fprintf(stderr, "    ...just about to call RexxWaitForTermination()...\n");
    #endif

        RexxWaitForTermination();       // wait for Object Rexx to re-synch ... (2003-02-25, ---rgf: doesn't really have any effect
#endif


#ifdef DEBUG2        // ---rgf, 2003-04-30
    fprintf(stderr, "..._jniRexxWaitForTermination(): about to leave...\n\n");
#endif

        return (jint) 1;               // just return something

     }
  ;


/*
 * This is a pass-thru for RexxDidRexxTerminate(), returns 0 if Object Rexx still runs,
 * 1 if Object Rexx has terminated, ---rgf, 2002-12-13
 */
JNIEXPORT jint JNICALL

Java_org_rexxla_bsf_engines_rexx_RexxAndJava_jniRexxDidRexxTerminate

  (JNIEnv *env, jobject obj)
     {

#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: ..._jniRexxDidRexxTerminate() 1 ... \n");
    fflush(stderr);
#endif

#ifdef DEBUG2        // ---rgf, 2003-04-30
    fprintf(stderr, "..._jniRexxDidRexxTerminate(), just arrived\n");
#endif

#if defined (USE_OREXX) || defined( USE_REXXTRANS )
    #ifdef DEBUG2        // ---rgf, 2003-04-30
        fprintf(stderr, "    ...about to call and return ..._jniRexxDidRexxTerminate() ...\n\n");
    #endif

        return (jint) RexxDidRexxTerminate();       // ask Object Rexx, if it is done

#else
    #ifdef DEBUG2       // ---rgf, 2003-04-30
        fprintf(stderr, "..._jniRexxDidRexxTerminate(), about to leave...\n\n");
    #endif

        return (jint) 1;        // default for non-Object Rexx is the integer value '1' for 'true'
#endif
     }
  ;






/*
 * Class:     com_ibm_bsf_engines_rexx_RexxAndJava
 * Method:    jniInitialize4Rexx
 * Signature: ()I
 *
 * This is the target from the Java side. Will be called upon initializing
 * the JVM from the Rexx side.
 *
 */
JNIEXPORT jint JNICALL Java_org_rexxla_bsf_engines_rexx_RexxAndJava_jniInitialize4Rexx

  (JNIEnv *env, jobject obj)
{

#ifdef RGF_INFO
    fprintf(stderr, "*** RGF_INFO: ..._jniInitialize4Rexx() 1 ... \n");
    fflush(stderr);
#endif

    if (currentJVM==NULL)   // invoked by Java, save JVM-pointer for later use
    {
        env->GetJavaVM( & currentJVM );
        bsfInvokedBy=2;     // Java invoked by Rexx !
    }

#ifdef DEBUG2        // ---rgf, 2003-04-30
    zeigeGlobs();    // show values for global variables
    fprintf(stderr, "..._jniInitialize4Rexx(): about to leave...\n\n");
#endif

    return (jint) 1;              // just return something which can be thought of being true
}



/*
 * This will be called from Java to invoke the Rexx interpreter. "source" contains
 * the Rexx program, "array" the arguments meant for the Rexx program.
 */
JNIEXPORT jstring JNICALL Java_org_rexxla_bsf_engines_rexx_RexxAndJava_jniRexxStart
    ( JNIEnv         *env,
      jobject         obj,
      jstring         scriptSourceLocation,
      jstring         source,
      jobjectArray    array)
{
#ifdef UNIX
    pthread_t
#else   // WIN32
    TID
#endif
        tid=RgfGetTID();   // get current TID

#if defined (RGF_INFO) || defined (RGF_ATTACH) || defined (RGF_DETACH) // || defined (RGF_BIT2)
     {
         fprintf(stderr, "*** RGF_INFO: jniRexxStart() 1, tid=[%lu] ... \n",
                         (unsigned long) tid);
         fflush(stderr);

         char msg[4096]="";  // define a buffer, big enough
         char title[512]="";
         sprintf(title, "...jniRexxStart(): 1 - tid=[%lu], pRoot_TID2JRST=[%p], about to setup and call Rexx...",
                        (unsigned long) tid, pRoot_TID2JRST);

         RgfAcquireLock();
         RgfShowTID2JRSTlist(title, msg);
         RgfReleaseLock();
    #ifdef RGF_BIT
         JNU_MessageBox(env, msg);
    #elif defined(RGF_BIT2)
         fprintf(stderr, "[%s]\n", msg);
         fflush(stderr);
    #endif
     }
#endif


    PSTRUCT_JRST a_JRST;
    a_JRST=RgfNewAttachToTID(tid); // try to attach: if possible, then this is an attempt for a nested invocation via a new BSFManager on the same thread


#if defined (RGF_BIT) || defined (RGF_BIT2)
     {
         char msg2[4096]="";  // define a buffer, big enough
         char title2  [512]="";
         sprintf(title2, "...jniRexxStart(), 1b (starting): tid=[%lu] --> a_JRST=[%p], pRoot_TID2JRST=[%p], pRoot_SAVE_NESTED_JRST=[%p]; AFTER ATTACHING\n",
                        (unsigned long) tid, a_JRST, pRoot_TID2JRST, pRoot_SAVE_NESTED_JRST);

         RgfAcquireLock();
         RgfShowTID2JRSTlist(title2, msg2);
         RgfReleaseLock();

#if defined (RGF_BIT2)
         fprintf(stderr, "[%s]\n", msg2);
         fflush(stderr);
#elif defined (RGF_BIT)
         JNU_MessageBox(env, msg2);
#endif
     }
#endif

        // nested invocation: this TID already is used by a previous jniRexxStart invocation!
    int bNestedInvocation=(a_JRST!=NULL);   // TRUE, if nested, FALSE else

        // we only allow nested invocations, if the previous invocation runs only on
        // one ooRexx thread; if more ooRexx threads are attached to the previous invocation,
        // then we create a Java exception and prematurely return
    if (bNestedInvocation) {

        RgfAcquireLock();
        int iCount=RgfCountUsageOfJRST(tid
#ifdef RGF_BIT
        , env
#endif
        );    // get number of threads using JRST of this tid

#if defined (RGF_BIT)
     {
         char title2  [512]="";
         sprintf(title2, "...jniRexxStart(), NESTED!  tid=[%lu], iCount=[%d], a_JRST=[%p], pRoot_TID2JRST=[%p], pRoot_SAVE_NESTED_JRST=[%p]\n",
                        (unsigned long) tid, iCount, a_JRST, pRoot_TID2JRST, pRoot_SAVE_NESTED_JRST);
         JNU_MessageBox(env, title2);
     }
#endif



#if defined (RGF_BIT) || defined (RGF_BIT2)
     {
         char msg2   [4096]="";
         char title2  [256]="";
         sprintf(title2, "...jniRexxStart(): BEGIN NESTED invocation! tid=[%lu], iCount=[%d], pRoot_TID2JRST=[%p], pRoot_SAVE_NESTED_JRST=[%p]\n",
                        (unsigned long) tid, iCount, pRoot_TID2JRST, pRoot_SAVE_NESTED_JRST);
         RgfShowTID2JRSTlist(title2, msg2);    // add TID2JRST list for debugging
      #if defined (RGF_BIT)
         JNU_MessageBox(env, msg2);
      #endif
     }
#endif

        if (iCount>1) {     // more than one ooRexx threads exploiting previous invocation, abort...
            char msg[4096]="";  // define a buffer, big enough
            char title[512]="";
            sprintf(title, "BSF4Rexx.cc: \n...jniRexxStart(): Illegal attempt to nest Rexx script invocations via BSF (more than one Rexx thread (%d) active on nested invocation: -> panic).", iCount);

            RgfShowTID2JRSTlist(title, msg);    // add TID2JRST list for debugging

            JNU_ThrowByName(env, "org/apache/bsf/BSFException", msg);

    // fprintf(stderr, "--> ..._RexxAndJava...: 'BSF4Rexx.cc:...': msg=[%s]\n", msg);
    // fflush(stderr);

            RgfReleaseLock();
            return NULL;
        }

        RgfSaveTID2JRST(tid);       // save the nested TID2JRST node
        RgfReleaseLock();
    }

        // create the appropriate JRST node (including GlobalReferences etc.)
    a_JRST=RgfGetJRST_for_new_jniRexxStart (tid, env, obj); // 2008-07-23, rgf

#if defined (RGF_BIT) || defined (RGF_BIT2)
     {
         char msg2[4096]="";  // define a buffer, big enough
         char title2  [512]="";
         sprintf(title2, "...jniRexxStart(), 1c (starting): tid=[%lu] --> a_JRST=[%p], pRoot_TID2JRST=[%p], pRoot_SAVE_NESTED_JRST=[%p]; after NEW JRST CREATION\n",
                        (unsigned long) tid, a_JRST, pRoot_TID2JRST, pRoot_SAVE_NESTED_JRST);

         RgfAcquireLock();
         RgfShowTID2JRSTlist(title2, msg2);
         RgfReleaseLock();

#if defined (RGF_BIT2)
         fprintf(stderr, "[%s]\n", msg2);
         fflush(stderr);
#elif defined (RGF_BIT)
         JNU_MessageBox(env, msg2);
#endif
     }
#endif



    const char *      strLoc=NULL;
    char       *sourceStrLoc=NULL;

    if (scriptSourceLocation==NULL)
    {
        // char * tmpStr="n/a";
        char * tmpStr="a_BSF4Rexx_script_without_supplied_source_location";
        sourceStrLoc = (char *) RgfAllocateMemory(strlen(tmpStr)+1) ;
        strcpy(sourceStrLoc, tmpStr);
    }
    else   // make a copy of the Java string containing the Rexx script to be executed
    {
        strLoc       = env->GetStringUTFChars(scriptSourceLocation, 0);
        sourceStrLoc = (char *) RgfAllocateMemory(strlen(strLoc)+1) ;

        strcpy(sourceStrLoc, strLoc);
        env->ReleaseStringUTFChars(scriptSourceLocation, strLoc);
    }

    // make a copy of the Java string containing the Rexx script to be executed
    const char      *str = env->GetStringUTFChars(source, 0);
    char      *sourceStr = (char *) RgfAllocateMemory(strlen(str)+1) ;

    strcpy(sourceStr, str);
    env->ReleaseStringUTFChars(source, str);

    // create argument array for Rexx
    PRXSTRING argList = NULL;       // pointer to array of RXSTRINGS
    jsize   arrNum = 0;
    long    numArgs= 0l;

    if (array != NULL)              // an Object array available?
    {
        arrNum    =  env->GetArrayLength(array);
        numArgs   = (long) arrNum;
    }

    if (arrNum>0)
    {
        // allocate enough memory for argument array of RXSTRINGs
        argList = (PRXSTRING) RgfAllocateMemory( sizeof(RXSTRING) * arrNum );

        for (int i = 0; i < arrNum; ++i)
        {
            if ((env->GetObjectArrayElement(array, i))==NULL)/* no argument*/
            {
                argList[i].strptr   =NULL;
                argList[i].strlength=0;
            }
            else        /* a string argument in hand, give it to Rexx*/
            {
                jstring        javaStr = (jstring) env->GetObjectArrayElement(array, i);

                // this will convert the jstring to a local single-byte string using the current locale of Java
                const char *tmpString=JNU_GetStringNativeChars(a_JRST, javaStr);                // rgf, 2006-01-28
                int         len = strlen(tmpString);

                MAKERXSTRING( argList[i], tmpString, len);/* save arg for Rexx*/
            }
        }
    }

    // Rexx program to execute
    RXSTRING        RXsourceStr[2];
    MAKERXSTRING   (RXsourceStr[0], sourceStr, strlen(sourceStr));
    PRXSTRING       Instore = &RXsourceStr[0];
    MAKERXSTRING   (RXsourceStr[1], NULL, 0);

    SHORT           ReturnCode;
    LONG            ReturnValue;

    // let Rexx allocate buffer, if needed for a result
    LONG            rc;
    RXSTRING        Result;
    MAKERXSTRING   (Result, NULL, 0);

    // PSZ             ProgramName = DLLNAME ; // rgf, 2008-08-06, not needed anymore

    // rgf, 2006-01-27: add Rexx exit handler to intercept error msg

    RGF_STDERR_BUFFER   *rsbarr[2];
    RGF_STDERR_BUFFER   rsb;

    INT tmpUInt[2]={ 0, 0 };                           // 0 count, next line at offset 0
    rsb.intBuffer =tmpUInt;

#ifdef RXSIO_USE_RGF_ALLOC
    rsb.strBuffer =(PCHAR) RgfAllocateMemory(2048);    // four lines  512 bytes including \0
#else
    char tmpBuf[2048]="";           // accommodate four lines  512 bytes including \0
    rsb.strBuffer = tmpBuf;         // assign buffer
#endif

    strcpy(rsb.strBuffer, "..._jniRexxStart(): Rony was here...");

    rsbarr[0]=&rsb;            // interested data
    rsbarr[1]=NULL;            // second four bytes set to NULL

    rc=RexxRegisterExitExe(         RGF_RXSIO_EXIT_NAME_STRING,    // name of the exit function
                           (PFN)    RGF_RXSIO_EXIT_NAME,
                           (PUCHAR) rsbarr               // user data for this exit instance
                          );          // address of the function


#ifdef DEBUG
    fprintf(stderr, "    ...after RexxRegisterExitExe().\n", rc);
#endif

    // now define the exit_list
    RXSYSEXIT exit_list[2];

    // set exit handler infos
    exit_list[0].sysexit_name=RGF_RXSIO_EXIT_NAME_STRING;      // C function name to invoke
    exit_list[0].sysexit_code=RXSIO;                           // exit function

    // indicate no more exit handlers
    exit_list[1].sysexit_name=NULL;
    exit_list[1].sysexit_code=RXENDLST;


/* rgf, 2008-08-09; not needed anymore with ooRexx 3.2 and up
// TODO: check whether this is still needed with ooRexx 3.2 and later
#ifdef CHECK_4_FORGOTTEN_BSF_FUNCTIONS
   // it seems that under Unix Object Rexx *sometimes* looses track of registered
   // external BSF functions
   #ifdef DEBUG
       fprintf(stderr, "...jniRexxStart(): calling makeSureBSF_isRegistered()...\n");
   #endif
         makeSureBSF_isRegistered ();    // make sure BSF() et.al. are registered for the Rexx program!
#endif
*/


         //start Rexx
         ReturnValue = RexxStart(
             (LONG)       arrNum,         // LONG         ArgCount
             (PRXSTRING)  argList,        // PRXSTRING    ArgList
             (PSZ)        sourceStrLoc,   // PSZ          ProgramName
             (PRXSTRING)  Instore,        // PRXSTRING    Instore
             (PSZ)        "BSF",          // NULL,           // PSZ          EnvName
             (LONG)       RXFUNCTION,     // LONG         CallType
             (PRXSYSEXIT) exit_list,     // PRXSYSEXIT   Exits
             (PSHORT)     &ReturnCode,    // PUSHORT      ReturnCode
             (PRXSTRING)  &Result         // PRXSTRING    Result
             );


#if defined (RGF_INFO_1) || defined (RGF_BIT2)
         fprintf(stderr, "*** *** RGF_INFO_1: jniRexxStart() 2 - after RexxStart(): tid=[%lu], ReturnValue=[%ld] ============================\n",
                                  (unsigned long) tid, ReturnValue);

    #if defined (USE_OREXX) || defined( USE_REXXTRANS )
         fprintf(stderr, "*** *** RGF_INFO_1: jniRexxStart() 2b - after RexxStart(): tid=[%lu], RexxDidRexxTerminate()=[%d] ============================\n",
                                  (unsigned long) tid, (int) RexxDidRexxTerminate());
         fflush(stderr);
    #endif
#endif

#if defined (USE_OREXX) || defined( USE_REXXTRANS ) || defined (RGF_BIT2)


// TODO: THINK! if nested invocation, then "RexxWaitForTermination()" may wait forever! :-(
//       possible strategies: do not wait for termination if nested,
//                            wait like 1/100 second if nested before returning
//

    if (!bNestedInvocation &&  !RexxDidRexxTerminate()) {      // ooRexx has not terminated yet

    #if defined ( RGF_INFO_1 ) || defined (RGF_BIT2)
             fprintf(stderr, "*** *** RGF_INFO_1: jniRexxStart() 2c - tid=[%lu], BEFORE RexxDidRexxTerminate()=[%d] ============================\n",
                                      (unsigned long) tid, (int) RexxDidRexxTerminate());
             fflush(stderr);
    #endif

        RexxWaitForTermination();       // wait for ooRexx to terminate (may have threads concurrently running)

    #if defined ( RGF_INFO_1 ) || defined (RGF_BIT2)
             fprintf(stderr, "*** *** RGF_INFO_1: jniRexxStart() 2d - tid=[%lu], AFTER  RexxDidRexxTerminate()=[%d] ============================\n",
                                      (unsigned long) tid, (int) RexxDidRexxTerminate());
             fflush(stderr);
    #endif
    }
#endif



    // fflush(stdin); TODO: evaluate necessity, 2008-07-29
    fflush(stdout);
    fflush(stderr);

    rc=RexxDeregisterExit( RGF_RXSIO_EXIT_NAME_STRING,  // name of the exit function
                           NULL // DLLNAME              // it's this DLL
                       );

#ifdef RGF_INFO_1
    fprintf(stderr, "*** *** RGF_INFO_1: jniRexxStart(), RexxDeregisterExit(), rc=[%d], RXEXIT_OK=[%d]) \n",
                                         rc, RXEXIT_OK);
    fflush(stderr);
#endif

    if (arrNum>0)   // free allocated memory, which was needed for Rexx arguments
    {
        for (int i = 0; i < arrNum; ++i)        // loop over Rexx args
        {
            RgfFreeMemory ( argList[i].strptr );// free argument array RXSTRING buffers
        }
        RgfFreeMemory ( argList );              // free argument array RXSTRING buffer itself
    }

    RgfFreeMemory(sourceStr);       // ---rgf, 2003-04-14, free memory reserved for the Rexx source code
    RgfFreeMemory(sourceStrLoc);    // ---rgf, 2008-06-14


    // error occurred, fetch Rexx error message
    if (ReturnValue != 0l)     // error occurred, return null
    {
        int i=0, j=0;
        PCHAR threeLines[3];
        PCHAR msgBuffer=NULL;

#ifdef RGF_MUTEX4RXSIOTRC
    RgfAcquireLockRXSIO();
#endif
        if (rsb.intBuffer[0]>0)         // o.k., lines captured get the last three in order
        {
            {
                if (rsb.intBuffer[1]==0)                // next line to write to, so all four lines were used already
                {
                    threeLines[0]=rsb.strBuffer+ 512;       // 2nd line
                    threeLines[1]=rsb.strBuffer+1024;       // 3rd line
                    threeLines[2]=rsb.strBuffer+1536;       // 4th line
                }
                else if (rsb.intBuffer[1]==1)            // next line to write to
                {
                    threeLines[0]=rsb.strBuffer+1024;       // 2nd line
                    threeLines[1]=rsb.strBuffer+1536;       // 3rd line
                    threeLines[2]=rsb.strBuffer     ;       // 4th line
                }
                else if (rsb.intBuffer[1]==2)            // next line to write to
                {
                    threeLines[0]=rsb.strBuffer+1536;       // 2nd line
                    threeLines[1]=rsb.strBuffer     ;       // 3rd line
                    threeLines[2]=rsb.strBuffer+ 512;       // 4th line
                }
                else if (rsb.intBuffer[1]==3)            // next line to write to
                {
                    threeLines[0]=rsb.strBuffer     ;       // 2nd line
                    threeLines[1]=rsb.strBuffer+ 512;       // 3rd line
                    threeLines[2]=rsb.strBuffer+1024;       // 4th line
                }
            }

            int iSize=0;                    // calc needed bytes for buffer
            int iSizeArr[3];
            for (i=0; i<3 && i<rsb.intBuffer[0]; i++)       // [0]...count, [1]...next write pos
            {
                iSizeArr[i]=strlen(threeLines[i]);
                iSize=iSize+iSizeArr[i]+1;
            }

            msgBuffer=(PCHAR) RgfAllocateMemory(iSize+1);   // account for trailing \0
            for (i=0, j=0; i<3 && i<rsb.intBuffer[0]; i++)  // [0]...count, [1]...next write pos
            {
                strncpy(msgBuffer+j, threeLines[i], iSizeArr[i]);
                j=j+iSizeArr[i];        // position to write a newline char
                msgBuffer[j]='\n';      // insert a newline character
                j++;                    // next position to copy to
            }
            msgBuffer[iSize-1]='\0';    // no pending \n character
        }
        else        // error condition, but no text captured in the RXSIO exit !
        {
            msgBuffer=(PCHAR) RgfAllocateMemory(512);
            sprintf(msgBuffer, "..._jniRexxStart(): Rexx execution error has occurred (Rexx reported error # [%ld])!", (long) ReturnValue);
        }
#ifdef RGF_MUTEX4RXSIOTRC
    RgfReleaseLockRXSIO();
#endif

        // throw Java exception
        JNU_ThrowByName(env, "org/apache/bsf/BSFException", msgBuffer);
        RgfFreeMemory(msgBuffer);       // make sure memory is freed

#if defined (RGF_INFO) || defined (RGF_ATTACH) || defined (RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: jniRexxStart() 3 - tid=[%lu], a_JRST=[%p], pRoot_TID2JRST=[%p] === about to return with exception! ===\n",
                                  (unsigned long) tid, a_JRST, pRoot_TID2JRST );
         fflush(stderr);
#endif

        RgfAcquireLock();
        int tmpRes=RgfRemoveTID2JRST(a_JRST, TRUE); // make sure, JRST and all dependents get removed

#if defined (RGF_ATTACH) || defined (RGF_DETACH) || defined (RGF_BIT2)  // || defined (RGF_BIT)
       {
        char t2j_list[4096]="";  // define a buffer, big enough
        char title[512]="";
        sprintf(title, "tid=[%lu], pRoot_TID2JRST=[%p], regular end of function, ... EXCEPTION",
                       (unsigned long) tid, pRoot_TID2JRST);
        RgfShowTID2JRSTlist(title, t2j_list);

        fprintf(stderr, "*** *** RGF_INFO_1: jniRexxStart() 4a  - tid=[%lu], TID2JRST-list=[%s] ... EXCEPTION has occurred!\n",
                                 (unsigned long) tid, t2j_list);
        fflush(stderr);
    #ifdef RGF_BIT
         JNU_MessageBox(env, t2j_list);
    #endif
       }
#endif

        // relies that RgfRemoveTID2JRST(jrst,TRUE) was executed beforehand
        if (bNestedInvocation) {    // restore saved (uncover nested) TID2JRST
            RgfRestoreTID2JRST(tid);
            RgfNewDetach();         // make sure counter gets decreased (got increased inadvertently at the top)

#if defined ( RGF_BIT ) || defined (RGF_BIT2)
     {
         char msg2   [4096]="";
         char title2  [256]="";
         sprintf(title2, "...jniRexxStart(): EXECUTION ERROR in nested invocation! tid=[%lu], pRoot_TID2JRST=[%p], pRoot_SAVE_NESTED_JRST=[%p], RESTORED to PREVIOUS JRST\n",
                        (unsigned long) tid, pRoot_TID2JRST, pRoot_SAVE_NESTED_JRST);
         RgfShowTID2JRSTlist(title2, msg2);    // add TID2JRST list for debugging
#if defined(RGF_BIT2)
         fprintf(stderr, "\t[%s]\n", msg2);
         fflush(stderr);
#elif defined (RGF_BIT)
         JNU_MessageBox(env, msg2);
#endif
     }
#endif
        }


#if defined (RGF_ATTACH) || defined (RGF_DETACH) || defined (RGF_BIT2) // || defined (RGF_BIT)
       {
        char t2j_list[4096]="";  // define a buffer, big enough
        char title[512]="";

        sprintf(title, "tid=[%lu], pRoot_TID2JRST=[%p], Rexx execution error, about to throw Java exception...",
                        (unsigned long) tid, pRoot_TID2JRST);
        RgfShowTID2JRSTlist(title, t2j_list);

        fprintf(stderr, "*** *** RGF_INFO_1: jniRexxStart() 3b - tid=[%lu], TID2JRST-list=[%s] \n        === about to return with exception! ===\n",
                                 (unsigned long) tid, t2j_list);
        fflush(stderr);

    #ifdef RGF_BIT
         JNU_MessageBox(env, t2j_list);
    #endif
       }
#endif
       RgfReleaseLock();


#ifdef RXSIO_USE_RGF_ALLOC
        if (rc==RXEXIT_OK) {    // deregistering worked, save to free buffer
            RgfFreeMemory(rsb.strBuffer);   // four lines  512 bytes including \0
        }
#endif


        return NULL;                    // return to Java
    }

#ifdef RXSIO_USE_RGF_ALLOC
    if (rc==RXEXIT_OK) {    // deregistering worked, save to free buffer
        RgfFreeMemory(rsb.strBuffer);   // four lines  512 bytes including \0
    }
#endif

    // --- get result and return it to Java
    jstring jResult=NULL;           // define Java String to return
    if ( Result.strptr != NULL )    // a result was returned from Rexx
    {
        if (Result.strlength==0)   // empty string?
        {
            // jResult=JAVA_EMPTY_UTF_STRING;
            jResult=a_JRST->emptyUTFString;
        }
        else                       // valid non-empty string
        {
            // jResult=env->NewStringUTF( Result.strptr );
            jResult=a_JRST->penv->NewStringUTF( Result.strptr );
        }
    }

    RgfAcquireLock();
    int tmpRes=RgfRemoveTID2JRST(a_JRST, TRUE); // make sure, JRST and all dependents get removed
    RgfReleaseLock();           

#if defined (RGF_ATTACH) || defined (RGF_DETACH) || defined (RGF_BIT2)  // || defined (RGF_BIT)
       {
        char t2j_list[4096]="";  // define a buffer, big enough
        char title[512]="";
        sprintf(title, "tid=[%lu], pRoot_TID2JRST=[%p], regular end of function, about to return a jResult [%p]...",
                       (unsigned long) tid, pRoot_TID2JRST, jResult);
        RgfShowTID2JRSTlist(title, t2j_list);

        fprintf(stderr, "*** *** RGF_INFO_1: jniRexxStart() 4b-1  - tid=[%lu], TID2JRST-list=[%s] \n        === about to return normally ===\n",
                                 (unsigned long) tid, t2j_list);
        fflush(stderr);
    #ifdef RGF_BIT
         JNU_MessageBox(env, t2j_list);
    #endif
       }
#endif

    // relies that RgfRemoveTID2JRST(jrst,TRUE) was executed beforehand
    if (bNestedInvocation) {    // restore saved (uncover nested) TID2JRST

#if defined (RGF_BIT2)
    fprintf(stderr, "... before RgfRestoreTID2JRST(tid): tid=[%lu]\n", (unsigned long) tid);
    fflush(stderr);
#endif
        RgfRestoreTID2JRST(tid);

#if defined (RGF_BIT2)
    fprintf(stderr, "... before RgfNewDetach(): tid=[%lu]\n", (unsigned long) tid);
    fflush(stderr);
#endif

        RgfNewDetach();         // make sure JRST counter gets decreased (got increased inadvertently at the top)

#if defined(RGF_BIT) || defined(RGF_BIT2)
     {
         char msg2   [4096]="";
         char title2  [256]="";


#if defined (RGF_BIT2)
    fprintf(stderr, "... before RgfShowTID2JRSTlist: tid=[%lu] #1\n", (unsigned long) tid);
    fflush(stderr);
#endif

         sprintf(title2, "...jniRexxStart(): END of nested invocation! tid=[%lu], pRoot_TID2JRST=[%p], pRoot_SAVE_NESTED_JRST=[%p]\n",
                        (unsigned long) tid, pRoot_TID2JRST, pRoot_SAVE_NESTED_JRST);


#if defined (RGF_BIT2)
    fprintf(stderr, "... before RgfShowTID2JRSTlist: tid=[%lu] #2\n", (unsigned long) tid);
    fflush(stderr);
#endif



        RgfShowTID2JRSTlist(title2, msg2);    // add TID2JRST list for debugging

        #ifdef RGF_BIT
         JNU_MessageBox(env, msg2);
        #else
          fprintf(stderr, "%s\n", msg2);
          fflush(stderr);
        #endif
     }
#endif

    }
// TODO: rgf, 20080903, moved to top    RgfReleaseLock();


#ifdef RGF_BIT
     {
         char title2  [512]="";
         sprintf(title2, "...jniRexxStart(), 2 (leaving) : tid=[%lu], a_JRST=[%p], pRoot_TID2JRST=[%p], pRoot_SAVE_NESTED_JRST=[%p]\n",
                        (unsigned long) tid, a_JRST, pRoot_TID2JRST, pRoot_SAVE_NESTED_JRST);
         JNU_MessageBox(env, title2);
     }
#endif


#if defined (RGF_INFO) || defined (RGF_ATTACH) || defined (RGF_DETACH)
         fprintf(stderr, "*** *** RGF_INFO_1: jniRexxStart() 4b-2 - a_JRST=[%p], pRoot_TID2JRST=[%p], jresult=[%p] === about to return ========\n",
                                  a_JRST, pRoot_TID2JRST, jResult );
         fflush(stderr);
#endif
    return jResult;         // return a Java String
}










        // ===>
        // ---rgf, 2006-01-27: use a RXSIO exit to capture the error-strings and return them in form of a Java exception
        // <===
// APIRET APIENTRY RGF_RXSIO_EXIT_NAME ( LONG exitNumber, LONG subFunction, PEXIT parmBlock )
LONG APIENTRY RGF_RXSIO_EXIT_NAME ( LONG exitNumber, LONG subFunction, PEXIT parmBlock )
{

#ifdef RGF_MUTEX4RXSIOTRC
    RgfAcquireLockRXSIO();
#endif

        // define variables
    USHORT            query_flag=0;     // for RexxQueryExit(): RXEXIT_OK or RXEXIT_NOTREG
    RGF_STDERR_BUFFER *user_info[2];
    LONG              rc=0;

#if defined (DEBUG) // || defined (RGF_BIT)
         fprintf(stderr, "\n---\ndebug - %s(): just arrived, exitNumber=[%d], subFunction=[%d], parmBlock=[%p]\n",
                         RGF_RXSIO_EXIT_NAME_STRING,
                         exitNumber, subFunction, parmBlock);
         fflush(stderr);

         RXSIOTRC_PARM *tparm_rgf = ( RXSIOTRC_PARM * ) parmBlock;
         fprintf(stderr, "\n    --> ---> [%s]\n", tparm_rgf->rxsio_string.strptr);
         fflush(stderr);
#endif


    if (subFunction!=RXSIOTRC)      // only intercept trace/error output from Rexx
    {
#ifdef RGF_MUTEX4RXSIOTRC
        RgfReleaseLockRXSIO();
#endif
        return RXEXIT_NOT_HANDLED;  // Rexx will now write to stdout: instead of stderr: !
    }

        // save string in a round-robin fashion in the user data, first get it!
    rc=RexxQueryExit(RGF_RXSIO_EXIT_NAME_STRING,
                     NULL,                  // area anchor from Rexx
                     &query_flag,
                     (PUCHAR) user_info);

    RGF_STDERR_BUFFER   rsb = *(user_info[0]);      // get access to our data structure

    if (subFunction==RXSIOTRC)
    {
        RXSIOTRC_PARM *tparm = ( RXSIOTRC_PARM * ) parmBlock;

#if defined (DEBUG) // || defined (RGF_BIT)
    fprintf(stderr, "debug - RXIOTRC: %s(), rc=[%d]: \n    --> ---> [%s]\n", RGF_RXSIO_EXIT_NAME_STRING,
                    rc,
                    tparm->rxsio_string.strptr);
    fprintf(stderr, "===> iCount == rsb.intBuffer[0]=[%d] | iNext == rsb.intBuffer[1]=[%d]\n",
                    rsb.intBuffer[0], rsb.intBuffer[1]);
    fflush(stderr);
#endif

            // truncate lines that are too long (> 511 bytes)
       // int iLength=min(511, tparm->rxsio_string.strlength  );
       // min-function not available on Linux gcc, hence this way

        int iTmpLength=(int)tparm->rxsio_string.strlength;
        int iLength=511;
        if (iLength>iTmpLength)
            iLength=iTmpLength;

        int iStartPos=rsb.intBuffer[1]*512;         // write position in buffer

        strncpy( rsb.strBuffer+iStartPos , tparm->rxsio_string.strptr, iLength);

        PCHAR p=rsb.strBuffer+iStartPos+iLength;    // position on last character
        *p=0;                                       // set ending 0
        if (iLength==511)   // too long? if so replace last three chars with " ..." to indicate truncation (ellipsis)
        {
             *--p=('.'); *--p=('.'); *--p=('.');    // *--p=' '; // add an ellipsis if too long
        }

        rsb.intBuffer[0]++;     // increase counter
        if (rsb.intBuffer[0]>2000000)   // in the unlikely event that this exit is called 2,000,000 times, reset counter
        {
            rsb.intBuffer[0]=5;         // just needs to be larger than maximum number of available lines (= 4)
        }

        rsb.intBuffer[1]++;     // increase next write position
        if (rsb.intBuffer[1]>3)         // roll over
        {
            rsb.intBuffer[1]=0;         // next line will be written to start of buffer
        }
#if defined (DEBUG) // || defined (RGF_BIT)
    fprintf(stderr, "===> startPos=[%d], length=[%d]: [%s]\n\n", iStartPos, iLength, rsb.strBuffer+iStartPos);
#endif

    }

#ifdef RGF_MUTEX4RXSIOTRC
    RgfReleaseLockRXSIO();
#endif
    return RXEXIT_NOT_HANDLED;  // Rexx will now write to stdout: instead of stderr: !
}




/*
#ifdef NIXI_RGF     // don't include
    // o.k. under Windows be verbose about process&thread de/creation ..., rgf, 2003-08-06
    #if defined (DEBUG_THREADS) && defined (WIN32)

        // We provide a DLL entry function. Look at the standard documentation
        BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD Reason, LPVOID reserved)
        {
           fprintf(stderr, "DllMain(): hinstDLL=[%p], ", hinstDLL);
           fprintf(stderr, "Reason=[%p], reserved=[%p]\n", Reason, reserved);

           // if (Reason == DLL_THREAD_ATTACH || Reason == DLL_THREAD_DETACH) {
           JNIEnv *env=NULL;       // to receive the thread specific env-pointer/TID
           if (Reason == DLL_THREAD_DETACH || Reason == DLL_PROCESS_DETACH)
           {
                        // get the JVM-pointer
                   JavaVM *vm= (globJvm==NULL ? globJavaVM : globJvm);    // get the JVM interface pointer
                       // get correct JNIEnv object for this thread !

                   rgfAttachCurrentThread(vm, env);
                   // fprintf(stderr, "DllMain(): Java-THREAD=[%p] <=== <=== <===\n", env);

#ifdef USE_DETACH_CURRENT_THREAD
               rgfDetachCurrentThread(vm, env);  // ---rgf, 2008-06-09, switched args!
#endif
           }

           switch (Reason) {
              case DLL_PROCESS_ATTACH:
                 fprintf(stderr, "    DllMain(): DLL_PROCESS_ATTACH <===\n");
                 // Two things to do
                 break;
              case DLL_PROCESS_DETACH:
                  fprintf(stderr, "    DllMain(): DLL_PROCESS_DETACH; TID=[%p] <===\n", env);
                  MT_Java_env_remove(env);
                  fprintf(stderr, "            did remove entry [%p] from HASHTABLE.\n", env);
                 break;
              case DLL_THREAD_ATTACH:
                  fprintf(stderr, "    DllMain(): DLL_THREAD_ATTACH  <===\n");
                 break;
              case DLL_THREAD_DETACH:
                  fprintf(stderr, "    DllMain(): DLL_THREAD_DETACH  TID=[%p] <===\n", env);
                  MT_Java_env_remove(env);
                  fprintf(stderr, "            did remove entry [%p] from HASHTABLE.\n", env);
                 break;
           }

           return(TRUE);
        }
    #endif
#endif
*/

    // now called (JNI_OnLoad was misspelled!), 2006-01-04, ---rgf // never called! 2003-07-24
JNIEXPORT void JNICALL
     JNI_OnUnload(JavaVM *vm, void *reserved)
     {

#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: JNI_OnUnLoad() 1 ...\n");
         fflush(stderr);
#endif

     }



JNIEXPORT jint JNICALL
     JNI_OnLoad(JavaVM *vm, void *reserved)
     {

         // 2008-07-23: initialize data structure --->
#ifdef RGF_INFO
         fprintf(stderr, "*** RGF_INFO: JNI_OnLoad() 1 ...\n");
         fflush(stderr);
#endif

#ifdef WIN32
        InitializeCriticalSection (&JRST_lock);
    #ifdef RGF_MUTEX4RXSIOTRC
        InitializeCriticalSection (&RXSIO_lock);
    #endif

#elif defined UNIX
		pthread_mutex_init(&JRST_lock, NULL);
    #ifdef RGF_MUTEX4RXSIOTRC
		pthread_mutex_init(&RXSIO_lock, NULL);
    #endif
#endif
        // <--- 2008-07-23, rgf

#ifdef DEBUG3
         fprintf(stderr, "!!! in JNI_Onload ... (rgf) !!! vm=[%p], reserved=[%p]\n", vm, reserved);
  #ifdef DEBUG
    zeigeGlobs();    // show values for global variables
  #endif
#endif


#ifdef DEBUG
   fprintf(stderr, "---> returning a jint: [%x] [%d]\n", USE_DEFINED_JNI_VERSION, USE_DEFINED_JNI_VERSION);
#endif

         return (jint) USE_DEFINED_JNI_VERSION; // JNI_VERSION_1_2;
         // return (jint) 0x00010000 | JNI_VERSION;
     }



#ifdef ALLOW_LOADING_JVM    //   ---rgf, 2005-08-23, #idef'ed - not for OS2 and not for Macintosh
    /* 2006-01-04, ---rgf: changed handling of arguments for JNI_1_2 and up:
       - arguments are passed on to the JVM as is; this way one can use the
         "-D<name>=<value>", "-verbose[:{class|gc|jni|X-non-standard-name}[,...]]
    */


    /*********************************************************************/
    /* load Java                                                         */
    /*                                                                   */
    /* ALL NEW BEHAVIOR FOR JNI_1_2 and up since 2006-01-04:             */
    /*                                                                   */
    /*    if Rexx-arguments are given, they are passed along to Java     */
    /*    as startup arguments (e.g. "-Djava.class.path=.")              */
    /*                                                                   */
    /*    if no Rexx argument sets 'java.class.path' and the environment */
    /*    variable CLASSPATH is given, then that value is used to pass   */
    /*    it on to the JVM (a "-Djava.class.path=$CLASSPATH"             */
    /*                                                                   */
    /*                                                                   */
    /* returns:                                                          */
    /*            0 ... JVM got loaded                                   */
    /*            1 ... JVM got loaded in earlier runs, merely made      */
    /*                  it available again                               */
    /*              ... else, whatever JNI returned                      */
    /*         -999 ... if JVM already loaded                            */
    /*         -998 ... first argument not Append nor Prepend            */
    /*         -997 ... argument #1 exceeds 1023 bytes                   */
    /*         -996 ... length of Java-classpath plus the addition of    */
    /*                  argument #1 (including PATH separator)           */
    /*                  exceeds 1023 bytes                               */
    /*         -995 ... could not create JVM                             */
    /*         -994 ... init error: could not find 'Java4Rexx.class'     */
    /*         -993 ... init error: could not find static method         */
    /*                  'Java4Rexx.createInterface4Rexx()'               */
    /*         -992 ... init error: could not find javai/jvm-DLL/so      */
    /*                                                                   */
    /* ---rgf, 2003-01-15,21; switched args on 2003-02-23                */
    /* ---rgf, 2003-08-11; dynamically loads JVM independent of version  */
    /*********************************************************************/

    APIRET APIENTRY BsfLoadJava( //2(
      PSZ       name,                      /* Function name              */
      LONG      numargs,                   /* Number of arguments        */
      RXSTRING  args[],                    /* Argument array             */
      PSZ       queuename,                 /* Current queue              */
      PRXSTRING retstr )                   /* Return RXSTRING            */
         {
             jint            res;
             jclass          cls;
             jmethodID       mid;
             jstring         str;
             JNIEnv *jniEnv=NULL;


         #ifdef DEBUG        // ---rgf, 2003-04-30
            fprintf(stderr, "BsfLoadJava(): just arrived\n");    // show values for global variables
         #endif

                 // JVM already loaded?
             // if (globJvm!=NULL)
             if (currentJVM != NULL)
             {
                 strcpy(retstr->strptr, "-999");
                 retstr->strlength = strlen(retstr->strptr); // set proper string length
                 return INVALID_ROUTINE;
             }

                 // all JNI versions ------------->
             char *cp_env=getenv("CLASSPATH");   // get value of environment variable CLASSPATH (NULL, if not set)

             // JNI 1.2 and above ------------>
             JavaVMInitArgs vm_args2;           // startup argument structure

                // vars for function pointers
             rgf_JNI_CreateJavaVM             rgfCreateJavaVM=NULL;
             rgf_JNI_GetDefaultJavaVMInitArgs rgfGetDefaultJavaVMInitArgs=NULL;

             #if defined   ( WIN32 )
                 // HINSTANCE hVM = NULL;
                 // char *jni_12_library="jvm";
                 // hVM=LoadLibrary( jni_12_library );   // try to load the JNI 1.1 DLL
                 HINSTANCE hVM=LoadLibrary( "jvm" );   // try to load the JavaVM

#if defined( DEBUG )
    if (hVM!= NULL)
    {
        char fileName[256]="";
        GetModuleFileName(hVM, fileName, 256);
        fprintf(stderr, "module's filename=[%s]\n", fileName);
    }
#endif

             #elif defined ( UNIX )
                 // PVOID      hVM = NULL;
                 // char *jni_12_library="libjvm.so";
                 // hVM=dlopen(jni_12_library, RTLD_LAZY | RTLD_GLOBAL );

                 PVOID hVM=dlopen("libjvm.so", RTLD_LAZY | RTLD_GLOBAL );

             #endif


#ifdef DEBUG2
   #if   defined ( WIN32 )
       fprintf(stderr, "hVM=[%p], proc=[%p]\n", hVM, GetProcAddress(hVM, "JNI_CreateJavaVM"));
   #elif defined ( UNIX )
       fprintf(stderr, "hVM=[%p], proc=[%p]\n", hVM, dlsym(hVM, "JNI_CreateJavaVM"));
   #endif
#endif

                 if ( hVM == NULL)  // oops, no Java DLL/so found
                 {
                     fprintf(stderr, "BsfLoadJava(): could not find the Java dynamic link library, aborting!\n");
                     strcpy(retstr->strptr, "-992");
                     retstr->strlength = strlen(retstr->strptr); // set proper string length
                     return INVALID_ROUTINE;
                 }



             #if defined   ( WIN32 )
                 rgfCreateJavaVM             = (rgf_JNI_CreateJavaVM)             GetProcAddress(hVM, "JNI_CreateJavaVM"); // return the address
                 rgfGetDefaultJavaVMInitArgs = (rgf_JNI_GetDefaultJavaVMInitArgs) GetProcAddress(hVM, "JNI_GetDefaultJavaVMInitArgs"); // return the address

             #elif defined ( UNIX )
                 rgfCreateJavaVM             = (rgf_JNI_CreateJavaVM)             dlsym(hVM, "JNI_CreateJavaVM") ;
                 rgfGetDefaultJavaVMInitArgs = (rgf_JNI_GetDefaultJavaVMInitArgs) dlsym(hVM, "JNI_GetDefaultJavaVMInitArgs");

             #endif


#ifdef DEBUG2
fprintf(stderr, "after finding procAddresses; h1=[%p], h2=[%p], leaving...\n",
                rgfCreateJavaVM, rgfGetDefaultJavaVMInitArgs);
{ char *rgfStr="hallo";char *rgfRes="holla";rgfRes = fgets(rgfStr, 3, stdin); }
#endif
/////////////////////


             if ( rgfCreateJavaVM == NULL)  // oops, no entry point found, cannot load Java !
             {
                 fprintf(stderr, "BsfLoadJava(): could not find the Java dynamic link library, aborting!\n");
                 strcpy(retstr->strptr, "-992");
                 retstr->strlength = strlen(retstr->strptr); // set proper string length
                 return INVALID_ROUTINE;
             }

             jint resVer;
#ifdef DEBUG2
    fprintf(stderr, "BsfLoadJava(): found DLL/so, now getting the default init args.\n");
    fprintf(stderr, "               now trying to get input from keyboard:\n");
    {
    char *rgfStr="hallo";char *rgfRes="holla";rgfRes = fgets(rgfStr, 3, stdin);
    fprintf(stderr, "              str=[%s], res=[%s]\n", rgfStr, rgfRes);
    }
#endif

             vm_args2.version = USE_DEFINED_JNI_VERSION ; // 0x00010002;
             resVer = rgfGetDefaultJavaVMInitArgs(&vm_args2);

#ifdef DEBUG1        // ---rgf, 2003-04-30
     fprintf(stderr, "BsfLoadJava(): after rgf_JNI_GetDefaultJavaVMInitArgs, resVer=[%p]\n", resVer);
     { char *rgfStr="hallo";char *rgfRes="holla";rgfRes = fgets(rgfStr, 3, stdin); }
#endif



             {
/* as of 2006-01-04 rules have changed: only supply options, if arguments are supplied (and if so
                    pass them on verbatimely!
   as of 2006-01-06: if Rexx-arg contains -Djava.class.path=, then use it; if not given and
                     CLASSPATH environment is given, use that instead; else do not set any java.class.path
*/

                    // default: no options !
             JavaVMOption *options=NULL;
             vm_args2.version = USE_DEFINED_JNI_VERSION ; // set version
             vm_args2.options = NULL;                 // set options-array (containing classpath)
             vm_args2.nOptions = 0;                   // indicate how many entries in array
             vm_args2.ignoreUnrecognized = FALSE;     // report unrecognized values !
             // vm_args2.ignoreUnrecognized = TRUE ;     // report unrecognized values !

             {
                     bool bCPdefined=FALSE; // is a classpath defined in the arguments? If so, use it and forgo
                     int m=0;
                                            // a possibly CLASSPATH environment variable definition
                     const char *needle="-Djava.class.path="; // needle to look for in the arguments
                     int  needleLength=strlen(needle);

                        // reserve enough space (one entry for java.lang.classpath)
                     options=(JavaVMOption *) malloc( sizeof( JavaVMOption ) * (numargs+1) );

                     for (int i=0; i<numargs; i++)  // iterate over all Rexx arguments
                     {

                         if (args[i].strptr==NULL || args[i].strlength==0)
                         {
                             continue;  // empty Rexx arg, ignore it
                         }
                         else        // o.k. classpath argument supplied, check it
                         {
                                 // determine whether java.class.path is supplied via a Rexx argument
                             bCPdefined= (bCPdefined || (strncmp(args[i].strptr, needle, needleLength)==0));
#ifdef DEBUG3
     fprintf(stderr, "BsfLoadJava(): Rexx arg # [%d]=[%s]\n", i, args[i].strptr);
     fprintf(stderr, "               bCPDefined=[%d], strncmp=[%d]\n", bCPdefined, strncmp(args[i].strptr, needle, needleLength));

#endif

                             char *ch = (char *) malloc(args[i].strlength+1);           // copy Rexx argument
                             strncpy(ch, args[i].strptr, args[i].strlength+1);
                             options[m].optionString = ch;      //
                             options[m].extraInfo    = NULL;    // Florian's Schuld! :) (2004-05-06)
#ifdef DEBUG3
    fprintf(stderr, "BsfLoadJava(): added Rexx argument [%s] as option # [%d]\n", options[m], m);
#endif
                             m++;                   // increase counter to reflect number of available options
                         }
                     }

#ifdef DEBUG3
     if (bCPdefined!=FALSE)
     {
         fprintf(stderr, "BsfLoadJava(): CLASSPATH set by a REXX argument.\n");
     }
     else
     {
         fprintf(stderr, "BsfLoadJava(): CLASSPATH was *NOT* set by a REXX argument.\n");
     }
#endif
                        // no java.class.path override in Rexx argument and CLASSPATH envirnoment variable given?
                     if ((bCPdefined==FALSE) && (cp_env!= NULL))
                     {
                         int bufLen=strlen(cp_env)+needleLength;
                         options[m].optionString = (char *) malloc(bufLen+1);   // get needed memory
                         sprintf(options[m].optionString, "%s%s", needle, cp_env);
                                 options[m].extraInfo=NULL;
                         m++;                       // increase counter to reflect number of available options
#ifdef DEBUG3
     fprintf(stderr, "BsfLoadJava(): using CLASSPATH environment variable for JVM, retrieved and use value:    [%s]\n",
                     options[m-1].optionString);
#endif
                     }

                     vm_args2.options  = options;   // set options-array (containing classpath)
                     vm_args2.nOptions = m;         // indicate how many entries in array
#ifdef DEBUG3
    fprintf(stderr, "BsfLoadJava(): # of options for JVM is: [%d]\n\n", vm_args2.nOptions);
#endif
             }

/*
         #ifdef DEBUG2        // ---rgf, 2003-04-30
            fprintf(stderr, "BsfLoadJava(): about to create a JVM, JNI=[%d]\n", JNI_VERSION);
            { char *rgfStr="hallo";char *rgfRes="holla";rgfRes = fgets(rgfStr, 3, stdin); }
         #endif
*/

            // res = rgfCreateJavaVM( &globJvm, (void **) &jniEnv, &vm_args2);
            // res = rgfCreateJavaVM( &globJvm, (void **) &jniEnv, &vm_args2);
            res = rgfCreateJavaVM( &currentJVM, (void **) &jniEnv, &vm_args2);
            bsfInvokedBy=2;

         #ifdef DEBUG2        // ---rgf, 2003-04-30
            fprintf(stderr, "BsfLoadJava(): AFTER create a JVM, res=[%d]\n", res);
         #endif
             }

             if (res<0) {
                 fprintf(stderr, "BsfLoadJava(): Can't create Java VM, rc=%d\n", res);
                 strcpy(retstr->strptr, "-995");
                 // sprintf(retstr->strptr, "%p", res);         // copy return code
                 retstr->strlength = strlen(retstr->strptr); // set proper string length
                 return INVALID_ROUTINE;
             }

             /* Find the class "Java4Rexx" */
             cls = (*jniEnv).FindClass(JAVA_4_REXX);    // or: cls = jniEnv->FindClass(JAVA_4_REXX);
             // cls = jniEnv->FindClass(JAVA_4_REXX);    // or: cls = jniEnv->FindClass(JAVA_4_REXX);
#ifdef DEBUG
     fprintf(stderr, "jniEnv=[%p], JAVA_4_REXX=[%s], cls=[%p]\n", jniEnv, JAVA_4_REXX, cls);
#endif
             if (cls == 0) {
                 fprintf(stderr, "BsfLoadJava(): initialization error, can't find class: \n    '%s'\n", JAVA_4_REXX);
                 strcpy(retstr->strptr, "-994");
                 retstr->strlength = strlen(retstr->strptr); // set proper string length
                 return INVALID_ROUTINE;
             }

             /* get static Method "createInterface4Rexx()" */
              mid = jniEnv->GetStaticMethodID(cls, "createInterface4Rexx", "()V");
             if (mid == 0) {
                 fprintf(stderr, "BsfLoadJava(): initialization error, can't find method: \n    'Java4Rexx.createInterface4Rexx()'\n");
                 strcpy(retstr->strptr, "-993");
                 retstr->strlength = strlen(retstr->strptr); // set proper string length
                 return INVALID_ROUTINE;
             }

             /* call the static method, which in turn will initialize BSF4Rexx by creating
                a BSFManager and having it load the "Rexx" (support) */
             strcpy(retstr->strptr, "0");
             retstr->strlength = strlen(retstr->strptr); // set proper string length

             jniEnv->CallStaticVoidMethod(cls, mid, NULL);      // invoke static method


         #ifdef DEBUG2        // ---rgf, 2003-04-30
             zeigeGlobs();    // show values for global variables
         #endif

         #ifdef DEBUG        // ---rgf, 2003-04-30
             fprintf(stderr, "BsfLoadJava(): about to leave...\n\n");
         #endif
           return VALID_ROUTINE;
         }
#endif



#ifdef __cplusplus
}               // closing bracket
#endif


