/* ------------------------------------------------------------------ */
/* GOSERVE -- Web and Gopher server                                   */
/* GosLin.h -- Linux-only includes                                    */
/* ------------------------------------------------------------------ */
/* Copyright (c) IBM Corporation, 2004, 2007                          */
/* Author: Mike Cowlishaw                                             */
/* ------------------------------------------------------------------ */

  /* Operating-system-specific names */
  #define DELIMCHR   '/'
  #define DELIMSTR   "/"
  #define LOGFILE   "~/goserveg.log"

  /* OS/2- and Rexx-style types */
  typedef char *         PSZ;
  typedef char *         PSTR;
  typedef unsigned char  UCHAR;
  typedef char           CHAR;
  typedef unsigned short USHORT;
  typedef short          SHORT;
  typedef unsigned long  ULONG;
  typedef long           LONG;
  typedef UCHAR *        PUCHAR;
  typedef USHORT *       PUSHORT;
  typedef ULONG *        PULONG;
  typedef SHORT *        PSHORT;
  typedef LONG  *        PLONG;
  typedef ULONG          APIRET;
  typedef void  *        PVOID;
  typedef ULONG          HWND;

  /* Miscellaneous */
  typedef struct recty {
    long  left;
    long  top;
    long  right;
    long  bottom;
    } RECT;
  typedef long int HINSTANCE;
  #define APIENTRY
  #define WINAPI
  typedef int (WINAPI *FARPROC)(void);

  /* Includes */
  #define  __USE_BSD
  #include <unistd.h>
  #include <stdarg.h>
  #include <pthread.h>
  #include <sys/socket.h>
  #include <sys/select.h>
  #include <errno.h>
  #include <netdb.h>

  #define  INCL_REXXSAA
  #include "rexxix.h"

  /* Sleep for n seconds */
  #define sleepSecs(n) sleep(n)

  /* ---------------------------------------------------------------- */
  /* TCP/IP modifications                                             */
  /* ---------------------------------------------------------------- */
  #define sock_errno()   errno
  #define closesocket(s) close(s)

  /* ---------------------------------------------------------------- */
  /* Process macros & definitions                                     */
  /* ---------------------------------------------------------------- */
  typedef pid_t          ProcessID;

  /* ---------------------------------------------------------------- */
  /* Threading macros & definitions                                   */
  /* ---------------------------------------------------------------- */

  #define ThreadID     pthread_t   // TID
  #define ThreadHandle pthread_t * // thread Handle (non-null if OK)
  #define ThreadRet    void *      // thread return type
  #define ThreadNULL   NULL        // thread null return
  #define Mutex        pthread_mutex_t  // Mutex object

  /* ---------------------------------------------------------------- */
  /* startThread:                                                     */
  /*                                                                  */
  /* ThreadHandle startThread(entrypoint,   -- function name          */
  /*                          void *,       -- start-up parameter     */
  /*                          ThreadID *)   -- gets TID               */
  /*                                                                  */
  /* where entrypoint is: ThreadRet thread(void *rptr)                */
  /* and returns NULL if the start fails.                             */
  /* ---------------------------------------------------------------- */
  #define startThread(entry, parm, tid) \
     (pthread_create((tid), NULL, (entry), (parm))==0 ? tid : NULL)

  /* ---------------------------------------------------------------- */
  /* endThread:                                                       */
  /*                                                                  */
  /* void endThread(ThreadHandle)                                     */
  /*                                                                  */
  /* The thread is ended, storage reclaimed, and (if a return value   */
  /* is supported) then ThreadNULL is returned                        */
  /* ---------------------------------------------------------------- */
  #define endThread(handle) \
     pthread_exit((handle)==NULL ? ThreadNULL : ThreadNULL)
     // handle is not needed, but referenced for compiler

  /* ---------------------------------------------------------------- */
  /* getThread: get current Thread ID                                 */
  /*                                                                  */
  /* ThreadID getThread(void)                                         */
  /*                                                                  */
  /* returns current Thread's ID                                      */
  /* ---------------------------------------------------------------- */
  #define getThread() pthread_self()

  /* ---------------------------------------------------------------- */
  /* sameThread: compare Thread IDs                                   */
  /*                                                                  */
  /* int sameThread(ThreadID, ThreadID)                               */
  /*                                                                  */
  /* returns 1 if thread IDs compare equal, 0 otherwise               */
  /* ---------------------------------------------------------------- */
  #define sameThread(tid1, tid2) pthread_equal(tid1, tid2)

  /* ---------------------------------------------------------------- */
  /* initMutex:    initialize Mutex object                            */
  /* lockMutex:    wait for Mutex object (must init first)            */
  /* unlockMutex:  release Mutex object  (must lock first)            */
  /* trylockMutex: try to lock Mutex     (must init first)            */
  /* deleteMutex:  recover resources     (must init first)            */
  /*                                                                  */
  /*   int initMutex(Mutex *)                                         */
  /*   int lockMutex(Mutex *)                                         */
  /*   int unlockMutex(Mutex *)                                       */
  /*   int trylockMutex(Mutex *)                                      */
  /*   int deleteMutex(Mutex *)                                       */
  /*                                                                  */
  /* All return 0 if OK, non-zero if error                            */
  /* For trylock, OK means lock was acquired                          */
  /* ---------------------------------------------------------------- */
  #define initMutex(mut)    (pthread_mutex_init(mut, NULL))
  #define lockMutex(mut)    (pthread_mutex_lock(mut))
  #define unlockMutex(mut)  (pthread_mutex_unlock(mut))
  #define trylockMutex(mut) (pthread_mutex_trylock(mut))
  #define deleteMutex(mut)  (pthread_mutex_destroy(mut))
