/* ------------------------------------------------------------------ */
/* GOSERVE -- Web and Gopher server                                   */
/* GosWin.h -- Windows-only includes                                  */
/* ------------------------------------------------------------------ */
/* Copyright (c) IBM Corporation, 2004, 2008                          */
/* Author: Mike Cowlishaw                                             */
/* ------------------------------------------------------------------ */


  /* Operating-system-specific names */
  #define DELIMCHR   '\\'
  #define DELIMSTR   "\\"
  #if GUI
    #define LOGFILE "c:\\goserveg.log"
  #else
    #define LOGFILE "c:\\goservec.log"
  #endif

  /* Includes */
  #include <windows.h>
  #include <process.h>
  #include <wincon.h>
  #include <io.h>
  #include <winsock.h>
  #include <sys/timeb.h>

  #define  INCL_REXXSAA
  #include "rexx.h"

  #if GUI
    #include <richedit.h>
    extern char * winMsgStr(int, char *); // Windows message as string
    /* Window & Dialog procedures */
    extern LRESULT CALLBACK ggpaint(HWND, UINT, WPARAM, LPARAM);
    extern LRESULT CALLBACK ggclient(HWND, UINT, WPARAM, LPARAM);
  #endif

  /* The next line ensures C interfaces, even with C++ functions */
  #define extern EXTERN_C

  /* ---------------------------------------------------------------- */
  /* Timing functions, etc.                                           */
  /* ---------------------------------------------------------------- */
//#if MS
    // Cygwin and Linux have these native
    struct timespec {
      time_t tv_sec;     /* seconds */
      long   tv_nsec;    /* nanoseconds */
      };
    #define CLOCK_REALTIME 1
    extern int clock_gettime(int, struct timespec *);
//#endif


  /* Sleep for n seconds */
  #define sleepSecs(n) Sleep((n)*1000)

  /* ---------------------------------------------------------------- */
  /* TCP/IP modifications                                             */
  /* ---------------------------------------------------------------- */
  #define socklen_t      int
  #define sock_errno()   WSAGetLastError()
  #define SHUT_RD        0
  #define SHUT_WR        1
  #define EADDRINUSE     WSAEADDRINUSE
  #define EADDRNOTAVAIL  WSAEADDRNOTAVAIL
  #define ENOBUFS        WSAENOBUFS
  #define EINVAL         WSAEINVAL
  #define EWOULDBLOCK    WSAEWOULDBLOCK
  #define EPIPE          WSAEPIPE
  #define EHOSTUNREACH   WSAEHOSTUNREACH
  #define ECONNRESET     WSAECONNRESET
  #define ECONNREFUSED   WSAECONNREFUSED
  #define ECONNABORTED   WSAECONNABORTED
  #define EHOSTDOWN      WSAEHOSTDOWN
  #define ENETDOWN       WSAENETDOWN
  #define EACCES         WSAEACCES

  /* ---------------------------------------------------------------- */
  /* Process macros & definitions                                     */
  /* ---------------------------------------------------------------- */
  typedef PID            ProcessID;
  #define getpid()       GetCurrentProcessId()

  /* ---------------------------------------------------------------- */
  /* Threading macros & definitions                                   */
  /* ---------------------------------------------------------------- */

  #define ThreadID       DWORD          // TID
  #define ThreadHandle   HANDLE         // thread Handle
  #define ThreadRet      DWORD WINAPI   // thread return type
  #define ThreadNULL     0              // thread null return

  /* ---------------------------------------------------------------- */
  /* startThread:                                                     */
  /*                                                                  */
  /*   ThreadHandle startThread(entrypoint,     -- function name      */
  /*                            void *,         -- start-up parameter */
  /*                            ThreadID *)     -- gets ID            */
  /*                                                                  */
  /* where entrypoint is: ThreadRet thread(void *rptr)                */
  /* and returns NULL if the start fails.                             */
  /* ---------------------------------------------------------------- */
  // Windows underlying call:
  //
  // hThreadr=CreateThread(NULL,   // security attributes
  //                       0,      // stack size (0=up to 1MB)
  //                       gosrun, // ThreadProc DWORD x(void *)
  //                       NULL,   // void * parameter to thread
  //                       0,      // flags (0=run immediately)
  //                       &tidr); // gets thread ID (DWORD *)
  // if (hThreadr==NULL) alert("Unable to start Run thread");

  #define startThread(entry, parm, tid) \
     CreateThread(NULL, 0, (entry), (parm), 0, (tid))

  /* ---------------------------------------------------------------- */
  /* endThread:                                                       */
  /*                                                                  */
  /*   void endThread(ThreadHandle)                                   */
  /*                                                                  */
  /* The thread is ended, storage reclaimed, and (if a return value   */
  /* is supported) then ThreadNULL is returned                        */
  /* ---------------------------------------------------------------- */
  // in Windows, Thread storage is not released until handle is closed

  #define endThread(handle) \
     (ExitThread(ThreadNULL), CloseHandle(handle))

  /* ---------------------------------------------------------------- */
  /* getThread: get current Thread ID                                 */
  /*                                                                  */
  /*   ThreadID getThread(void)                                       */
  /*                                                                  */
  /* returns current Thread's ID                                      */
  /* ---------------------------------------------------------------- */
  #define getThread() GetCurrentThreadId()

  /* ---------------------------------------------------------------- */
  /* sameThread: compare Thread IDs                                   */
  /*                                                                  */
  /*   int sameThread(ThreadID, ThreadID)                             */
  /*                                                                  */
  /* returns 1 if thread IDs compare equal, 0 otherwise               */
  /* ---------------------------------------------------------------- */
  #define sameThread(tid1, tid2) ((tid1)==(tid2))

  /* ---------------------------------------------------------------- */
  /* initMutex:    initialize Mutex object                            */
  /* lockMutex:    wait for Mutex object (must init first)            */
  /* unlockMutex:  release Mutex object  (must lock first)            */
  /* trylockMutex: try to lock Mutex     (must init first)            */
  /* deleteMutex:  recover resources     (must init first)            */
  /*                                                                  */
  /*   int initMutex(Mutex *)                                         */
  /*   int lockMutex(Mutex *)                                         */
  /*   int unlockMutex(Mutex *)                                       */
  /*   int trylockMutex(Mutex *)                                      */
  /*   int deleteMutex(Mutex *)                                       */
  /*                                                                  */
  /* All return 0 if OK, non-zero if error                            */
  /* For trylock, OK means lock was acquired                          */
  /* ---------------------------------------------------------------- */
  #define Mutex CRITICAL_SECTION        // Mutex object
  #define initMutex(mut) (InitializeCriticalSection(mut), 0)
  #define lockMutex(mut) (EnterCriticalSection(mut), 0)
  #define unlockMutex(mut) (LeaveCriticalSection(mut), 0)
  #define trylockMutex(mut) (!(TryEnterCriticalSection(mut)))
  #define deleteMutex(mut) (DeleteCriticalSection(mut))

