# ------------------------ Apache Version 2.0 license -------------------------
#    Copyright (C) 2001-2006 Rony G. Flatscher
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.
# -----------------------------------------------------------------------------

#-------------------------------------------------------------------------
# linux_bsf4rexx_regina.mak: makefile to build libBSF4Rexx.so
#
# ooRexx, R E G I N A, 2005-06-07
#
# make -f lin_bsf4rexx [orexx | regina | clean | clean_dll | rebuild ]
#-------------------------------------------------------------------------

# -----------------------  Path Definitions  ----------------------------
BLD_PATH = .

# JDK_BASE = /usr/java/j2sdk1.4.2_08
JDK_BASE = /home/rony/dev/jdk1.6.0_06 

INC_PATH = -I. -I/usr/local/include -I$(JDK_BASE)/include -I$(JDK_BASE)/include/linux -I/usr/include -I../source_java/apache-rexxla

INC_PATH_ORX = -I/opt/orexx $(INC_PATH)

LIB_PATH = -L. -L/usr/local/lib -L/usr/lib -L/usr/local/lib/ooRexx


# --------------------------------------------------------
del_cmd  = rm -f
# copy_cmd = cp -p
copy_cmd = cp

ORX     = OREXX
REG     = REGINA
RXT     = REXXTRANS

BSF_SRC		= BSF4Rexx.cc


#
# Compiler macros
#
# cc = g++ -fPIC
cc = gcc -fPIC
link = gcc

#
# CFLAGS_ori     = -c -ggdb -D__cplusplus
CFLAGS		= -c -O3 -D__cplusplus -DUNIX
CFLAGS_ORX      = -DUSE_$(ORX)
CFLAGS_REG      = -DUSE_$(REG)
CFLAGS_RXT      = -DUSE_$(RXT)


# link_lib_flags_lib_bsf4rexx_ori = -shared -rdynamic -lpthreads -lrexxapi -lc  -lm
# 2003-04-05, ---rgf, added "-ljvm"
# LINK_FLAGS      = -shared -rdynamic -lpthread -ljvm -lc  -lm
# LINK_FLAGS      = -shared -rdynamic -lpthread /usr/java/j2sdk1.4.1_02/jre/lib/i386/client/libjvm.so -lc  -lm
# LINK_FLAGS      = -shared -rdynamic -lpthread $(JDK_BASE)/jre/lib/i386/client/libjvm.so -lc  -lm
LINK_FLAGS      = -shared -rdynamic -lpthread -lc  -lm

LINK_ORX_FLAGS  = -lrexx -lrexxapi -lrexxutil
# LINK_REG_FLAGS  = -lregina_ts -lcrypt
LINK_REG_FLAGS  = -lregina -lcrypt
LINK_RXT_FLAGS  = -lrexxtrans


BSF_OBJ_ORX     = $(BLD_PATH)/BSF4Rexx_$(ORX).o
BSF_OBJ_REG     = $(BLD_PATH)/BSF4Rexx_$(REG).o
BSF_OBJ_RXT     = $(BLD_PATH)/BSF4Rexx_$(RXT).o


BSF_ORX_TARGET  = $(BLD_PATH)/libBSF4Rexx_$(ORX).so
BSF_REG_TARGET  = $(BLD_PATH)/libBSF4Rexx_$(REG).so
BSF_RXT_TARGET  = $(BLD_PATH)/libBSF4Rexx_$(RXT).so

BSF4REXX	= $(BLD_PATH)/libBSF4Rexx.so

# *************************************************************************** #
# Rules									      #
# *************************************************************************** #
# .cc.o:
#	  $(cc) $(CFLAGS) -o$*.o $(INC_PATH) $(LIB_PATH) $*.cc

#---------------------------------------------------------- Generate library

# Object Rexx ----------------------------------------------
$(BSF_ORX_TARGET) : $(BSF_SRC)
	echo
	echo Building $@ ...
	echo
	$(cc) $(CFLAGS) $(CFLAGS_ORX) -o$(BSF_OBJ_ORX) $(INC_PATH) $(INC_PATH_ORX) $(LIB_PATH) $(BSF_SRC)
	$(link) -Wl,-soname,$@ -o $(BLD_PATH)/$@ $(BSF_OBJ_ORX) \
	$(LIB_PATH) $(LINK_FLAGS) $(LINK_ORX_FLAGS)
	$(copy_cmd) $(BSF_ORX_TARGET) $(BSF4REXX)


# Regina ---------------------------------------------------
$(BSF_REG_TARGET) : $(BSF_SRC)
	echo
	echo Building $@ ...
	echo
	$(cc) $(CFLAGS) $(CFLAGS_REG) -o$(BSF_OBJ_REG) $(INC_PATH) $(INC_PATH_REG) $(LIB_PATH) $(BSF_SRC)
	$(link) -Wl,-soname,$@ -o $(BLD_PATH)/$@ $(BSF_OBJ_REG) \
	$(LIB_PATH) $(LINK_FLAGS) $(LINK_REG_FLAGS)
	$(copy_cmd) $(BSF_REG_TARGET) $(BSF4REXX)

# RexxTrans ---------------------------------------------------
$(BSF_RXT_TARGET) : $(BSF_SRC)
	echo
	echo Building $@ ...
	echo
	$(cc) $(CFLAGS) $(CFLAGS_RXT) -o$(BSF_OBJ_RXT) $(INC_PATH) $(INC_PATH_RXT) $(LIB_PATH) $(BSF_SRC)
	$(link) -Wl,-soname,$@ -o $(BLD_PATH)/$@ $(BSF_OBJ_RXT) \
	$(LIB_PATH) $(LINK_FLAGS) $(LINK_RXT_FLAGS)
	$(copy_cmd) $(BSF_RXT_TARGET) $(BSF4REXX)


#---------------------------------------------------------- END section
orexx :		$(BSF_ORX_TARGET)

#---------------------------------------------------------- END section
regina :	$(BSF_REG_TARGET)

#---------------------------------------------------------- END section
rexxtrans :	$(BSF_RXT_TARGET)



# -------------------------------------------------------------------
# builds all
rebuild: clean clean_dll orexx regina rexxtrans

#---------------------------------------------------------- END section
# just clean up the mess, just leave the dll
clean:
	- $(del_cmd) $(BLD_PATH)/*.o

#---------------------------------------------------------- END section
clean_dll:
	- $(del_cmd) $(BLD_PATH)/*.so


# -------------------------------------------------------------------
# builds all
all: clean orexx regina rexxtrans

# -------------------------------------------------------------------
i:
	$(cc) $(CFLAGS) $(CFLAGS_ORX) -oBSF4Rexx.i $(INC_PATH) $(INC_PATH_ORX) -E $(LIB_PATH) $(BSF_SRC)

