# ------------------------ Apache Version 2.0 license -------------------------
#    Copyright (C) 2001-2006 Rony G. Flatscher
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.
# -----------------------------------------------------------------------------

#-------------------------------------------------------------------------
# win_bsf4rexx.mak: makefile to build the Windows versions of bsf4rexx with MS's VCPP
#
# 2001-06-02, 2003-01/02, 2005-05-07, 2005-06-01, 2005-06-02 ---rgf
#
# nmake /f win_bsf4rexx.mak [orexx | regina | rexxtrans | rebuild | clean | clean_dll ]
#
#   creates "BSF4Rexx.dll" either for Object Rexx ("orexx"), Regina or RexxTrans
#-------------------------------------------------------------------------

# -----------------------  Path Definitions  ----------------------------
# adjust to your system
BLD_PATH	= .

# ORX_PATH	= d:\programme\objrexx\api
ORX_PATH	= d:\programme\oorexx\api
REG_PATH	= .\regina
TRANS_PATH      = .\rexxtrans

# JDK_PATH	= E:\jdk1.1.8
# JDK_PATH	= e:\jdk1.2.2
# JDK_PATH	= e:\jdk1.3.1_06
# JDK_PATH	= e:\j2sdk1.4.2_06
JDK_PATH	= e:\jdk1.4.2_12


# the following is for Java 1.1 (e.g. 1.1.8 for OS/2)
# JDK_LIB		= $(JDK_PATH)\lib\javai.lib
# the following is for Java 1.2 or higher
# JDK_LIB		= $(JDK_PATH)\lib\jvm.lib


# need access to either one "org_rexxla_bsf_engines_rexx_RexxAndJava.h", created from "RexxAndJava.java" with "javah"
INC_BSF4REXX_JAVA = /I..\source_java\apache-rexxla  /I..\source_java\ibm-rexxla

# also use JDK include path for "win32"
INC_PATH	=  /I. /I$(JDK_PATH)\include /I$(JDK_PATH)\include\win32 $(INC_BSF4REXX_JAVA)


# DEBUG           = -D DEBUG
# DEBUG           = -D DEBUG1
# DEBUG           = -D DEBUG2
# DEBUG           = -D DEBUG3
# DEBUG           = -D DEBUG_THREADS


# -------------------------------------------------------------------------
# Compiler macros
#
BASE_NAME       = BSF4Rexx
BSF_DEF		= $(BASE_NAME).def
BSF_SRC		= $(BASE_NAME).cc

BSF_BIN_DIR     = ..\bin

orx		= OREXX
reg		= REGINA
trans		= REXXTRANS

BSF_ORX_OBJ     = $(BASE_NAME)_$(orx).obj
BSF_REG_OBJ     = $(BASE_NAME)_$(reg).obj
BSF_TRANS_OBJ   = $(BASE_NAME)_$(trans).obj

BSF_ORX_LST     = $(BASE_NAME)_$(orx).lst
BSF_REG_LST     = $(BASE_NAME)_$(reg).lst
BSF_TRANS_LST   = $(BASE_NAME)_$(trans).lst

BSF_ORX_LIB     = $(BASE_NAME)_$(orx).lib
BSF_REG_LIB     = $(BASE_NAME)_$(reg).lib
BSF_TRANS_LIB   = $(BASE_NAME)_$(trans).lib

BSF_ORX_EXP     = $(BASE_NAME)_$(orx).exp
BSF_REG_EXP     = $(BASE_NAME)_$(reg).exp
BSF_TRANS_EXP   = $(BASE_NAME)_$(trans).exp

BSF_ORX_TARGET  = $(BASE_NAME)_$(orx).dll
BSF_REG_TARGET  = $(BASE_NAME)_$(reg).dll
BSF_TRANS_TARGET= $(BASE_NAME)_$(trans).dll

DEF_ORX		= -DUSE_$(orx)   $(DEBUG)
DEF_REG		= -DUSE_$(reg)   $(DEBUG)
DEF_TRANS       = -DUSE_$(trans) $(DEBUG)

ORX_LIB		= rexx.lib rexxapi.lib
REG_LIB		= regina.lib
TRANS_LIB       = rexxtrans.lib

BSF_DLL_NAME    = $(BASE_NAME).dll

OP_SYS          = -DWINDOWS


# compiler: Microsoft's Visual C++
cc		= cl

del_cmd		= del
copy_cmd	= copy

# flags for compilation
CFLAGS		= /Ot /GD /DLL /LD /FAcs /Tp$(BSF_SRC) $(INC_PATH) $(OP_SYS)
CC_ORX		= /Fo$(BSF_ORX_OBJ)   /I$(ORX_PATH)   $(DEF_ORX)
CC_REG		= /Fo$(BSF_REG_OBJ)   /I$(REG_PATH)   $(DEF_REG)
CC_TRANS	= /Fo$(BSF_TRANS_OBJ) /I$(TRANS_PATH) $(DEF_TRANS)

# flags for linking
LINK_FLAGS      = /link /mapinfo:exports /DEF:$(BSF_DEF)
LINK_ORX	= /LIBPATH:$(ORX_PATH)   $(ORX_LIB)   $(JDK_LIB) /OUT:$(BSF_ORX_TARGET)
LINK_REG	= /LIBPATH:$(REG_PATH)   $(REG_LIB)   $(JDK_LIB) /OUT:$(BSF_REG_TARGET)
LINK_TRANS      = /LIBPATH:$(TRANS_PATH) $(TRANS_LIB) $(JDK_LIB) /OUT:$(BSF_TRANS_TARGET)


# *************************************************************************** #
# Rules									      #
# *************************************************************************** #
#.cc.o:
# $(BSF_OBJ) :
#       $(cc) $(CFLAGS) /Fo$(BSF_OBJ) $(INC_PATH) /Tp$*.cc
#---------------------------------------------------------- Generate library

# compile and link for Object Rexx
$(BSF_ORX_TARGET) : $(BSF_SRC)
       @echo target: $@
       @echo $(CFLAGS) $(CC_ORX) /Fa$(BSF_ORX_LST) $(LINK_FLAGS) $(LINK_ORX)
       @echo .
       $(cc) $(CFLAGS) $(CC_ORX) /Fa$(BSF_ORX_LST) $(LINK_FLAGS) $(LINK_ORX)
       $(copy_cmd) $(BSF_ORX_TARGET) $(BSF_DLL_NAME)
       $(copy_cmd) $(BSF_DLL_NAME) $(BSF_BIN_DIR)

# compile and link for Regina
$(BSF_REG_TARGET) : $(BSF_SRC)
       @echo target: $@
       @echo $(CFLAGS) $(CC_REG) /Fa$(BSF_REG_LST) $(LINK_FLAGS) $(LINK_REG)
       @echo .
       $(cc) $(CFLAGS) $(CC_REG) /Fa$(BSF_REG_LST) $(LINK_FLAGS) $(LINK_REG)
       $(copy_cmd) $(BSF_REG_TARGET) $(BSF_DLL_NAME)
       $(copy_cmd) $(BSF_DLL_NAME) $(BSF_BIN_DIR)

# compile and link for RexxTrans (runs the installed Rexx interpreter,
$(BSF_TRANS_TARGET) : $(BSF_SRC)
       @echo target: $@
       @echo $(CFLAGS) $(CC_TRANS) /Fa$(BSF_TRANS_LST) $(LINK_FLAGS) $(LINK_TRANS)
       @echo .
       $(cc) $(CFLAGS) $(CC_TRANS) /Fa$(BSF_TRANS_LST) $(LINK_FLAGS) $(LINK_TRANS)
       $(copy_cmd) $(BSF_TRANS_TARGET) $(BSF_DLL_NAME)
       $(copy_cmd) $(BSF_DLL_NAME) $(BSF_BIN_DIR)


#----------------------------------------------------------
regina :	$(BSF_REG_TARGET)

#----------------------------------------------------------
orexx :		$(BSF_ORX_TARGET)

#----------------------------------------------------------
rexxtrans :     $(BSF_TRANS_TARGET)

#----------------------------------------------------------
# builds all
rebuild :       clean clean_dll regina rexxtrans orexx

#----------------------------------------------------------
# just clean up the mess, just leave the dll
clean:
	- $(del_cmd) $(BLD_PATH)\*.exp
	- $(del_cmd) $(BLD_PATH)\*.lib
	- $(del_cmd) $(BLD_PATH)\*.lst
	- $(del_cmd) $(BLD_PATH)\*.map
	- $(del_cmd) $(BLD_PATH)\*.obj

clean_dll:
	- $(del_cmd) $(BLD_PATH)\*.dll

#----------------------------------------------------------
# builds all
all :       clean regina rexxtrans orexx


