package org.rexxla.bsf.engines.rexx;   // belongs to that fine package ...

import com.ibm.bsf.*;   // BSF support
import java.io.*;       // exception handling


/** Java class to allow Rexx to invoke <code>BSF4Rexx</code> via JNI, after the JVM was created.
 *  <p>
 *  <code>&quot;BSF4Rexx.BsfLoadJava()&quot;</code> will create a JVM, load this class and
 *  then invoke the static method {@link #createInterface4Rexx()}. This method creates an instance
 *  of {@link BSFManager} and uses it to load an instance of the Rexx engine, which allows
 *  to initialize the <code>&quot;BSF4Rexx&quot;</code> link library.
 *
 *  <p>
 *  To make sure that
 *  upon return from the static method {@link #createInterface4Rexx()} the reference
 *  to the Rexx engine object received via {@link RexxEngine#getRexxInterface()
 *  RexxEngine.getRexxInterface()}, a
 *  global reference is created via JNI while executing the method
 *  {@link RexxAndJava#jniInitialize4Rexx() RexxAndJava.jniInitialize4Rexx()}, which
 *  calls into the BSF4Rexx-DLL.
 *
 *
 * <pre>------------------------ Apache Version 2.0 license -------------------------
 *    Copyright (C) 2001-2006 Rony G. Flatscher
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        <a href="http://www.apache.org/licenses/LICENSE-2.0">http://www.apache.org/licenses/LICENSE-2.0</a>
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * ----------------------------------------------------------------------------- </pre>
 *
 *
 * @author Rony G. Flatscher (<a href="http://www.wu-wien.ac.at">WU-Wien/Wirtschaftsuniversit&auml;t Wien</a>, <a href="http://www.wu-wien.ac.at/english">http://www.wu-wien.ac.at/english</a>)
  * @version 2.5, 2006-01-01
 */
class Java4Rexx {
    /** Version string indicating version of this class (majorVersion*100+minorVersion
     *  concatenated with a dot and the sorted date of last change.
     */
    static public String version = "205.20060101";


  /**  BSF-manager to be used to get (instantiate) the Rexx engine. */
  static private BSFManager bsfMgr=null;

  /** The Rexx engine loaded via {@link #bsfMgr}. */
  static private BSFEngine  rxEngine=null;

  /** This method allows Rexx to load Java, then initialize
   *  the BSF4Rexx infrastructure from the Java side, and
   *  thereafter use all of the infrastructure from Rexx.
   *
   * <p> Hint: JNI is able to get to private/protected members of a class! This way this method
   * can <em>only</em> be invoked by JNI.
   *
    */
  private static void createInterface4Rexx() throws IOException {

    try {
        bsfMgr  = new BSFManager ();   // create and initialize a BSFManager
        // this will load BSF4Rexx.dll from the Java side and initialize
        rxEngine = bsfMgr.loadScriptingEngine("rexx");   // now the Rexx Engine and its supporting class is available
    }
    catch (BSFException e)
    {
      e.printStackTrace();
    }

        // now call into the DLL ("BSF4Rexx.dll") in order to initialize
    ((RexxEngine) rxEngine).getRexxInterface().jniInitialize4Rexx();
  }
}

