import java.io.*;
import java.net.*;
import java.util.*;
class GetHostInfo
{
    public static void main (String args[])
    {
        InetAddress ia=null;
        if (args.length==0) // give localhost-infos
        {       // attempt to get InetAddress object of localhost
            try { ia=InetAddress.getLocalHost(); }
            catch (UnknownHostException uhe)
            {
                System.err.println("No localhost defined for your computer!");
                System.exit(-1);
            }
        }
        else
        {       // attempt to get InetAddress object by hostname
            try { ia=InetAddress.getByName(args[0]); }
            catch (UnknownHostException uhe)
            {
                try     // attempt to get InetAddress object by IP address
                {
                    StringTokenizer st = new StringTokenizer(args[0], ".");
                    byte ab[] = new byte [st.countTokens()];    // create appropriate byte array
                    for (int i=0; st.hasMoreTokens();i++)       // loop over tokens
                        ab[i]=Byte.parseByte(st.nextToken());   // get value and create byte of it

                    ia=InetAddress.getByAddress(ab);
                }
                catch (UnknownHostException uhe2)
                {
                    System.err.println("["+args[0]+"]: not a valid hostname nor IP-address!");
                    System.exit(-1);
                }
            }
        }
        System.out.println("         HostName: ["+ia.getHostName()+"]\n"+
                           "       IP address: ["+ia.getHostAddress()+"]\n\n"+
                           "canonicalHostName: ["+ia.getCanonicalHostName()+"]\n"+
                           "       toString(): ["+ia+"]");
    }
}
