/*
 * Decompiled with CFR 0.152.
 */
package org.ooRexxTryFX;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.impl.source.tree.FileElement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.concurrent.Task;
import javafx.util.Pair;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.oorexx.ide.standalone.OoRexxStandaloneParser;

public class Highlighter {
    private CodeArea codeArea;
    private ExecutorService executor;
    private static List instructionLengthMap = new ArrayList();

    public Highlighter(CodeArea codeArea) {
        this.codeArea = codeArea;
        this.executor = Executors.newSingleThreadExecutor();
        codeArea.plainTextChanges().filter(ch -> !((String)ch.getInserted()).equals(ch.getRemoved())).successionEnds(Duration.ofMillis(500L)).supplyTask(this::computeHighlightingAsync).awaitLatest(codeArea.plainTextChanges()).filterMap(t -> {
            if (t.isSuccess()) {
                return Optional.of(t.get());
            }
            t.getFailure().printStackTrace();
            return Optional.empty();
        }).subscribe(this::applyHighlighting);
    }

    private void applyHighlighting(StyleSpans<Collection<String>> highlighting) {
        this.codeArea.setStyleSpans(0, highlighting);
    }

    private Task<StyleSpans<Collection<String>>> computeHighlightingAsync() {
        final String text = this.codeArea.getText();
        Task<StyleSpans<Collection<String>>> task = new Task<StyleSpans<Collection<String>>>(){

            protected StyleSpans<Collection<String>> call() throws Exception {
                return Highlighter.this.computeHighlighting(text);
            }
        };
        this.executor.execute((Runnable)task);
        return task;
    }

    public StyleSpans<Collection<String>> computeHighlighting(String code) {
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        instructionLengthMap.clear();
        FileElement node = (FileElement)OoRexxStandaloneParser.parse((String)code);
        LighterAST tree = node.getLighterAST();
        Highlighter.walkTheAST(tree, tree.getRoot());
        for (Object map : instructionLengthMap) {
            Pair pair = (Pair)map;
            String type = Highlighter.parseType((String)pair.getKey());
            type = type.toLowerCase();
            int length = (Integer)pair.getValue();
            spansBuilder.add(Collections.singleton(type), length);
        }
        return spansBuilder.create();
    }

    private static void walkTheAST(LighterAST tree, LighterASTNode root) {
        Highlighter.walkTheAST(tree, root, 0);
    }

    private static void walkTheAST(LighterAST tree, LighterASTNode root, Integer level) {
        List children = tree.getChildren(root);
        for (LighterASTNode child : children) {
            List grandchildren = tree.getChildren(child);
            String type = child.getTokenType().toString();
            int start = child.getStartOffset();
            int end = child.getEndOffset();
            int length = end - start;
            if (grandchildren.size() > 0) {
                Highlighter.walkTheAST(tree, child, level + 1);
                continue;
            }
            if (length <= 0) continue;
            instructionLengthMap.add(new Pair((Object)type, (Object)length));
        }
    }

    private static String parseType(String type) {
        switch (type) {
            case ":": {
                return "directive";
            }
            case ".false": {
                return "false";
            }
            case ".true": {
                return "true";
            }
            case ".nil": {
                return "nil";
            }
            case "<": 
            case ">": 
            case "=": 
            case "\\": 
            case "\u00ac": 
            case "&": 
            case "|": {
                return "comparison";
            }
            case "-": 
            case "+": 
            case "/": 
            case "*": 
            case "%": {
                return "arithmetic";
            }
            case "~": {
                return "message";
            }
        }
        return type;
    }
}

