/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.jython;

import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.InteractiveInterpreter;

public class JythonEngine
extends BSFEngineImpl {
    BSFPythonInterpreter interp;
    private static final Pattern fromRegExp = Pattern.compile("from ([.^\\S]*)");

    @Override
    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        try {
            PyObject[] pyObjectArray = Py.EmptyObjects;
            if (objectArray != null) {
                pyObjectArray = new PyObject[objectArray.length];
                for (int i = 0; i < pyObjectArray.length; ++i) {
                    pyObjectArray[i] = Py.java2py((Object)objectArray[i]);
                }
            }
            if (object != null) {
                PyObject pyObject = Py.java2py((Object)object);
                return this.unwrap(pyObject.invoke(string, pyObjectArray));
            }
            PyObject pyObject = this.interp.get(string);
            if (pyObject == null) {
                pyObject = this.interp.eval(string);
            }
            if (pyObject != null) {
                return this.unwrap(pyObject.__call__(pyObjectArray));
            }
            return null;
        }
        catch (PyException pyException) {
            throw new BSFException(100, "exception from Jython:\n" + (Object)((Object)pyException), pyException);
        }
    }

    @Override
    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        this.interp.set(bSFDeclaredBean.name, bSFDeclaredBean.bean);
    }

    @Override
    public Object apply(String string, int n, int n2, Object object, Vector vector, Vector vector2) throws BSFException {
        try {
            StringBuffer stringBuffer = new StringBuffer(this.byteify(object.toString()));
            stringBuffer.insert(0, "def bsf_temp_fn():\n");
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != '\n') continue;
                stringBuffer.insert(i + 1, '\t');
            }
            String string2 = stringBuffer.toString();
            this.importPackage(string2);
            this.interp.exec(string2);
            Object object2 = this.interp.eval("bsf_temp_fn()");
            if (object2 != null && object2 instanceof PyJavaInstance) {
                object2 = ((PyJavaInstance)object2).__tojava__(Object.class);
            }
            return object2;
        }
        catch (PyException pyException) {
            throw new BSFException(100, "exception from Jython:\n" + (Object)((Object)pyException), pyException);
        }
    }

    @Override
    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        try {
            String string2 = this.byteify(object.toString());
            this.importPackage(string2);
            Object object2 = this.interp.eval(string2);
            if (object2 != null && object2 instanceof PyJavaInstance) {
                object2 = ((PyJavaInstance)object2).__tojava__(Object.class);
            }
            return object2;
        }
        catch (PyException pyException) {
            throw new BSFException(100, "exception from Jython:\n" + (Object)((Object)pyException), pyException);
        }
    }

    @Override
    public void exec(String string, int n, int n2, Object object) throws BSFException {
        try {
            String string2 = this.byteify(object.toString());
            this.importPackage(string2);
            this.interp.exec(string2);
        }
        catch (PyException pyException) {
            throw new BSFException(100, "exception from Jython:\n" + (Object)((Object)pyException), pyException);
        }
    }

    private void importPackage(String string) {
        Matcher matcher = fromRegExp.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            PySystemState.add_package((String)string2);
        }
    }

    @Override
    public void iexec(String string, int n, int n2, Object object) throws BSFException {
        String string2 = this.byteify(object.toString());
        this.importPackage(string2);
        int n3 = string2.indexOf("\n");
        if (n3 > -1) {
            string2 = string2.substring(0, n3);
        }
        try {
            if (this.interp.buffer.length() > 0) {
                this.interp.buffer.append("\n");
            }
            this.interp.buffer.append(string2);
            if (!this.interp.runsource(this.interp.buffer.toString())) {
                this.interp.resetbuffer();
            }
        }
        catch (PyException pyException) {
            this.interp.resetbuffer();
            throw new BSFException(100, "exception from Jython:\n" + (Object)((Object)pyException), pyException);
        }
    }

    @Override
    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        this.interp = new BSFPythonInterpreter();
        this.interp.setOut(System.out);
        this.interp.setErr(System.err);
        this.interp.set("bsf", new BSFFunctions(bSFManager, this));
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.declareBean((BSFDeclaredBean)vector.elementAt(i));
        }
    }

    @Override
    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        this.interp.set(bSFDeclaredBean.name, null);
    }

    public Object unwrap(PyObject pyObject) {
        Object object;
        if (pyObject != null && (object = pyObject.__tojava__(Object.class)) != Py.NoConversion) {
            return object;
        }
        return pyObject;
    }

    private String byteify(String string) {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = byteArrayInputStream.read()) >= 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (string.equals("classLoader")) {
            Py.getSystemState().setClassLoader((ClassLoader)object);
        }
    }

    private class BSFPythonInterpreter
    extends InteractiveInterpreter {
        public void runcode(PyObject pyObject) {
            this.exec(pyObject);
        }
    }
}

