/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.test;

import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.bsf.BSFManager;
import org.apache.bsf.test.BSFEngineTestTmpl;
import org.apache.bsf.test.engineTests.jaclTest;
import org.apache.bsf.test.engineTests.javascriptTest;
import org.apache.bsf.test.engineTests.jythonTest;
import org.apache.bsf.test.engineTests.netrexxTest;
import org.apache.bsf.test.fakeEngine;
import org.apache.bsf.test.utilTests.EngineUtilsTest;
import org.apache.bsf.test.utilTests.IOUtilsTest;
import org.apache.bsf.test.utilTests.StringUtilsTest;

public class BSFTest
extends BSFEngineTestTmpl {
    public static String[] testNames;

    public BSFTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner testRunner = new TestRunner();
        TestSuite testSuite = (TestSuite)BSFTest.suite();
        for (int i = 0; i < testSuite.testCount(); ++i) {
            System.out.print(testNames[i]);
            TestResult testResult = testRunner.doRun(testSuite.testAt(i), false);
            System.out.println("Results: " + testResult.runCount() + " tests run, " + testResult.failureCount() + " failures, " + testResult.errorCount() + " errors.");
            System.out.print("\n----------------------------------------\n");
        }
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testNames = new String[8];
        testSuite.addTestSuite(BSFTest.class);
        BSFTest.testNames[0] = "BSFManager Base Tests";
        testSuite.addTestSuite(jaclTest.class);
        BSFTest.testNames[1] = "Jacl Engine Tests";
        testSuite.addTestSuite(javascriptTest.class);
        BSFTest.testNames[2] = "Rhino Engine Tests";
        testSuite.addTestSuite(jythonTest.class);
        BSFTest.testNames[3] = "Jython Engine Tests";
        testSuite.addTestSuite(netrexxTest.class);
        BSFTest.testNames[4] = "NetRexx Engine Tests";
        testSuite.addTestSuite(StringUtilsTest.class);
        BSFTest.testNames[5] = "StringUtils Test";
        testSuite.addTestSuite(IOUtilsTest.class);
        BSFTest.testNames[6] = "IOUtils Test";
        testSuite.addTestSuite(EngineUtilsTest.class);
        BSFTest.testNames[7] = "EngineUtils Test";
        return testSuite;
    }

    @Override
    public void setUp() {
        super.setUp();
        BSFManager.registerScriptingEngine("fakeEngine", fakeEngine.class.getName(), new String[]{"fakeEng", "fE"});
    }

    public void testRegisterEngine() {
        BSFTest.assertTrue((boolean)BSFManager.isLanguageRegistered("fakeEngine"));
    }

    public void testGetLangFromFileName() {
        try {
            BSFTest.assertEquals((String)"fakeEngine", (String)BSFManager.getLangFromFilename("Test.fE"));
        }
        catch (Exception exception) {
            BSFTest.fail((String)this.failMessage("getLangFromFilename() test failed", exception));
        }
    }

    public void testExec() {
        try {
            this.bsfManager.exec("fakeEngine", "Test.fE", 0, 0, "Fake syntax");
        }
        catch (Exception exception) {
            BSFTest.fail((String)this.failMessage("exec() test failed", exception));
        }
        BSFTest.assertEquals((String)"PASSED", (String)this.getTmpOutStr());
    }

    public void testEval() {
        Boolean bl = Boolean.FALSE;
        try {
            bl = (Boolean)this.bsfManager.eval("fakeEngine", "Test.fE", 0, 0, "Fake Syntax");
        }
        catch (Exception exception) {
            BSFTest.fail((String)this.failMessage("eval() test failed", exception));
        }
        BSFTest.assertTrue((boolean)bl);
    }

    public void testIexec() {
        try {
            this.bsfManager.iexec("fakeEngine", "Test.fE", 0, 0, "Fake syntax");
        }
        catch (Exception exception) {
            BSFTest.fail((String)this.failMessage("iexec() test failed", exception));
        }
        BSFTest.assertEquals((String)"PASSED", (String)this.getTmpOutStr());
    }

    public void testDeclareBean() {
        try {
            this.bsfManager.declareBean("foo", new Integer(1), Integer.class);
        }
        catch (Exception exception) {
            BSFTest.fail((String)this.failMessage("declareBean() test failed", exception));
        }
        BSFTest.assertEquals((Object)new Integer(1), (Object)((Integer)this.bsfManager.lookupBean("foo")));
    }

    public void testUndeclareBean() {
        try {
            this.bsfManager.declareBean("foo", new Integer(1), Integer.class);
            this.bsfManager.undeclareBean("foo");
        }
        catch (Exception exception) {
            BSFTest.fail((String)this.failMessage("undeclareBean() test failed", exception));
        }
        BSFTest.assertNull((Object)this.bsfManager.lookupBean("foo"));
    }

    public void testTerminate() throws Exception {
        try {
            this.bsfManager.loadScriptingEngine("fakeEngine");
            this.bsfManager.terminate();
        }
        catch (Exception exception) {
            BSFTest.fail((String)this.failMessage("terminate() test failed", exception));
        }
        BSFTest.assertEquals((String)"PASSED", (String)this.getTmpOutStr());
    }
}

