/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.test.engineTests;

import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.test.BSFEngineTestTmpl;

public class jythonTest
extends BSFEngineTestTmpl {
    private BSFEngine jythonEngine;

    public jythonTest(String string) {
        super(string);
    }

    @Override
    public void setUp() {
        super.setUp();
        try {
            this.jythonEngine = this.bsfManager.loadScriptingEngine("jython");
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("Failure attempting to load jython", exception));
        }
    }

    public void testExec() {
        try {
            this.jythonEngine.exec("Test.py", 0, 0, "print \"PASSED\",");
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("exec() test failed", exception));
        }
        jythonTest.assertEquals((String)"PASSED", (String)this.getTmpOutStr());
    }

    public void testEval() {
        Integer n = null;
        try {
            n = new Integer(this.jythonEngine.eval("Test.py", 0, 0, "1 + 1").toString());
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("eval() test failed", exception));
        }
        jythonTest.assertEquals((Object)new Integer(2), (Object)n);
    }

    public void testCall() {
        Object[] objectArray = new Object[]{new Integer(1)};
        Integer n = null;
        try {
            this.jythonEngine.exec("Test.py", 0, 0, "def addOne(f):\n\t return f + 1\n");
            n = new Integer(this.jythonEngine.call(null, "addOne", objectArray).toString());
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("call() test failed", exception));
        }
        jythonTest.assertEquals((Object)new Integer(2), n);
    }

    public void testIexec() {
        try {
            this.jythonEngine.iexec("Test.py", 0, 0, "print \"PASSED\",\nprint \"FAILED\",");
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("iexec() test failed", exception));
        }
        jythonTest.assertEquals((String)"PASSED", (String)this.getTmpOutStr());
    }

    public void testBSFManagerEval() {
        Integer n = null;
        try {
            n = new Integer(this.bsfManager.eval("jython", "Test.py", 0, 0, "1 + 1").toString());
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("BSFManager eval() test failed", exception));
        }
        jythonTest.assertEquals((Object)new Integer(2), (Object)n);
    }

    public void testBSFManagerAvailability() {
        Object object = null;
        try {
            object = this.jythonEngine.eval("Test.py", 0, 0, "bsf.lookupBean(\"foo\")");
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("Test of BSFManager availability failed", exception));
        }
        jythonTest.assertEquals((String)"None", (String)object.toString());
    }

    public void testRegisterBean() {
        Integer n = new Integer(1);
        Integer n2 = null;
        try {
            this.bsfManager.registerBean("foo", n);
            n2 = new Integer(this.jythonEngine.eval("Test.py", 0, 0, "bsf.lookupBean(\"foo\")").toString());
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("registerBean() test failed", exception));
        }
        jythonTest.assertEquals((Object)n, n2);
    }

    public void testUnregisterBean() {
        Integer n = new Integer(1);
        Object object = null;
        try {
            this.bsfManager.registerBean("foo", n);
            this.bsfManager.unregisterBean("foo");
            object = this.jythonEngine.eval("Test.py", 0, 0, "bsf.lookupBean(\"foo\")");
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("unregisterBean() test failed", exception));
        }
        jythonTest.assertEquals((String)"None", (String)object.toString());
    }

    public void testDeclareBean() {
        Integer n = new Integer(1);
        Integer n2 = null;
        try {
            this.bsfManager.declareBean("foo", n, Integer.class);
            n2 = new Integer(this.jythonEngine.eval("Test.py", 0, 0, "foo + 1").toString());
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("declareBean() test failed", exception));
        }
        jythonTest.assertEquals((Object)new Integer(2), n2);
    }

    public void testUndeclareBean() {
        Integer n = new Integer(1);
        Integer n2 = null;
        try {
            this.bsfManager.declareBean("foo", n, Integer.class);
            this.bsfManager.undeclareBean("foo");
            n2 = new Integer(this.jythonEngine.eval("Test.py", 0, 0, "foo + 1").toString());
        }
        catch (BSFException bSFException) {
        }
        catch (Exception exception) {
            jythonTest.fail((String)this.failMessage("undeclareBean() test failed", exception));
        }
        jythonTest.assertNull(n2);
    }
}

