/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.ICookable;
import org.codehaus.commons.nullanalysis.Nullable;

public abstract class Cookable
implements ICookable {
    @Override
    public abstract void cook(@Nullable String var1, Reader var2) throws CompileException, IOException;

    @Override
    public final void cook(Reader reader) throws CompileException, IOException {
        this.cook(null, reader);
    }

    @Override
    public final void cook(InputStream inputStream) throws CompileException, IOException {
        this.cook(null, inputStream);
    }

    @Override
    public final void cook(@Nullable String string, InputStream inputStream) throws CompileException, IOException {
        this.cook(string, inputStream, null);
    }

    @Override
    public final void cook(InputStream inputStream, @Nullable String string) throws CompileException, IOException {
        this.cook(string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string));
    }

    @Override
    public final void cook(@Nullable String string, InputStream inputStream, @Nullable String string2) throws CompileException, IOException {
        this.cook(string, string2 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string2));
    }

    @Override
    public final void cook(String string) throws CompileException {
        this.cook((String)null, string);
    }

    @Override
    public final void cook(@Nullable String string, String string2) throws CompileException {
        try {
            this.cook(string, new StringReader(string2));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("SNO: StringReader throws IOException");
        }
    }

    @Override
    public final void cookFile(File file) throws CompileException, IOException {
        this.cookFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cookFile(File file, @Nullable String string) throws CompileException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.cook(file.getAbsolutePath(), string == null ? new InputStreamReader(fileInputStream) : new InputStreamReader((InputStream)fileInputStream, string));
            ((InputStream)fileInputStream).close();
            fileInputStream = null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public final void cookFile(String string) throws CompileException, IOException {
        this.cookFile(string, null);
    }

    @Override
    public final void cookFile(String string, @Nullable String string2) throws CompileException, IOException {
        this.cookFile(new File(string), string2);
    }
}

