/*
 * Decompiled with CFR 0.152.
 */
package org.oorexx.handlers.jdor;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import org.oorexx.handlers.jdor.JavaDrawingHandler;

class JavaDrawingPrintable
implements Printable {
    BufferedImage img = null;
    JavaDrawingHandler jdh = null;

    JavaDrawingPrintable(BufferedImage bufferedImage, JavaDrawingHandler javaDrawingHandler) {
        this.img = bufferedImage;
        this.jdh = javaDrawingHandler;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        if (this.jdh.printScaleToPage) {
            double d = pageFormat.getImageableWidth();
            double d2 = pageFormat.getImageableHeight();
            double d3 = this.img.getWidth();
            double d4 = this.img.getHeight();
            double d5 = d / d3;
            double d6 = d2 / d4;
            double d7 = Math.min(d5, d6);
            graphics2D.scale(d7, d7);
            graphics.drawImage(this.img, 0, 0, null);
        } else {
            graphics2D.scale(this.jdh.printScaleX, this.jdh.printScaleY);
            graphics.drawImage(this.img, this.jdh.printPosX, this.jdh.printPosY, null);
        }
        return 0;
    }
}

