/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.rexxla.bsf.engines.rexx.RexxAndJava;
import org.rexxla.bsf.engines.rexx.RexxConfiguration;
import org.rexxla.bsf.engines.rexx.RexxException;
import org.rexxla.bsf.engines.rexx.RexxProxy;

public class RexxEngine
extends BSFEngineImpl {
    public static final String version = "850.20250827";
    static int terminationCounter = 0;
    protected boolean bTerminated = false;
    protected boolean bJNITerminated = false;
    private static String terminateFixed = "9 99991231";
    private static boolean terminateOnSeparateThreadDefault = false;
    private boolean terminateOnSeparateThread = terminateOnSeparateThreadDefault;
    private static boolean resetLocalBeforeTerminateDefault = true;
    private boolean resetLocalBeforeTerminate = resetLocalBeforeTerminateDefault;
    protected static String languageVersionString = null;
    private String rii_ID = null;
    private RexxConfiguration rexxConfig = new RexxConfiguration();
    private static final boolean bDebugTermination = false;
    private static long id_counter = 0L;
    protected long id = 0L;
    private final boolean bDebug = false;
    private RexxAndJava rexxInterface;
    private String lastScriptCode = null;
    private String lastSourceLocation = null;
    HashMap<String, BSFDeclaredBean> engineDeclaredBeans = new HashMap();
    boolean hasDeclaredBeans = false;

    public boolean isTerminated() {
        return this.bTerminated;
    }

    public static String getTerminateFixed() {
        return terminateFixed;
    }

    public static void setTerminateFixed(String string) {
        terminateFixed = string;
    }

    public static void setTerminateOnSeparateThreadDefault(boolean bl) {
        terminateOnSeparateThreadDefault = bl;
    }

    public static boolean isTerminateOnSeparateThreadDefault() {
        return terminateOnSeparateThreadDefault;
    }

    public static boolean getTerminateOnSeparateThreadDefault() {
        return terminateOnSeparateThreadDefault;
    }

    public void setTerminateOnSeparateThread(boolean bl) {
        this.terminateOnSeparateThread = bl;
    }

    public boolean isTerminateOnSeparateThread() {
        return this.terminateOnSeparateThread;
    }

    public boolean getTerminateOnSeparateThread() {
        return this.terminateOnSeparateThread;
    }

    public static void setResetLocalBeforeTerminateDefault(boolean bl) {
        resetLocalBeforeTerminateDefault = bl;
    }

    public static boolean isResetLocalBeforeTerminateDefault() {
        return resetLocalBeforeTerminateDefault;
    }

    public static boolean getResetLocalBeforeTerminateDefault() {
        return resetLocalBeforeTerminateDefault;
    }

    public void setResetLocalBeforeTerminate(boolean bl) {
        this.resetLocalBeforeTerminate = bl;
    }

    public boolean isResetLocalBeforeTerminate() {
        return this.resetLocalBeforeTerminate;
    }

    public boolean getResetLocalBeforeTerminate() {
        return this.resetLocalBeforeTerminate;
    }

    public static String getLanguageVersionString() {
        if (languageVersionString == null) {
            String string = "PARSE VERSION v; return v;";
            languageVersionString = RexxAndJava.jniExecuteSimpleProcedureOnOwnRII(string, null);
            boolean bl = RexxEngine.isTerminationFixed();
            if (bl) {
                terminateOnSeparateThreadDefault = true;
                resetLocalBeforeTerminateDefault = false;
            }
        }
        return languageVersionString;
    }

    protected static boolean isTerminationFixed() {
        String string = "YYYYMMd";
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        String[] stringArray = terminateFixed.split(" ");
        if (stringArray.length == 2) {
            string2 = stringArray[0];
            string3 = stringArray[1];
            int n = languageVersionString.indexOf("_");
            int n2 = languageVersionString.indexOf(".");
            String string4 = languageVersionString.substring(n + 1, n2);
            n = languageVersionString.indexOf(" ");
            n2 = languageVersionString.indexOf(" ", n + 1);
            String string5 = languageVersionString.substring(n2 + 1);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d MMM yyyy", Locale.ENGLISH);
            Date date = null;
            String string6 = "";
            try {
                date = simpleDateFormat.parse(string5);
                simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                string6 = simpleDateFormat.format(date);
                boolean bl2 = bl = string2.compareTo(string4) < 0;
                if (!bl) {
                    bl = string2.compareTo(string4) == 0 && string3.compareTo(string6) <= 0;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
    }

    public String get_rii_ID() {
        return this.rii_ID;
    }

    protected void set_rii_ID(String string) {
        this.rii_ID = string;
    }

    public RexxConfiguration getRexxConfiguration() {
        return this.rexxConfig;
    }

    public long getId() {
        return this.id;
    }

    protected void setId(long l) {
        this.id = l;
    }

    public RexxAndJava getRexxInterface() {
        return this.rexxInterface;
    }

    @Override
    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        this.id = --id_counter;
        this.rexxInterface = new RexxAndJava(bSFManager, this);
        if (languageVersionString == null) {
            languageVersionString = RexxEngine.getLanguageVersionString();
        }
        this.terminateOnSeparateThread = terminateOnSeparateThreadDefault;
        this.resetLocalBeforeTerminate = resetLocalBeforeTerminateDefault;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.declareBean((BSFDeclaredBean)iterator.next());
        }
    }

    public Object getLocalEnvironment() {
        if (this.rii_ID == null) {
            throw new NullPointerException("\"rii_ID\" (Rexx interpereter instance ID) null, Rexx interpreter instance not yet created (just eval() or apply() a script))");
        }
        return this.rexxInterface.jniGetLocalEnvironment0(this.rii_ID);
    }

    public Object getGlobalEnvironment() {
        if (this.rii_ID == null) {
            throw new NullPointerException("\"rii_ID\" (Rexx interpereter instance ID) null, Rexx interpreter instance not yet created (just eval() or apply() a script))");
        }
        return this.rexxInterface.jniGetGlobalEnvironment0(this.rii_ID);
    }

    public Object getNil() {
        if (this.rii_ID == null) {
            throw new NullPointerException("\"rii_ID\" (Rexx interpereter instance ID) null, Rexx interpreter instance not yet created (just eval() or apply() a script))");
        }
        return this.rexxInterface.jniNil0(this.rii_ID);
    }

    public long getInterpreterVersion() {
        if (this.rii_ID == null) {
            throw new NullPointerException("\"rii_ID\" (Rexx interpereter instance ID) null, Rexx interpreter instance not yet created (just eval() or apply() a script))");
        }
        return this.rexxInterface.jniInterpreterVersion0(this.rii_ID);
    }

    public long getLanguageLevel() {
        if (this.rii_ID == null) {
            throw new NullPointerException("\"rii_ID\" (Rexx interpereter instance ID) null, Rexx interpreter instance not yet created (just eval() or apply() a script))");
        }
        return this.rexxInterface.jniLanguageLevel0(this.rii_ID);
    }

    @Override
    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        if (this.bTerminated) {
            throw new RexxException("RexxEngine " + this + " got terminated, cannot be used anymore.");
        }
        if (this.rii_ID == null) {
            this.rii_ID = this.rexxInterface.createRexxInterpreterInstance(this.rexxConfig);
        }
        String string2 = object.toString();
        if (string != null && string.equals("<eventText>")) {
            if (string2.startsWith("/*2*/")) {
                this.rexxInterface.eventTextList.put(string2, 2);
            } else if (string2.startsWith("/*0*/")) {
                this.rexxInterface.eventTextList.put(string2, 0);
            } else {
                this.rexxInterface.eventTextList.put(string2, 1);
            }
            return null;
        }
        this.lastScriptCode = string2;
        this.lastSourceLocation = string;
        Object object2 = null;
        object2 = this.rexxInterface.jniRexxRunProgram(this.rii_ID, 2, string, string2, null);
        return object2;
    }

    @Override
    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        if (this.bTerminated) {
            throw new RexxException("RexxEngine " + this + " got terminated, cannot be used anymore.");
        }
        return this.call(object, string, objectArray, null);
    }

    public Object call(Object object, String string, Object[] objectArray, Object object2) throws BSFException {
        String string2;
        Enumeration enumeration;
        if (this.bTerminated) {
            throw new RexxException("RexxEngine " + this + " got terminated, cannot be used anymore.");
        }
        if (this.rii_ID == null) {
            this.rii_ID = this.rexxInterface.createRexxInterpreterInstance(this.rexxConfig);
        }
        if (object2 != null && !(object2 instanceof String) && !(object2 instanceof RexxProxy)) {
            throw new RexxException("scope argument must be either null, a String or a RexxProxy: scope=" + object2 + ", scope.getClass()=" + object2.getClass().toString());
        }
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
        }
        Vector<Object> vector = new Vector<Object>();
        boolean bl = object instanceof RexxProxy;
        for (int i = 0; i < (objectArray != null ? objectArray.length : 0); ++i) {
            enumeration = objectArray[i];
            if (enumeration != null) {
                if (enumeration instanceof RexxProxy) {
                    objectArray2[i] = enumeration;
                    continue;
                }
                Object[] objectArray3 = this.args2RexxString(enumeration);
                if (((Boolean)objectArray3[0]).booleanValue()) {
                    vector.addElement(objectArray3[1]);
                }
                objectArray2[i] = (String)objectArray3[1];
                continue;
            }
            objectArray2[i] = null;
        }
        Object object3 = null;
        if (bl) {
            enumeration = (RexxProxy)object;
            string2 = null;
            string2 = object2 instanceof RexxProxy ? ((RexxProxy)object2).rexxObjectID : (object2 == null ? null : (String)object2);
            object3 = this.rexxInterface.jniRexxSendMessageToRexxObject(((RexxProxy)((Object)enumeration)).rexxInterpreterID, ((RexxProxy)((Object)enumeration)).rexxObjectID, ((RexxProxy)((Object)enumeration)).rexxUserDataID, null, null, string, null, objectArray2, null, string2);
        } else {
            object3 = this.rexxInterface.jniRexxRunProgram(this.rii_ID, 2, this.lastSourceLocation, this.lastScriptCode, objectArray2);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (this.rexxInterface.bsfPrefixReturnValue) {
                this.rexxInterface.unregisterBean(string2.substring(3));
                continue;
            }
            this.rexxInterface.unregisterBean(string2);
        }
        return object3;
    }

    public Object call(RexxProxy rexxProxy, Method method, Object[] objectArray) throws BSFException {
        Class<?> clazz;
        if (rexxProxy == null) {
            throw new RexxException("'proxy' argument must not be null!");
        }
        if (method == null) {
            throw new RexxException("'methodObject' argument must not be null!");
        }
        if (this.bTerminated) {
            throw new RexxException("RexxEngine " + this + " got terminated, cannot be used anymore.");
        }
        if (this.rii_ID == null) {
            this.rii_ID = this.rexxInterface.createRexxInterpreterInstance(this.rexxConfig);
        }
        String string = method.getName();
        String string2 = RexxAndJava.makeString4Rexx(this.rexxInterface, method);
        if (this.rexxInterface.bsfPrefixReturnValue) {
            RexxAndJava.registerBean(this.rexxInterface, string2.substring(3), method);
        } else {
            RexxAndJava.registerBean(this.rexxInterface, string2, method);
        }
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < (objectArray != null ? objectArray.length : 0); ++i) {
            clazz = objectArray[i];
            if (clazz != null) {
                if (clazz instanceof RexxProxy) {
                    objectArray2[i] = clazz;
                    continue;
                }
                Object[] objectArray3 = this.args2RexxString(clazz);
                if (((Boolean)objectArray3[0]).booleanValue()) {
                    vector.addElement(objectArray3[1]);
                }
                objectArray2[i] = (String)objectArray3[1];
                continue;
            }
            objectArray2[i] = null;
        }
        String string3 = null;
        clazz = method.getReturnType();
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            string3 = "Z";
        } else if (clazz == Integer.TYPE || clazz == Integer.class) {
            string3 = "I";
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            string3 = "J";
        } else if (clazz == Byte.TYPE || clazz == Byte.class) {
            string3 = "B";
        } else if (clazz == Character.TYPE || clazz == Character.class) {
            string3 = "C";
        } else if (clazz == Short.TYPE || clazz == Short.class) {
            string3 = "S";
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            string3 = "F";
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            string3 = "D";
        }
        Object object = null;
        object = this.rexxInterface.jniRexxSendMessageToRexxObject(rexxProxy.rexxInterpreterID, rexxProxy.rexxObjectID, rexxProxy.rexxUserDataID, null, string2, string, null, objectArray2, string3, null);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (this.rexxInterface.bsfPrefixReturnValue) {
                this.rexxInterface.unregisterBean(string4.substring(3));
                continue;
            }
            this.rexxInterface.unregisterBean(string4);
        }
        if (this.rexxInterface.bsfPrefixReturnValue) {
            this.rexxInterface.unregisterBean(string2.substring(3));
        } else {
            this.rexxInterface.unregisterBean(string2);
        }
        return object;
    }

    public Object call(RexxProxy rexxProxy, Object object, String string, String string2, Object[] objectArray) throws BSFException {
        Object object2;
        int n;
        int n2;
        if (rexxProxy == null) {
            throw new RexxException("'proxy' argument must not be null!");
        }
        if (object == null) {
            throw new RexxException("'javaObject' argument must not be null!");
        }
        if (string == null) {
            throw new RexxException("'methodName' argument must not be null!");
        }
        if (this.bTerminated) {
            throw new RexxException("RexxEngine " + this + " got terminated, cannot be used anymore.");
        }
        if (this.rii_ID == null) {
            this.rii_ID = this.rexxInterface.createRexxInterpreterInstance(this.rexxConfig);
        }
        String string3 = RexxAndJava.makeString4Rexx(this.rexxInterface, object);
        if (this.rexxInterface.bsfPrefixReturnValue) {
            RexxAndJava.registerBean(this.rexxInterface, string3.substring(3), object);
        } else {
            RexxAndJava.registerBean(this.rexxInterface, string3, object);
        }
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < (objectArray != null ? objectArray.length : 0); ++i) {
            Object object3 = objectArray[i];
            if (object3 != null) {
                if (object3 instanceof RexxProxy) {
                    objectArray2[i] = object3;
                    continue;
                }
                Object[] objectArray3 = this.args2RexxString(object3);
                if (((Boolean)objectArray3[0]).booleanValue()) {
                    vector.addElement(objectArray3[1]);
                }
                objectArray2[i] = (String)objectArray3[1];
                continue;
            }
            objectArray2[i] = null;
        }
        String string4 = null;
        int n3 = n2 = string2 == null ? 0 : string2.length();
        if (n2 > 0 && (n = ((String)(object2 = string2.split(" | ")[0])).lastIndexOf(41)) > 0 && n < n2) {
            char c = ((String)object2).charAt(n + 1);
            if (c != 'L') {
                if (c != 'V') {
                    string4 = "" + c;
                }
            } else {
                String string5 = ((String)object2).substring(n + 1);
                if (string5.startsWith("Ljava/lang/")) {
                    // empty if block
                }
                if ((string5 = string5.substring(string5.lastIndexOf(47))).equals("/Boolean;")) {
                    string4 = "Z";
                } else if (string5.equals("/Byte;")) {
                    string4 = "B";
                } else if (string5.equals("/Character;")) {
                    string4 = "C";
                } else if (string5.equals("/Short;")) {
                    string4 = "S";
                } else if (string5.equals("/Integer;")) {
                    string4 = "I";
                } else if (string5.equals("/Long;")) {
                    string4 = "J";
                } else if (string5.equals("/Float;")) {
                    string4 = "F";
                } else if (string5.equals("/Double;")) {
                    string4 = "D";
                }
            }
        }
        object2 = null;
        object2 = this.rexxInterface.jniRexxSendMessageToRexxObject(rexxProxy.rexxInterpreterID, rexxProxy.rexxObjectID, rexxProxy.rexxUserDataID, string3, null, string, string2, objectArray2, string4, null);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            if (this.rexxInterface.bsfPrefixReturnValue) {
                this.rexxInterface.unregisterBean(string6.substring(3));
                continue;
            }
            this.rexxInterface.unregisterBean(string6);
        }
        if (this.rexxInterface.bsfPrefixReturnValue) {
            this.rexxInterface.unregisterBean(string3.substring(3));
        } else {
            this.rexxInterface.unregisterBean(string3);
        }
        return object2;
    }

    @Override
    public Object apply(String string, int n, int n2, Object object, Vector vector, Vector vector2) throws BSFException {
        Object object2;
        Enumeration enumeration;
        if (this.bTerminated) {
            throw new RexxException("RexxEngine " + this + " got terminated, cannot be used anymore.");
        }
        if (this.rii_ID == null) {
            this.rii_ID = this.rexxInterface.createRexxInterpreterInstance(this.rexxConfig);
        }
        String string2 = object.toString();
        if (string != null && string.equals("<eventText>")) {
            int n3 = 0;
            int n4 = vector2.size();
            Object[] objectArray = new Object[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray[n3] = vector2.elementAt(n3);
            }
            String string3 = "/*BSFBEAN/*" + RexxAndJava.makeString4Rexx(this.rexxInterface, objectArray) + "*/*/";
            if (string2.startsWith("/*2*/")) {
                this.rexxInterface.eventTextList.put(string3 + string2, 2);
            } else if (string2.startsWith("/*0*/")) {
                this.rexxInterface.eventTextList.put(string3 + string2, 0);
            } else {
                this.rexxInterface.eventTextList.put(string3 + string2, 1);
            }
            return null;
        }
        this.lastScriptCode = string2;
        this.lastSourceLocation = string;
        Vector<Object> vector3 = null;
        Object[] objectArray = null;
        if (vector2 != null && vector2.isEmpty()) {
            vector2 = null;
        }
        if (vector2 != null) {
            int n5 = 0;
            enumeration = vector2.elements();
            objectArray = new Object[vector2.size()];
            vector3 = new Vector<Object>(vector2.size());
            n5 = 0;
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (object2 != null) {
                    if (object2 instanceof RexxProxy) {
                        objectArray[n5] = object2;
                    } else {
                        Object[] objectArray2 = this.args2RexxString(object2);
                        if (((Boolean)objectArray2[0]).booleanValue()) {
                            vector3.addElement(objectArray2[1]);
                        }
                        objectArray[n5] = (String)objectArray2[1];
                    }
                } else {
                    objectArray[n5] = null;
                }
                ++n5;
            }
        }
        Object object3 = null;
        object3 = this.rexxInterface.jniRexxRunProgram(this.rii_ID, 2, this.lastSourceLocation, this.lastScriptCode, objectArray);
        if (vector3 != null) {
            enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                if (this.rexxInterface.bsfPrefixReturnValue) {
                    this.rexxInterface.unregisterBean(((String)object2).substring(3));
                    continue;
                }
                this.rexxInterface.unregisterBean((String)object2);
            }
        }
        return object3;
    }

    private Object[] args2RexxString(Object object) {
        Object[] objectArray = new Object[]{Boolean.FALSE, object};
        if (object == null) {
            return objectArray;
        }
        Class<?> clazz = object.getClass();
        if (clazz == String.class) {
            if (((String)object).startsWith("<O>")) {
                objectArray[1] = RexxAndJava.makeString4Rexx(this.rexxInterface, object);
            }
            return objectArray;
        }
        if (clazz == Boolean.class) {
            objectArray[1] = (Boolean)object != false ? "1" : "0";
            return objectArray;
        }
        if (clazz.isPrimitive() || clazz == Integer.class || clazz == Character.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Byte.class || clazz == Short.class) {
            objectArray[1] = object.toString();
            return objectArray;
        }
        objectArray[0] = Boolean.TRUE;
        objectArray[1] = RexxAndJava.makeString4Rexx(this.rexxInterface, object);
        return objectArray;
    }

    @Override
    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (this.bTerminated) {
            return;
        }
        this.engineDeclaredBeans.put(bSFDeclaredBean.name, bSFDeclaredBean);
        this.hasDeclaredBeans = true;
    }

    @Override
    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (this.bTerminated) {
            return;
        }
        this.engineDeclaredBeans.remove(bSFDeclaredBean.name);
        this.hasDeclaredBeans = !this.engineDeclaredBeans.isEmpty();
    }

    @Override
    public synchronized void terminate() {
        if (this.bJNITerminated) {
            return;
        }
        this.bTerminated = true;
        if (this.rii_ID != null) {
            boolean bl = false;
            if (this.rexxInterface != null) {
                Object object;
                if (this.resetLocalBeforeTerminate) {
                    String string = "  lDir = .local  -- get .local                      ;\n  lDir['INPUT'      ]= .monitor~new(ldir['STDIN' ]) ;\n  lDir['OUTPUT'     ]= .monitor~new(ldir['STDOUT']) ;\n  lDir['ERROR'      ]= .monitor~new(ldir['STDERR']) ;\n  lDir['TRACEOUTPUT']= .monitor~new(ldir['ERROR' ]) ;\n  lDir['DEBUGINPUT' ]= .monitor~new(ldir['INPUT' ]) ;\n";
                    object = null;
                    try {
                        object = this.rexxInterface.jniRexxRunProgram(this.rii_ID, 2, "RexxEngine_terminate_cleanup_local_monitors", string, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                bl = this.rexxInterface.bTerminated;
                this.rexxInterface.bTerminated = true;
                if (this.terminateOnSeparateThread) {
                    boolean bl2 = bl;
                    object = this.rii_ID;
                    long l = Thread.currentThread().getId();
                    Runnable runnable = new Runnable(){
                        final /* synthetic */ String val$re_rii_ID;
                        final /* synthetic */ long val$currTid;
                        final /* synthetic */ boolean val$tmpBTerminated;
                        {
                            this.val$re_rii_ID = string;
                            this.val$currTid = l;
                            this.val$tmpBTerminated = bl;
                        }

                        @Override
                        public void run() {
                            int n = 0;
                            try {
                                long l = Thread.currentThread().getId();
                                n = RexxEngine.this.rexxInterface.jniRexxTerminateInterpreterInstance(this.val$re_rii_ID);
                            }
                            catch (Throwable throwable) {
                                System.err.println("*** RexxEngine.java # 1597: rii_ID=[" + this.val$re_rii_ID + "] already terminated! res: [" + n + "] ! (on separate thread) [RE_" + RexxEngine.this.id + "]");
                            }
                            if (n == -2) {
                                if (RexxEngine.this.rexxInterface != null) {
                                    ((RexxEngine)RexxEngine.this).rexxInterface.bTerminated = this.val$tmpBTerminated;
                                }
                                return;
                            }
                            RexxEngine.this.bJNITerminated = true;
                            RexxEngine.this.rexxInterface.terminate();
                            RexxEngine.this.rexxInterface = null;
                            RexxEngine.super.terminate();
                        }
                    };
                    String string = "RexxEngine.terminate_T" + ++terminationCounter + "_for_[RE_" + this.id + "]_rii_ID_" + this.rii_ID;
                    new Thread(runnable, string).start();
                } else {
                    int n = 0;
                    try {
                        n = this.rexxInterface.jniRexxTerminateInterpreterInstance(this.rii_ID);
                    }
                    catch (Throwable throwable) {
                        System.err.println("*** RexxEngine.java # 1637: rii_ID=[" + this.rii_ID + "] already terminated! res: [" + n + "] !");
                    }
                    if (n == -2) {
                        if (this.rexxInterface != null) {
                            this.rexxInterface.bTerminated = bl;
                        }
                        return;
                    }
                    this.bJNITerminated = true;
                    this.rexxInterface.terminate();
                    this.rexxInterface = null;
                    super.terminate();
                }
            }
        }
    }

    public void halt() throws RexxException {
        if (this.rii_ID != null) {
            this.rexxInterface.jniRexxHaltInterpreterInstance(this.rii_ID);
        }
    }

    public int halt(String string) {
        if (this.rii_ID != null) {
            return this.rexxInterface.jniRexxSetHalt(string);
        }
        return 3;
    }

    public String registerBean(Object object) throws RexxException {
        if (this.bTerminated) {
            throw new RexxException("RexxEngine " + this + " got terminated, cannot be used anymore.");
        }
        return RexxAndJava.registerBean(this.rexxInterface, RexxAndJava.makeString4Rexx(this.rexxInterface, object), object);
    }

    public String registerBean(String string, Object object) throws RexxException {
        if (this.bTerminated) {
            throw new RexxException("RexxEngine " + this + " got terminated, cannot be used anymore.");
        }
        return RexxAndJava.registerBean(this.rexxInterface, string, object);
    }

    public boolean unregisterBean(String string) throws RexxException {
        return this.rexxInterface.unregisterBean(string) >= 0;
    }

    public Object lookupBean(String string) throws RexxException {
        if (this.bTerminated) {
            throw new RexxException("RexxEngine " + this + " got terminated, cannot be used anymore.");
        }
        return RexxAndJava.lookupBean(this.rexxInterface, string);
    }

    public String procEnvironment(int n, String string, String string2) throws RexxException {
        if (this.bTerminated) {
            throw new RexxException("RexxEngine " + this + " got terminated, cannot be used anymore.");
        }
        return this.rexxInterface.jniProcEnvironment(n, string, string2);
    }

    static String showObjectAndTypeName(Object object) {
        if (object == null) {
            return "null";
        }
        return "__|" + object + "|__ -> type=__|" + object.getClass().getName() + "|__";
    }
}

