#!/usr/bin/env rexx
/* ------------------------ Apache Version 2.0 license -------------------------
 *    Copyright (C) 2012 Rony G. Flatscher
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        <a href="http://www.apache.org/licenses/LICENSE-2.0">http://www.apache.org/licenses/LICENSE-2.0</a>
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * -----------------------------------------------------------------------------
 *
 * purpose: demonstrate the possibilities Java command handlers allows for
 *
 * @author Rony G. Flatscher
 * @since  2012-02-21
 */

   -- define various Rexx command handlers implemented in Java
call BsfCommandHandler 'Add', 'Alice'               , .bsf~new("DirectCommandHandlers$AliceCommandHandler")
call BsfCommandHandler 'Add', 'Daniel'              , .bsf~new("DirectCommandHandlers$DanielCommandHandler")
call BsfCommandHandler 'Add', 'Michael'             , .bsf~new("DirectCommandHandlers$MichaelCommandHandler")
call BsfCommandHandler 'Add', 'Rony'                , .bsf~new("DirectCommandHandlers$RonyCommandHandler")
call BsfCommandHandler 'Add', 'Gregorian'           , .bsf~new("DirectCommandHandlers$ReturnGregorianCalendarCommandHandler")
call BsfCommandHandler 'Add', 'TestFailureCondition', .bsf~new("DirectCommandHandlers$TestFailureConditionCommandHandler")
call BsfCommandHandler 'Add', 'TestErrorCondition'  , .bsf~new("DirectCommandHandlers$TestErrorConditionCommandHandler")
call BsfCommandHandler 'Add', 'TestException'       , .bsf~new("DirectCommandHandlers$TestExceptionCommandHandler")
call BsfCommandHandler 'Add', 'TestException0'      , .bsf~new("DirectCommandHandlers$TestException0CommandHandler")
call BsfCommandHandler 'Add', 'TestException1'      , .bsf~new("DirectCommandHandlers$TestException1CommandHandler")
call BsfCommandHandler 'Add', 'TestException2'      , .bsf~new("DirectCommandHandlers$TestException2CommandHandler")

say "1) default environment:" pp(address())
say

say "   list of currently defined Java command handlers:"
do counter c item over bsfCommandHandler('List')
   say "       " right(c,2)":" item
end
say

say "   setting default environment to:" pp(Alice)
address Alice        -- define default environment for commands consisting of a string only
say

say "2) default environment:" pp(address())  -- query and display current environment
say
say " now employing commands for all of these environments ..."
say "---------------------------------------------------------"
say

say "default environment:" address()
"helloWorld"
say "rc="pp(rc)
say "---"
say

address alice   "aimed at 'alice' command handler ..."
say "rc="pp(rc)
say "---"
address daniel  "aimed at 'daniel' command handler ..."
say "rc="pp(rc)
say "---"
address michael "aimed at 'michael' command handler ..."
say "rc="pp(rc)
say "---"
address rony    "aimed at 'rony' command handler ..."
say "rc="pp(rc)
say "---"

address gregorian "aimed at 'gregorian' command handler ..."
say "rc="pp(rc) "rc~class="pp(rc~class)
say "rc~toString="pp(rc~toString)
say "---"

drop rc     -- delete variable RC
signal on any name any_label1
say "sending to an environment that raises intentionally a failure condition (very serious):"
address testFailureCondition "aimed at 'testFailureCondition' command handler ..."
say "rc="pp(rc)
say "--- The end. ---"
say
any_label1:
   say "rc="pp(rc) ".rs="pp(.rs) "(see rexxref.pdf for '.rs')"
   say "attempting to dump a condition object:"
   say ppCondition2(condition('Object'))
   say "---"
say

drop rc     -- delete variable RC
signal on any name any_label2
say "sending to an environment that raises intentionally an error condition:"
address testErrorCondition "aimed at 'testErrorCondition' command handler ..."
say "rc="pp(rc)
say "--- The end. ---"
say
any_label2:
   say "rc="pp(rc) ".rs="pp(.rs) "(see rexxref.pdf for '.rs')"
   say "attempting to dump a condition object:"
   say ppCondition2(condition('Object'))
   say "---"
say

say "permanent address change to 'Alice' ..."
address alice
say "address():" address()
"aimed at alice #2 ..."
say "--- The End # 2 ---"
say

call testExceptionHandler
say "---"
say

call testExceptionHandler0
say "---"
say

call testExceptionHandler1
say "---"
say

call testExceptionHandler2
say "---"
say

say "permanent address change to NIXI ..."
drop rc     -- delete variable RC
address nixi
say "rc="pp(rc) ".rs="pp(.rs) "(see rexxref.pdf for '.rs')"
drop rc     -- delete variable RC
"aimed at nixi ..."
say "rc="pp(rc) ".rs="pp(.rs) "(see rexxref.pdf for '.rs')"
say "--- The End # 3 ---"
exit

::requires "BSF.CLS"    -- get Java support

::requires "rgf_util2.rex" -- get access to utilities



::routine testExceptionHandler
  signal on syntax
  address testexception "hello there!"
  return

syntax:
  say ppCondition2(condition('Object'))


::routine testExceptionHandler0
  signal on syntax
  address testexception0 "hello there0!"
  return

syntax:
  say ppCondition2(condition('Object'))

::routine testExceptionHandler1
  signal on syntax
  address testexception1 "hello there1!"
  return

syntax:
  say ppCondition2(condition('Object'))

::routine testExceptionHandler2
  signal on syntax
  say "(REXX-side) 1) test="pp2(test) "(variable TEST not yet defined)"
  address testexception2 "hello there2!"
  return

syntax:
  say ppCondition2(condition('Object'))
  say "(REXX-side) 2) test="pp2(test) "(variable TEST should have been defined by the Java command handler)"