/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation.decoration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.control.Control;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.StyleClassDecoration;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.decoration.AbstractValidationDecoration;

public class StyleClassValidationDecoration
extends AbstractValidationDecoration {
    private final String errorClass;
    private final String warningClass;

    public StyleClassValidationDecoration() {
        this(null, null);
    }

    public StyleClassValidationDecoration(String errorClass, String warningClass) {
        this.errorClass = errorClass != null ? errorClass : "error";
        this.warningClass = warningClass != null ? warningClass : "warning";
    }

    @Override
    protected Collection<Decoration> createValidationDecorations(ValidationMessage message) {
        return Arrays.asList(new StyleClassDecoration(Severity.ERROR == message.getSeverity() ? this.errorClass : this.warningClass));
    }

    @Override
    protected Collection<Decoration> createRequiredDecorations(Control target) {
        return Collections.emptyList();
    }
}

