/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextFlow;
import javafx.stage.PopupWindow;
import javafx.util.Duration;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualFlowHit;
import org.fxmisc.flowless.Virtualized;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.ClipboardActions;
import org.fxmisc.richtext.CssProperties;
import org.fxmisc.richtext.MouseOverTextEvent;
import org.fxmisc.richtext.ParagraphBox;
import org.fxmisc.richtext.PopupAlignment;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.StyledTextAreaBehavior;
import org.fxmisc.richtext.ViewActions;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.EditActions;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.GenericEditableStyledDocument;
import org.fxmisc.richtext.model.NavigationActions;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleActions;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextChange;
import org.fxmisc.richtext.model.TextEditingArea;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;
import org.fxmisc.richtext.model.UndoActions;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.UndoManagerFactory;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Guard;
import org.reactfx.StateMachine;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableEventStream;
import org.reactfx.SuspendableNo;
import org.reactfx.collection.LiveList;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.SuspendableVar;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class GenericStyledArea<PS, SEG, S>
extends Region
implements TextEditingArea<PS, SEG, S>,
EditActions<PS, SEG, S>,
ClipboardActions<PS, SEG, S>,
NavigationActions<PS, SEG, S>,
StyleActions<PS, S>,
UndoActions,
ViewActions<PS, SEG, S>,
TwoDimensional,
Virtualized {
    public static final IndexRange EMPTY_RANGE = new IndexRange(0, 0);
    private static final PseudoClass HAS_CARET = PseudoClass.getPseudoClass((String)"has-caret");
    private static final PseudoClass FIRST_PAR = PseudoClass.getPseudoClass((String)"first-paragraph");
    private static final PseudoClass LAST_PAR = PseudoClass.getPseudoClass((String)"last-paragraph");
    private final StyleableObjectProperty<Paint> highlightFill = new CssProperties.HighlightFillProperty(this, (Paint)Color.DODGERBLUE);
    private final StyleableObjectProperty<Paint> highlightTextFill = new CssProperties.HighlightTextFillProperty(this, (Paint)Color.WHITE);
    private final StyleableObjectProperty<Duration> caretBlinkRate = new CssProperties.CaretBlinkRateProperty(this, Duration.millis((double)500.0));
    private final BooleanProperty editable = new CssProperties.EditableProperty<GenericStyledArea>(this);
    private final BooleanProperty wrapText = new SimpleBooleanProperty((Object)this, "wrapText");
    private final Var<ViewActions.CaretVisibility> showCaret = Var.newSimpleVar(ViewActions.CaretVisibility.AUTO);
    private UndoManager undoManager;
    private final ObjectProperty<java.time.Duration> mouseOverTextDelay = new SimpleObjectProperty(null);
    private final BooleanProperty autoScrollOnDragDesired = new SimpleBooleanProperty(true);
    private final Property<Consumer<MouseEvent>> onOutsideSelectionMousePress = new SimpleObjectProperty(e -> {
        CharacterHit hit = this.hit(e.getX(), e.getY());
        this.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR);
    });
    private final Property<Consumer<MouseEvent>> onInsideSelectionMousePressRelease = new SimpleObjectProperty(e -> {
        CharacterHit hit = this.hit(e.getX(), e.getY());
        this.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR);
    });
    private final Property<Consumer<Point2D>> onNewSelectionDrag = new SimpleObjectProperty(p -> {
        CharacterHit hit = this.hit(p.getX(), p.getY());
        this.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.ADJUST);
    });
    private final Property<Consumer<MouseEvent>> onNewSelectionDragEnd = new SimpleObjectProperty(e -> {
        CharacterHit hit = this.hit(e.getX(), e.getY());
        this.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.ADJUST);
    });
    private final Property<Consumer<Point2D>> onSelectionDrag = new SimpleObjectProperty(p -> {
        CharacterHit hit = this.hit(p.getX(), p.getY());
        this.displaceCaret(hit.getInsertionIndex());
    });
    private final Property<Consumer<MouseEvent>> onSelectionDrop = new SimpleObjectProperty(e -> {
        CharacterHit hit = this.hit(e.getX(), e.getY());
        this.moveSelectedText(hit.getInsertionIndex());
    });
    private final ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactory = new SimpleObjectProperty(null);
    private ObjectProperty<ContextMenu> contextMenu = new SimpleObjectProperty(null);
    private double contextMenuXOffset = 2.0;
    private double contextMenuYOffset = 2.0;
    private final BooleanProperty useInitialStyleForInsertion = new SimpleBooleanProperty();
    private Optional<Tuple2<Codec<PS>, Codec<SEG>>> styleCodecs = Optional.empty();
    private final Var<Integer> internalCaretPosition = Var.newSimpleVar(0);
    private final SuspendableVal<Integer> caretPosition = this.internalCaretPosition.suspendable();
    private final Val<Optional<Bounds>> caretBounds;
    private final SuspendableVar<Integer> anchor = Var.newSimpleVar(0).suspendable();
    private final Var<IndexRange> internalSelection = Var.newSimpleVar(EMPTY_RANGE);
    private final SuspendableVal<IndexRange> selection = this.internalSelection.suspendable();
    private final SuspendableVal<String> selectedText;
    private final Val<Optional<Bounds>> selectionBounds;
    private final SuspendableVal<Integer> currentParagraph;
    private final SuspendableVal<Integer> caretColumn;
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private TwoDimensional.Position selectionStart2D;
    private TwoDimensional.Position selectionEnd2D;
    private Subscription subscriptions = () -> {};
    private Optional<ParagraphBox.CaretOffsetX> targetCaretOffset = Optional.empty();
    private final Binding<Boolean> caretVisible;
    private final Val<UnaryOperator<Point2D>> _popupAnchorAdjustment;
    private final VirtualFlow<Paragraph<PS, SEG, S>, Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>> virtualFlow;
    private final TwoLevelNavigator navigator;
    private boolean followCaretRequested = false;
    private final SuspendableEventStream<?> viewportDirty;
    private final EditableStyledDocument<PS, SEG, S> content;
    private final S initialTextStyle;
    private final PS initialParagraphStyle;
    private final BiConsumer<TextFlow, PS> applyParagraphStyle;
    private final boolean preserveStyle;
    private final TextOps<SEG, S> segmentOps;
    @Deprecated
    private final ObjectProperty<PopupWindow> popupWindow = new SimpleObjectProperty();
    @Deprecated
    private final ObjectProperty<Point2D> popupAnchorOffset = new SimpleObjectProperty();
    @Deprecated
    private final ObjectProperty<UnaryOperator<Point2D>> popupAnchorAdjustment = new SimpleObjectProperty();
    @Deprecated
    private final ObjectProperty<PopupAlignment> popupAlignment = new SimpleObjectProperty((Object)PopupAlignment.CARET_TOP);

    private static int clamp(int min, int val, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    @Override
    public final boolean isEditable() {
        return this.editable.get();
    }

    @Override
    public final void setEditable(boolean value) {
        this.editable.set(value);
    }

    @Override
    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    @Override
    public final boolean isWrapText() {
        return this.wrapText.get();
    }

    @Override
    public final void setWrapText(boolean value) {
        this.wrapText.set(value);
    }

    @Override
    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    @Override
    public final ViewActions.CaretVisibility getShowCaret() {
        return (ViewActions.CaretVisibility)((Object)this.showCaret.getValue());
    }

    @Override
    public final void setShowCaret(ViewActions.CaretVisibility value) {
        this.showCaret.setValue((Object)value);
    }

    @Override
    public final Var<ViewActions.CaretVisibility> showCaretProperty() {
        return this.showCaret;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setUndoManager(UndoManagerFactory undoManagerFactory) {
        this.undoManager.close();
        this.undoManager = this.preserveStyle ? this.createRichUndoManager(undoManagerFactory) : this.createPlainUndoManager(undoManagerFactory);
    }

    @Override
    public void setMouseOverTextDelay(java.time.Duration delay) {
        this.mouseOverTextDelay.set((Object)delay);
    }

    @Override
    public java.time.Duration getMouseOverTextDelay() {
        return (java.time.Duration)this.mouseOverTextDelay.get();
    }

    @Override
    public ObjectProperty<java.time.Duration> mouseOverTextDelayProperty() {
        return this.mouseOverTextDelay;
    }

    @Override
    public final void setAutoScrollOnDragDesired(boolean val) {
        this.autoScrollOnDragDesired.set(val);
    }

    @Override
    public final boolean isAutoScrollOnDragDesired() {
        return this.autoScrollOnDragDesired.get();
    }

    @Override
    public final void setOnOutsideSelectionMousePress(Consumer<MouseEvent> consumer) {
        this.onOutsideSelectionMousePress.setValue(consumer);
    }

    @Override
    public final Consumer<MouseEvent> getOnOutsideSelectionMousePress() {
        return (Consumer)this.onOutsideSelectionMousePress.getValue();
    }

    @Override
    public final void setOnInsideSelectionMousePressRelease(Consumer<MouseEvent> consumer) {
        this.onInsideSelectionMousePressRelease.setValue(consumer);
    }

    @Override
    public final Consumer<MouseEvent> getOnInsideSelectionMousePressRelease() {
        return (Consumer)this.onInsideSelectionMousePressRelease.getValue();
    }

    @Override
    public final void setOnNewSelectionDrag(Consumer<Point2D> consumer) {
        this.onNewSelectionDrag.setValue(consumer);
    }

    @Override
    public final Consumer<Point2D> getOnNewSelectionDrag() {
        return (Consumer)this.onNewSelectionDrag.getValue();
    }

    @Override
    public final void setOnNewSelectionDragEnd(Consumer<MouseEvent> consumer) {
        this.onNewSelectionDragEnd.setValue(consumer);
    }

    @Override
    public final Consumer<MouseEvent> getOnNewSelectionDragEnd() {
        return (Consumer)this.onNewSelectionDragEnd.getValue();
    }

    @Override
    public final void setOnSelectionDrag(Consumer<Point2D> consumer) {
        this.onSelectionDrag.setValue(consumer);
    }

    @Override
    public final Consumer<Point2D> getOnSelectionDrag() {
        return (Consumer)this.onSelectionDrag.getValue();
    }

    @Override
    public final void setOnSelectionDrop(Consumer<MouseEvent> consumer) {
        this.onSelectionDrop.setValue(consumer);
    }

    @Override
    public final Consumer<MouseEvent> getOnSelectionDrop() {
        return (Consumer)this.onSelectionDrop.getValue();
    }

    @Override
    public void setParagraphGraphicFactory(IntFunction<? extends Node> factory) {
        this.paragraphGraphicFactory.set(factory);
    }

    @Override
    public IntFunction<? extends Node> getParagraphGraphicFactory() {
        return (IntFunction)this.paragraphGraphicFactory.get();
    }

    @Override
    public ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactoryProperty() {
        return this.paragraphGraphicFactory;
    }

    @Override
    public final ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenu.get();
    }

    @Override
    public final void setContextMenu(ContextMenu menu) {
        this.contextMenu.setValue((Object)menu);
    }

    @Override
    public final ObjectProperty<ContextMenu> contextMenuObjectProperty() {
        return this.contextMenu;
    }

    protected final boolean isContextMenuPresent() {
        return this.contextMenu.get() != null;
    }

    @Override
    public final double getContextMenuXOffset() {
        return this.contextMenuXOffset;
    }

    @Override
    public final void setContextMenuXOffset(double offset) {
        this.contextMenuXOffset = offset;
    }

    @Override
    public final double getContextMenuYOffset() {
        return this.contextMenuYOffset;
    }

    @Override
    public final void setContextMenuYOffset(double offset) {
        this.contextMenuYOffset = offset;
    }

    @Override
    public BooleanProperty useInitialStyleForInsertionProperty() {
        return this.useInitialStyleForInsertion;
    }

    @Override
    public void setUseInitialStyleForInsertion(boolean value) {
        this.useInitialStyleForInsertion.set(value);
    }

    @Override
    public boolean getUseInitialStyleForInsertion() {
        return this.useInitialStyleForInsertion.get();
    }

    @Override
    public void setStyleCodecs(Codec<PS> paragraphStyleCodec, Codec<SEG> textStyleCodec) {
        this.styleCodecs = Optional.of(Tuples.t(paragraphStyleCodec, textStyleCodec));
    }

    @Override
    public Optional<Tuple2<Codec<PS>, Codec<SEG>>> getStyleCodecs() {
        return this.styleCodecs;
    }

    @Override
    public Var<Double> estimatedScrollXProperty() {
        return this.virtualFlow.estimatedScrollXProperty();
    }

    @Override
    public double getEstimatedScrollX() {
        return (Double)this.virtualFlow.estimatedScrollXProperty().getValue();
    }

    @Override
    public void setEstimatedScrollX(double value) {
        this.virtualFlow.estimatedScrollXProperty().setValue(value);
    }

    @Override
    public Var<Double> estimatedScrollYProperty() {
        return this.virtualFlow.estimatedScrollYProperty();
    }

    @Override
    public double getEstimatedScrollY() {
        return (Double)this.virtualFlow.estimatedScrollYProperty().getValue();
    }

    @Override
    public void setEstimatedScrollY(double value) {
        this.virtualFlow.estimatedScrollYProperty().setValue(value);
    }

    @Override
    public final String getText() {
        return this.content.getText();
    }

    @Override
    public final ObservableValue<String> textProperty() {
        return this.content.textProperty();
    }

    @Override
    public final StyledDocument<PS, SEG, S> getDocument() {
        return this.content;
    }

    @Override
    public final int getLength() {
        return this.content.getLength();
    }

    @Override
    public final ObservableValue<Integer> lengthProperty() {
        return this.content.lengthProperty();
    }

    @Override
    public final int getCaretPosition() {
        return (Integer)this.caretPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> caretPositionProperty() {
        return this.caretPosition;
    }

    @Override
    public final Optional<Bounds> getCaretBounds() {
        return (Optional)this.caretBounds.getValue();
    }

    @Override
    public final ObservableValue<Optional<Bounds>> caretBoundsProperty() {
        return this.caretBounds;
    }

    @Override
    public final int getAnchor() {
        return (Integer)this.anchor.getValue();
    }

    @Override
    public final ObservableValue<Integer> anchorProperty() {
        return this.anchor;
    }

    @Override
    public final IndexRange getSelection() {
        return (IndexRange)this.selection.getValue();
    }

    @Override
    public final ObservableValue<IndexRange> selectionProperty() {
        return this.selection;
    }

    @Override
    public final String getSelectedText() {
        return (String)this.selectedText.getValue();
    }

    @Override
    public final ObservableValue<String> selectedTextProperty() {
        return this.selectedText;
    }

    @Override
    public final Optional<Bounds> getSelectionBounds() {
        return (Optional)this.selectionBounds.getValue();
    }

    @Override
    public final ObservableValue<Optional<Bounds>> selectionBoundsProperty() {
        return this.selectionBounds;
    }

    @Override
    public final int getCurrentParagraph() {
        return (Integer)this.currentParagraph.getValue();
    }

    @Override
    public final ObservableValue<Integer> currentParagraphProperty() {
        return this.currentParagraph;
    }

    @Override
    public final int getCaretColumn() {
        return (Integer)this.caretColumn.getValue();
    }

    @Override
    public final ObservableValue<Integer> caretColumnProperty() {
        return this.caretColumn;
    }

    @Override
    public LiveList<Paragraph<PS, SEG, S>> getParagraphs() {
        return this.content.getParagraphs();
    }

    public ObservableBooleanValue beingUpdatedProperty() {
        return this.beingUpdated;
    }

    public boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    @Override
    public Val<Double> totalWidthEstimateProperty() {
        return this.virtualFlow.totalWidthEstimateProperty();
    }

    @Override
    public double getTotalWidthEstimate() {
        return (Double)this.virtualFlow.totalWidthEstimateProperty().getValue();
    }

    @Override
    public Val<Double> totalHeightEstimateProperty() {
        return this.virtualFlow.totalHeightEstimateProperty();
    }

    @Override
    public double getTotalHeightEstimate() {
        return (Double)this.virtualFlow.totalHeightEstimateProperty().getValue();
    }

    @Override
    public final EventStream<PlainTextChange> plainTextChanges() {
        return this.content.plainChanges();
    }

    @Override
    public final EventStream<RichTextChange<PS, SEG, S>> richChanges() {
        return this.content.richChanges();
    }

    public final EditableStyledDocument<PS, SEG, S> getContent() {
        return this.content;
    }

    @Override
    public final S getInitialTextStyle() {
        return this.initialTextStyle;
    }

    @Override
    public final PS getInitialParagraphStyle() {
        return this.initialParagraphStyle;
    }

    @Override
    public final BiConsumer<TextFlow, PS> getApplyParagraphStyle() {
        return this.applyParagraphStyle;
    }

    @Override
    public final boolean isPreserveStyle() {
        return this.preserveStyle;
    }

    @Override
    public final SegmentOps<SEG, S> getSegOps() {
        return this.segmentOps;
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="segmentOps") TextOps<SEG, S> segmentOps, @NamedArg(value="nodeFactory") Function<SEG, Node> nodeFactory) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, segmentOps, true, nodeFactory);
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="segmentOps") TextOps<SEG, S> segmentOps, @NamedArg(value="preserveStyle") boolean preserveStyle, @NamedArg(value="nodeFactory") Function<SEG, Node> nodeFactory) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, new GenericEditableStyledDocument<PS, SEG, S>(initialParagraphStyle, initialTextStyle, segmentOps), segmentOps, preserveStyle, nodeFactory);
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="document") EditableStyledDocument<PS, SEG, S> document, @NamedArg(value="segmentOps") TextOps<SEG, S> segmentOps, @NamedArg(value="nodeFactory") Function<SEG, Node> nodeFactory) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, document, segmentOps, true, nodeFactory);
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="document") EditableStyledDocument<PS, SEG, S> document, @NamedArg(value="segmentOps") TextOps<SEG, S> segmentOps, @NamedArg(value="preserveStyle") boolean preserveStyle, @NamedArg(value="nodeFactory") Function<SEG, Node> nodeFactory) {
        this.initialTextStyle = initialTextStyle;
        this.initialParagraphStyle = initialParagraphStyle;
        this.preserveStyle = preserveStyle;
        this.content = document;
        this.applyParagraphStyle = applyParagraphStyle;
        this.segmentOps = segmentOps;
        this.undoManager = preserveStyle ? this.createRichUndoManager(UndoManagerFactory.unlimitedHistoryFactory()) : this.createPlainUndoManager(UndoManagerFactory.unlimitedHistoryFactory());
        Val<TwoDimensional.Position> caretPosition2D = Val.create(() -> this.content.offsetToPosition((Integer)this.internalCaretPosition.getValue(), TwoDimensional.Bias.Forward), new Observable[]{this.internalCaretPosition, this.getParagraphs()});
        this.currentParagraph = caretPosition2D.map(TwoDimensional.Position::getMajor).suspendable();
        this.caretColumn = caretPosition2D.map(TwoDimensional.Position::getMinor).suspendable();
        this.selectionStart2D = this.position(0, 0);
        this.selectionEnd2D = this.position(0, 0);
        this.internalSelection.addListener(obs -> {
            IndexRange sel = (IndexRange)this.internalSelection.getValue();
            this.selectionStart2D = this.offsetToPosition(sel.getStart(), TwoDimensional.Bias.Forward);
            this.selectionEnd2D = sel.getLength() == 0 ? this.selectionStart2D : this.selectionStart2D.offsetBy(sel.getLength(), TwoDimensional.Bias.Backward);
        });
        this.selectedText = Val.create(() -> this.content.getText((IndexRange)this.internalSelection.getValue()), new Observable[]{this.internalSelection, this.content.getParagraphs()}).suspendable();
        Suspendable omniSuspendable = Suspendable.combine(this.beingUpdated, this.caretPosition, this.anchor, this.selection, this.selectedText, this.currentParagraph, this.caretColumn);
        this.manageSubscription(omniSuspendable.suspendWhen(this.content.beingUpdatedProperty()));
        this.subscribeTo(this.plainTextChanges(), plainTextChange -> {
            int changeLength = ((String)plainTextChange.getInserted()).length() - ((String)plainTextChange.getRemoved()).length();
            if (changeLength != 0) {
                int selectionEnd;
                int selectionStart;
                int indexOfChange = plainTextChange.getPosition();
                int endOfChange = indexOfChange + Math.abs(changeLength);
                int caretPosition = this.getCaretPosition();
                if (indexOfChange < caretPosition) {
                    this.displaceCaret(caretPosition < endOfChange ? indexOfChange : caretPosition + changeLength);
                }
                if ((selectionStart = this.getSelection().getStart()) != (selectionEnd = this.getSelection().getEnd())) {
                    if (indexOfChange < selectionStart) {
                        int n = selectionStart = selectionStart < endOfChange ? indexOfChange : selectionStart + changeLength;
                    }
                    if (indexOfChange < selectionEnd) {
                        selectionEnd = selectionEnd < endOfChange ? indexOfChange : selectionEnd + changeLength;
                    }
                    this.selectRange(selectionStart, selectionEnd);
                } else {
                    int internalCaretPos = (Integer)this.internalCaretPosition.getValue();
                    this.selectRange(internalCaretPos, internalCaretPos);
                }
            }
        });
        this.setFocusTraversable(true);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getStyleClass().add((Object)"styled-text-area");
        this.getStylesheets().add((Object)StyledTextArea.class.getResource("styled-text-area.css").toExternalForm());
        ObservableSet nonEmptyCells = FXCollections.observableSet((Object[])new ParagraphBox[0]);
        this.virtualFlow = VirtualFlow.createVertical(this.getParagraphs(), par -> {
            Cell cell = this.createCell((Paragraph<PS, SEG, S>)par, applyParagraphStyle, nodeFactory);
            nonEmptyCells.add(cell.getNode());
            return cell.beforeReset(() -> nonEmptyCells.remove(cell.getNode())).afterUpdateItem(p -> nonEmptyCells.add(cell.getNode()));
        });
        this.getChildren().add(this.virtualFlow);
        IntSupplier cellCount = () -> this.getParagraphs().size();
        IntUnaryOperator cellLength = i -> this.virtualFlow.getCell(i).getNode().getLineCount();
        this.navigator = new TwoLevelNavigator(cellCount, cellLength);
        EventStream<Void> popupAlignmentDirty = EventStreams.invalidationsOf(this.popupAlignmentProperty());
        EventStream<Void> popupAnchorAdjustmentDirty = EventStreams.invalidationsOf(this.popupAnchorAdjustmentProperty());
        EventStream<Void> popupAnchorOffsetDirty = EventStreams.invalidationsOf(this.popupAnchorOffsetProperty());
        EventStream popupDirty = EventStreams.merge(popupAlignmentDirty, popupAnchorAdjustmentDirty, popupAnchorOffsetDirty);
        this.subscribeTo(popupDirty, x -> this.layoutPopup());
        EventStream<Void> caretPosDirty = EventStreams.invalidationsOf(this.caretPositionProperty());
        EventStream<Void> paragraphsDirty = EventStreams.invalidationsOf((Observable)this.getParagraphs());
        EventStream<Void> selectionDirty = EventStreams.invalidationsOf(this.selectionProperty());
        EventStream caretDirty = EventStreams.merge(caretPosDirty, paragraphsDirty, selectionDirty);
        EventStream blinkCaret = EventStreams.valuesOf(this.showCaretProperty()).flatMap(mode -> {
            switch (mode) {
                case ON: {
                    return EventStreams.valuesOf(Val.constant(true));
                }
                case OFF: {
                    return EventStreams.valuesOf(Val.constant(false));
                }
            }
            return EventStreams.valuesOf(this.focusedProperty().and((ObservableBooleanValue)this.editableProperty()).and((ObservableBooleanValue)this.disabledProperty().not()));
        });
        EventStream<Duration> blinkRate = EventStreams.valuesOf(this.caretBlinkRate);
        this.caretVisible = EventStreams.combine(blinkCaret, blinkRate).flatMap(tuple -> {
            Boolean blink = (Boolean)tuple.get1();
            Duration rate = (Duration)tuple.get2();
            if (blink.booleanValue()) {
                return rate.lessThanOrEqualTo(Duration.ZERO) ? EventStreams.valuesOf(Val.constant(true)) : GenericStyledArea.booleanPulse(rate, caretDirty);
            }
            return EventStreams.valuesOf(Val.constant(false));
        }).toBinding(false);
        this.manageBinding(this.caretVisible);
        this.viewportDirty = EventStreams.merge(EventStreams.invalidationsOf((Observable)this.scaleXProperty()), EventStreams.invalidationsOf((Observable)this.scaleYProperty()), EventStreams.invalidationsOf(this.estimatedScrollXProperty()), EventStreams.invalidationsOf(this.estimatedScrollYProperty())).suppressible();
        EventStream caretBoundsDirty = EventStreams.merge(this.viewportDirty, caretDirty).suppressWhen((ObservableValue<Boolean>)this.beingUpdatedProperty());
        EventStream selectionBoundsDirty = EventStreams.merge(this.viewportDirty, EventStreams.invalidationsOf(this.selectionProperty())).suppressWhen((ObservableValue<Boolean>)this.beingUpdatedProperty());
        this.caretBounds = Val.create(this::getCaretBoundsOnScreen, caretBoundsDirty);
        this.selectionBounds = Val.create(this::impl_bounds_getSelectionBoundsOnScreen, selectionBoundsDirty);
        Val<UnaryOperator> userOffset = Val.map(this.popupAnchorOffsetProperty(), offset -> anchor -> anchor.add(offset));
        this._popupAnchorAdjustment = Val.orElse(this.popupAnchorAdjustmentProperty(), userOffset).orElseConst(UnaryOperator.identity());
        EventStreams.valuesOf(this.mouseOverTextDelayProperty()).flatMap(delay -> delay != null ? this.mouseOverTextEvents((ObservableSet<ParagraphBox<PS, SEG, S>>)nonEmptyCells, (java.time.Duration)delay) : EventStreams.never()).subscribe(evt -> Event.fireEvent((EventTarget)this, (Event)evt));
        new StyledTextAreaBehavior(this);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
        styleables.add(this.highlightFill.getCssMetaData());
        styleables.add(this.highlightTextFill.getCssMetaData());
        styleables.add(this.caretBlinkRate.getCssMetaData());
        return styleables;
    }

    Optional<Bounds> getCaretBoundsInViewport() {
        return this.virtualFlow.getCellIfVisible(this.getCurrentParagraph()).map(c -> {
            Bounds cellBounds = ((ParagraphBox)((Object)((Object)c.getNode()))).getCaretBounds();
            return this.virtualFlow.cellToViewport((Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>)c, cellBounds);
        });
    }

    ParagraphBox.CaretOffsetX getCaretOffsetX() {
        int idx = this.getCurrentParagraph();
        return this.getCell(idx).getCaretOffsetX();
    }

    double getViewportHeight() {
        return this.virtualFlow.getHeight();
    }

    CharacterHit hit(ParagraphBox.CaretOffsetX x, TwoDimensional.Position targetLine) {
        int parIdx = targetLine.getMajor();
        ParagraphBox<PS, SEG, S> cell = this.virtualFlow.getCell(parIdx).getNode();
        CharacterHit parHit = cell.hitTextLine(x, targetLine.getMinor());
        return parHit.offset(this.getParagraphOffset(parIdx));
    }

    CharacterHit hit(ParagraphBox.CaretOffsetX x, double y) {
        VirtualFlowHit<Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>> hit = this.virtualFlow.hit(0.0, y);
        if (hit.isBeforeCells()) {
            return CharacterHit.insertionAt(0);
        }
        if (hit.isAfterCells()) {
            return CharacterHit.insertionAt(this.getLength());
        }
        int parIdx = hit.getCellIndex();
        int parOffset = this.getParagraphOffset(parIdx);
        ParagraphBox<PS, SEG, S> cell = hit.getCell().getNode();
        Point2D cellOffset = hit.getCellOffset();
        CharacterHit parHit = cell.hitText(x, cellOffset.getY());
        return parHit.offset(parOffset);
    }

    @Override
    public CharacterHit hit(double x, double y) {
        VirtualFlowHit<Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>> hit = this.virtualFlow.hit(x, y);
        if (hit.isBeforeCells()) {
            return CharacterHit.insertionAt(0);
        }
        if (hit.isAfterCells()) {
            return CharacterHit.insertionAt(this.getLength());
        }
        int parIdx = hit.getCellIndex();
        int parOffset = this.getParagraphOffset(parIdx);
        ParagraphBox<PS, SEG, S> cell = hit.getCell().getNode();
        Point2D cellOffset = hit.getCellOffset();
        CharacterHit parHit = cell.hit(cellOffset);
        return parHit.offset(parOffset);
    }

    TwoDimensional.Position currentLine() {
        int parIdx = this.getCurrentParagraph();
        Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell = this.virtualFlow.getCell(parIdx);
        int lineIdx = cell.getNode().getCurrentLineIndex();
        return this._position(parIdx, lineIdx);
    }

    TwoDimensional.Position _position(int par, int line) {
        return this.navigator.position(par, line);
    }

    @Override
    public int getParagraphLinesCount(int paragraphIndex) {
        return this.virtualFlow.getCell(paragraphIndex).getNode().getLineCount();
    }

    @Override
    public Optional<Bounds> getCharacterBoundsOnScreen(int from, int to) {
        TwoDimensional.Position endPosition;
        int endRow;
        if (from < 0) {
            throw new IllegalArgumentException("From is negative: " + from);
        }
        if (from > to) {
            throw new IllegalArgumentException(String.format("From is greater than to. from=%s to=%s", from, to));
        }
        if (to > this.getLength()) {
            throw new IllegalArgumentException(String.format("To is greater than area's length. length=%s, to=%s", this.getLength(), to));
        }
        if (this.getText(from, to).equals("\n")) {
            return Optional.empty();
        }
        int realFrom = this.getText(from, from + 1).equals("\n") ? from + 1 : from;
        TwoDimensional.Position startPosition = this.offsetToPosition(realFrom, TwoDimensional.Bias.Forward);
        int startRow = startPosition.getMajor();
        if (startRow == (endRow = (endPosition = startPosition.offsetBy(to - realFrom, TwoDimensional.Bias.Forward)).getMajor())) {
            return this.getRangeBoundsOnScreen(startRow, startPosition.getMinor(), endPosition.getMinor());
        }
        Optional<Bounds> rangeBounds = this.getRangeBoundsOnScreen(startRow, startPosition.getMinor(), this.getParagraph(startRow).length());
        for (int i = startRow + 1; i <= endRow; ++i) {
            Optional<Bounds> nextLineBounds = this.getRangeBoundsOnScreen(i, 0, i == endRow ? endPosition.getMinor() : this.getParagraph(i).length());
            if (!nextLineBounds.isPresent()) continue;
            if (rangeBounds.isPresent()) {
                Bounds lineBounds = nextLineBounds.get();
                rangeBounds = rangeBounds.map(b -> {
                    double minX = Math.min(b.getMinX(), lineBounds.getMinX());
                    double minY = Math.min(b.getMinY(), lineBounds.getMinY());
                    double maxX = Math.max(b.getMaxX(), lineBounds.getMaxX());
                    double maxY = Math.max(b.getMaxY(), lineBounds.getMaxY());
                    return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
                });
                continue;
            }
            rangeBounds = nextLineBounds;
        }
        return rangeBounds;
    }

    @Override
    public final String getText(int start, int end) {
        return this.content.getText(start, end);
    }

    @Override
    public String getText(int paragraph) {
        return this.content.getText(paragraph);
    }

    public Paragraph<PS, SEG, S> getParagraph(int index) {
        return this.content.getParagraph(index);
    }

    public int getParagraphLenth(int index) {
        return this.content.getParagraphLength(index);
    }

    @Override
    public StyledDocument<PS, SEG, S> subDocument(int start, int end) {
        return this.content.subSequence(start, end);
    }

    @Override
    public StyledDocument<PS, SEG, S> subDocument(int paragraphIndex) {
        return this.content.subDocument(paragraphIndex);
    }

    public IndexRange getParagraphSelection(int paragraph) {
        int startPar = this.selectionStart2D.getMajor();
        int endPar = this.selectionEnd2D.getMajor();
        if (paragraph < startPar || paragraph > endPar) {
            return EMPTY_RANGE;
        }
        int start = paragraph == startPar ? this.selectionStart2D.getMinor() : 0;
        int end = paragraph == endPar ? this.selectionEnd2D.getMinor() : this.getParagraphLenth(paragraph);
        this.getSelection();
        return new IndexRange(start, end);
    }

    @Override
    public S getStyleOfChar(int index) {
        return this.content.getStyleOfChar(index);
    }

    @Override
    public S getStyleAtPosition(int position) {
        return this.content.getStyleAtPosition(position);
    }

    @Override
    public IndexRange getStyleRangeAtPosition(int position) {
        return this.content.getStyleRangeAtPosition(position);
    }

    @Override
    public StyleSpans<S> getStyleSpans(int from, int to) {
        return this.content.getStyleSpans(from, to);
    }

    @Override
    public S getStyleOfChar(int paragraph, int index) {
        return this.content.getStyleOfChar(paragraph, index);
    }

    @Override
    public S getStyleAtPosition(int paragraph, int position) {
        return this.content.getStyleAtPosition(paragraph, position);
    }

    @Override
    public IndexRange getStyleRangeAtPosition(int paragraph, int position) {
        return this.content.getStyleRangeAtPosition(paragraph, position);
    }

    @Override
    public StyleSpans<S> getStyleSpans(int paragraph) {
        return this.content.getStyleSpans(paragraph);
    }

    @Override
    public StyleSpans<S> getStyleSpans(int paragraph, int from, int to) {
        return this.content.getStyleSpans(paragraph, from, to);
    }

    @Override
    public int getAbsolutePosition(int paragraphIndex, int columnIndex) {
        return this.content.getAbsolutePosition(paragraphIndex, columnIndex);
    }

    @Override
    public TwoDimensional.Position position(int row, int col) {
        return this.content.position(row, col);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int charOffset, TwoDimensional.Bias bias) {
        return this.content.offsetToPosition(charOffset, bias);
    }

    @Override
    public void scrollBy(Point2D deltas) {
        this.virtualFlow.scrollXBy(deltas.getX());
        this.virtualFlow.scrollYBy(deltas.getY());
    }

    void show(double y) {
        this.virtualFlow.show(y);
    }

    @Override
    public void showParagraphInViewport(int paragraphIndex) {
        this.virtualFlow.show(paragraphIndex);
    }

    @Override
    public void showParagraphAtTop(int paragraphIndex) {
        this.virtualFlow.showAsFirst(paragraphIndex);
    }

    @Override
    public void showParagraphAtBottom(int paragraphIndex) {
        this.virtualFlow.showAsLast(paragraphIndex);
    }

    void showCaretAtBottom() {
        int parIdx = this.getCurrentParagraph();
        Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell = this.virtualFlow.getCell(parIdx);
        Bounds caretBounds = cell.getNode().getCaretBounds();
        double y = caretBounds.getMaxY();
        this.virtualFlow.showAtOffset(parIdx, this.getViewportHeight() - y);
    }

    void showCaretAtTop() {
        int parIdx = this.getCurrentParagraph();
        Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell = this.virtualFlow.getCell(parIdx);
        Bounds caretBounds = cell.getNode().getCaretBounds();
        double y = caretBounds.getMinY();
        this.virtualFlow.showAtOffset(parIdx, -y);
    }

    @Override
    public void requestFollowCaret() {
        this.followCaretRequested = true;
        this.requestLayout();
    }

    private void followCaret() {
        int parIdx = this.getCurrentParagraph();
        Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell = this.virtualFlow.getCell(parIdx);
        Bounds caretBounds = cell.getNode().getCaretBounds();
        double graphicWidth = cell.getNode().getGraphicPrefWidth();
        Bounds region = GenericStyledArea.extendLeft(caretBounds, graphicWidth);
        this.virtualFlow.show(parIdx, region);
    }

    @Override
    public void lineStart(NavigationActions.SelectionPolicy policy) {
        int columnPos = this.virtualFlow.getCell(this.getCurrentParagraph()).getNode().getCurrentLineStartPosition();
        this.moveTo(this.getCurrentParagraph(), columnPos, policy);
    }

    @Override
    public void lineEnd(NavigationActions.SelectionPolicy policy) {
        int columnPos = this.virtualFlow.getCell(this.getCurrentParagraph()).getNode().getCurrentLineEndPosition();
        this.moveTo(this.getCurrentParagraph(), columnPos, policy);
    }

    @Override
    public void selectLine() {
        this.lineStart(NavigationActions.SelectionPolicy.CLEAR);
        this.lineEnd(NavigationActions.SelectionPolicy.ADJUST);
    }

    @Override
    public void prevPage(NavigationActions.SelectionPolicy selectionPolicy) {
        this.showCaretAtBottom();
        CharacterHit hit = this.hit(this.getTargetCaretOffset(), 1.0);
        this.moveTo(hit.getInsertionIndex(), selectionPolicy);
    }

    @Override
    public void nextPage(NavigationActions.SelectionPolicy selectionPolicy) {
        this.showCaretAtTop();
        CharacterHit hit = this.hit(this.getTargetCaretOffset(), this.getViewportHeight() - 1.0);
        this.moveTo(hit.getInsertionIndex(), selectionPolicy);
    }

    public void displaceCaret(int pos) {
        try (Guard g = this.suspend(this.caretPosition, this.currentParagraph, this.caretColumn);){
            this.internalCaretPosition.setValue(pos);
        }
    }

    public final void hideContextMenu() {
        ContextMenu menu = this.getContextMenu();
        if (menu != null && menu.isShowing()) {
            menu.hide();
        }
    }

    @Override
    public void setStyle(int from, int to, S style) {
        this.content.setStyle(from, to, style);
    }

    @Override
    public void setStyle(int paragraph, S style) {
        this.content.setStyle(paragraph, style);
    }

    @Override
    public void setStyle(int paragraph, int from, int to, S style) {
        this.content.setStyle(paragraph, from, to, style);
    }

    @Override
    public void setStyleSpans(int from, StyleSpans<? extends S> styleSpans) {
        this.content.setStyleSpans(from, styleSpans);
    }

    @Override
    public void setStyleSpans(int paragraph, int from, StyleSpans<? extends S> styleSpans) {
        this.content.setStyleSpans(paragraph, from, styleSpans);
    }

    @Override
    public void setParagraphStyle(int paragraph, PS paragraphStyle) {
        this.content.setParagraphStyle(paragraph, paragraphStyle);
    }

    @Override
    public void replaceText(int start, int end, String text) {
        ReadOnlyStyledDocument<PS, SEG, S> doc = ReadOnlyStyledDocument.fromString(text, this.getParagraphStyleForInsertionAt(start), this.getStyleForInsertionAt(start), this.segmentOps);
        this.replace(start, end, doc);
    }

    @Override
    public void replace(int start, int end, StyledDocument<PS, SEG, S> replacement) {
        this.content.replace(start, end, replacement);
        int newCaretPos = start + replacement.length();
        this.selectRange(newCaretPos, newCaretPos);
    }

    @Override
    public void selectRange(int anchor, int caretPosition) {
        try (Guard g = this.suspend(this.caretPosition, this.currentParagraph, this.caretColumn, this.anchor, this.selection, this.selectedText);){
            this.internalCaretPosition.setValue(GenericStyledArea.clamp(0, caretPosition, this.getLength()));
            this.anchor.setValue(GenericStyledArea.clamp(0, anchor, this.getLength()));
            this.internalSelection.setValue(IndexRange.normalize((int)this.getAnchor(), (int)this.getCaretPosition()));
        }
    }

    public void dispose() {
        this.subscriptions.unsubscribe();
        this.virtualFlow.dispose();
    }

    protected void layoutChildren() {
        this.virtualFlow.resize(this.getWidth(), this.getHeight());
        if (this.followCaretRequested) {
            this.followCaretRequested = false;
            try (Guard g = this.viewportDirty.suspend();){
                this.followCaret();
            }
        }
        this.layoutPopup();
    }

    private Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> createCell(Paragraph<PS, SEG, S> paragraph, BiConsumer<TextFlow, PS> applyParagraphStyle, Function<SEG, Node> nodeFactory) {
        final ParagraphBox box = new ParagraphBox(paragraph, applyParagraphStyle, nodeFactory);
        box.highlightFillProperty().bind(this.highlightFill);
        box.highlightTextFillProperty().bind(this.highlightTextFill);
        box.wrapTextProperty().bind((ObservableValue)this.wrapTextProperty());
        box.graphicFactoryProperty().bind(this.paragraphGraphicFactoryProperty());
        box.graphicOffset.bind(this.virtualFlow.breadthOffsetProperty());
        Val<Boolean> hasCaret = Val.combine(box.indexProperty(), this.currentParagraphProperty(), (bi, cp) -> bi.intValue() == cp.intValue());
        final Subscription hasCaretPseudoClass = hasCaret.values().subscribe(value -> box.pseudoClassStateChanged(HAS_CARET, (boolean)value));
        final Subscription firstParPseudoClass = box.indexProperty().values().subscribe(idx -> box.pseudoClassStateChanged(FIRST_PAR, idx == 0));
        final Subscription lastParPseudoClass = EventStreams.combine(box.indexProperty().values(), this.getParagraphs().sizeProperty().values()).subscribe(in -> in.exec((i, n) -> box.pseudoClassStateChanged(LAST_PAR, i == n - 1)));
        Val cellCaretVisible = hasCaret.flatMap(x -> x != false ? this.caretVisible : Val.constant(false));
        box.caretVisibleProperty().bind(cellCaretVisible);
        box.caretPositionProperty().bind(hasCaret.flatMap(has -> has != false ? this.caretColumnProperty() : Val.constant(0)));
        final ObjectBinding cellSelection = Bindings.createObjectBinding(() -> {
            int idx = box.getIndex();
            return idx != -1 ? this.getParagraphSelection(idx) : StyledTextArea.EMPTY_RANGE;
        }, (Observable[])new Observable[]{this.selectionProperty(), box.indexProperty()});
        box.selectionProperty().bind((ObservableValue)cellSelection);
        return new Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>(){

            @Override
            public ParagraphBox<PS, SEG, S> getNode() {
                return box;
            }

            @Override
            public void updateIndex(int index) {
                box.setIndex(index);
            }

            @Override
            public void dispose() {
                box.highlightFillProperty().unbind();
                box.highlightTextFillProperty().unbind();
                box.wrapTextProperty().unbind();
                box.graphicFactoryProperty().unbind();
                box.graphicOffset.unbind();
                hasCaretPseudoClass.unsubscribe();
                firstParPseudoClass.unsubscribe();
                lastParPseudoClass.unsubscribe();
                box.caretVisibleProperty().unbind();
                box.caretPositionProperty().unbind();
                box.selectionProperty().unbind();
                cellSelection.dispose();
            }
        };
    }

    private ParagraphBox<PS, SEG, S> getCell(int index) {
        return this.virtualFlow.getCell(index).getNode();
    }

    private EventStream<MouseOverTextEvent> mouseOverTextEvents(ObservableSet<ParagraphBox<PS, SEG, S>> cells, java.time.Duration delay) {
        return EventStreams.merge(cells, c -> c.stationaryIndices(delay).map(e -> e.unify(l -> l.map((pos, charIdx) -> MouseOverTextEvent.beginAt(c.localToScreen((Point2D)pos), this.getParagraphOffset(c.getIndex()) + charIdx)), r -> MouseOverTextEvent.end())));
    }

    private int getParagraphOffset(int parIdx) {
        return this.position(parIdx, 0).toOffset();
    }

    private void layoutPopup() {
        PopupWindow popup = this.getPopupWindow();
        PopupAlignment alignment = this.getPopupAlignment();
        UnaryOperator adjustment = (UnaryOperator)this._popupAnchorAdjustment.getValue();
        if (popup != null) {
            this.positionPopup(popup, alignment, adjustment);
        }
    }

    private void positionPopup(PopupWindow popup, PopupAlignment alignment, UnaryOperator<Point2D> adjustment) {
        Optional<Bounds> bounds = null;
        switch (alignment.getAnchorObject()) {
            case CARET: {
                bounds = this.getCaretBoundsOnScreen();
                break;
            }
            case SELECTION: {
                bounds = this.impl_popup_getSelectionBoundsOnScreen();
            }
        }
        bounds.ifPresent(b -> {
            double x = 0.0;
            double y = 0.0;
            switch (alignment.getHorizontalAlignment()) {
                case LEFT: {
                    x = b.getMinX();
                    break;
                }
                case H_CENTER: {
                    x = (b.getMinX() + b.getMaxX()) / 2.0;
                    break;
                }
                case RIGHT: {
                    x = b.getMaxX();
                }
            }
            switch (alignment.getVerticalAlignment()) {
                case TOP: {
                    y = b.getMinY();
                }
                case V_CENTER: {
                    y = (b.getMinY() + b.getMaxY()) / 2.0;
                    break;
                }
                case BOTTOM: {
                    y = b.getMaxY();
                }
            }
            Point2D anchor = (Point2D)adjustment.apply(new Point2D(x, y));
            popup.setAnchorX(anchor.getX());
            popup.setAnchorY(anchor.getY());
        });
    }

    private Optional<Bounds> getRangeBoundsOnScreen(int paragraphIndex, int from, int to) {
        return this.virtualFlow.getCellIfVisible(paragraphIndex).map(c -> ((ParagraphBox)((Object)((Object)c.getNode()))).getRangeBoundsOnScreen(from, to));
    }

    private Optional<Bounds> getCaretBoundsOnScreen() {
        return this.virtualFlow.getCellIfVisible(this.getCurrentParagraph()).map(c -> ((ParagraphBox)((Object)((Object)c.getNode()))).getCaretBoundsOnScreen());
    }

    private Optional<Bounds> impl_popup_getSelectionBoundsOnScreen() {
        IndexRange selection = this.getSelection();
        if (selection.getLength() == 0) {
            return this.getCaretBoundsOnScreen();
        }
        return this.impl_getSelectionBoundsOnScreen();
    }

    private Optional<Bounds> impl_bounds_getSelectionBoundsOnScreen() {
        IndexRange selection = this.getSelection();
        if (selection.getLength() == 0) {
            return Optional.empty();
        }
        return this.impl_getSelectionBoundsOnScreen();
    }

    private Optional<Bounds> impl_getSelectionBoundsOnScreen() {
        Bounds[] bounds = (Bounds[])this.virtualFlow.visibleCells().stream().map(c -> ((ParagraphBox)((Object)((Object)c.getNode()))).getSelectionBoundsOnScreen()).filter(Optional::isPresent).map(Optional::get).toArray(Bounds[]::new);
        if (bounds.length == 0) {
            return Optional.empty();
        }
        double minX = Stream.of(bounds).mapToDouble(Bounds::getMinX).min().getAsDouble();
        double maxX = Stream.of(bounds).mapToDouble(Bounds::getMaxX).max().getAsDouble();
        double minY = Stream.of(bounds).mapToDouble(Bounds::getMinY).min().getAsDouble();
        double maxY = Stream.of(bounds).mapToDouble(Bounds::getMaxY).max().getAsDouble();
        return Optional.of(new BoundingBox(minX, minY, maxX - minX, maxY - minY));
    }

    private <T> void subscribeTo(EventStream<T> src, Consumer<T> cOnsumer) {
        this.manageSubscription(src.subscribe(cOnsumer));
    }

    private void manageSubscription(Subscription subscription) {
        this.subscriptions = this.subscriptions.and(subscription);
    }

    private void manageBinding(Binding<?> binding) {
        this.subscriptions = this.subscriptions.and(() -> binding.dispose());
    }

    private static Bounds extendLeft(Bounds b, double w) {
        if (w == 0.0) {
            return b;
        }
        return new BoundingBox(b.getMinX() - w, b.getMinY(), b.getWidth() + w, b.getHeight());
    }

    private S getStyleForInsertionAt(int pos) {
        if (this.useInitialStyleForInsertion.get()) {
            return this.initialTextStyle;
        }
        return this.content.getStyleAtPosition(pos);
    }

    private PS getParagraphStyleForInsertionAt(int pos) {
        if (this.useInitialStyleForInsertion.get()) {
            return this.initialParagraphStyle;
        }
        return this.content.getParagraphStyleAtPosition(pos);
    }

    private UndoManager createPlainUndoManager(UndoManagerFactory factory) {
        Consumer<PlainTextChange> apply = change -> this.replaceText(change.getPosition(), change.getPosition() + ((String)change.getRemoved()).length(), (String)change.getInserted());
        BiFunction<PlainTextChange, PlainTextChange, Optional> merge = TextChange::mergeWith;
        return factory.create(this.plainTextChanges(), TextChange::invert, apply, merge);
    }

    private UndoManager createRichUndoManager(UndoManagerFactory factory) {
        Consumer<RichTextChange> apply = change -> this.replace(change.getPosition(), change.getPosition() + ((StyledDocument)change.getRemoved()).length(), (StyledDocument)change.getInserted());
        BiFunction<RichTextChange, RichTextChange, Optional> merge = TextChange::mergeWith;
        return factory.create(this.richChanges(), TextChange::invert, apply, merge);
    }

    private Guard suspend(Suspendable ... suspendables) {
        return Suspendable.combine(this.beingUpdated, Suspendable.combine(suspendables)).suspend();
    }

    void clearTargetCaretOffset() {
        this.targetCaretOffset = Optional.empty();
    }

    ParagraphBox.CaretOffsetX getTargetCaretOffset() {
        if (!this.targetCaretOffset.isPresent()) {
            this.targetCaretOffset = Optional.of(this.getCaretOffsetX());
        }
        return this.targetCaretOffset.get();
    }

    private static EventStream<Boolean> booleanPulse(Duration javafxDuration, EventStream<?> restartImpulse) {
        java.time.Duration duration = java.time.Duration.ofMillis(Math.round(javafxDuration.toMillis()));
        EventStream<?> ticks = EventStreams.restartableTicks(duration, restartImpulse);
        return StateMachine.init(false).on(restartImpulse.withDefaultEvent(null)).transition((state, impulse) -> true).on(ticks).transition((state, tick) -> state == false).toStateStream();
    }

    @Deprecated
    public void setPopupWindow(PopupWindow popup) {
        this.popupWindow.set((Object)popup);
    }

    @Deprecated
    public PopupWindow getPopupWindow() {
        return (PopupWindow)this.popupWindow.get();
    }

    @Deprecated
    public ObjectProperty<PopupWindow> popupWindowProperty() {
        return this.popupWindow;
    }

    @Deprecated
    public void setPopupAtCaret(PopupWindow popup) {
        this.popupWindow.set((Object)popup);
    }

    @Deprecated
    public PopupWindow getPopupAtCaret() {
        return (PopupWindow)this.popupWindow.get();
    }

    @Deprecated
    public ObjectProperty<PopupWindow> popupAtCaretProperty() {
        return this.popupWindow;
    }

    @Deprecated
    public void setPopupAnchorOffset(Point2D offset) {
        this.popupAnchorOffset.set((Object)offset);
    }

    @Deprecated
    public Point2D getPopupAnchorOffset() {
        return (Point2D)this.popupAnchorOffset.get();
    }

    @Deprecated
    public ObjectProperty<Point2D> popupAnchorOffsetProperty() {
        return this.popupAnchorOffset;
    }

    @Deprecated
    public void setPopupAnchorAdjustment(UnaryOperator<Point2D> f) {
        this.popupAnchorAdjustment.set(f);
    }

    @Deprecated
    public UnaryOperator<Point2D> getPopupAnchorAdjustment() {
        return (UnaryOperator)this.popupAnchorAdjustment.get();
    }

    @Deprecated
    public ObjectProperty<UnaryOperator<Point2D>> popupAnchorAdjustmentProperty() {
        return this.popupAnchorAdjustment;
    }

    @Deprecated
    public void setPopupAlignment(PopupAlignment pos) {
        this.popupAlignment.set((Object)pos);
    }

    @Deprecated
    public PopupAlignment getPopupAlignment() {
        return (PopupAlignment)((Object)this.popupAlignment.get());
    }

    @Deprecated
    public ObjectProperty<PopupAlignment> popupAlignmentProperty() {
        return this.popupAlignment;
    }
}

