@echo off
rem  ------------------------ Apache Version 2.0 license -------------------------
rem     Copyright (C) 2001-2022 Rony G. Flatscher
rem
rem     Licensed under the Apache License, Version 2.0 (the "License")rem
rem     you may not use this file except in compliance with the License.
rem     You may obtain a copy of the License at
rem
rem         http://www.apache.org/licenses/LICENSE-2.0
rem
rem     Unless required by applicable law or agreed to in writing, software
rem     distributed under the License is distributed on an "AS IS" BASIS,
rem     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
rem     See the License for the specific language governing permissions and
rem     limitations under the License.
rem  -----------------------------------------------------------------------------
rem 2016-11-04, rgf: now basing BSF4ooRexx on Java 1.6/6.0
rem 2022-08-10, rgf: now basing BSF4ooRexx on Java 1.8/8.0

@echo on
@echo off
setlocal

rem set path2root=E:\rony\dev\bsf\src
set path2root=%cd%\..

rem set default path to org.rexxla.bsf, 2005-06-02, ---rgf
set path2engine=%path2root%\org\rexxla\bsf\engines\rexx
set path2jsr223=%path2root%\org\rexxla\bsf\engines\rexx

set path2rexxlaBsf=%path2root%\org\rexxla\bsf

set path2BsfSystemClipboard=%path2root%\org\rexxla\bsf\engines\rexx

rem rgf, 20140927: make sure that the extension jar is not picked up (if bsf4oorexx-jar got installed there)
set javacDefines=-Djava.ext.dirs=""
set target=-target 8
set source=-source 8
@rem baseline is Java 1.6/6 (decided during 2017 as earlier Java version deployments cannot be located anymore)
set javaBaseLine=-source 8   -target 8

@rem set java7=-source 1.7 -target 1.7  --> baseline is Java 8 use 'java8' instead as a result

rem default to Apache's BSF
set javaSrc=%cd%\source_java
echo Compiling for [%javaSrc%] ...

md %path2engine%
@echo off

echo path2root     =%path2root%
echo path2engine   =%path2engine%
echo path2rexxlaBsf=%path2rexxlaBsf%
echo javaSRc       =%javaSrc%

@echo on


@rem 2023-06-10: adding BsfSystemClipboard
@rem directory where "org" resides:                 %path2root%
@rem directory where the class files get placed to: %path2BsfSystemClipboard%
javac %javacDefines% %javaBaseLine%  %javaSrc%\BsfSystemClipboard.java
javac %javacDefines% %javaBaseLine%  -d %path2root% %javaSrc%\BsfSystemClipboard.java
copy %javaSrc%\BsfSystemClipboard.java %path2BsfSystemClipboard%



endlocal

