#!/usr/bin/env rexx
-- demonstrate ShellExecute method
    use arg case=1
    pgm = "rexx.exe"
    pgmArgs = "c:\Rexx\projects\elevate\two.rex"
    if case > 4 then do
        case -= 4
        pgm = "cmd.exe"
        pgmArgs = "/c" pgmArgs
    end
    select
        when case = 1 then do
            v = "open"
            dir = "c:\"
        end
        when case = 2 then do
            v = "open"
            dir = ""
        end
        when case = 3 then do
            v = "runas"
            dir = "c:\"
        end
        when case = 4 then do
            v = "runas"
            dir = ""
        end
        otherwise
            say "Value of case is unknown: ["case"]"
            "pause"
            exit
    end
    pgmArgs = pgmArgs v dir
    say "Running case" (arg(1) 1)~word(1)
    call charout , "Press Enter to launch two.rex..."
    pull .
    .OLEObject~New("Shell.Application")~ShellExecute(pgm, pgmArgs, dir, v)
    "pause"
    exit
/* Observations:  an ommitted working directory defaults to the directory of the
    program that launches it; when cmd.exe is invoked with runas, the working
    directory is ignored - always set to c:\windows\system32; when running
    cmd.exe, either /c or /k is needed before the program to be run or it is
    ignored */