/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.clock;

import eu.hansolo.enzo.clock.Clock;
import java.time.LocalTime;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;

public class ClockBuilder<B extends ClockBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected ClockBuilder() {
    }

    public static final ClockBuilder create() {
        return new ClockBuilder();
    }

    public final B text(String TEXT) {
        this.properties.put("text", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B nightMode(boolean NIGHT_MODE) {
        this.properties.put("nightMode", (Property)new SimpleBooleanProperty(NIGHT_MODE));
        return (B)this;
    }

    public final B design(Clock.Design DESIGN) {
        this.properties.put("design", (Property)new SimpleObjectProperty((Object)DESIGN));
        return (B)this;
    }

    public final B discreteSecond(boolean DISCRETE_SECOND) {
        this.properties.put("discreteSecond", (Property)new SimpleBooleanProperty(DISCRETE_SECOND));
        return (B)this;
    }

    public final B secondPointerVisible(boolean SECOND_POINTER_VISIBLE) {
        this.properties.put("secondPointerVisible", (Property)new SimpleBooleanProperty(SECOND_POINTER_VISIBLE));
        return (B)this;
    }

    public final B highlightVisible(boolean HIGHLIGHT_VISIBLE) {
        this.properties.put("highlightVisible", (Property)new SimpleBooleanProperty(HIGHLIGHT_VISIBLE));
        return (B)this;
    }

    public final B time(LocalTime TIME) {
        this.properties.put("dateTime", (Property)new SimpleObjectProperty((Object)TIME));
        return (B)this;
    }

    public final B running(boolean RUNNING) {
        this.properties.put("running", (Property)new SimpleBooleanProperty(RUNNING));
        return (B)this;
    }

    public final B autoNightMode(boolean AUTO_NIGHT_MODE) {
        this.properties.put("autoNightMode", (Property)new SimpleBooleanProperty(AUTO_NIGHT_MODE));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final Clock build() {
        Clock CONTROL = new Clock();
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("text".equals(key)) {
                CONTROL.setText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("nightMode".equals(key)) {
                CONTROL.setNightMode(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("design".equals(key)) {
                CONTROL.setDesign((Clock.Design)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("discreteSecond".equals(key)) {
                CONTROL.setDiscreteSecond(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("secondPointerVisible".equals(key)) {
                CONTROL.setSecondPointerVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("highlightVisible".equals(key)) {
                CONTROL.setHighlightVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("dateTime".equals(key)) {
                CONTROL.setTime((LocalTime)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("running".equals(key)) {
                CONTROL.setRunning(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"autoNightMode".equals(key)) continue;
            CONTROL.setAutoNightMode(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

