/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.gauge.SimpleGauge;
import eu.hansolo.enzo.gauge.SimpleGaugeBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class DemoSimpleGauge
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private SimpleGauge thermoMeter;
    private SimpleGauge wattMeter;
    private SimpleGauge energyMeter;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.thermoMeter = ((SimpleGaugeBuilder)SimpleGaugeBuilder.create().prefSize(400.0, 400.0)).sections(new Section(0.0, 16.66666, "0"), new Section(16.66666, 33.33333, "1"), new Section(33.33333, 50.0, "2"), new Section(50.0, 66.66666, "3"), new Section(66.66666, 83.33333, "4"), new Section(83.33333, 100.0, "5")).title("Temperature").unit("C").value(20.0).styleClass("green-to-red-6").build();
        this.wattMeter = ((SimpleGaugeBuilder)SimpleGaugeBuilder.create().prefSize(400.0, 400.0)).sections(new Section(0.0, 16.66666, "0"), new Section(16.66666, 33.33333, "1"), new Section(33.33333, 50.0, "2"), new Section(50.0, 66.66666, "3"), new Section(66.66666, 83.33333, "4"), new Section(83.33333, 100.0, "5")).unit("W").measuredRangeVisible(true).rangeFill(Color.rgb((int)0, (int)0, (int)200, (double)0.5)).styleClass("green-to-darkgreen-6").build();
        this.energyMeter = ((SimpleGaugeBuilder)SimpleGaugeBuilder.create().prefSize(400.0, 400.0)).sections(new Section(0.0, 10.0, "A++"), new Section(10.0, 20.0, "A+"), new Section(20.0, 30.0, "A"), new Section(30.0, 40.0, "B"), new Section(40.0, 50.0, "C"), new Section(50.0, 60.0, "D"), new Section(60.0, 70.0, "E"), new Section(70.0, 80.0, "F"), new Section(80.0, 90.0, "G"), new Section(90.0, 100.0, "H")).sectionTextVisible(true).unit("W").styleClass("green-to-red-10").build();
        this.lastTimerCall = System.nanoTime() + 2000000000L;
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > DemoSimpleGauge.this.lastTimerCall + 5000000000L) {
                    DemoSimpleGauge.this.thermoMeter.setValue(RND.nextDouble() * 100.0);
                    DemoSimpleGauge.this.wattMeter.setValue(RND.nextDouble() * 100.0);
                    DemoSimpleGauge.this.energyMeter.setValue(RND.nextDouble() * 100.0);
                    DemoSimpleGauge.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) throws Exception {
        HBox pane = new HBox();
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.setSpacing(10.0);
        pane.getChildren().addAll((Object[])new Node[]{this.thermoMeter, this.wattMeter, this.energyMeter});
        Scene scene = new Scene((Parent)pane, (Paint)Color.BLACK);
        stage.setTitle("SimpleGauge");
        stage.setScene(scene);
        stage.show();
        this.wattMeter.setValue(50.0);
        this.timer.start();
        DemoSimpleGauge.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoSimpleGauge.calcNoOfNodes(n);
            }
        }
    }
}

