/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge.skin;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.RadialGauge;
import java.time.Instant;
import java.util.Locale;
import java.util.stream.IntStream;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class RadialGaugeSkin
extends SkinBase<RadialGauge>
implements Skin<RadialGauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double oldValue;
    private double size;
    private Pane pane;
    private Region background;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Region ledFrame;
    private Region ledMain;
    private Region ledHl;
    private Region needle;
    private Region needleHighlight;
    private Rotate needleRotate;
    private Region knob;
    private Group shadowGroup;
    private DropShadow dropShadow;
    private InnerShadow innerShadow;
    private DropShadow glow;
    private Text titleText;
    private Text unitText;
    private Text valueText;
    private double angleStep;
    private Timeline timeline;
    private String limitString;
    private Instant lastCall;
    private boolean withinSpeedLimit;
    private double interactiveAngle;

    public RadialGaugeSkin(RadialGauge gauge) {
        super((Control)gauge);
        this.angleStep = gauge.getAngleRange() / (gauge.getMaxValue() - gauge.getMinValue());
        this.timeline = new Timeline();
        this.oldValue = ((RadialGauge)this.getSkinnable()).getValue();
        this.limitString = "";
        this.lastCall = Instant.now();
        this.withinSpeedLimit = true;
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if ((Double.compare(((RadialGauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((RadialGauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((RadialGauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((RadialGauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((RadialGauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((RadialGauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((RadialGauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((RadialGauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((RadialGauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((RadialGauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((RadialGauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((RadialGauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((RadialGauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.ticksAndSectionsCanvas = new Canvas(250.0, 250.0);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 8.0, 0.0, 0.0, 0.0);
        this.glow = new DropShadow(BlurType.TWO_PASS_BOX, ((RadialGauge)this.getSkinnable()).getLedColor(), 20.0, 0.0, 0.0, 0.0);
        this.glow.setInput((Effect)this.innerShadow);
        this.ledFrame = new Region();
        this.ledFrame.getStyleClass().setAll((Object[])new String[]{"led-frame"});
        this.ledMain = new Region();
        this.ledMain.getStyleClass().setAll((Object[])new String[]{"led-main"});
        this.ledMain.setStyle("-led-color: " + this.colorToCss(((RadialGauge)this.getSkinnable()).getLedColor()) + ";");
        this.ledHl = new Region();
        this.ledHl.getStyleClass().setAll((Object[])new String[]{"led-hl"});
        this.needle = new Region();
        this.needle.getStyleClass().setAll((Object[])new String[]{RadialGauge.STYLE_CLASS_NEEDLE_STANDARD});
        this.needleRotate = new Rotate(180.0 - ((RadialGauge)this.getSkinnable()).getStartAngle());
        this.needleRotate.setAngle(this.needleRotate.getAngle() + (((RadialGauge)this.getSkinnable()).getValue() - this.oldValue - ((RadialGauge)this.getSkinnable()).getMinValue()) * this.angleStep);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needleHighlight = new Region();
        this.needleHighlight.setMouseTransparent(true);
        this.needleHighlight.getStyleClass().setAll((Object[])new String[]{"needle-highlight"});
        this.needleHighlight.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.knob = new Region();
        this.knob.setPickOnBounds(false);
        this.knob.getStyleClass().setAll((Object[])new String[]{"knob"});
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.75);
        this.dropShadow.setOffsetY(3.75);
        this.shadowGroup = new Group(new Node[]{this.needle, this.needleHighlight, this.knob});
        this.shadowGroup.setEffect((Effect)(((RadialGauge)this.getSkinnable()).isDropShadowEnabled() ? this.dropShadow : null));
        this.titleText = new Text(((RadialGauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.getStyleClass().setAll((Object[])new String[]{"title"});
        this.unitText = new Text(((RadialGauge)this.getSkinnable()).getUnit());
        this.unitText.setMouseTransparent(true);
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.valueText = new Text(String.format(Locale.US, "%." + ((RadialGauge)this.getSkinnable()).getDecimals() + "f", ((RadialGauge)this.getSkinnable()).getValue()));
        this.valueText.setMouseTransparent(true);
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.getStyleClass().setAll((Object[])new String[]{"value"});
        this.angleStep = ((RadialGauge)this.getSkinnable()).getAngleRange() / (((RadialGauge)this.getSkinnable()).getMaxValue() - ((RadialGauge)this.getSkinnable()).getMinValue());
        double targetAngle = 180.0 - ((RadialGauge)this.getSkinnable()).getStartAngle() + (((RadialGauge)this.getSkinnable()).getValue() - ((RadialGauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        targetAngle = this.clamp(180.0 - ((RadialGauge)this.getSkinnable()).getStartAngle(), 180.0 - ((RadialGauge)this.getSkinnable()).getStartAngle() + ((RadialGauge)this.getSkinnable()).getAngleRange(), targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.ticksAndSectionsCanvas, this.titleText, this.ledFrame, this.ledMain, this.ledHl, this.unitText, this.valueText, this.shadowGroup});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((RadialGauge)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((RadialGauge)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((RadialGauge)this.getSkinnable()).ledOnProperty().addListener(observable -> this.ledMain.setEffect((Effect)(((RadialGauge)this.getSkinnable()).isLedOn() ? this.glow : this.innerShadow)));
        ((RadialGauge)this.getSkinnable()).ledColorProperty().addListener(observable -> this.handleControlPropertyChanged("LED_COLOR"));
        ((RadialGauge)this.getSkinnable()).ledVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((RadialGauge)this.getSkinnable()).tickLabelOrientationProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((RadialGauge)this.getSkinnable()).tickLabelFillProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((RadialGauge)this.getSkinnable()).tickMarkFillProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((RadialGauge)this.getSkinnable()).needleColorProperty().addListener(observable -> this.handleControlPropertyChanged("NEEDLE_COLOR"));
        ((RadialGauge)this.getSkinnable()).animatedProperty().addListener(observable -> this.handleControlPropertyChanged("ANIMATED"));
        ((RadialGauge)this.getSkinnable()).angleRangeProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE_RANGE"));
        ((RadialGauge)this.getSkinnable()).numberFormatProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((RadialGauge)this.getSkinnable()).dropShadowEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("DROP_SHADOW"));
        ((RadialGauge)this.getSkinnable()).getSections().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((RadialGauge)this.getSkinnable()).getAreas().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((RadialGauge)this.getSkinnable()).valueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.withinSpeedLimit = !Instant.now().minusMillis((long)((RadialGauge)this.getSkinnable()).getAnimationDuration()).isBefore(this.lastCall);
            this.lastCall = Instant.now();
            this.oldValue = OLD_VALUE.doubleValue();
            this.rotateNeedle();
        });
        ((RadialGauge)this.getSkinnable()).minValueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStep = ((RadialGauge)this.getSkinnable()).getAngleRange() / (((RadialGauge)this.getSkinnable()).getMaxValue() - NEW_VALUE.doubleValue());
            this.needleRotate.setAngle(180.0 - ((RadialGauge)this.getSkinnable()).getStartAngle() + (((RadialGauge)this.getSkinnable()).getValue() - NEW_VALUE.doubleValue()) * this.angleStep);
            if (((RadialGauge)this.getSkinnable()).getValue() < NEW_VALUE.doubleValue()) {
                ((RadialGauge)this.getSkinnable()).setValue(NEW_VALUE.doubleValue());
                this.oldValue = NEW_VALUE.doubleValue();
            }
        });
        ((RadialGauge)this.getSkinnable()).maxValueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStep = ((RadialGauge)this.getSkinnable()).getAngleRange() / (NEW_VALUE.doubleValue() - ((RadialGauge)this.getSkinnable()).getMinValue());
            this.needleRotate.setAngle(180.0 - ((RadialGauge)this.getSkinnable()).getStartAngle() + (((RadialGauge)this.getSkinnable()).getValue() - ((RadialGauge)this.getSkinnable()).getMinValue()) * this.angleStep);
            if (((RadialGauge)this.getSkinnable()).getValue() > NEW_VALUE.doubleValue()) {
                ((RadialGauge)this.getSkinnable()).setValue(NEW_VALUE.doubleValue());
                this.oldValue = NEW_VALUE.doubleValue();
            }
        });
        this.needleRotate.angleProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("ANGLE".equals(PROPERTY)) {
            double currentValue = (this.needleRotate.getAngle() + ((RadialGauge)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep + ((RadialGauge)this.getSkinnable()).getMinValue();
            this.valueText.setText(this.limitString + String.format(Locale.US, "%." + ((RadialGauge)this.getSkinnable()).getDecimals() + "f", currentValue));
            this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        } else if ("DROP_SHADOW".equals(PROPERTY)) {
            this.shadowGroup.setEffect((Effect)(((RadialGauge)this.getSkinnable()).isDropShadowEnabled() ? this.dropShadow : null));
        } else if ("CANVAS_REFRESH".equals(PROPERTY)) {
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            this.drawSections(this.ticksAndSections);
            this.drawAreas(this.ticksAndSections);
            this.drawTickMarks(this.ticksAndSections);
        } else if ("NEEDLE_COLOR".equals(PROPERTY)) {
            this.needle.setStyle("-needle-color: " + this.colorToCss(((RadialGauge)this.getSkinnable()).getNeedleColor()) + ";");
        } else if ("LED_COLOR".equals(PROPERTY)) {
            this.ledMain.setStyle("-led-color: " + this.colorToCss(((RadialGauge)this.getSkinnable()).getLedColor()));
            this.resize();
        }
    }

    private String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    private void rotateNeedle() {
        this.timeline.stop();
        this.angleStep = ((RadialGauge)this.getSkinnable()).getAngleRange() / (((RadialGauge)this.getSkinnable()).getMaxValue() - ((RadialGauge)this.getSkinnable()).getMinValue());
        double targetAngle = 180.0 - ((RadialGauge)this.getSkinnable()).getStartAngle() + (((RadialGauge)this.getSkinnable()).getValue() - ((RadialGauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        targetAngle = this.clamp(180.0 - ((RadialGauge)this.getSkinnable()).getStartAngle(), 180.0 - ((RadialGauge)this.getSkinnable()).getStartAngle() + ((RadialGauge)this.getSkinnable()).getAngleRange(), targetAngle);
        if (this.withinSpeedLimit && ((RadialGauge)this.getSkinnable()).isAnimated()) {
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.needleRotate.angleProperty(), (Object)targetAngle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((RadialGauge)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timeline.play();
        } else {
            this.needleRotate.setAngle(targetAngle);
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        double startAngle = ((RadialGauge)this.getSkinnable()).getStartAngle();
        double orthText = RadialGauge.TickLabelOrientation.ORTHOGONAL == ((RadialGauge)this.getSkinnable()).getTickLabelOrientation() ? 0.33 : 0.31;
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        boolean smallRange = ((RadialGauge)this.getSkinnable()).getMaxValue() - ((RadialGauge)this.getSkinnable()).getMinValue() < 10.0;
        double tmpMinValue = smallRange ? ((RadialGauge)this.getSkinnable()).getMinValue() * 10.0 : ((RadialGauge)this.getSkinnable()).getMinValue();
        double tmpMaxValue = smallRange ? ((RadialGauge)this.getSkinnable()).getMaxValue() * 10.0 : ((RadialGauge)this.getSkinnable()).getMaxValue();
        double tmpAngleStep = smallRange ? this.angleStep / 10.0 : this.angleStep;
        double angle = 0.0;
        double counter = tmpMinValue;
        while (Double.compare(counter, tmpMaxValue) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerMainPoint = new Point2D(center.getX() + this.size * 0.368 * sinValue, center.getY() + this.size * 0.368 * cosValue);
            Point2D innerMediumPoint = new Point2D(center.getX() + this.size * 0.388 * sinValue, center.getY() + this.size * 0.388 * cosValue);
            Point2D innerMinorPoint = new Point2D(center.getX() + this.size * 0.3975 * sinValue, center.getY() + this.size * 0.3975 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.432 * sinValue, center.getY() + this.size * 0.432 * cosValue);
            Point2D textPoint = new Point2D(center.getX() + this.size * orthText * sinValue, center.getY() + this.size * orthText * cosValue);
            CTX.setStroke(((RadialGauge)this.getSkinnable()).getTickMarkFill());
            if (counter % ((RadialGauge)this.getSkinnable()).getMajorTickSpace() == 0.0) {
                CTX.setLineWidth(this.size * 0.0055);
                CTX.strokeLine(innerMainPoint.getX(), innerMainPoint.getY(), outerPoint.getX(), outerPoint.getY());
                CTX.save();
                CTX.translate(textPoint.getX(), textPoint.getY());
                switch (((RadialGauge)this.getSkinnable()).getTickLabelOrientation()) {
                    case ORTHOGONAL: {
                        if ((360.0 - startAngle - angle) % 360.0 > 90.0 && (360.0 - startAngle - angle) % 360.0 < 270.0) {
                            CTX.rotate((180.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((360.0 - startAngle - angle) % 360.0);
                        break;
                    }
                    case TANGENT: {
                        if ((360.0 - startAngle - angle - 90.0) % 360.0 > 90.0 && (360.0 - startAngle - angle - 90.0) % 360.0 < 270.0) {
                            CTX.rotate((90.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((270.0 - startAngle - angle) % 360.0);
                        break;
                    }
                }
                CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.045 * this.size)));
                CTX.setTextAlign(TextAlignment.CENTER);
                CTX.setTextBaseline(VPos.CENTER);
                CTX.setFill(((RadialGauge)this.getSkinnable()).getTickLabelFill());
                CTX.fillText(Integer.toString((int)(smallRange ? counter / 10.0 : counter)), 0.0, 0.0);
                CTX.restore();
            } else if (((RadialGauge)this.getSkinnable()).getMinorTickSpace() % 2.0 != 0.0 && counter % 5.0 == 0.0) {
                CTX.setLineWidth(this.size * 0.0035);
                CTX.strokeLine(innerMediumPoint.getX(), innerMediumPoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if (counter % ((RadialGauge)this.getSkinnable()).getMinorTickSpace() == 0.0) {
                CTX.setLineWidth(this.size * 0.00225);
                CTX.strokeLine(innerMinorPoint.getX(), innerMinorPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= tmpAngleStep;
            counter += 1.0;
        }
    }

    private final void drawSections(GraphicsContext CTX) {
        double xy = (this.size - 0.83425 * this.size) / 2.0;
        double wh = this.size * 0.83425;
        double MIN_VALUE = ((RadialGauge)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((RadialGauge)this.getSkinnable()).getMaxValue();
        double OFFSET = 90.0 - ((RadialGauge)this.getSkinnable()).getStartAngle();
        IntStream.range(0, ((RadialGauge)this.getSkinnable()).getSections().size()).parallel().forEachOrdered(i -> {
            Section SECTION = (Section)((RadialGauge)this.getSkinnable()).getSections().get(i);
            if (Double.compare(SECTION.getStart(), MAX_VALUE) <= 0 && Double.compare(SECTION.getStop(), MIN_VALUE) >= 0) {
                double SECTION_START_ANGLE = SECTION.getStart() < MIN_VALUE && SECTION.getStop() < MAX_VALUE ? MIN_VALUE * this.angleStep : (SECTION.getStart() - MIN_VALUE) * this.angleStep;
                double SECTION_ANGLE_EXTEND = SECTION.getStop() > MAX_VALUE ? (MAX_VALUE - SECTION.getStart()) * this.angleStep : (SECTION.getStop() - SECTION.getStart()) * this.angleStep;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setStroke((Paint)((RadialGauge)this.getSkinnable()).getSectionFill0());
                        break;
                    }
                    case 1: {
                        CTX.setStroke((Paint)((RadialGauge)this.getSkinnable()).getSectionFill1());
                        break;
                    }
                    case 2: {
                        CTX.setStroke((Paint)((RadialGauge)this.getSkinnable()).getSectionFill2());
                        break;
                    }
                    case 3: {
                        CTX.setStroke((Paint)((RadialGauge)this.getSkinnable()).getSectionFill3());
                        break;
                    }
                    case 4: {
                        CTX.setStroke((Paint)((RadialGauge)this.getSkinnable()).getSectionFill4());
                        break;
                    }
                    case 5: {
                        CTX.setStroke((Paint)((RadialGauge)this.getSkinnable()).getSectionFill5());
                        break;
                    }
                    case 6: {
                        CTX.setStroke((Paint)((RadialGauge)this.getSkinnable()).getSectionFill6());
                        break;
                    }
                    case 7: {
                        CTX.setStroke((Paint)((RadialGauge)this.getSkinnable()).getSectionFill7());
                        break;
                    }
                    case 8: {
                        CTX.setStroke((Paint)((RadialGauge)this.getSkinnable()).getSectionFill8());
                        break;
                    }
                    case 9: {
                        CTX.setStroke((Paint)((RadialGauge)this.getSkinnable()).getSectionFill9());
                    }
                }
                CTX.setLineWidth(this.size * 0.0415);
                CTX.setLineCap(StrokeLineCap.BUTT);
                CTX.strokeArc(xy, xy, wh, wh, -(OFFSET + SECTION_START_ANGLE), -SECTION_ANGLE_EXTEND, ArcType.OPEN);
                CTX.restore();
            }
        });
    }

    private final void drawAreas(GraphicsContext CTX) {
        double xy = (this.size - 0.7925 * this.size) / 2.0;
        double wh = this.size * 0.7925;
        double MIN_VALUE = ((RadialGauge)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((RadialGauge)this.getSkinnable()).getMaxValue();
        double OFFSET = 90.0 - ((RadialGauge)this.getSkinnable()).getStartAngle();
        IntStream.range(0, ((RadialGauge)this.getSkinnable()).getAreas().size()).parallel().forEachOrdered(i -> {
            Section AREA = (Section)((RadialGauge)this.getSkinnable()).getAreas().get(i);
            if (Double.compare(AREA.getStart(), MAX_VALUE) <= 0 && Double.compare(AREA.getStop(), MIN_VALUE) >= 0) {
                double AREA_START_ANGLE = AREA.getStart() < MIN_VALUE && AREA.getStop() < MAX_VALUE ? MIN_VALUE * this.angleStep : (AREA.getStart() - MIN_VALUE) * this.angleStep;
                double AREA_ANGLE_EXTEND = AREA.getStop() > MAX_VALUE ? (MAX_VALUE - AREA.getStart()) * this.angleStep : (AREA.getStop() - AREA.getStart()) * this.angleStep;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setFill((Paint)((RadialGauge)this.getSkinnable()).getAreaFill0());
                        break;
                    }
                    case 1: {
                        CTX.setFill((Paint)((RadialGauge)this.getSkinnable()).getAreaFill1());
                        break;
                    }
                    case 2: {
                        CTX.setFill((Paint)((RadialGauge)this.getSkinnable()).getAreaFill2());
                        break;
                    }
                    case 3: {
                        CTX.setFill((Paint)((RadialGauge)this.getSkinnable()).getAreaFill3());
                        break;
                    }
                    case 4: {
                        CTX.setFill((Paint)((RadialGauge)this.getSkinnable()).getAreaFill4());
                        break;
                    }
                    case 5: {
                        CTX.setFill((Paint)((RadialGauge)this.getSkinnable()).getAreaFill5());
                        break;
                    }
                    case 6: {
                        CTX.setFill((Paint)((RadialGauge)this.getSkinnable()).getAreaFill6());
                        break;
                    }
                    case 7: {
                        CTX.setFill((Paint)((RadialGauge)this.getSkinnable()).getAreaFill7());
                        break;
                    }
                    case 8: {
                        CTX.setFill((Paint)((RadialGauge)this.getSkinnable()).getAreaFill8());
                        break;
                    }
                    case 9: {
                        CTX.setFill((Paint)((RadialGauge)this.getSkinnable()).getAreaFill9());
                    }
                }
                CTX.fillArc(xy, xy, wh, wh, -(OFFSET + AREA_START_ANGLE), -AREA_ANGLE_EXTEND, ArcType.ROUND);
                CTX.restore();
            }
        });
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private void resizeText() {
        this.titleText.setFont(Fonts.robotoMedium(this.size * 0.06));
        this.titleText.setTranslateX((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5);
        this.titleText.setTranslateY(this.size * 0.35);
        this.unitText.setFont(Fonts.robotoMedium(this.size * 0.06));
        this.unitText.setTranslateX((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5);
        this.unitText.setTranslateY(this.size * 0.65);
        this.valueText.setFont(Fonts.robotoBold(this.size * 0.1));
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        this.valueText.setTranslateY(this.size * 0.85);
    }

    private void resize() {
        double d = this.size = ((RadialGauge)this.getSkinnable()).getWidth() < ((RadialGauge)this.getSkinnable()).getHeight() ? ((RadialGauge)this.getSkinnable()).getWidth() : ((RadialGauge)this.getSkinnable()).getHeight();
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((RadialGauge)this.getSkinnable()).getWidth() - this.size) * 0.5, (((RadialGauge)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.01 * this.size);
            this.dropShadow.setOffsetY(0.01 * this.size);
            this.background.setPrefSize(this.size, this.size);
            this.background.setStyle("-fx-background-insets: 0, " + 0.02 * this.size + ", " + 0.022 * this.size + ", " + 0.038 * this.size + ";");
            this.ticksAndSectionsCanvas.setWidth(this.size);
            this.ticksAndSectionsCanvas.setHeight(this.size);
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            if (((RadialGauge)this.getSkinnable()).isSectionsVisible()) {
                this.drawSections(this.ticksAndSections);
            }
            if (((RadialGauge)this.getSkinnable()).isAreasVisible()) {
                this.drawAreas(this.ticksAndSections);
            }
            this.drawTickMarks(this.ticksAndSections);
            this.ticksAndSectionsCanvas.setCache(true);
            this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
            this.innerShadow.setRadius(0.01 * this.size);
            this.glow.setRadius(0.05 * this.size);
            this.glow.setColor(((RadialGauge)this.getSkinnable()).getLedColor());
            this.ledFrame.setPrefSize(0.06 * this.size, 0.06 * this.size);
            this.ledFrame.relocate(0.61 * this.size, 0.4 * this.size);
            this.ledMain.setPrefSize(0.0432 * this.size, 0.0432 * this.size);
            this.ledMain.relocate(0.61 * this.size + 0.0084 * this.size, 0.4 * this.size + 0.0084 * this.size);
            this.ledHl.setPrefSize(0.0348 * this.size, 0.0348 * this.size);
            this.ledHl.relocate(0.61 * this.size + 0.0126 * this.size, 0.4 * this.size + 0.0126 * this.size);
            boolean ledVisible = ((RadialGauge)this.getSkinnable()).isLedVisible();
            this.ledFrame.setManaged(ledVisible);
            this.ledFrame.setVisible(ledVisible);
            this.ledMain.setManaged(ledVisible);
            this.ledMain.setVisible(ledVisible);
            this.ledHl.setManaged(ledVisible);
            this.ledHl.setVisible(ledVisible);
            this.needle.setPrefSize(this.size * 0.04, this.size * 0.425);
            this.needle.relocate((this.size - this.needle.getPrefWidth()) * 0.5, this.size * 0.5 - this.needle.getPrefHeight());
            this.needleRotate.setPivotX(this.needle.getPrefWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getPrefHeight());
            this.needleHighlight.setPrefSize(this.size * 0.04, this.size * 0.425);
            this.needleHighlight.setTranslateX((this.size - this.needle.getPrefWidth()) * 0.5);
            this.needleHighlight.setTranslateY(this.size * 0.5 - this.needle.getPrefHeight());
            this.knob.setPrefSize(this.size * 0.15, this.size * 0.15);
            this.knob.setTranslateX((this.size - this.knob.getPrefWidth()) * 0.5);
            this.knob.setTranslateY((this.size - this.knob.getPrefHeight()) * 0.5);
            this.resizeText();
        }
    }
}

