/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.signaltower;

import eu.hansolo.enzo.signaltower.SignalTower;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;

public class SignalTowerBuilder<B extends SignalTowerBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected SignalTowerBuilder() {
    }

    public static final SignalTowerBuilder create() {
        return new SignalTowerBuilder();
    }

    public final SignalTowerBuilder greenOn(boolean GREEN_ON) {
        this.properties.put("greenOn", (Property)new SimpleBooleanProperty(GREEN_ON));
        return this;
    }

    public final SignalTowerBuilder yellowOn(boolean YELLOW_ON) {
        this.properties.put("yellowOn", (Property)new SimpleBooleanProperty(YELLOW_ON));
        return this;
    }

    public final SignalTowerBuilder redOn(boolean RED_ON) {
        this.properties.put("redOn", (Property)new SimpleBooleanProperty(RED_ON));
        return this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final SignalTower build() {
        SignalTower CONTROL = new SignalTower();
        this.properties.forEach((key, property) -> {
            if ("minSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                CONTROL.setMinSize(dim.getWidth(), dim.getHeight());
            } else if ("prefSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
            } else if ("maxSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                CONTROL.setMaxSize(dim.getWidth(), dim.getHeight());
            } else if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)property).get());
            } else if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)property).get());
            } else if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)property).get());
            } else if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)property).get());
            } else if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)property).get());
            } else if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)property).get());
            } else if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)property).get());
            } else if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)property).get());
            } else if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)property).get());
            } else if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)property).get());
            } else if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)property).get());
            } else if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)property).get());
            } else if ("greenOn".equals(key)) {
                CONTROL.setGreenOn(((BooleanProperty)property).get());
            } else if ("yellowOn".equals(key)) {
                CONTROL.setYellowOn(((BooleanProperty)property).get());
            } else if ("redOn".equals(key)) {
                CONTROL.setRedOn(((BooleanProperty)property).get());
            }
        });
        return CONTROL;
    }
}

