/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class HashtableOfLong {
    public long[] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfLong() {
        this(13);
    }

    public HashtableOfLong(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new long[n2];
        this.valueTable = new Object[n2];
    }

    public boolean containsKey(long l2) {
        long l3;
        int n = this.keyTable.length;
        int n2 = (int)(l2 >>> 32) % n;
        while ((l3 = this.keyTable[n2]) != 0L) {
            if (l3 == l2) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public Object get(long l2) {
        long l3;
        int n = this.keyTable.length;
        int n2 = (int)(l2 >>> 32) % n;
        while ((l3 = this.keyTable[n2]) != 0L) {
            if (l3 == l2) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public Object put(long l2, Object object) {
        long l3;
        int n = this.keyTable.length;
        int n2 = (int)(l2 >>> 32) % n;
        while ((l3 = this.keyTable[n2]) != 0L) {
            if (l3 == l2) {
                this.valueTable[n2] = object;
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.keyTable[n2] = l2;
        this.valueTable[n2] = object;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object;
    }

    private void rehash() {
        HashtableOfLong hashtableOfLong = new HashtableOfLong(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            long l2 = this.keyTable[n];
            if (l2 == 0L) continue;
            hashtableOfLong.put(l2, this.valueTable[n]);
        }
        this.keyTable = hashtableOfLong.keyTable;
        this.valueTable = hashtableOfLong.valueTable;
        this.threshold = hashtableOfLong.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = this.valueTable.length;
        for (int i = 0; i < n; ++i) {
            Object object = this.valueTable[i];
            if (object == null) continue;
            string = string + this.keyTable[i] + " -> " + object.toString() + "\n";
        }
        return string;
    }
}

