/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import org.netrexx.process.RxClassInfo;
import org.netrexx.process.RxProxy;
import org.netrexx.process.RxTranslator;

public class RxProxyLoader
extends ClassLoader {
    private static final String $0 = "RxProxyLoader.nrx";
    RxTranslator rxt;

    public RxProxyLoader(RxTranslator rxTranslator) {
        super(RxProxyLoader.selectParent(rxTranslator));
        this.rxt = rxTranslator;
    }

    public static ClassLoader selectParent(RxTranslator rxTranslator) {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return rxTranslator.getClass().getClassLoader();
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        RxClassInfo rxClassInfo;
        Class<?> clazz = null;
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# loadClass: " + string + " [String]");
        }
        if (this.rxt.jsr223Engine != null & (rxClassInfo = this.rxt.classer.findknownclass(Rexx.toRexx(string))) != null && rxClassInfo.importer != null) {
            clazz = super.loadClass(string, bl);
            if (clazz == null && this.rxt.superflag.diag) {
                RexxIO.Say("# super.loadClass: " + string + " failed");
            }
            return clazz;
        }
        if (rxClassInfo != null) {
            if (rxClassInfo.local) {
                return this.loadClass(rxClassInfo, bl);
            }
            if (!rxClassInfo.ispublic) {
                return this.loadClass(rxClassInfo, bl);
            }
            if (this.rxt.localpackages.containsKey(rxClassInfo.packname)) {
                return this.loadClass(rxClassInfo, bl);
            }
        }
        if ((clazz = super.loadClass(string, bl)) == null && this.rxt.superflag.diag) {
            RexxIO.Say("# loadClass: " + string + " failed");
        }
        return clazz;
    }

    synchronized Class loadClass(RxClassInfo rxClassInfo, boolean bl) {
        byte[] byArray = null;
        RxProxy rxProxy = null;
        if (rxClassInfo.classobject != null) {
            return rxClassInfo.classobject;
        }
        if (this.rxt.superflag.diag) {
            RexxIO.Say("# loadClass: " + rxClassInfo.type.toString() + " [Info]");
        }
        if (!rxClassInfo.local) {
            byArray = rxClassInfo.imagedata;
            this.rxt.classer.addlookaside(rxClassInfo);
        } else {
            rxProxy = new RxProxy(this.rxt, rxClassInfo);
            byArray = rxProxy.getBytes();
        }
        String string = rxClassInfo.type.toJavaSig();
        string = string.substring(1, string.length() - 1);
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
        if (bl) {
            this.resolveClass(clazz);
        }
        rxClassInfo.classobject = clazz;
        return clazz;
    }
}

