/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class BsfSystemClipboard {
    public static final String version = "100.20230611";
    private static final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    static ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    static PrintStream ps = new PrintStream(baos);

    public static boolean isEmpty() {
        Transferable transferable = null;
        DataFlavor[] dataFlavorArray = null;
        try {
            transferable = clipboard.getContents(null);
            dataFlavorArray = transferable.getTransferDataFlavors();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return dataFlavorArray == null ? true : dataFlavorArray.length == 0;
    }

    public static DataFlavor[] getDataFlavors() {
        try {
            return clipboard.getContents(null).getTransferDataFlavors();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public static void clear() {
        clipboard.setContents(new ClearClipboardTransferable(), null);
    }

    public static Image setImageWithoutAlpha(Image image) {
        int n;
        BufferedImage bufferedImage = (BufferedImage)image;
        int n2 = n = bufferedImage.getType();
        switch (bufferedImage.getType()) {
            case 6: 
            case 7: {
                n2 = 5;
                break;
            }
            case 2: 
            case 3: {
                n2 = 1;
            }
        }
        if (n != n2) {
            BufferedImage bufferedImage2 = new BufferedImage(image.getWidth(null), image.getHeight(null), n2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            BsfSystemClipboard.setImage(bufferedImage2);
            return bufferedImage2;
        }
        BsfSystemClipboard.setImage(image);
        return image;
    }

    public static void setImage(Image image) {
        PrintStream printStream = System.err;
        baos.reset();
        System.setErr(ps);
        try {
            clipboard.setContents(new TransferableImage(image), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.setErr(printStream);
        baos.reset();
    }

    public static Image getImage() {
        if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
            try {
                return (Image)clipboard.getData(DataFlavor.imageFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setString(String string) {
        clipboard.setContents(new StringSelection(string), null);
    }

    public static String getString() {
        if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            try {
                return (String)clipboard.getData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static byte[] getString(String string) {
        if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            if (string == null) {
                string = "UTF-8";
            }
            try {
                String string2 = (String)clipboard.getData(DataFlavor.stringFlavor);
                return string2.getBytes(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static class ClearClipboardTransferable
    implements Transferable {
        ClearClipboardTransferable() {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    static class TransferableImage
    implements Transferable {
        Image img;

        public TransferableImage(Image image) {
            this.img = image;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.img != null && dataFlavor.equals(DataFlavor.imageFlavor)) {
                return this.img;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(DataFlavor.imageFlavor);
        }
    }
}

