/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import impl.org.controlsfx.behavior.RatingBehavior;
import java.util.ArrayList;
import java.util.Collections;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.Rating;
import org.controlsfx.tools.Utils;

public class RatingSkin
extends BehaviorSkinBase<Rating, RatingBehavior> {
    private static final String STRONG = "strong";
    private boolean updateOnHover;
    private boolean partialRating;
    private Pane backgroundContainer;
    private Pane foregroundContainer;
    private double rating = -1.0;
    private Rectangle forgroundClipRect;
    private final EventHandler<MouseEvent> mouseMoveHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (RatingSkin.this.updateOnHover) {
                RatingSkin.this.updateRatingFromMouseEvent(event);
            }
        }
    };
    private final EventHandler<MouseEvent> mouseClickHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (!RatingSkin.this.updateOnHover) {
                RatingSkin.this.updateRatingFromMouseEvent(event);
            }
        }
    };

    private void updateRatingFromMouseEvent(MouseEvent event) {
        Rating control = (Rating)this.getSkinnable();
        if (!control.ratingProperty().isBound()) {
            Point2D mouseLocation = new Point2D(event.getSceneX(), event.getSceneY());
            control.setRating(this.calculateRating(mouseLocation));
        }
    }

    public RatingSkin(Rating control) {
        super((Control)control, (BehaviorBase)new RatingBehavior(control));
        this.updateOnHover = control.isUpdateOnHover();
        this.partialRating = control.isPartialRating();
        this.recreateButtons();
        this.updateRating();
        this.registerChangeListener((ObservableValue)control.ratingProperty(), "RATING");
        this.registerChangeListener((ObservableValue)control.maxProperty(), "MAX");
        this.registerChangeListener((ObservableValue)control.orientationProperty(), "ORIENTATION");
        this.registerChangeListener((ObservableValue)control.updateOnHoverProperty(), "UPDATE_ON_HOVER");
        this.registerChangeListener((ObservableValue)control.partialRatingProperty(), "PARTIAL_RATING");
        this.registerChangeListener((ObservableValue)control.boundsInLocalProperty(), "BOUNDS");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if (p == "RATING") {
            this.updateRating();
        } else if (p == "MAX") {
            this.recreateButtons();
        } else if (p == "ORIENTATION") {
            this.recreateButtons();
        } else if (p == "PARTIAL_RATING") {
            this.partialRating = ((Rating)this.getSkinnable()).isPartialRating();
            this.recreateButtons();
        } else if (p == "UPDATE_ON_HOVER") {
            this.updateOnHover = ((Rating)this.getSkinnable()).isUpdateOnHover();
            this.recreateButtons();
        } else if (p == "BOUNDS" && this.partialRating) {
            this.updateClip();
        }
    }

    private void recreateButtons() {
        this.backgroundContainer = null;
        this.foregroundContainer = null;
        this.backgroundContainer = this.isVertical() ? new VBox() : new HBox();
        this.backgroundContainer.getStyleClass().add((Object)"container");
        this.getChildren().setAll((Object[])new Node[]{this.backgroundContainer});
        if (this.updateOnHover || this.partialRating) {
            this.foregroundContainer = this.isVertical() ? new VBox() : new HBox();
            this.foregroundContainer.getStyleClass().add((Object)"container");
            this.foregroundContainer.setMouseTransparent(true);
            this.getChildren().add((Object)this.foregroundContainer);
            this.forgroundClipRect = new Rectangle();
            this.foregroundContainer.setClip((Node)this.forgroundClipRect);
        }
        for (int index = 0; index <= ((Rating)this.getSkinnable()).getMax(); ++index) {
            Node backgroundNode = this.createButton();
            if (index <= 0) continue;
            if (this.isVertical()) {
                this.backgroundContainer.getChildren().add(0, (Object)backgroundNode);
            } else {
                this.backgroundContainer.getChildren().add((Object)backgroundNode);
            }
            if (!this.partialRating) continue;
            Node foregroundNode = this.createButton();
            foregroundNode.getStyleClass().add((Object)STRONG);
            foregroundNode.setMouseTransparent(true);
            if (this.isVertical()) {
                this.foregroundContainer.getChildren().add(0, (Object)foregroundNode);
                continue;
            }
            this.foregroundContainer.getChildren().add((Object)foregroundNode);
        }
        this.updateRating();
    }

    private double calculateRating(Point2D sceneLocation) {
        Point2D b = this.backgroundContainer.sceneToLocal(sceneLocation);
        double x = b.getX();
        double y = b.getY();
        Rating control = (Rating)this.getSkinnable();
        int max = control.getMax();
        double w = control.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        double h = control.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double newRating = -1.0;
        newRating = this.isVertical() ? (h - y) / h * (double)max : x / w * (double)max;
        if (!this.partialRating) {
            newRating = Utils.clamp(1.0, Math.ceil(newRating), control.getMax());
        }
        return newRating;
    }

    private void updateClip() {
        Rating control = (Rating)this.getSkinnable();
        double h = control.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double w = control.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        if (this.isVertical()) {
            double y = h * this.rating / (double)control.getMax();
            this.forgroundClipRect.relocate(0.0, h - y);
            this.forgroundClipRect.setWidth(control.getWidth());
            this.forgroundClipRect.setHeight(y);
        } else {
            double x = w * this.rating / (double)control.getMax();
            this.forgroundClipRect.setWidth(x);
            this.forgroundClipRect.setHeight(control.getHeight());
        }
    }

    protected Node createButtonNode() {
        return new Region();
    }

    private Node createButton() {
        Node btn = this.createButtonNode();
        btn.getStyleClass().add((Object)"button");
        btn.setOnMouseMoved(this.mouseMoveHandler);
        btn.setOnMouseClicked(this.mouseClickHandler);
        return btn;
    }

    private void updateRating() {
        double newRating = ((Rating)this.getSkinnable()).getRating();
        if (newRating == this.rating) {
            return;
        }
        this.rating = Utils.clamp(0.0, newRating, ((Rating)this.getSkinnable()).getMax());
        if (this.partialRating) {
            this.updateClip();
        } else {
            this.updateButtonStyles();
        }
    }

    private void updateButtonStyles() {
        int max = ((Rating)this.getSkinnable()).getMax();
        ArrayList buttons = new ArrayList(this.backgroundContainer.getChildren());
        if (this.isVertical()) {
            Collections.reverse(buttons);
        }
        for (int i = 0; i < max; ++i) {
            Node button = (Node)buttons.get(i);
            ObservableList styleClass = button.getStyleClass();
            boolean containsStrong = styleClass.contains(STRONG);
            if ((double)i < this.rating) {
                if (containsStrong) continue;
                styleClass.add(STRONG);
                continue;
            }
            if (!containsStrong) continue;
            styleClass.remove(STRONG);
        }
    }

    private boolean isVertical() {
        return ((Rating)this.getSkinnable()).getOrientation() == Orientation.VERTICAL;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }
}

