/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.rexxla.bsf.engines.rexx.RexxEngine;
import org.rexxla.bsf.engines.rexx.RexxException;

public class RexxDispatcher {
    public static final String version = "405.20260114";
    private static final boolean bDebug = false;
    private static final String keyName = "allCommandLineArguments";

    private RexxDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length == 0) {
            System.err.println("usage:\n\tjava RexxDispatcher rexx_file_name [arguments]");
            System.exit(1);
        }
        if (System.getProperty("os.name").startsWith("Mac")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            string = stringArray[0];
            int n = string.lastIndexOf("/");
            if (n >= 0 && n + 1 < string.length()) {
                string = string.substring(n + 1);
            }
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "BSF4ooRexx [" + string + "]");
        }
        string = null;
        String string2 = null;
        Vector<String> vector = null;
        Object var4_5 = null;
        BSFManager bSFManager = null;
        RexxEngine rexxEngine = null;
        try {
            bSFManager = new BSFManager();
            bSFManager.declareBean(keyName, stringArray, stringArray.getClass());
            rexxEngine = (RexxEngine)bSFManager.loadScriptingEngine("rexx");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (stringArray.length > 1) {
            vector = new Vector<String>();
            string2 = "";
            boolean bl = false;
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + (string2.length() > 0 ? " " : "");
                bl = false;
                for (int j = 0; j < stringArray[i].length() && !bl; ++j) {
                    bl = stringArray[i].charAt(j) == ' ';
                }
                string2 = string2 + (bl ? "\"" : "") + stringArray[i] + (bl ? "\"" : "");
            }
            vector.addElement(string2);
        }
        try {
            String string3 = RexxDispatcher.findFile(stringArray[0]);
            if (string3 == null) {
                System.err.println("RexxDispatcher.java: the supplied Rexx program \"" + stringArray[0] + "\" can neither be found in the current directory (\".\", ie., \"" + System.getProperty("user.dir") + "\") nor in 'java.library.path':\n---> \"" + System.getProperty("java.library.path") + "\" <---, aborting...");
                System.exit(-1);
            }
            Object object = rexxEngine.apply(string3, 0, 0, IOUtils.getStringFromReader(new FileReader(string3)), null, vector);
        }
        catch (Throwable throwable) {
            System.err.println("RexxDispatcher.java: Throwable of type '" + throwable.getClass().getName() + "' thrown while invoking Rexx:\ngetLocalizedMessage(): [" + throwable.getLocalizedMessage() + "]");
            try {
                rexxEngine.terminate();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            System.exit(-1);
        }
        finally {
            block23: {
                try {
                    rexxEngine.terminate();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof RexxException) break block23;
                    System.err.println("\nRexxDispatcher.java: a '" + throwable.getClass().getName() + "' thrown while terminating Rexx instance: [" + throwable.getLocalizedMessage() + "]");
                    throwable.printStackTrace();
                }
            }
        }
        System.exit(0);
    }

    static String findFile(String string) {
        File file = new File(string);
        try {
            if (file.exists()) {
                return file.getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = System.getProperty("file.separator");
        String[] stringArray = System.getProperty("java.library.path").split(System.getProperty("path.separator"));
        String[] stringArray2 = new String[]{"", ".rex", ".rexx", ".rxj", ".rxo", ".cls"};
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : stringArray2) {
            for (String string4 : stringArray) {
                String string5 = string4 + string2 + string + string3;
                if (!hashSet.add(string5) || !(file = new File(string5)).exists()) continue;
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

