/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.apache.bsf.BSFException;
import org.rexxla.bsf.engines.rexx.RexxException;
import org.rexxla.bsf.engines.rexx.RexxProxy;
import org.rexxla.bsf.engines.rexx.RexxScriptEngine;

public class RexxCompiledScript
extends CompiledScript
implements Invocable {
    private static final boolean bDebug = false;
    private static final boolean bShowSource = true;
    RexxScriptEngine rse;
    boolean bSupplyBSFExceptionObject = false;
    String filename;
    String scriptSource;
    String editedScriptSource = null;
    RexxProxy rexxScriptObject;
    RexxProxy rexxPackageObject;

    public RexxScriptEngine getRexxScriptEngine() {
        return this.rse;
    }

    public boolean getSupplyBSFExceptionObject() {
        return this.bSupplyBSFExceptionObject;
    }

    public void setSupplyBSFExceptionObject(boolean bl) {
        this.bSupplyBSFExceptionObject = bl;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getScriptSource() {
        return this.scriptSource;
    }

    public String getEditedScriptSource() {
        return this.editedScriptSource;
    }

    public RexxProxy getScriptObject() {
        return this.rexxScriptObject;
    }

    public RexxProxy getPackageObject() {
        return this.rexxPackageObject;
    }

    RexxCompiledScript(RexxScriptEngine rexxScriptEngine, String string, String string2, boolean bl, RexxProxy rexxProxy, RexxProxy rexxProxy2) {
        this.rse = rexxScriptEngine;
        this.scriptSource = string;
        this.filename = string2;
        this.bSupplyBSFExceptionObject = bl;
        this.rexxScriptObject = rexxProxy;
        this.rexxPackageObject = rexxProxy2;
    }

    @Override
    public Object eval(ScriptContext scriptContext) throws ScriptException {
        Object[] objectArray;
        if (scriptContext == null) {
            throw new NullPointerException("Received \"ScriptContext sc\" argument null");
        }
        try {
            objectArray = RexxCompiledScript.createArgV(this.rse, (Object[])scriptContext.getAttribute("javax.script.argv"), scriptContext, null, null);
        }
        catch (BSFException bSFException) {
            throw this.createScriptException(bSFException);
        }
        try {
            this.rse.updateRexxEngine(scriptContext);
            return this.rexxScriptObject.sendMessage("CALLWITH", objectArray);
        }
        catch (BSFException bSFException) {
            throw this.createScriptException(bSFException);
        }
    }

    @Override
    public RexxScriptEngine getEngine() {
        return this.rse;
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        RexxProxy rexxProxy;
        if (clazz == null) {
            throw new IllegalArgumentException("Received 'clasz' argument is null");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Received 'clasz' argument is not an interface class");
        }
        ScriptContext scriptContext = this.rse.getContext();
        try {
            this.rse.updateRexxEngine(scriptContext);
            rexxProxy = (RexxProxy)this.rse.getRoutineWrapper().sendMessage3("CALL", this.getScriptObject(), this.getPackageObject(), scriptContext);
        }
        catch (Exception exception) {
            System.err.println("Exception [" + exception + "] raised while trying to create dispatching object, cause: [" + exception.getCause() + "]");
            System.err.println("Exception [" + exception + "], stack trace:");
            exception.printStackTrace();
            System.err.println("Exception [" + exception + "], returning null to indicate failure");
            return null;
        }
        Object[] objectArray = new Object[]{clazz};
        return (T)rexxProxy.newJavaProxyInstance(objectArray);
    }

    @Override
    public <T> T getInterface(Object object, Class<T> clazz) {
        return this.rse.getInterface(object, clazz);
    }

    @Override
    public Object invokeFunction(String string, Object ... objectArray) throws ScriptException, NoSuchMethodException {
        if (string == null) {
            throw new NullPointerException("Received 'name' argument (function name) is null");
        }
        try {
            RexxProxy rexxProxy = (RexxProxy)this.rexxPackageObject.sendMessage0("PUBLICROUTINES");
            String string2 = (String)rexxProxy.sendMessage1("HASENTRY", string);
            if (string2.equals("0")) {
                throw new NoSuchMethodException("Received 'name' argument \"" + string + "\" does not denote an existing, public Rexx routine");
            }
            Object[] objectArray2 = null;
            objectArray2 = RexxCompiledScript.createArgV(this.rse, objectArray, this.rse.getContext(), null, null);
            RexxProxy rexxProxy2 = (RexxProxy)rexxProxy.sendMessage1("ENTRY", string);
            return rexxProxy2.sendMessage1("CALLWITH", objectArray2);
        }
        catch (Exception exception) {
            throw this.createScriptException(exception);
        }
    }

    @Override
    public Object invokeMethod(Object object, String string, Object ... objectArray) throws ScriptException, NoSuchMethodException {
        return this.rse.invokeMethod(object, string, objectArray);
    }

    ScriptException createScriptException(Exception exception) {
        if (this.bSupplyBSFExceptionObject) {
            return new ScriptException(exception);
        }
        if (!(exception instanceof RexxException) || ((RexxException)exception).getRexxConditionObject() == null) {
            return new ScriptException(exception);
        }
        RexxProxy rexxProxy = ((RexxException)exception).getRexxConditionObject();
        String string = this.createRexxLikeConditionMessage(rexxProxy);
        String string2 = "n/a";
        String string3 = null;
        try {
            string2 = (String)rexxProxy.sendMessage0("PROGRAM");
            string3 = (String)rexxProxy.sendMessage0("POSITION");
        }
        catch (Exception exception2) {
            // empty catch block
        }
        int n = -1;
        if (string3 instanceof String) {
            n = Integer.valueOf(string3);
        }
        return new ScriptException(string, string2, n);
    }

    String createRexxLikeConditionMessage(RexxProxy rexxProxy) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        try {
            string = (String)rexxProxy.sendMessage0("CONDITION");
            if (string.equals("SYNTAX")) {
                stringBuffer.append((String)((RexxProxy)rexxProxy.sendMessage0("TRACEBACK")).sendMessage0("FIRSTITEM"));
                stringBuffer.append('\n');
                stringBuffer.append(String.format("Error %s running %s line %s:  %s", (String)rexxProxy.sendMessage0("RC"), (String)rexxProxy.sendMessage0("PROGRAM"), (String)rexxProxy.sendMessage0("POSITION"), (String)rexxProxy.sendMessage0("ERRORTEXT")));
                stringBuffer.append('\n');
                stringBuffer.append(String.format("Error %s:  %s", (String)rexxProxy.sendMessage0("CODE"), (String)rexxProxy.sendMessage0("MESSAGE")));
            } else if (string.equals("NOVALUE")) {
                stringBuffer.append((String)((RexxProxy)rexxProxy.sendMessage0("TRACEBACK")).sendMessage0("FIRSTITEM"));
                stringBuffer.append('\n');
                stringBuffer.append(String.format("Rexx condition [%s] raised for variable [%s] running %s line: %s", string, (String)rexxProxy.sendMessage0("DESCRIPTION"), (String)rexxProxy.sendMessage0("PROGRAM"), (String)rexxProxy.sendMessage0("POSITION")));
            } else {
                stringBuffer.append(String.format("Rexx condition [%s] raised running %s", string, this.filename));
                if (!string.startsWith("USER")) {
                    stringBuffer.append(String.format(", return code [%s]", (String)rexxProxy.sendMessage0("RC")));
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("accessing argument \"rco\" with conditionname [" + string + "] caused the exception: [" + exception + "]");
        }
        return stringBuffer.toString();
    }

    static Object[] createArgV(RexxScriptEngine rexxScriptEngine, Object[] objectArray, ScriptContext scriptContext, RexxScriptEngine rexxScriptEngine2, RexxCompiledScript rexxCompiledScript) throws ScriptException, BSFException {
        int n = objectArray != null ? objectArray.length : 0;
        Object[] objectArray2 = new Object[n + 1];
        int n2 = 0;
        if (objectArray != null && objectArray.length > 0) {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                objectArray2[n2] = objectArray[n2];
            }
        }
        RexxProxy rexxProxy = (RexxProxy)rexxScriptEngine.getCreateSlotArgument().sendMessage2("CALL", "SCRIPTCONTEXT", scriptContext);
        if (rexxCompiledScript != null) {
            rexxProxy.sendMessage2("SETENTRY", "REXXCOMPILEDSCRIPT", rexxCompiledScript);
        }
        if (rexxScriptEngine2 != null) {
            rexxProxy.sendMessage2("SETENTRY", "REXXSCRIPTENGINE", rexxScriptEngine2);
        }
        objectArray2[n2] = rexxProxy;
        return objectArray2;
    }
}

