/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.IPolyExpression;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.ExceptionInferenceFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class LambdaExpression
extends FunctionalExpression
implements IPolyExpression,
ReferenceContext,
ProblemSeverities {
    public Argument[] arguments;
    private TypeBinding[] argumentTypes;
    public int arrowPosition;
    public Statement body;
    public boolean hasParentheses;
    public MethodScope scope;
    boolean voidCompatible = true;
    boolean valueCompatible = false;
    boolean returnsValue;
    private boolean requiresGenericSignature;
    boolean returnsVoid;
    public LambdaExpression original = this;
    public SyntheticArgumentBinding[] outerLocalVariables = NO_SYNTHETIC_ARGUMENTS;
    private int outerLocalVariablesSlotSize = 0;
    private boolean assistNode = false;
    private boolean hasIgnoredMandatoryErrors = false;
    private ReferenceBinding classType;
    private Set thrownExceptions;
    public char[] text;
    private static final SyntheticArgumentBinding[] NO_SYNTHETIC_ARGUMENTS = new SyntheticArgumentBinding[0];
    private static final Block NO_BODY = new Block(0);
    private HashMap<TypeBinding, LambdaExpression> copiesPerTargetType;
    protected Expression[] resultExpressions = NO_EXPRESSIONS;
    public InferenceContext18 inferenceContext;
    private Map<Integer, LocalTypeBinding> localTypes;
    public boolean argumentsTypeVar = false;

    public LambdaExpression(CompilationResult compilationResult, boolean bl, boolean bl2) {
        super(compilationResult);
        this.assistNode = bl;
        this.requiresGenericSignature = bl2;
        this.setArguments(NO_ARGUMENTS);
        this.setBody(NO_BODY);
    }

    public LambdaExpression(CompilationResult compilationResult, boolean bl) {
        this(compilationResult, bl, false);
    }

    public void setArguments(Argument[] argumentArray) {
        this.arguments = argumentArray != null ? argumentArray : ASTNode.NO_ARGUMENTS;
        this.argumentTypes = new TypeBinding[argumentArray != null ? argumentArray.length : 0];
    }

    public Argument[] arguments() {
        return this.arguments;
    }

    public TypeBinding[] argumentTypes() {
        return this.argumentTypes;
    }

    public void setBody(Statement statement) {
        this.body = statement == null ? NO_BODY : statement;
    }

    public Statement body() {
        return this.body;
    }

    public Expression[] resultExpressions() {
        return this.resultExpressions;
    }

    public void setArrowPosition(int n) {
        this.arrowPosition = n;
    }

    public int arrowPosition() {
        return this.arrowPosition;
    }

    protected FunctionalExpression original() {
        return this.original;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n;
        int n2;
        this.binding.modifiers = this.shouldCaptureInstance ? (this.binding.modifiers &= 0xFFFFFFF7) : (this.binding.modifiers |= 8);
        SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
        boolean bl2 = !(this.binding instanceof SyntheticMethodBinding);
        this.binding = sourceTypeBinding.addSyntheticMethod(this);
        int n3 = codeStream.position;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (this.shouldCaptureInstance) {
            codeStream.aload_0();
            stringBuffer.append(sourceTypeBinding.signature());
        }
        int n4 = n2 = this.outerLocalVariables == null ? 0 : this.outerLocalVariables.length;
        for (n = 0; n < n2; ++n) {
            SyntheticArgumentBinding syntheticArgumentBinding = this.outerLocalVariables[n];
            if (this.shouldCaptureInstance && bl2) {
                ++syntheticArgumentBinding.resolvedPosition;
            }
            stringBuffer.append(syntheticArgumentBinding.type.signature());
            LocalVariableBinding localVariableBinding = syntheticArgumentBinding.actualOuterLocalVariable;
            Object[] objectArray = blockScope.getEmulationPath(localVariableBinding);
            codeStream.generateOuterAccess(objectArray, this, localVariableBinding, blockScope);
        }
        stringBuffer.append(')');
        if (this.expectedType instanceof IntersectionTypeBinding18) {
            stringBuffer.append(((IntersectionTypeBinding18)this.expectedType).getSAMType(blockScope).signature());
        } else {
            stringBuffer.append(this.expectedType.signature());
        }
        n = codeStream.classFile.recordBootstrapMethod(this);
        codeStream.invokeDynamic(n, (this.shouldCaptureInstance ? 1 : 0) + this.outerLocalVariablesSlotSize, 1, this.descriptor.selector, stringBuffer.toString().toCharArray(), this.resolvedType.id, this.resolvedType);
        if (!bl) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n3, this.sourceStart);
    }

    @Override
    public boolean kosherDescriptor(Scope scope, MethodBinding methodBinding, boolean bl) {
        if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
            if (bl) {
                scope.problemReporter().lambdaExpressionCannotImplementGenericMethod(this, methodBinding);
            }
            return false;
        }
        return super.kosherDescriptor(scope, methodBinding, bl);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        int n;
        TypeBinding[] typeBindingArray;
        Object object2;
        int n2;
        int n3;
        boolean bl2;
        int n4;
        boolean bl3 = this.argumentsTypeElided();
        int n5 = n4 = this.arguments == null ? 0 : this.arguments.length;
        if (this.constant != Constant.NotAConstant) {
            this.constant = Constant.NotAConstant;
            this.enclosingScope = blockScope;
            if (this.original == this) {
                this.ordinal = this.recordFunctionalType(blockScope);
            }
            if (!bl3) {
                for (int i = 0; i < n4; ++i) {
                    this.argumentTypes[i] = this.arguments[i].type.resolveType(blockScope, true);
                }
            }
            if (this.expectedType == null && this.expressionContext == ExpressionContext.INVOCATION_CONTEXT) {
                return new PolyTypeBinding(this);
            }
        }
        MethodScope methodScope = blockScope.methodScope();
        this.scope = new MethodScope(blockScope, this, methodScope.isStatic, methodScope.lastVisibleFieldID);
        this.scope.isConstructorCall = methodScope.isConstructorCall;
        super.resolveType(blockScope, bl);
        boolean bl4 = bl2 = this.descriptor != null;
        if (!(bl || bl2 && this.descriptor.typeVariables == Binding.NO_TYPE_VARIABLES)) {
            this.resolvedType = null;
            return null;
        }
        this.binding = new MethodBinding(0x2001002, CharOperation.concat(TypeConstants.ANONYMOUS_METHOD, Integer.toString(this.ordinal).toCharArray()), bl2 ? this.descriptor.returnType : TypeBinding.VOID, Binding.NO_PARAMETERS, bl2 ? this.descriptor.thrownExceptions : Binding.NO_EXCEPTIONS, blockScope.enclosingSourceType());
        this.binding.typeVariables = Binding.NO_TYPE_VARIABLES;
        int n6 = 0;
        if (bl2 && (n3 = this.descriptor.parameters.length) != n4) {
            this.scope.problemReporter().lambdaSignatureMismatched(this);
            if (bl3 || this.original != this) {
                this.resolvedType = null;
                return null;
            }
            this.resolvedType = null;
            n6 = 1;
        }
        TypeBinding[] typeBindingArray2 = new TypeBinding[n4];
        AnnotationBinding[][] annotationBindingArrayArray = null;
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = this.arguments[n2];
            if (((Argument)object2).isVarArgs()) {
                if (n2 == n4 - 1) {
                    this.binding.modifiers |= 0x80;
                } else {
                    this.scope.problemReporter().illegalVarargInLambda((Argument)object2);
                    n6 = 1;
                }
            }
            TypeBinding[] typeBindingArray3 = bl2 && n2 < this.descriptor.parameters.length ? this.descriptor.parameters[n2] : null;
            TypeBinding[] typeBindingArray4 = typeBindingArray = bl3 ? typeBindingArray3 : this.argumentTypes[n2];
            if (typeBindingArray == null) {
                n6 = 1;
                continue;
            }
            if (typeBindingArray == TypeBinding.VOID) {
                this.scope.problemReporter().argumentTypeCannotBeVoid(this, (Argument)object2);
                n6 = 1;
                continue;
            }
            if (!typeBindingArray.isValidBinding()) {
                this.binding.tagBits |= 0x200L;
            }
            if ((typeBindingArray.tagBits & 0x80L) == 0L) continue;
            this.binding.tagBits |= 0x80L;
        }
        if (!bl3 && n6 == 0) {
            ReferenceBinding referenceBinding = null;
            object2 = null;
            if (this.expectedType instanceof IntersectionTypeBinding18) {
                object2 = (ReferenceBinding)((IntersectionTypeBinding18)this.expectedType).getSAMType(blockScope);
            } else if (this.expectedType instanceof ReferenceBinding) {
                object2 = (ReferenceBinding)this.expectedType;
            }
            if (object2 != null) {
                referenceBinding = this.findGroundTargetType(blockScope, this.expectedType, (TypeBinding)object2, bl3);
            }
            if (referenceBinding != null) {
                this.descriptor = referenceBinding.getSingleAbstractMethod(blockScope, true);
                if (!this.descriptor.isValidBinding()) {
                    this.reportSamProblem(blockScope, this.descriptor);
                } else {
                    if (referenceBinding != object2 && !referenceBinding.isCompatibleWith((TypeBinding)object2, this.scope)) {
                        blockScope.problemReporter().typeMismatchError((TypeBinding)referenceBinding, this.expectedType, this, null);
                        return null;
                    }
                    this.resolvedType = referenceBinding;
                }
            } else {
                this.binding = new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 18);
                this.reportSamProblem(blockScope, this.binding);
                this.resolvedType = null;
                return null;
            }
        }
        n2 = 0;
        boolean bl5 = this.requiresGenericSignature || blockScope.compilerOptions().generateGenericSignatureForLambdaExpressions;
        typeBindingArray = new TypeBinding[n4];
        for (n = 0; n < n4; ++n) {
            TypeBinding typeBinding;
            Argument argument = this.arguments[n];
            TypeBinding object3 = bl2 && n < this.descriptor.parameters.length ? this.descriptor.parameters[n] : null;
            TypeBinding typeBinding2 = bl3 ? object3 : this.argumentTypes[n];
            typeBindingArray[n] = object3;
            if (typeBinding2 == null || typeBinding2 == TypeBinding.VOID) continue;
            if (bl2 && object3 != null && typeBinding2.isValidBinding() && TypeBinding.notEquals(typeBinding2, object3) && object3.isProperType(true) && !this.isOnlyWildcardMismatch(object3, typeBinding2)) {
                this.scope.problemReporter().lambdaParameterTypeMismatched(argument, argument.type, object3);
                n2 = 1;
            }
            if (bl5 && (typeBinding = typeBinding2.leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)typeBinding).modifiers & 0x40000000) != 0) {
                this.binding.modifiers |= 0x40000000;
            }
            typeBindingArray2[n] = argument.bind(this.scope, typeBinding2, false);
            if (argument.annotations != null) {
                this.binding.tagBits |= 0x400L;
                if (annotationBindingArrayArray == null) {
                    annotationBindingArrayArray = new AnnotationBinding[n4][];
                    for (int i = 0; i < n; ++i) {
                        annotationBindingArrayArray[i] = Binding.NO_ANNOTATIONS;
                    }
                }
                annotationBindingArrayArray[n] = argument.binding.getAnnotations();
                continue;
            }
            if (annotationBindingArrayArray == null) continue;
            annotationBindingArrayArray[n] = Binding.NO_ANNOTATIONS;
        }
        if (this.argumentsTypeVar) {
            for (n = 0; n < n4; ++n) {
                this.arguments[n].type.resolvedType = typeBindingArray[n];
            }
        }
        if (n6 == 0) {
            this.binding.parameters = typeBindingArray2;
            if (annotationBindingArrayArray != null) {
                this.binding.setParameterAnnotations(annotationBindingArrayArray);
            }
        }
        if (!bl3 && n6 == 0 && this.binding.isVarargs() && !this.binding.parameters[this.binding.parameters.length - 1].isReifiable()) {
            this.scope.problemReporter().possibleHeapPollutionFromVararg(this.arguments[this.arguments.length - 1]);
        }
        for (ReferenceBinding referenceBinding : this.binding.thrownExceptions) {
            if ((referenceBinding.tagBits & 0x80L) != 0L) {
                this.binding.tagBits |= 0x80L;
            }
            if (!bl5) continue;
            this.binding.modifiers |= referenceBinding.modifiers & 0x40000000;
        }
        TypeBinding typeBinding = this.binding.returnType;
        if (typeBinding != null) {
            TypeBinding typeBinding2;
            if ((typeBinding.tagBits & 0x80L) != 0L) {
                this.binding.tagBits |= 0x80L;
            }
            if (bl5 && (typeBinding2 = typeBinding.leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)typeBinding2).modifiers & 0x40000000) != 0) {
                this.binding.modifiers |= 0x40000000;
            }
        }
        if (bl2 && n6 == 0 && blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
            if (!bl3) {
                AbstractMethodDeclaration.createArgumentBindings(this.arguments, this.binding, this.scope);
                this.mergeParameterNullAnnotations(blockScope);
            }
            this.binding.tagBits |= this.descriptor.tagBits & 0x180000000000000L;
        }
        this.binding.modifiers &= 0xFDFFFFFF;
        if (this.body instanceof Expression && ((Expression)this.body).isTrulyExpression()) {
            Expression expression = (Expression)this.body;
            new ReturnStatement(expression, expression.sourceStart, expression.sourceEnd, true).resolve(this.scope);
            if (expression.resolvedType == TypeBinding.VOID && !expression.statementExpression()) {
                this.scope.problemReporter().invalidExpressionAsStatement(expression);
            }
        } else {
            this.body.resolve(this.scope);
            if (!this.returnsVoid && !this.returnsValue) {
                this.valueCompatible = this.body.doesNotCompleteNormally();
            }
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            this.scope.problemReporter().missingTypeInLambda(this, this.binding);
        }
        if (this.shouldCaptureInstance && this.scope.isConstructorCall) {
            this.scope.problemReporter().fieldsOrThisBeforeConstructorInvocation(this);
        }
        this.updateLocalTypes();
        return (n6 | n2) != 0 ? null : this.resolvedType;
    }

    private boolean isOnlyWildcardMismatch(TypeBinding typeBinding, TypeBinding typeBinding2) {
        boolean bl = false;
        if (typeBinding.isParameterizedType() && typeBinding2.isParameterizedType()) {
            TypeBinding[] typeBindingArray = ((ParameterizedTypeBinding)typeBinding).typeArguments();
            TypeBinding[] typeBindingArray2 = ((ParameterizedTypeBinding)typeBinding2).typeArguments();
            if (typeBindingArray2.length != typeBindingArray.length) {
                return false;
            }
            for (int i = 0; i < typeBindingArray2.length; ++i) {
                if (!TypeBinding.notEquals(typeBindingArray[i], typeBindingArray2[i])) continue;
                if (typeBindingArray[i].isWildcard() && typeBindingArray2[i].isUnboundWildcard()) {
                    WildcardBinding wildcardBinding = (WildcardBinding)typeBindingArray[i];
                    TypeBinding typeBinding3 = wildcardBinding.allBounds();
                    if (typeBinding3 == null || wildcardBinding.boundKind != 1 || typeBinding3.id != 1) continue;
                    bl = true;
                    continue;
                }
                bl = false;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferenceBinding findGroundTargetType(BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2, boolean bl) {
        if (typeBinding2 instanceof IntersectionTypeBinding18) {
            typeBinding2 = ((IntersectionTypeBinding18)typeBinding2).getSAMType(blockScope);
        }
        if (typeBinding2 instanceof ReferenceBinding && typeBinding2.isValidBinding()) {
            ParameterizedTypeBinding parameterizedTypeBinding = InferenceContext18.parameterizedWithWildcard(typeBinding2);
            if (parameterizedTypeBinding != null) {
                if (!bl) {
                    InferenceContext18 inferenceContext18 = new InferenceContext18(blockScope);
                    try {
                        ReferenceBinding referenceBinding = inferenceContext18.inferFunctionalInterfaceParameterization(this, blockScope, parameterizedTypeBinding);
                        return referenceBinding;
                    }
                    finally {
                        inferenceContext18.cleanUp();
                    }
                }
                return this.findGroundTargetTypeForElidedLambda(blockScope, parameterizedTypeBinding);
            }
            if (typeBinding instanceof ReferenceBinding) {
                return (ReferenceBinding)typeBinding;
            }
        }
        return null;
    }

    public ReferenceBinding findGroundTargetTypeForElidedLambda(BlockScope blockScope, ParameterizedTypeBinding parameterizedTypeBinding) {
        TypeBinding[] typeBindingArray = parameterizedTypeBinding.getNonWildcardParameterization(blockScope);
        if (typeBindingArray == null) {
            return null;
        }
        ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
        return blockScope.environment().createParameterizedType(referenceBinding, typeBindingArray, parameterizedTypeBinding.enclosingType());
    }

    @Override
    public boolean argumentsTypeElided() {
        return this.arguments.length > 0 && this.arguments[0].hasElidedType() || this.argumentsTypeVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeExceptions() {
        CompilerOptions compilerOptions = this.scope.compilerOptions();
        boolean bl = compilerOptions.analyseResourceLeaks;
        compilerOptions.analyseResourceLeaks = false;
        try {
            ExceptionInferenceFlowContext exceptionInferenceFlowContext = new ExceptionInferenceFlowContext(null, this, Binding.NO_EXCEPTIONS, null, this.scope, FlowInfo.DEAD_END);
            this.body.analyseCode(this.scope, exceptionInferenceFlowContext, UnconditionalFlowInfo.fakeInitializedFlowInfo(this.scope.outerMostMethodScope().analysisIndex, this.scope.referenceType().maxFieldCount));
            this.thrownExceptions = exceptionInferenceFlowContext.extendedExceptions == null ? Collections.emptySet() : new HashSet(exceptionInferenceFlowContext.extendedExceptions);
        }
        catch (Exception exception) {
        }
        finally {
            compilerOptions.analyseResourceLeaks = bl;
        }
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        FlowInfo flowInfo2 = flowInfo.copy();
        ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(flowContext, this, this.binding.thrownExceptions, flowContext.getInitializationContext(), this.scope, FlowInfo.DEAD_END);
        MethodBinding methodBinding = this.argumentsTypeElided() ? this.descriptor : this.binding;
        AbstractMethodDeclaration.analyseArguments(blockScope.environment(), flowInfo2, this.arguments, methodBinding);
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                this.bits |= this.arguments[i].bits & 0x100000;
            }
        }
        flowInfo2 = this.body.analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo2);
        if (this.body instanceof Block) {
            TypeBinding typeBinding = this.expectedResultType();
            if (typeBinding == TypeBinding.VOID) {
                if ((flowInfo2.tagBits & 1) == 0 || ((Block)this.body).statements == null) {
                    this.bits |= 0x40;
                }
            } else if (flowInfo2 != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(typeBinding, this);
            }
        } else if (blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled && flowInfo2.reachMode() == 0) {
            Expression expression = (Expression)this.body;
            this.checkAgainstNullAnnotation(flowContext, expression, flowInfo, expression.nullStatus(flowInfo2, flowContext));
        }
        return flowInfo;
    }

    void validateNullAnnotations() {
        if (this.binding != null) {
            int n = this.binding.parameters.length;
            for (int i = 0; i < n; ++i) {
                if (this.scope.validateNullAnnotation(this.binding.returnType.tagBits, this.arguments[i].type, this.arguments[i].annotations)) continue;
                this.binding.returnType = this.binding.returnType.withoutToplevelNullAnnotation();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeParameterNullAnnotations(BlockScope blockScope) {
        LookupEnvironment lookupEnvironment = blockScope.environment();
        TypeBinding[] typeBindingArray = this.binding.parameters;
        TypeBinding[] typeBindingArray2 = this.descriptor.parameters;
        int n = Math.min(typeBindingArray.length, typeBindingArray2.length);
        for (int i = 0; i < n; ++i) {
            void var11_13;
            long l2 = typeBindingArray[i].tagBits & 0x180000000000000L;
            long l3 = typeBindingArray2[i].tagBits & 0x180000000000000L;
            if (l2 == 0L) {
                if (l3 == 0L || typeBindingArray[i].isBaseType()) continue;
                for (AnnotationBinding annotationBinding : typeBindingArray2[i].getTypeAnnotations()) {
                    if (annotationBinding == null || !annotationBinding.getAnnotationType().hasNullBit(96)) continue;
                    typeBindingArray[i] = lookupEnvironment.createAnnotatedType(typeBindingArray[i], new AnnotationBinding[]{annotationBinding});
                }
                continue;
            }
            if (l2 == l3 || l2 != 0x100000000000000L) continue;
            Object var11_11 = null;
            if (l3 == 0x80000000000000L) {
                char[][] cArray = lookupEnvironment.getNullableAnnotationName();
            }
            blockScope.problemReporter().illegalRedefinitionToNonNullParameter(this.arguments[i], this.descriptor.declaringClass, (char[][])var11_13);
        }
    }

    void checkAgainstNullAnnotation(FlowContext flowContext, Expression expression, FlowInfo flowInfo, int n) {
        if (n != 4 && (this.descriptor.returnType.tagBits & 0x100000000000000L) != 0L) {
            flowContext.recordNullityMismatch(this.scope, expression, expression.resolvedType, this.descriptor.returnType, flowInfo, n, null);
        }
    }

    @Override
    public boolean isPertinentToApplicability(final TypeBinding typeBinding, final MethodBinding methodBinding) {
        if (typeBinding == null) {
            return true;
        }
        if (this.argumentsTypeElided()) {
            return false;
        }
        if (!super.isPertinentToApplicability(typeBinding, methodBinding)) {
            return false;
        }
        if (this.body instanceof Expression && ((Expression)this.body).isTrulyExpression()) {
            if (!((Expression)this.body).isPertinentToApplicability(typeBinding, methodBinding)) {
                return false;
            }
        } else {
            Expression[] expressionArray = this.resultExpressions;
            if (expressionArray != NO_EXPRESSIONS) {
                int n = expressionArray.length;
                for (int i = 0; i < n; ++i) {
                    if (expressionArray[i].isPertinentToApplicability(typeBinding, methodBinding)) continue;
                    return false;
                }
            } else {
                class NotPertientToApplicability
                extends RuntimeException {
                    private static final long serialVersionUID = 1L;

                    NotPertientToApplicability() {
                    }
                }
                try {
                    class ResultsAnalyser
                    extends ASTVisitor {
                        ResultsAnalyser() {
                        }

                        @Override
                        public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
                            return false;
                        }

                        @Override
                        public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
                            return false;
                        }

                        @Override
                        public boolean visit(LambdaExpression lambdaExpression, BlockScope blockScope) {
                            return false;
                        }

                        @Override
                        public boolean visit(ReturnStatement returnStatement, BlockScope blockScope) {
                            if (returnStatement.expression != null && !returnStatement.expression.isPertinentToApplicability(typeBinding, methodBinding)) {
                                throw new NotPertientToApplicability();
                            }
                            return false;
                        }
                    }
                    this.body.traverse(new ResultsAnalyser(), this.scope);
                }
                catch (NotPertientToApplicability notPertientToApplicability) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isVoidCompatible() {
        return this.voidCompatible;
    }

    public boolean isValueCompatible() {
        return this.valueCompatible;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return this.printExpression(n, stringBuffer, false);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer, boolean bl) {
        int n2;
        int n3 = (this.bits & 0x1FE00000) >> 21;
        String string = "";
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append('(');
            string = string + ')';
        }
        stringBuffer.append('(');
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].print(0, stringBuffer);
            }
        }
        stringBuffer.append(") -> ");
        if (bl) {
            stringBuffer.append("{}");
        } else if (this.body != null) {
            this.body.print(this.body instanceof Block ? n : 0, stringBuffer);
        } else {
            stringBuffer.append("<@incubator>");
        }
        return stringBuffer.append(string);
    }

    public TypeBinding expectedResultType() {
        return this.descriptor != null && this.descriptor.isValidBinding() ? this.descriptor.returnType : null;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.arguments != null) {
                int n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    this.arguments[i].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.body != null) {
                this.body.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public MethodScope getScope() {
        return this.scope;
    }

    private boolean enclosingScopesHaveErrors() {
        Scope scope = this.enclosingScope;
        while (scope != null) {
            ReferenceContext referenceContext = scope.referenceContext();
            if (referenceContext != null && referenceContext.hasErrors()) {
                return true;
            }
            scope = scope.parent;
        }
        return false;
    }

    private void analyzeShape() {
        if (this.body instanceof Expression && ((Expression)this.body).isTrulyExpression()) {
            this.voidCompatible = this.assistNode ? true : ((Expression)this.body).statementExpression();
            this.valueCompatible = true;
        } else {
            if (this.assistNode) {
                this.voidCompatible = true;
                this.valueCompatible = true;
            }
            class ShapeComputer
            extends ASTVisitor {
                ShapeComputer() {
                }

                @Override
                public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
                    return false;
                }

                @Override
                public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
                    return false;
                }

                @Override
                public boolean visit(LambdaExpression lambdaExpression, BlockScope blockScope) {
                    return false;
                }

                @Override
                public boolean visit(ReturnStatement returnStatement, BlockScope blockScope) {
                    if (returnStatement.expression != null) {
                        LambdaExpression.this.valueCompatible = true;
                        LambdaExpression.this.voidCompatible = false;
                        LambdaExpression.this.returnsValue = true;
                    } else {
                        LambdaExpression.this.voidCompatible = true;
                        LambdaExpression.this.valueCompatible = false;
                        LambdaExpression.this.returnsVoid = true;
                    }
                    return false;
                }
            }
            this.body.traverse(new ShapeComputer(), null);
            if (!this.returnsValue && !this.returnsVoid) {
                this.valueCompatible = this.body.doesNotCompleteNormally();
            }
        }
    }

    @Override
    public boolean isPotentiallyCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (!super.isPertinentToApplicability(typeBinding, null)) {
            return true;
        }
        MethodBinding methodBinding = typeBinding.getSingleAbstractMethod(scope, true);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            return false;
        }
        if (methodBinding.parameters.length != this.arguments.length) {
            return false;
        }
        this.analyzeShape();
        return !(methodBinding.returnType.id == 6 ? !this.voidCompatible : !this.valueCompatible);
    }

    public boolean reportShapeError(TypeBinding typeBinding, Scope scope) {
        return this.internalIsCompatibleWith(typeBinding, scope, true) == CompatibilityResult.REPORTED;
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        return this.internalIsCompatibleWith(typeBinding, scope, false) == CompatibilityResult.COMPATIBLE;
    }

    CompatibilityResult internalIsCompatibleWith(TypeBinding typeBinding, Scope scope, boolean bl) {
        if (!super.isPertinentToApplicability(typeBinding, null)) {
            return CompatibilityResult.COMPATIBLE;
        }
        LambdaExpression lambdaExpression = null;
        try {
            lambdaExpression = this.cachedResolvedCopy(typeBinding, this.argumentsTypeElided(), false, null);
        }
        catch (CopyFailureException copyFailureException) {
            if (this.assistNode) {
                return CompatibilityResult.COMPATIBLE;
            }
            return this.isPertinentToApplicability(typeBinding, null) ? CompatibilityResult.INCOMPATIBLE : CompatibilityResult.COMPATIBLE;
        }
        if (lambdaExpression == null) {
            return CompatibilityResult.INCOMPATIBLE;
        }
        MethodBinding methodBinding = (typeBinding = this.findGroundTargetType(this.enclosingScope, typeBinding, typeBinding, this.argumentsTypeElided())).getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding == null || methodBinding.problemId() == 17) {
            return CompatibilityResult.INCOMPATIBLE;
        }
        if (methodBinding.returnType.id == 6) {
            if (!lambdaExpression.voidCompatible) {
                return CompatibilityResult.INCOMPATIBLE;
            }
        } else if (!lambdaExpression.valueCompatible) {
            if (bl) {
                scope.problemReporter().missingValueFromLambda(this, methodBinding.returnType);
                return CompatibilityResult.REPORTED;
            }
            return CompatibilityResult.INCOMPATIBLE;
        }
        if (bl) {
            return CompatibilityResult.COMPATIBLE;
        }
        if (!this.isPertinentToApplicability(typeBinding, null)) {
            return CompatibilityResult.COMPATIBLE;
        }
        if (!this.kosherDescriptor(this.enclosingScope, methodBinding, false)) {
            return CompatibilityResult.INCOMPATIBLE;
        }
        Expression[] expressionArray = lambdaExpression.resultExpressions;
        int n = expressionArray.length;
        for (int i = 0; i < n; ++i) {
            if (!methodBinding.returnType.isProperType(true) || this.enclosingScope.parameterCompatibilityLevel(expressionArray[i].resolvedType, methodBinding.returnType) != -1 || expressionArray[i].isConstantValueOfTypeAssignableToType(expressionArray[i].resolvedType, methodBinding.returnType) || methodBinding.returnType.id == 6 && !(this.body instanceof Block)) continue;
            return CompatibilityResult.INCOMPATIBLE;
        }
        return CompatibilityResult.COMPATIBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LambdaExpression cachedResolvedCopy(TypeBinding typeBinding, boolean bl, boolean bl2, InferenceContext18 inferenceContext18) {
        if ((typeBinding = this.findGroundTargetType(this.enclosingScope, typeBinding, typeBinding, this.argumentsTypeElided())) == null) {
            return null;
        }
        MethodBinding methodBinding = typeBinding.getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            return null;
        }
        if (methodBinding.parameters.length != this.arguments.length) {
            return null;
        }
        LambdaExpression lambdaExpression = null;
        if (this.copiesPerTargetType != null && (lambdaExpression = this.copiesPerTargetType.get(typeBinding)) == null && bl && this.copiesPerTargetType.values().size() > 0) {
            lambdaExpression = this.copiesPerTargetType.values().iterator().next();
        }
        IErrorHandlingPolicy iErrorHandlingPolicy = this.enclosingScope.problemReporter().switchErrorHandlingPolicy(silentErrorHandlingPolicy);
        try {
            Object object;
            if (lambdaExpression == null) {
                lambdaExpression = this.copy();
                if (lambdaExpression == null) {
                    throw new CopyFailureException();
                }
                lambdaExpression.setExpressionContext(this.expressionContext);
                lambdaExpression.setExpectedType(typeBinding);
                lambdaExpression.inferenceContext = inferenceContext18;
                object = lambdaExpression.resolveType(this.enclosingScope, true);
                if (object == null || !((Binding)object).isValidBinding()) {
                    LambdaExpression lambdaExpression2 = null;
                    return lambdaExpression2;
                }
                if (this.copiesPerTargetType == null) {
                    this.copiesPerTargetType = new HashMap();
                }
                this.copiesPerTargetType.put(typeBinding, lambdaExpression);
            }
            if (!bl2) {
                object = lambdaExpression;
                return object;
            }
            if (lambdaExpression.thrownExceptions == null && !lambdaExpression.hasIgnoredMandatoryErrors && !this.enclosingScopesHaveErrors()) {
                lambdaExpression.analyzeExceptions();
            }
            object = lambdaExpression;
            return object;
        }
        finally {
            this.enclosingScope.problemReporter().switchErrorHandlingPolicy(iErrorHandlingPolicy);
        }
    }

    @Override
    public LambdaExpression resolveExpressionExpecting(TypeBinding typeBinding, Scope scope, InferenceContext18 inferenceContext18) {
        LambdaExpression lambdaExpression = null;
        try {
            lambdaExpression = this.cachedResolvedCopy(typeBinding, false, true, inferenceContext18);
        }
        catch (CopyFailureException copyFailureException) {
            return null;
        }
        return lambdaExpression;
    }

    @Override
    public boolean sIsMoreSpecific(TypeBinding typeBinding, TypeBinding typeBinding2, Scope scope) {
        int n;
        LambdaExpression lambdaExpression;
        if (super.sIsMoreSpecific(typeBinding, typeBinding2, scope)) {
            return true;
        }
        if (this.argumentsTypeElided() || typeBinding2.findSuperTypeOriginatingFrom(typeBinding) != null) {
            return false;
        }
        TypeBinding typeBinding3 = typeBinding;
        MethodBinding methodBinding = (typeBinding = typeBinding.capture(this.enclosingScope, this.sourceStart, this.sourceEnd)).getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            return false;
        }
        MethodBinding methodBinding2 = typeBinding2.getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding2 == null || !methodBinding2.isValidBinding()) {
            return true;
        }
        MethodBinding methodBinding3 = methodBinding2.computeSubstitutedMethod(methodBinding, scope.environment());
        if (methodBinding3 == null) {
            return false;
        }
        MethodBinding methodBinding4 = typeBinding3.getSingleAbstractMethod(this.enclosingScope, true);
        TypeBinding[] typeBindingArray = methodBinding3.parameters;
        MethodBinding methodBinding5 = methodBinding2.computeSubstitutedMethod(methodBinding4, scope.environment());
        TypeBinding[] typeBindingArray2 = methodBinding5.parameters;
        TypeBinding[] typeBindingArray3 = methodBinding2.parameters;
        for (int i = 0; i < typeBindingArray.length; ++i) {
            if (typeBindingArray3[i].isCompatibleWith(typeBindingArray[i]) && !TypeBinding.notEquals(typeBindingArray3[i], typeBindingArray2[i])) continue;
            return false;
        }
        TypeBinding typeBinding4 = methodBinding3.returnType;
        TypeBinding typeBinding5 = methodBinding2.returnType;
        if (typeBinding5.id == 6) {
            return true;
        }
        if (typeBinding4.id == 6) {
            return false;
        }
        if (typeBinding4.isCompatibleWith(typeBinding5, scope)) {
            return true;
        }
        try {
            lambdaExpression = this.cachedResolvedCopy(typeBinding, true, false, null);
        }
        catch (CopyFailureException copyFailureException) {
            if (this.assistNode) {
                return false;
            }
            throw copyFailureException;
        }
        Expression[] expressionArray = lambdaExpression.resultExpressions;
        int n2 = n = expressionArray == null ? 0 : expressionArray.length;
        if (n > 0) {
            int n3;
            if (typeBinding4.isBaseType() && !typeBinding5.isBaseType()) {
                for (n3 = 0; n3 < n && !expressionArray[n3].isPolyExpression() && expressionArray[n3].resolvedType.isBaseType(); ++n3) {
                }
                if (n3 == n) {
                    return true;
                }
            }
            if (!typeBinding4.isBaseType() && typeBinding5.isBaseType()) {
                for (n3 = 0; n3 < n && !expressionArray[n3].resolvedType.isBaseType(); ++n3) {
                }
                if (n3 == n) {
                    return true;
                }
            }
            if (typeBinding4.isFunctionalInterface(this.enclosingScope) && typeBinding5.isFunctionalInterface(this.enclosingScope)) {
                Expression expression;
                for (n3 = 0; n3 < n && (expression = expressionArray[n3]).sIsMoreSpecific(typeBinding4, typeBinding5, scope); ++n3) {
                }
                if (n3 == n) {
                    return true;
                }
            }
        }
        return false;
    }

    LambdaExpression copy() {
        ICompilationUnit iCompilationUnit;
        char[] cArray;
        Parser parser = new Parser(this.enclosingScope.problemReporter(), false);
        LambdaExpression lambdaExpression = (LambdaExpression)parser.parseLambdaExpression(cArray = (iCompilationUnit = this.compilationResult.getCompilationUnit()) != null ? iCompilationUnit.getContents() : this.text, iCompilationUnit != null ? this.sourceStart : 0, this.sourceEnd - this.sourceStart + 1, this.enclosingScope.referenceCompilationUnit(), false);
        if (lambdaExpression != null) {
            lambdaExpression.original = this;
            lambdaExpression.assistNode = this.assistNode;
            lambdaExpression.enclosingScope = this.enclosingScope;
        }
        return lambdaExpression;
    }

    public void returnsExpression(Expression expression, TypeBinding typeBinding) {
        if (this.original == this) {
            return;
        }
        if (this.body instanceof Expression && ((Expression)this.body).isTrulyExpression()) {
            this.valueCompatible = typeBinding == null || typeBinding.id != 6;
            this.voidCompatible = this.assistNode ? true : ((Expression)this.body).statementExpression();
            this.resultExpressions = new Expression[]{expression};
            return;
        }
        if (expression != null) {
            this.returnsValue = true;
            this.voidCompatible = false;
            this.valueCompatible = !this.returnsVoid;
            Expression[] expressionArray = this.resultExpressions;
            int n = expressionArray.length;
            Expression[] expressionArray2 = expressionArray;
            expressionArray = new Expression[n + 1];
            System.arraycopy(expressionArray2, 0, expressionArray, 0, n);
            expressionArray[n] = expression;
            this.resultExpressions = expressionArray;
        } else {
            this.returnsVoid = true;
            this.valueCompatible = false;
            this.voidCompatible = !this.returnsValue;
        }
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    @Override
    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, categorizedProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortMethod(this.compilationResult, categorizedProblem);
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        return this.enclosingScope == null ? null : this.enclosingScope.compilationUnitScope().referenceContext;
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
        Scope scope = this.enclosingScope.parent;
        while (scope != null) {
            switch (scope.kind) {
                case 2: 
                case 3: {
                    ReferenceContext referenceContext = scope.referenceContext();
                    if (referenceContext == this) break;
                    referenceContext.tagAsHavingErrors();
                    return;
                }
            }
            scope = scope.parent;
        }
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int n) {
        MethodScope methodScope;
        switch (n) {
            case 16777362: 
            case 16777384: 
            case 16778098: {
                return;
            }
            case 99: 
            case 0x1000013: 
            case 67108969: 
            case 0x4000303: 
            case 553648781: 
            case 553648783: 
            case 553648784: 
            case 553648785: 
            case 553648786: 
            case 553648787: 
            case 603979884: {
                return;
            }
        }
        this.hasIgnoredMandatoryErrors = true;
        MethodScope methodScope2 = methodScope = this.scope == null ? null : this.scope.enclosingLambdaScope();
        while (methodScope != null) {
            LambdaExpression lambdaExpression = (LambdaExpression)methodScope.referenceContext;
            lambdaExpression.hasIgnoredMandatoryErrors = true;
            methodScope = methodScope.enclosingLambdaScope();
        }
    }

    public Set<TypeBinding> getThrownExceptions() {
        if (this.thrownExceptions == null) {
            return Collections.emptySet();
        }
        return this.thrownExceptions;
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n = 0;
        classFile.codeStream.wideMode = false;
        boolean bl = false;
        do {
            try {
                n = classFile.contentsOffset;
                this.generateCode(classFile);
                bl = false;
            }
            catch (AbortMethod abortMethod) {
                if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    bl = true;
                    continue;
                }
                if (abortMethod.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    bl = true;
                    continue;
                }
                throw new AbortType(this.compilationResult, abortMethod.problem);
            }
        } while (bl);
    }

    public void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n = classFile.contentsOffset;
        int n2 = classFile.generateMethodInfoAttributes(this.binding);
        int n3 = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        codeStream.reset(this, classFile);
        this.scope.computeLocalVariablePositions(this.outerLocalVariablesSlotSize + (this.binding.isStatic() ? 0 : 1), codeStream);
        if (this.outerLocalVariables != null) {
            for (SyntheticArgumentBinding localVariableBinding : this.outerLocalVariables) {
                codeStream.addVisibleLocalVariable(localVariableBinding);
                codeStream.record(localVariableBinding);
                localVariableBinding.recordInitializationStartPC(0);
            }
        }
        if (this.arguments != null) {
            int n4 = this.arguments.length;
            for (int i = 0; i < n4; ++i) {
                LocalVariableBinding localVariableBinding = this.arguments[i].binding;
                codeStream.addVisibleLocalVariable(localVariableBinding);
                localVariableBinding.recordInitializationStartPC(0);
            }
        }
        if (this.body instanceof Block) {
            this.body.generateCode(this.scope, codeStream);
            if ((this.bits & 0x40) != 0) {
                codeStream.return_();
            }
        } else {
            Expression expression = (Expression)this.body;
            expression.generateCode(this.scope, codeStream, true);
            if (this.binding.returnType == TypeBinding.VOID) {
                codeStream.return_();
            } else {
                codeStream.generateReturnBytecode(expression);
            }
        }
        codeStream.exitUserScope(this.scope);
        codeStream.recordPositionsFrom(0, this.sourceEnd);
        try {
            classFile.completeCodeAttribute(n3, this.scope);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
        }
        classFile.completeMethodInfo(this.binding, n, ++n2);
    }

    public void addSyntheticArgument(LocalVariableBinding localVariableBinding) {
        int n;
        if (this.original != this || this.binding == null) {
            return;
        }
        SyntheticArgumentBinding syntheticArgumentBinding = null;
        int n2 = this.outerLocalVariables.length;
        for (n = 0; n < n2; ++n) {
            if (this.outerLocalVariables[n].actualOuterLocalVariable != localVariableBinding) continue;
            return;
        }
        this.outerLocalVariables = new SyntheticArgumentBinding[n2 + 1];
        System.arraycopy(this.outerLocalVariables, 0, this.outerLocalVariables, 0, n2);
        this.outerLocalVariables[n2] = syntheticArgumentBinding = new SyntheticArgumentBinding(localVariableBinding);
        syntheticArgumentBinding.resolvedPosition = this.outerLocalVariablesSlotSize;
        syntheticArgumentBinding.declaringScope = this.scope;
        n = this.binding.parameters.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n + 1];
        typeBindingArray[n2] = localVariableBinding.type;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            if (n3 == n2) {
                ++n4;
            }
            typeBindingArray[n4] = this.binding.parameters[n3];
            ++n3;
            ++n4;
        }
        this.binding.parameters = typeBindingArray;
        switch (syntheticArgumentBinding.type.id) {
            case 7: 
            case 8: {
                this.outerLocalVariablesSlotSize += 2;
                break;
            }
            default: {
                ++this.outerLocalVariablesSlotSize;
            }
        }
    }

    public SyntheticArgumentBinding getSyntheticArgument(LocalVariableBinding localVariableBinding) {
        int n;
        int n2 = n = this.outerLocalVariables == null ? 0 : this.outerLocalVariables.length;
        for (int i = 0; i < n; ++i) {
            if (this.outerLocalVariables[i].actualOuterLocalVariable != localVariableBinding) continue;
            return this.outerLocalVariables[i];
        }
        return null;
    }

    @Override
    public MethodBinding getMethodBinding() {
        if (this.actualMethodBinding == null) {
            if (this.binding != null) {
                TypeBinding[] typeBindingArray = null;
                if (this.binding instanceof SyntheticMethodBinding && this.outerLocalVariables.length > 0) {
                    typeBindingArray = new TypeBinding[this.binding.parameters.length - this.outerLocalVariables.length];
                    System.arraycopy(this.binding.parameters, this.outerLocalVariables.length, typeBindingArray, 0, typeBindingArray.length);
                } else {
                    typeBindingArray = this.binding.parameters;
                }
                this.actualMethodBinding = new MethodBinding(this.binding.modifiers, this.binding.selector, this.binding.returnType, typeBindingArray, this.binding.thrownExceptions, this.binding.declaringClass);
                this.actualMethodBinding.tagBits = this.binding.tagBits;
            } else {
                this.actualMethodBinding = new ProblemMethodBinding(CharOperation.NO_CHAR, null, 17);
            }
        }
        return this.actualMethodBinding;
    }

    @Override
    public int diagnosticsSourceEnd() {
        return this.body instanceof Block ? this.arrowPosition : this.sourceEnd;
    }

    public TypeBinding[] getMarkerInterfaces() {
        if (this.expectedType instanceof IntersectionTypeBinding18) {
            LinkedHashSet<ReferenceBinding> linkedHashSet = new LinkedHashSet<ReferenceBinding>();
            IntersectionTypeBinding18 intersectionTypeBinding18 = (IntersectionTypeBinding18)this.expectedType;
            ReferenceBinding[] referenceBindingArray = intersectionTypeBinding18.intersectingTypes;
            TypeBinding typeBinding = intersectionTypeBinding18.getSAMType(this.enclosingScope);
            for (ReferenceBinding referenceBinding : referenceBindingArray) {
                if (!((TypeBinding)referenceBinding).isInterface() || TypeBinding.equalsEquals(typeBinding, referenceBinding) || referenceBinding.id == 37) continue;
                linkedHashSet.add(referenceBinding);
            }
            if (linkedHashSet.size() > 0) {
                return linkedHashSet.toArray(new TypeBinding[linkedHashSet.size()]);
            }
        }
        return null;
    }

    public ReferenceBinding getTypeBinding() {
        if (this.classType != null || this.resolvedType == null) {
            return null;
        }
        class LambdaTypeBinding
        extends ReferenceBinding {
            LambdaTypeBinding() {
            }

            @Override
            public MethodBinding[] methods() {
                return new MethodBinding[]{LambdaExpression.this.getMethodBinding()};
            }

            @Override
            public char[] sourceName() {
                return TypeConstants.LAMBDA_TYPE;
            }

            @Override
            public ReferenceBinding superclass() {
                return LambdaExpression.this.scope.getJavaLangObject();
            }

            @Override
            public ReferenceBinding[] superInterfaces() {
                return new ReferenceBinding[]{(ReferenceBinding)LambdaExpression.this.resolvedType};
            }

            @Override
            public char[] computeUniqueKey() {
                return LambdaExpression.this.descriptor.declaringClass.computeUniqueKey();
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer("()->{} implements ");
                stringBuffer.append(LambdaExpression.this.descriptor.declaringClass.sourceName());
                stringBuffer.append('.');
                stringBuffer.append(LambdaExpression.this.descriptor.toString());
                return stringBuffer.toString();
            }
        }
        this.classType = new LambdaTypeBinding();
        return this.classType;
    }

    public void addLocalType(LocalTypeBinding localTypeBinding) {
        if (this.localTypes == null) {
            this.localTypes = new HashMap<Integer, LocalTypeBinding>();
        }
        this.localTypes.put(localTypeBinding.sourceStart, localTypeBinding);
    }

    private void updateLocalTypes() {
        if (this.descriptor == null || this.localTypes == null) {
            return;
        }
        LocalTypeSubstitutor localTypeSubstitutor = new LocalTypeSubstitutor(this.localTypes);
        Substitution.NullSubstitution nullSubstitution = new Substitution.NullSubstitution(this.scope.environment());
        this.updateLocalTypesInMethod(this.binding, localTypeSubstitutor, nullSubstitution);
        this.updateLocalTypesInMethod(this.descriptor, localTypeSubstitutor, nullSubstitution);
        this.resolvedType = localTypeSubstitutor.substitute((Substitution)nullSubstitution, this.resolvedType);
        this.expectedType = localTypeSubstitutor.substitute((Substitution)nullSubstitution, this.expectedType);
    }

    boolean updateLocalTypesInMethod(MethodBinding methodBinding) {
        if (this.localTypes == null) {
            return false;
        }
        this.updateLocalTypesInMethod(methodBinding, new LocalTypeSubstitutor(this.localTypes), new Substitution.NullSubstitution(this.scope.environment()));
        return true;
    }

    private void updateLocalTypesInMethod(MethodBinding methodBinding, Scope.Substitutor substitutor, Substitution substitution) {
        methodBinding.declaringClass = (ReferenceBinding)substitutor.substitute(substitution, methodBinding.declaringClass);
        methodBinding.returnType = substitutor.substitute(substitution, methodBinding.returnType);
        for (int i = 0; i < methodBinding.parameters.length; ++i) {
            methodBinding.parameters[i] = substitutor.substitute(substitution, methodBinding.parameters[i]);
        }
    }

    private static enum CompatibilityResult {
        COMPATIBLE,
        INCOMPATIBLE,
        REPORTED;

    }

    class CopyFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CopyFailureException() {
        }
    }

    class LocalTypeSubstitutor
    extends Scope.Substitutor {
        Map<Integer, LocalTypeBinding> localTypes2;

        public LocalTypeSubstitutor(Map<Integer, LocalTypeBinding> map) {
            this.localTypes2 = map;
        }

        @Override
        public TypeBinding substitute(Substitution substitution, TypeBinding typeBinding) {
            if (typeBinding.isLocalType()) {
                TypeBinding typeBinding2;
                LocalTypeBinding localTypeBinding = (LocalTypeBinding)typeBinding;
                MethodScope methodScope = localTypeBinding.scope.enclosingLambdaScope();
                if (methodScope != null && ((LambdaExpression)methodScope.referenceContext).sourceStart == LambdaExpression.this.sourceStart && (typeBinding2 = (TypeBinding)this.localTypes2.get(localTypeBinding.sourceStart)) != null && typeBinding2 != localTypeBinding) {
                    localTypeBinding.transferConstantPoolNameTo(typeBinding2);
                    return typeBinding2;
                }
                return typeBinding;
            }
            return super.substitute(substitution, typeBinding);
        }
    }
}

