/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;

public class TypeAnnotationWalker
implements ITypeAnnotationWalker {
    protected final IBinaryTypeAnnotation[] typeAnnotations;
    protected final long matches;
    protected final int pathPtr;

    public TypeAnnotationWalker(IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray) {
        this(iBinaryTypeAnnotationArray, -1L >>> 64 - iBinaryTypeAnnotationArray.length);
    }

    TypeAnnotationWalker(IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray, long l2) {
        this(iBinaryTypeAnnotationArray, l2, 0);
    }

    protected TypeAnnotationWalker(IBinaryTypeAnnotation[] iBinaryTypeAnnotationArray, long l2, int n) {
        this.typeAnnotations = iBinaryTypeAnnotationArray;
        this.matches = l2;
        this.pathPtr = n;
    }

    protected ITypeAnnotationWalker restrict(long l2, int n) {
        if (this.matches == l2 && this.pathPtr == n) {
            return this;
        }
        if (l2 == 0L || this.typeAnnotations == null || this.typeAnnotations.length == 0) {
            return EMPTY_ANNOTATION_WALKER;
        }
        return new TypeAnnotationWalker(this.typeAnnotations, l2, n);
    }

    @Override
    public ITypeAnnotationWalker toField() {
        return this.toTarget(19);
    }

    @Override
    public ITypeAnnotationWalker toMethodReturn() {
        return this.toTarget(20);
    }

    @Override
    public ITypeAnnotationWalker toReceiver() {
        return this.toTarget(21);
    }

    protected ITypeAnnotationWalker toTarget(int n) {
        long l2 = this.matches;
        if (l2 == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = this.typeAnnotations.length;
        long l3 = 1L;
        int n3 = 0;
        while (n3 < n2) {
            if (this.typeAnnotations[n3].getTargetType() != n) {
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n3;
            l3 <<= 1;
        }
        return this.restrict(l2, 0);
    }

    @Override
    public ITypeAnnotationWalker toTypeParameter(boolean bl, int n) {
        long l2 = this.matches;
        if (l2 == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = bl ? 0 : 1;
        int n3 = this.typeAnnotations.length;
        long l3 = 1L;
        int n4 = 0;
        while (n4 < n3) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n4];
            if (iBinaryTypeAnnotation.getTargetType() != n2 || iBinaryTypeAnnotation.getTypeParameterIndex() != n) {
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n4;
            l3 <<= 1;
        }
        return this.restrict(l2, 0);
    }

    @Override
    public ITypeAnnotationWalker toTypeParameterBounds(boolean bl, int n) {
        long l2 = this.matches;
        if (l2 == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = this.typeAnnotations.length;
        int n3 = bl ? 17 : 18;
        long l3 = 1L;
        int n4 = 0;
        while (n4 < n2) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n4];
            if (iBinaryTypeAnnotation.getTargetType() != n3 || (short)iBinaryTypeAnnotation.getTypeParameterIndex() != n) {
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n4;
            l3 <<= 1;
        }
        return this.restrict(l2, 0);
    }

    @Override
    public ITypeAnnotationWalker toTypeBound(short s) {
        long l2 = this.matches;
        if (l2 == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n = this.typeAnnotations.length;
        long l3 = 1L;
        int n2 = 0;
        while (n2 < n) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n2];
            if ((short)iBinaryTypeAnnotation.getBoundIndex() != s) {
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n2;
            l3 <<= 1;
        }
        return this.restrict(l2, 0);
    }

    @Override
    public ITypeAnnotationWalker toSupertype(short s, char[] cArray) {
        long l2 = this.matches;
        if (l2 == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n = this.typeAnnotations.length;
        long l3 = 1L;
        int n2 = 0;
        while (n2 < n) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n2];
            if (iBinaryTypeAnnotation.getTargetType() != 16 || (short)iBinaryTypeAnnotation.getSupertypeIndex() != s) {
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n2;
            l3 <<= 1;
        }
        return this.restrict(l2, 0);
    }

    @Override
    public ITypeAnnotationWalker toMethodParameter(short s) {
        long l2 = this.matches;
        if (l2 == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n = this.typeAnnotations.length;
        long l3 = 1L;
        int n2 = 0;
        while (n2 < n) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n2];
            if (iBinaryTypeAnnotation.getTargetType() != 22 || (short)iBinaryTypeAnnotation.getMethodFormalParameterIndex() != s) {
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n2;
            l3 <<= 1;
        }
        return this.restrict(l2, 0);
    }

    @Override
    public ITypeAnnotationWalker toThrows(int n) {
        long l2 = this.matches;
        if (l2 == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = this.typeAnnotations.length;
        long l3 = 1L;
        int n3 = 0;
        while (n3 < n2) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n3];
            if (iBinaryTypeAnnotation.getTargetType() != 23 || iBinaryTypeAnnotation.getThrowsTypeIndex() != n) {
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n3;
            l3 <<= 1;
        }
        return this.restrict(l2, 0);
    }

    @Override
    public ITypeAnnotationWalker toTypeArgument(int n) {
        long l2 = this.matches;
        if (l2 == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n2 = this.typeAnnotations.length;
        long l3 = 1L;
        int n3 = 0;
        while (n3 < n2) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n3];
            int[] nArray = iBinaryTypeAnnotation.getTypePath();
            if (this.pathPtr >= nArray.length || nArray[this.pathPtr] != 3 || nArray[this.pathPtr + 1] != n) {
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n3;
            l3 <<= 1;
        }
        return this.restrict(l2, this.pathPtr + 2);
    }

    @Override
    public ITypeAnnotationWalker toWildcardBound() {
        long l2 = this.matches;
        if (l2 == 0L) {
            return EMPTY_ANNOTATION_WALKER;
        }
        int n = this.typeAnnotations.length;
        long l3 = 1L;
        int n2 = 0;
        while (n2 < n) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n2];
            int[] nArray = iBinaryTypeAnnotation.getTypePath();
            if (this.pathPtr >= nArray.length || nArray[this.pathPtr] != 2) {
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n2;
            l3 <<= 1;
        }
        return this.restrict(l2, this.pathPtr + 2);
    }

    @Override
    public ITypeAnnotationWalker toNextArrayDimension() {
        return this.toNextDetail(0);
    }

    @Override
    public ITypeAnnotationWalker toNextNestedType() {
        return this.toNextDetail(1);
    }

    protected ITypeAnnotationWalker toNextDetail(int n) {
        long l2 = this.matches;
        if (l2 == 0L) {
            return this.restrict(l2, this.pathPtr + 2);
        }
        int n2 = this.typeAnnotations.length;
        long l3 = 1L;
        int n3 = 0;
        while (n3 < n2) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation = this.typeAnnotations[n3];
            int[] nArray = iBinaryTypeAnnotation.getTypePath();
            if (this.pathPtr >= nArray.length || nArray[this.pathPtr] != n) {
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n3;
            l3 <<= 1;
        }
        return this.restrict(l2, this.pathPtr + 2);
    }

    @Override
    public IBinaryAnnotation[] getAnnotationsAtCursor(int n, boolean bl) {
        int n2 = this.typeAnnotations.length;
        IBinaryAnnotation[] iBinaryAnnotationArray = new IBinaryAnnotation[n2];
        long l2 = 1L;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            IBinaryTypeAnnotation iBinaryTypeAnnotation;
            if ((this.matches & l2) != 0L && (iBinaryTypeAnnotation = this.typeAnnotations[n4]).getTypePath().length <= this.pathPtr) {
                iBinaryAnnotationArray[n3++] = iBinaryTypeAnnotation.getAnnotation();
            }
            ++n4;
            l2 <<= 1;
        }
        if (n3 == 0) {
            return NO_ANNOTATIONS;
        }
        if (n3 < n2) {
            IBinaryAnnotation[] iBinaryAnnotationArray2 = iBinaryAnnotationArray;
            iBinaryAnnotationArray = new IBinaryAnnotation[n3];
            System.arraycopy(iBinaryAnnotationArray2, 0, iBinaryAnnotationArray, 0, n3);
        }
        return iBinaryAnnotationArray;
    }
}

