/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.File;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileObject;

public class EclipseDiagnostic
implements Diagnostic<EclipseFileObject> {
    private Diagnostic.Kind kind;
    private final int problemId;
    private final String[] problemArguments;
    private final char[] originatingFileName;
    private final int lineNumber;
    private final int columnNumber;
    private final int startPosition;
    private final int endPosition;
    private final DefaultProblemFactory problemFactory;

    private EclipseDiagnostic(Diagnostic.Kind kind, int n, String[] stringArray, char[] cArray, DefaultProblemFactory defaultProblemFactory, int n2, int n3, int n4, int n5) {
        this.kind = kind;
        this.problemId = n;
        this.problemArguments = stringArray;
        this.originatingFileName = cArray;
        this.problemFactory = defaultProblemFactory;
        this.lineNumber = n2;
        this.columnNumber = n3;
        this.startPosition = n4;
        this.endPosition = n5;
    }

    private EclipseDiagnostic(Diagnostic.Kind kind, int n, String[] stringArray, char[] cArray, DefaultProblemFactory defaultProblemFactory) {
        this(kind, n, stringArray, cArray, defaultProblemFactory, -1, -1, -1, -1);
    }

    public static EclipseDiagnostic newInstance(CategorizedProblem categorizedProblem, DefaultProblemFactory defaultProblemFactory) {
        if (categorizedProblem instanceof DefaultProblem) {
            return EclipseDiagnostic.newInstanceFromDefaultProblem((DefaultProblem)categorizedProblem, defaultProblemFactory);
        }
        return new EclipseDiagnostic(EclipseDiagnostic.getKind(categorizedProblem), categorizedProblem.getID(), categorizedProblem.getArguments(), categorizedProblem.getOriginatingFileName(), defaultProblemFactory);
    }

    private static EclipseDiagnostic newInstanceFromDefaultProblem(DefaultProblem defaultProblem, DefaultProblemFactory defaultProblemFactory) {
        return new EclipseDiagnostic(EclipseDiagnostic.getKind(defaultProblem), defaultProblem.getID(), defaultProblem.getArguments(), defaultProblem.getOriginatingFileName(), defaultProblemFactory, defaultProblem.getSourceLineNumber(), defaultProblem.getSourceColumnNumber(), defaultProblem.getSourceStart(), defaultProblem.getSourceEnd());
    }

    private static Diagnostic.Kind getKind(CategorizedProblem categorizedProblem) {
        Diagnostic.Kind kind = Diagnostic.Kind.OTHER;
        if (categorizedProblem.isError()) {
            kind = Diagnostic.Kind.ERROR;
        } else if (categorizedProblem.isWarning()) {
            kind = Diagnostic.Kind.WARNING;
        } else if (categorizedProblem instanceof DefaultProblem && ((DefaultProblem)categorizedProblem).isInfo()) {
            kind = Diagnostic.Kind.NOTE;
        }
        return kind;
    }

    @Override
    public Diagnostic.Kind getKind() {
        return this.kind;
    }

    @Override
    public EclipseFileObject getSource() {
        File file2 = new File(new String(this.originatingFileName));
        if (file2.exists()) {
            return new EclipseFileObject(null, file2.toURI(), JavaFileObject.Kind.SOURCE, null);
        }
        return null;
    }

    @Override
    public long getPosition() {
        return this.startPosition;
    }

    @Override
    public long getStartPosition() {
        return this.startPosition;
    }

    @Override
    public long getEndPosition() {
        return this.endPosition;
    }

    @Override
    public long getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public long getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public String getCode() {
        return Integer.toString(this.problemId);
    }

    @Override
    public String getMessage(Locale locale) {
        if (locale != null) {
            this.problemFactory.setLocale(locale);
        }
        return this.problemFactory.getLocalizedMessage(this.problemId, this.problemArguments);
    }
}

