/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;
import netrexx.lang.NoOtherwiseException;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import netrexx.lang.RexxSet;
import netrexx.lang.RexxTrace;
import org.netrexx.process.NrAssign;
import org.netrexx.process.NrBlock;
import org.netrexx.process.NrCatch;
import org.netrexx.process.NrDo;
import org.netrexx.process.NrEnd;
import org.netrexx.process.NrFinally;
import org.netrexx.process.NrIf;
import org.netrexx.process.NrLevel;
import org.netrexx.process.NrLoop;
import org.netrexx.process.NrNumeric;
import org.netrexx.process.NrOtherwise;
import org.netrexx.process.NrSay;
import org.netrexx.process.NrSelect;
import org.netrexx.process.NrTrace;
import org.netrexx.process.RxArray;
import org.netrexx.process.RxClass;
import org.netrexx.process.RxClassInfo;
import org.netrexx.process.RxClause;
import org.netrexx.process.RxClauseParser;
import org.netrexx.process.RxClauser;
import org.netrexx.process.RxCode;
import org.netrexx.process.RxCursor;
import org.netrexx.process.RxError;
import org.netrexx.process.RxField;
import org.netrexx.process.RxFileReader;
import org.netrexx.process.RxInterpreterHelper;
import org.netrexx.process.RxMethod;
import org.netrexx.process.RxParser;
import org.netrexx.process.RxProgram;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxSignal;
import org.netrexx.process.RxSignalPend;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTracer;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxType;
import org.netrexx.process.RxVariable;
import org.netrexx.process.WriterOutputStream;

public class RxInterpreter {
    private static final Rexx $01 = Rexx.toRexx(">> iarge:");
    private static final Rexx $02 = Rexx.toRexx("int");
    private static final Rexx $03 = new Rexx('=');
    private static final Rexx $04 = Rexx.toRexx("");
    private static final Rexx $05 = new Rexx('+');
    private static final Rexx $06 = new Rexx('-');
    private static final Rexx $07 = Rexx.toRexx("TRACE OFF");
    private static final Rexx $08 = new Rexx('?');
    private static final String $0 = "RxInterpreter.nrx";
    RxTranslator rxt;
    RxInterpreterHelper helper;
    private static final Integer int0 = new Integer(0);
    private static final Long long0 = new Long(0L);
    private static final Double dub0 = new Double(0.0);
    private static final Rexx char0 = new Rexx('\u0000');
    private static final RxClause nojump = new RxClause();

    public RxInterpreter(RxTranslator rxTranslator) {
        this.rxt = rxTranslator;
        this.helper = new RxInterpreterHelper(this.rxt);
    }

    private void initializeProperties(RxClass rxClass, Object object) {
        String string = null;
        int n = 0;
        NrNumeric nrNumeric = null;
        NrTrace nrTrace = null;
        RxClauseParser rxClauseParser = null;
        boolean bl = false;
        if (rxClass.classclauses == null && rxClass.classprogram.pendtrace.size() == 0 && rxClass.classprogram.pendnumeric.size() == 0) {
            return;
        }
        boolean bl2 = object == null;
        RxCursor rxCursor = new RxCursor(rxClass.classprogram, rxClass, null, null);
        rxCursor.curexec = true;
        rxCursor.curbinary = rxClass.classbinary;
        rxCursor.curstatic = bl2;
        rxCursor.curthis = object;
        RxProgram rxProgram = rxCursor.curprogram;
        if (rxProgram.flag.diag) {
            string = bl2 ? "static" : "instance";
            RexxIO.Say(Rexx.toRexx("# " + string + " Initialize class:").OpCcblank(null, rxClass.classname));
        }
        int n2 = rxProgram.pendnumeric.size();
        n = 0;
        while (n2 > 0) {
            rxCursor.curclause = (RxClause)rxProgram.pendnumeric.elementAt(n);
            nrNumeric = (NrNumeric)rxCursor.curclause.lookaside;
            nrNumeric.interpret(rxCursor);
            --n2;
            ++n;
        }
        if (rxCursor.curstatic) {
            n2 = rxProgram.pendtrace.size();
            n = 0;
            while (n2 > 0) {
                rxCursor.curclause = (RxClause)rxProgram.pendtrace.elementAt(n);
                nrTrace = (NrTrace)rxCursor.curclause.lookaside;
                nrTrace.interpret(rxCursor);
                --n2;
                ++n;
            }
        }
        RxClause rxClause = rxClass.classclauses;
        rxCursor.curpropatts = rxClass.classpropatts;
        while (rxClause != null) {
            rxCursor.curclause = rxClause;
            if (rxClause.lookaside != null && !((rxClauseParser = rxClause.lookaside) instanceof NrAssign ? (bl = (rxCursor.curpropatts & 0x300) != 0) != bl2 : rxClauseParser instanceof NrTrace && !bl2)) {
                rxClauseParser.interpret(rxCursor);
            }
            rxClause = rxClause.next;
        }
    }

    public Object initvalue(RxType rxType) {
        if (rxType.isPrimitive()) {
            if (rxType.equals(RxType.INT_TYPE)) {
                return int0;
            }
            if (rxType.equals(RxType.BOOL_TYPE)) {
                return int0;
            }
            if (rxType.equals(RxType.LONG_TYPE)) {
                return long0;
            }
            if (rxType.equals(RxType.DOUBLE_TYPE)) {
                return dub0;
            }
            if (rxType.equals(RxType.BYTE_TYPE)) {
                return int0;
            }
            if (rxType.equals(RxType.SHORT_TYPE)) {
                return int0;
            }
            if (rxType.equals(RxType.FLOAT_TYPE)) {
                return dub0;
            }
            if (rxType.equals(RxType.CHAR_TYPE)) {
                return char0;
            }
            throw new NoOtherwiseException();
        }
        return null;
    }

    public String stringvalue(RxCode rxCode) {
        if (rxCode.value == null) {
            return null;
        }
        if (rxCode.type.isPrimitive()) {
            if (rxCode.type.equals(RxType.INT_TYPE)) {
                return rxCode.value.toString();
            }
            if (rxCode.type.equals(RxType.BOOL_TYPE)) {
                return rxCode.value.toString();
            }
            if (rxCode.type.equals(RxType.LONG_TYPE)) {
                return rxCode.value.toString();
            }
            if (rxCode.type.equals(RxType.DOUBLE_TYPE)) {
                return rxCode.value.toString();
            }
            if (rxCode.type.equals(RxType.BYTE_TYPE)) {
                return String.valueOf(((Integer)rxCode.value).byteValue());
            }
            if (rxCode.type.equals(RxType.SHORT_TYPE)) {
                return String.valueOf(((Integer)rxCode.value).shortValue());
            }
            if (rxCode.type.equals(RxType.FLOAT_TYPE)) {
                return String.valueOf(((Double)rxCode.value).floatValue());
            }
            if (rxCode.type.equals(RxType.CHAR_TYPE)) {
                return rxCode.value.toString();
            }
            throw new NoOtherwiseException();
        }
        if (rxCode.value instanceof char[]) {
            return new String((char[])rxCode.value);
        }
        return rxCode.value.toString();
    }

    public int signvalue(RxCode rxCode) {
        char c = '\u0000';
        if (rxCode.value == null) {
            throw new NullPointerException("numeric value null");
        }
        if (rxCode.type.equals(RxType.INT_TYPE)) {
            return (Integer)rxCode.value;
        }
        if (rxCode.type.equals(RxType.BYTE_TYPE)) {
            return (Integer)rxCode.value;
        }
        if (rxCode.type.equals(RxType.SHORT_TYPE)) {
            return (Integer)rxCode.value;
        }
        if (rxCode.type.equals(RxType.BOOL_TYPE)) {
            return (Integer)rxCode.value;
        }
        if (rxCode.type.equals(RxType.LONG_TYPE)) {
            return ((Long)rxCode.value).compareTo(long0);
        }
        if (rxCode.type.equals(RxType.DOUBLE_TYPE)) {
            return ((Double)rxCode.value).compareTo(dub0);
        }
        if (rxCode.type.equals(RxType.FLOAT_TYPE)) {
            return ((Double)rxCode.value).compareTo(dub0);
        }
        if (rxCode.type.equals(RxType.CHAR_TYPE)) {
            c = ((Rexx)rxCode.value).tochar();
            if (c == '0') {
                return 0;
            }
            if (c > '0' && c <= '9') {
                return 1;
            }
            throw new NumberFormatException(String.valueOf(c));
        }
        if (rxCode.type.equals(RxType.REXX_TYPE)) {
            return ((Rexx)rxCode.value).sign().toint();
        }
        throw new NumberFormatException(rxCode.value.toString());
    }

    private void setupArgs(RxType[] rxTypeArray, Object[] objectArray, Class[] classArray, Object[] objectArray2, RxType rxType, Object object) {
        int n = 0;
        int n2 = 0;
        RxType rxType2 = null;
        if (rxType == null) {
            n = 0;
        } else {
            n = 1;
            classArray[0] = rxType.getClassObject(this.rxt.loader);
            objectArray2[0] = this.code2ref(object, rxType);
        }
        int n3 = objectArray.length;
        n2 = 0;
        while (n3 > 0) {
            rxType2 = rxTypeArray[n2];
            classArray[n2 + n] = rxType2.getClassObject(this.rxt.loader);
            objectArray2[n2 + n] = this.code2ref(objectArray[n2], rxType2);
            --n3;
            ++n2;
        }
    }

    public Object code2ref(Object object, RxType rxType) {
        if (rxType.isPrimitive() && !rxType.equals(RxType.INT_TYPE) && !rxType.equals(RxType.LONG_TYPE) && !rxType.equals(RxType.DOUBLE_TYPE)) {
            if (rxType.equals(RxType.BYTE_TYPE)) {
                object = new Byte(((Integer)object).byteValue());
            } else if (rxType.equals(RxType.SHORT_TYPE)) {
                object = new Short(((Integer)object).shortValue());
            } else if (rxType.equals(RxType.FLOAT_TYPE)) {
                object = new Float(((Number)object).floatValue());
            } else if (rxType.equals(RxType.BOOL_TYPE)) {
                object = new Boolean((Integer)object == 1);
            } else if (rxType.equals(RxType.CHAR_TYPE)) {
                object = new Character(((Rexx)object).tochar());
            } else {
                throw new NoOtherwiseException();
            }
        }
        return object;
    }

    public Object ref2code(Object object, RxType rxType) {
        if (rxType.isPrimitive() && !rxType.equals(RxType.INT_TYPE) && !rxType.equals(RxType.LONG_TYPE) && !rxType.equals(RxType.DOUBLE_TYPE)) {
            if (rxType.equals(RxType.BYTE_TYPE)) {
                object = new Integer(((Byte)object).byteValue());
            } else if (rxType.equals(RxType.SHORT_TYPE)) {
                object = new Integer(((Short)object).shortValue());
            } else if (rxType.equals(RxType.FLOAT_TYPE)) {
                object = new Double(((Float)object).floatValue());
            } else if (rxType.equals(RxType.BOOL_TYPE)) {
                object = ((Boolean)object).booleanValue() ? new Integer(1) : new Integer(0);
            } else if (rxType.equals(RxType.CHAR_TYPE)) {
                object = new Rexx(((Character)object).charValue());
            } else {
                throw new NoOtherwiseException();
            }
        }
        return object;
    }

    public Object getArrayElementValue(RxCursor rxCursor, Object object, RxType rxType, RxArray rxArray, RxToken rxToken) {
        int n = 0;
        int n2 = 0;
        RxType rxType2 = null;
        ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = null;
        if (object == null) {
            throw new NullPointerException("null array reference");
        }
        int n3 = rxArray.arraydim - 1;
        try {
            int n4 = rxArray.arraydim;
            n = 0;
            while (n4 > 0) {
                n2 = (Integer)rxArray.arraycode[n].value;
                object = Array.get(object, n2);
                if (n3 == 0) {
                    rxType2 = rxType.basetype(rxType.dimension - rxArray.arraydim);
                    object = this.ref2code(object, rxType2);
                }
                --n3;
                --n4;
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
            arrayIndexOutOfBoundsException = arrayIndexOutOfBoundsException2;
            throw new RxSignal(rxCursor, arrayIndexOutOfBoundsException, rxToken);
        }
        return object;
    }

    public void setArrayElementValue(RxCursor rxCursor, Object object, RxType rxType, RxArray rxArray, RxToken rxToken, Object object2) {
        int n = 0;
        int n2 = 0;
        ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = null;
        if (object == null) {
            throw new NullPointerException("null array reference");
        }
        int n3 = rxArray.arraydim - 1;
        try {
            int n4 = rxArray.arraydim;
            n = 0;
            while (n4 > 0) {
                n2 = (Integer)rxArray.arraycode[n].value;
                if (n3 > 0) {
                    object = Array.get(object, n2);
                } else {
                    object2 = this.code2ref(object2, rxType);
                    Array.set(object, n2, object2);
                }
                --n3;
                --n4;
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
            arrayIndexOutOfBoundsException = arrayIndexOutOfBoundsException2;
            throw new RxSignal(rxCursor, arrayIndexOutOfBoundsException, rxToken);
        }
    }

    public Rexx getStemElementValue(RxCursor rxCursor, Rexx rexx, RxArray rxArray, RxToken rxToken) {
        int n = 0;
        Rexx rexx2 = null;
        if (rexx == null) {
            throw new RxSignal(rxCursor, new NullPointerException(), rxToken);
        }
        int n2 = rxArray.arraydim;
        n = 0;
        while (n2 > 0) {
            rexx2 = (Rexx)rxArray.arraycode[n].value;
            rexx = rexx.getnode((Rexx)rexx2).leaf;
            --n2;
            ++n;
        }
        return rexx;
    }

    public void setStemElementValue(RxCursor rxCursor, Rexx rexx, RxArray rxArray, RxToken rxToken, Rexx rexx2) {
        int n;
        int n2 = 0;
        Rexx rexx3 = null;
        if (rexx == null) {
            throw new RxSignal(rxCursor, new NullPointerException(), rxToken);
        }
        int n3 = n = rxArray.arraydim - 1;
        for (n2 = 0; n2 <= n3; ++n2) {
            rexx3 = (Rexx)rxArray.arraycode[n2].value;
            if (n2 < n) {
                rexx = rexx.getnode((Rexx)rexx3).leaf;
                continue;
            }
            rexx.getnode((Rexx)rexx3).leaf = rexx2;
        }
    }

    public Object getVar(RxCursor rxCursor, RxVariable rxVariable, RxToken rxToken) {
        if ((rxVariable.varatts & 4) == 0) {
            return rxVariable.varvalue;
        }
        return this.getProperty(rxCursor.curthis, rxVariable.varfield, rxToken);
    }

    public void setVar(RxCursor rxCursor, RxVariable rxVariable, RxToken rxToken, Object object) {
        if ((rxVariable.varatts & 4) == 0) {
            rxVariable.varvalue = object;
            return;
        }
        this.setProperty(rxCursor.curthis, rxVariable.varfield, rxToken, object);
    }

    public Object getProperty(Object object, RxField rxField, RxToken rxToken) {
        return this.doProperty(object, rxField, rxToken, false, null);
    }

    public void setProperty(Object object, RxField rxField, RxToken rxToken, Object object2) {
        this.doProperty(object, rxField, rxToken, true, object2);
    }

    private Object doProperty(Object object, RxField rxField, RxToken rxToken, boolean bl, Object object2) {
        Field field = null;
        Object object3 = null;
        IllegalAccessException illegalAccessException = null;
        SecurityException securityException = null;
        IllegalArgumentException illegalArgumentException = null;
        Class clazz = rxField.fieldinfo.getClassObject(this.rxt.loader);
        try {
            field = clazz.getDeclaredField(Rexx.toString(rxField.fieldname));
            field.setAccessible(true);
            if (bl) {
                object2 = this.code2ref(object2, rxField.fieldtype);
                field.set(object, object2);
                object3 = null;
            } else {
                object3 = field.get(object);
                object3 = this.ref2code(object3, rxField.fieldtype);
            }
        }
        catch (IllegalAccessException illegalAccessException2) {
            illegalAccessException = illegalAccessException2;
            throw new RxSignalPend(illegalAccessException, rxToken);
        }
        catch (SecurityException securityException2) {
            securityException = securityException2;
            throw new RxSignalPend(securityException, rxToken);
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
            throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxInterpreter: pia " + illegalArgumentException.getMessage()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxInterpreter: pnf"));
        }
        return object3;
    }

    public void proxyInit(int n) {
        RxClassInfo rxClassInfo = this.rxt.classer.findclassbyid(n);
        RxClass rxClass = rxClassInfo.localclass;
        this.initializeProperties(rxClass, null);
    }

    public Object callMethod(Object object, int n, Object[] objectArray) {
        boolean bl = false;
        Object object2 = null;
        RxSignal rxSignal = null;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        RxField rxField = this.rxt.classer.findfieldbyid(n);
        if (rxField.fieldtype.equals(RxType.VOID_TYPE)) {
            try {
                object2 = this.callMethod(object, rxField, objectArray, null, bl, true);
                return object2;
            }
            catch (RxSignal rxSignal2) {
                rxSignal = rxSignal2;
                if (rxSignal.signalobj == null) {
                    return null;
                }
                throw rxSignal;
            }
        }
        return this.callMethod(object, rxField, objectArray, null, bl, true);
    }

    public Object callMethod(Object object, RxField rxField, RxCode[] rxCodeArray, RxToken rxToken) {
        int n = 0;
        Object[] objectArray = new Object[rxCodeArray.length];
        int n2 = rxCodeArray.length;
        n = 0;
        while (n2 > 0) {
            objectArray[n] = rxCodeArray[n].value;
            --n2;
            ++n;
        }
        return this.callMethod(object, rxField, objectArray, rxToken, false, false);
    }

    public Object callMethod(Object object, RxField rxField, Object[] objectArray, RxToken rxToken, boolean bl, boolean bl2) {
        Class clazz = null;
        Class[] classArray = null;
        Object[] objectArray2 = null;
        Constructor constructor = null;
        Object object2 = null;
        Method method = null;
        IllegalArgumentException illegalArgumentException = null;
        int n = 0;
        InvocationTargetException invocationTargetException = null;
        IllegalAccessException illegalAccessException = null;
        SecurityException securityException = null;
        int n2 = 0;
        String string = null;
        RxField rxField2 = null;
        int n3 = 0;
        PrintStream printStream = null;
        RxVariable rxVariable = null;
        String string2 = null;
        RxCode rxCode = null;
        String string3 = null;
        String string4 = null;
        Object object3 = null;
        RxSignal rxSignal = null;
        if (this.rxt.interpreting) {
            return null;
        }
        boolean bl3 = rxField.isConstructor();
        RxMethod rxMethod = (RxMethod)rxField.fieldlocal;
        if (rxMethod == null || bl3 & !bl2) {
            clazz = rxField.fieldinfo.getClassObject(this.rxt.loader);
            try {
                if (bl3) {
                    if (rxField.fieldinfo.isdependent) {
                        classArray = new Class[objectArray.length + 1];
                        objectArray2 = new Object[objectArray.length + 1];
                        this.setupArgs(rxField.fieldargtypes, objectArray, classArray, objectArray2, rxField.fieldinfo.parentinfo.type, object);
                    } else {
                        classArray = new Class[objectArray.length];
                        objectArray2 = new Object[objectArray.length];
                        this.setupArgs(rxField.fieldargtypes, objectArray, classArray, objectArray2, null, null);
                    }
                    constructor = clazz.getDeclaredConstructor(classArray);
                    constructor.setAccessible(true);
                    object2 = constructor.newInstance(objectArray2);
                } else {
                    classArray = new Class[objectArray.length];
                    objectArray2 = new Object[objectArray.length];
                    this.setupArgs(rxField.fieldargtypes, objectArray, classArray, objectArray2, null, null);
                    method = clazz.getDeclaredMethod(Rexx.toString(rxField.fieldname), classArray);
                    method.setAccessible(true);
                    object2 = method.invoke(object, objectArray2);
                    object2 = this.ref2code(object2, rxField.fieldtype);
                }
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                illegalArgumentException = illegalArgumentException2;
                RexxIO.Say($01.OpCcblank(null, rxField.fieldname).OpCcblank(null, new Rexx(object == null)).OpCcblank(null, Rexx.toRexx(illegalArgumentException.getMessage())));
                int n4 = objectArray.length;
                n = 0;
                while (n4 > 0) {
                    RexxIO.Say("  Type: " + classArray[n].toString() + " VType: " + objectArray2[n].getClass().toString() + " Value: " + objectArray2[n].toString());
                    --n4;
                    ++n;
                }
                throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxInterpreter: iarge"));
            }
            catch (InvocationTargetException invocationTargetException2) {
                invocationTargetException = invocationTargetException2;
                throw new RxSignalPend(invocationTargetException.getTargetException(), rxToken);
            }
            catch (IllegalAccessException illegalAccessException2) {
                illegalAccessException = illegalAccessException2;
                throw new RxSignalPend(illegalAccessException, rxToken);
            }
            catch (SecurityException securityException2) {
                securityException = securityException2;
                throw new RxSignalPend(securityException, rxToken);
            }
            catch (InstantiationException instantiationException) {
                throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxInterpreter: cie"));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                RexxIO.Say("Field: " + rxField.toConciseString(rxField.fieldprogram));
                int n5 = classArray.length;
                n2 = 0;
                while (n5 > 0) {
                    RexxIO.Say("     : " + classArray[n2].getName());
                    --n5;
                    ++n2;
                }
                throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxInterpreter: mnf"));
            }
            return object2;
        }
        this.rxt.program = rxMethod.methodprogram;
        RxClassInfo rxClassInfo = rxField.fieldinfo;
        RxClass rxClass = rxClassInfo.localclass;
        RxCursor rxCursor = new RxCursor(rxClass.classprogram, rxClass, rxMethod, rxMethod.methodclause);
        rxCursor.curbinary = rxMethod.methodbinary;
        rxCursor.curprecall = bl;
        rxCursor.curexec = true;
        rxCursor.curthis = object;
        if (this.rxt.exiting) {
            throw new RxSignal(rxCursor, null, null);
        }
        if (!rxClassInfo.initialized) {
            rxClassInfo.getClassObject(this.rxt.loader);
        }
        if (this.rxt.superflag.diag) {
            if (bl3) {
                string = "constructor";
                string = bl ? string + " precall" : string + " body";
            } else {
                string = rxMethod.methodstatic ? "function" : "method";
            }
            RexxIO.Say(Rexx.toRexx("# -> invoke " + string + ":").OpCcblank(null, rxMethod.methodname).OpCcblank(null, new Rexx(object == null)).OpCcblank(null, new Rexx(rxMethod.methodprotected)));
        }
        if (bl3) {
            if (!bl) {
                this.initializeProperties(rxClass, object);
                if (rxMethod.methodhadthissuper) {
                    rxCursor.curskipone = true;
                    rxField2 = rxField.fieldspecial;
                    n3 = rxField2.fieldargtypes.length;
                    if (n3 > 0) {
                        rxCursor.curskiptrace = true;
                    }
                }
            } else {
                rxCursor.curparent = object;
                rxCursor.curthis = null;
            }
        }
        rxCursor.curnumer = !rxMethod.methodhadnumeric ? rxCursor.curclass.classrunnumer : (rxCursor.curclass.classrunnumer == null ? new RexxSet() : new RexxSet(rxCursor.curclass.classrunnumer));
        if (!rxMethod.methodtracechange) {
            rxCursor.curtrace = rxCursor.curclass.classruntrace;
        } else if (rxCursor.curclass.classruntrace == null) {
            printStream = rxCursor.curprogram.flag.trace == 1 ? System.out : System.err;
            if (this.rxt.jsr223Engine != null) {
                printStream = new PrintStream(new WriterOutputStream(this.rxt.jsr223Engine.getContext().getErrorWriter()));
            }
            rxCursor.curtrace = new RexxTrace(rxCursor.curprogram.source.getLineCount(), printStream, rxCursor.curprogram.source.getName());
        } else {
            rxCursor.curtrace = new RexxTrace(rxCursor.curclass.classruntrace);
        }
        if (!(rxCursor.curtrace == null || rxMethod.methoddefault || rxMethod.methodsynthetic || rxCursor.curskiptrace)) {
            rxCursor.curtrace.traceclause(rxMethod.methodclause.tokens[0].line, rxMethod.methodclause.tracelines(this.rxt), 2, (String[])null);
        }
        int n6 = rxMethod.methodprotopool.size() * 7 / 4;
        rxCursor.curlpool = new Hashtable(n6);
        Enumeration enumeration = rxMethod.methodprotopool.elements();
        Enumeration enumeration2 = rxMethod.methodprotopool.keys();
        while (enumeration.hasMoreElements()) {
            rxVariable = (RxVariable)enumeration.nextElement();
            rxVariable = rxVariable.copy();
            rxVariable.varvalue = this.initvalue(rxVariable.vartype);
            string2 = (String)enumeration2.nextElement();
            rxCursor.curlpool.put(string2, rxVariable);
        }
        RxVariable[] rxVariableArray = rxMethod.methodargvars;
        int n7 = rxVariableArray.length;
        n = 0;
        while (n7 > 0) {
            rxVariable = rxCursor.curprogram.pooler.refindvar(rxCursor, rxVariableArray[n].varname);
            if (n < objectArray.length) {
                rxVariable.varvalue = objectArray[n];
                if (rxVariable.varmain) {
                    rxVariable.varvalue = new Rexx((String[])rxVariable.varvalue);
                }
            } else {
                rxCode = rxMethod.methodargcode[n];
                if (!rxCode.constant || rxCursor.curtrace != null) {
                    rxCode = this.rxt.eparser.evalexpr(rxCursor, false, rxCode.begoff, RxMethod.methodargends.toCharArray(), null, '\u0000', null);
                }
                rxVariable.varvalue = rxCode.value;
            }
            if (!(rxCursor.curtrace == null || rxVariable.varmain || rxCursor.curskiptrace || rxMethod.methodsynthetic)) {
                if (n < objectArray.length) {
                    rxCode = new RxCode('G', rxVariable.vartype, null);
                    rxCode.value = rxVariable.varvalue;
                }
                string3 = this.stringvalue(rxCode);
                string4 = "m";
                rxCursor.curtrace.traceString(rxMethod.methodclause.tokens[0].line, string3, Rexx.tochar(string4), 2, Rexx.toString(rxVariable.varname));
            }
            --n7;
            ++n;
        }
        Object object4 = null;
        if (rxMethod.methodsynthetic) {
            if (rxCursor.curprogram.flag.diag) {
                RexxIO.Say(Rexx.toRexx("# synthetic method:").OpCcblank(null, rxMethod.methodname));
            }
            rxMethod.interpret(rxCursor);
            if (rxCursor.curreturn != null) {
                return rxCursor.curreturn;
            }
            return object4;
        }
        rxCursor.curstatic = rxMethod.methodstatic;
        rxCursor.curjump = nojump;
        rxCursor.curclause = null;
        this.pushlevel(rxCursor);
        rxCursor.curclause = rxMethod.methodclauses;
        if (!rxMethod.methodprotected) {
            this.runfree(rxCursor);
        } else {
            object3 = !rxMethod.methodstatic ? rxCursor.curthis : rxClass.classinfo.getClassObject();
            this.runprotected(rxCursor, object3);
        }
        if (rxCursor.curreturn != null) {
            object4 = rxCursor.curreturn;
            rxCursor.curreturn = null;
        }
        this.poplevel(rxCursor);
        if (rxCursor.curacttype == 2) {
            rxSignal = (RxSignal)object4;
            if (rxSignal.signalobj == null) {
                this.rxt.exiting = true;
                return null;
            }
            if (rxSignal.signalobj instanceof Object[]) {
                return rxSignal.signalobj;
            }
            RxSignal rxSignal2 = rxSignal;
            Objects.requireNonNull(rxSignal2);
            new RxSignal.Frame(rxSignal2, rxCursor.curprogram, rxField, rxToken);
            throw rxSignal;
        }
        return object4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runprotected(RxCursor rxCursor, Object object) {
        Object object2 = object;
        synchronized (object2) {
            if (rxCursor.curprogram.flag.diag) {
                RexxIO.Say("# protecting: " + object.toString());
            }
            this.runfree(rxCursor);
            if (rxCursor.curprogram.flag.diag) {
                RexxIO.Say("# unprotecting: " + object.toString());
            }
        }
    }

    public void runfree(RxCursor rxCursor) {
        RxClause rxClause = null;
        String[] stringArray = null;
        int n = 0;
        NrBlock nrBlock = null;
        Object object = null;
        RxSignal rxSignal = null;
        Rexx rexx = null;
        RxClauseParser rxClauseParser = null;
        RxFileReader rxFileReader = null;
        RxClauser rxClauser = null;
        int n2 = 0;
        RxClause rxClause2 = null;
        RxCursor rxCursor2 = null;
        RxCode rxCode = null;
        RxToken rxToken = null;
        char c = '\u0000';
        RxToken rxToken2 = null;
        char c2 = '\u0000';
        boolean bl = false;
        int n3 = 0;
        RxToken rxToken3 = null;
        char c3 = '\u0000';
        NrAssign nrAssign = null;
        NrSay nrSay = null;
        RxClauseParser rxClauseParser2 = null;
        block17: while (rxCursor.curclause != null) {
            rxClause = rxCursor.curclause;
            if (rxCursor.curtrace != null && !rxCursor.curnewprot && !rxCursor.curskiptrace) {
                if (rxClause.lookaside != null) {
                    stringArray = rxClause.lookaside.getAssigns();
                    n = 1;
                } else {
                    stringArray = null;
                    n = 3;
                }
                rxCursor.curtrace.traceclause(rxClause.tokens[0].line, rxClause.tracelines(this.rxt), n, stringArray);
            }
            block18: while (rxClause.lookaside != null) {
                if (rxClause.startprot & !rxCursor.curnewprot) {
                    nrBlock = (NrBlock)rxClause.lookaside;
                    object = nrBlock.evalProtect(rxCursor);
                    rxCursor.curnewprot = true;
                    this.runprotected(rxCursor, object);
                    rxClause = rxCursor.curclause;
                } else {
                    try {
                        if (rxCursor.curskipone) {
                            rxCursor.curskipone = false;
                            rxCursor.curskiptrace = false;
                        } else {
                            rxClause.lookaside.interpret(rxCursor);
                        }
                        if (rxCursor.curendprot) {
                            rxCursor.curendprot = false;
                            rxCursor.curnewprot = false;
                            return;
                        }
                    }
                    catch (RxSignal rxSignal2) {
                        rxSignal = rxSignal2;
                        rxCursor.curreturn = rxSignal;
                        rxCursor.curact = true;
                        rxCursor.curacttype = 2;
                    }
                }
                if (rxCursor.curtrace != null && rxCursor.curtrace.levelword().OpEqS(null, $02)) {
                    block19: while (true) {
                        RexxIO.Say("    *-> \u0000");
                        rexx = RexxIO.Ask();
                        if (rexx.OpEqS(null, $03)) {
                            rxClauseParser = rxCursor.curclause.lookaside;
                            if (!(rxClauseParser instanceof NrDo | rxClauseParser instanceof NrLoop | rxClauseParser instanceof NrSelect | rxClauseParser instanceof NrEnd | rxClauseParser instanceof NrCatch | rxClauseParser instanceof NrOtherwise | rxClauseParser instanceof NrFinally)) continue block18;
                            RexxIO.Say("        Sorry, this clause cannot be re-interpreted");
                            continue;
                        }
                        if (rexx.OpEqS(null, $04)) break;
                        if (rexx.substr(new Rexx(1), new Rexx(1)).OpEqS(null, $05)) {
                            this.helper.showSource(rxCursor, rexx);
                            continue;
                        }
                        if (rexx.substr(new Rexx(1), new Rexx(1)).OpEqS(null, $06)) {
                            this.helper.showSource(rxCursor, rexx);
                            continue;
                        }
                        if (rexx.upper().strip(new Rexx('B')).OpEqS(null, $07)) {
                            rxCursor.curtrace.newlevel(0);
                            break;
                        }
                        if (rexx.OpEqS(null, $08)) {
                            RexxIO.Say("Experimental interactive trace :");
                            RexxIO.Say("  press [Enter] to trace interactively");
                            RexxIO.Say("  type '=' to reinterpret current clause");
                            RexxIO.Say("  type '-[n]' to show previous n clause(s), shows current clause if n is absent");
                            RexxIO.Say("  type '+[n]' to show next n clause(s), shows next clause if n is absent");
                            RexxIO.Say("  type 'trace off' to stop tracing");
                            RexxIO.Say("  any other clause entered must be either an assignment or a SAY instruction");
                            continue;
                        }
                        rxFileReader = new RxFileReader(this.rxt);
                        rxFileReader.openfile(Rexx.toRexx("trace"), Rexx.toString(rexx));
                        rxClauser = new RxClauser(this.rxt, rxFileReader);
                        this.rxt.program.parser = new RxParser(this.rxt, rxClauser);
                        this.rxt.program.tracer = new RxTracer(this.rxt);
                        this.rxt.program.parser.level = 3;
                        this.rxt.program.parser.cursor = rxCursor;
                        this.rxt.pass = 0;
                        this.rxt.pass0 = true;
                        n2 = 0;
                        do {
                            ++n2;
                            try {
                                rxClause2 = rxClauser.clause(n2);
                            }
                            catch (RxQuit rxQuit) {
                                RexxIO.Say("    --- Invalid trace instruction (Q0)");
                                continue block19;
                            }
                            catch (RxError rxError) {
                                RexxIO.Say("    --- Invalid trace instruction (E0)");
                                continue block19;
                            }
                        } while (rxClause2 != null);
                        this.rxt.pass = 3;
                        this.rxt.pass0 = false;
                        n2 = 0;
                        while ((rxClause2 = rxClauser.clause(++n2)) != null) {
                            rxCursor2 = new RxCursor(rxCursor.curprogram, rxCursor.curclass, rxCursor.curmethod, rxClause2);
                            rxCursor2.curlpool = rxCursor.curlpool;
                            rxCursor2.curexec = true;
                            rxCursor2.curthis = rxCursor.curthis;
                            rxCursor2.curclass = rxCursor.curclass;
                            rxCode = null;
                            rxToken = rxCursor2.curclause.tokens[0];
                            c = rxToken.type;
                            if (c == ';') {
                                throw new RxQuit(this.rxt, (RxToken)null, "internal.error", Rexx.toRexx("null clause 3"));
                            }
                            rxToken2 = rxCursor2.curclause.tokens[1];
                            c2 = rxToken2.type;
                            this.rxt.program.parser.cursor = rxCursor2;
                            if (c == 'S') {
                                if (c2 == 'B') {
                                    rxCode = this.rxt.tparser.parsesymbol(rxCursor2, 0);
                                } else if (c2 == 'O' && rxToken2.value != null && rxToken2.value[0] == '=') {
                                    rxCode = this.rxt.tparser.parsesymbol(rxCursor2, 0);
                                }
                            }
                            bl = false;
                            if (rxCode == null) {
                                try {
                                    rxCode = this.rxt.tparser.parseterm(rxCursor2, 0, false);
                                    if (rxCode.group == 'M') {
                                        bl = true;
                                    }
                                }
                                catch (RxQuit rxQuit) {
                                }
                                catch (RxError rxError) {
                                    // empty catch block
                                }
                            }
                            if (rxCode == null) {
                                n3 = 0;
                            } else {
                                if (rxCode.begclause == null) {
                                    throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxParser: bcnull"));
                                }
                                n3 = rxCode.endoff + 1;
                            }
                            rxToken3 = rxCursor2.curclause.tokens[n3];
                            c3 = rxToken3.type;
                            if (c3 == 'O') {
                                if (rxToken3.value[0] == '=') {
                                    try {
                                        bl = true;
                                        nrAssign = new NrAssign(this.rxt);
                                        rxCursor2.curclause.lookaside = nrAssign;
                                        rxCursor2.curtrace = new RexxTrace(1);
                                        rxCursor2.curexec = false;
                                        nrAssign.process(rxCode, n3);
                                        rxCursor2.curexec = true;
                                        nrAssign.interpret(rxCursor2);
                                    }
                                    catch (RxQuit rxQuit) {
                                        RexxIO.Say("    --- Invalid trace instruction (QA)");
                                    }
                                    catch (RxError rxError) {
                                        RexxIO.Say("    --- Invalid trace instruction (EA)");
                                    }
                                }
                            } else if (c == 'S' && this.rxt.program.parser.iskey(rxToken.value, "SAY")) {
                                try {
                                    bl = true;
                                    nrSay = new NrSay(this.rxt);
                                    rxCursor2.curexec = false;
                                    nrSay.scan(2);
                                    rxCursor2.curexec = true;
                                    nrSay.interpret(rxCursor2);
                                }
                                catch (RxQuit rxQuit) {
                                    RexxIO.Say("    --- Invalid trace instruction (QS)");
                                }
                                catch (RxError rxError) {
                                    RexxIO.Say("    --- Invalid trace instruction (ES)");
                                }
                            }
                            if (bl) continue;
                            try {
                                rxCode = this.rxt.tparser.parseterm(rxCursor2, 0, false);
                                if (rxCode == null) {
                                    throw new RxError(this.rxt, null, "expression.has.no.value");
                                }
                                if (rxCode.group != 'U') continue;
                                throw new RxError(this.rxt, null, "expression.has.no.value");
                            }
                            catch (RxQuit rxQuit) {
                                RexxIO.Say("    --- Invalid trace instruction (QT)");
                            }
                            catch (RxError rxError) {
                                RexxIO.Say("    --- Invalid trace instruction (ET)");
                            }
                        }
                        this.rxt.program.parser = null;
                        this.rxt.program.tracer = null;
                    }
                }
                while (rxCursor.curlevel.thisone) {
                    rxClauseParser2 = rxCursor.curlevel.clause.lookaside;
                    if (rxClauseParser2 instanceof NrIf) {
                        rxCursor.curjump = ((NrIf)rxClauseParser2).nextclause;
                        this.poplevel(rxCursor);
                        continue;
                    }
                    rxCursor.curlevel.thisone = false;
                    this.endblock(rxCursor);
                }
                if (rxCursor.curlevel.nextone) {
                    rxCursor.curlevel.thisone = true;
                    rxCursor.curlevel.nextone = false;
                    break;
                }
                if (rxCursor.curacttype == 0) break;
                if (rxCursor.curact || rxCursor.curclause.lookaside instanceof NrEnd) {
                    this.unwind(rxCursor);
                }
                if (rxCursor.curlevel.prev == null) break block17;
            }
            if (rxCursor.curjump != nojump) {
                rxCursor.curclause = rxCursor.curjump;
                rxCursor.curjump = nojump;
            } else {
                rxCursor.curclause = rxClause.next;
            }
            if (rxCursor.curact) {
                rxCursor.curact = false;
                continue;
            }
            if (rxCursor.curclause == null || !rxCursor.curclause.skipend || rxCursor.curlevel.trystate == 2) continue;
            this.endBody(rxCursor);
            rxCursor.curclause = rxCursor.curjump;
            rxCursor.curjump = nojump;
        }
    }

    public void endBody(RxCursor rxCursor) {
        RxClauseParser rxClauseParser = rxCursor.curlevel.clause.lookaside;
        if (rxClauseParser instanceof NrLoop) {
            rxCursor.curjump = rxCursor.curlevel.clause;
        } else {
            this.endblock(rxCursor);
        }
    }

    private void endblock(RxCursor rxCursor) {
        NrBlock nrBlock = (NrBlock)rxCursor.curlevel.clause.lookaside;
        rxCursor.curjump = rxCursor.curlevel.trystate == 2 ? nrBlock.endclause : (nrBlock.finclause != null ? nrBlock.finclause : nrBlock.endclause);
        rxCursor.curlevel.trystate = 2;
    }

    private void unwind(RxCursor rxCursor) {
        block16: {
            Vector vector2 = null;
            RxSignal rxSignal = null;
            int n = 0;
            RxClause rxClause = null;
            if (rxCursor.curlevel.prev == null) {
                return;
            }
            RxClauseParser rxClauseParser = rxCursor.curlevel.clause.lookaside;
            while (rxClauseParser instanceof NrIf) {
                this.poplevel(rxCursor);
                if (rxCursor.curlevel.prev == null) {
                    return;
                }
                rxClauseParser = rxCursor.curlevel.clause.lookaside;
            }
            if (rxCursor.curacttype == 2) {
                if (rxCursor.curlevel.trystate == 0 && (vector2 = ((NrBlock)rxClauseParser).catches) != null) {
                    rxSignal = (RxSignal)rxCursor.curreturn;
                    int n2 = vector2.size();
                    n = 0;
                    while (n2 > 0) {
                        rxClause = (RxClause)vector2.elementAt(n);
                        if (((NrCatch)rxClause.lookaside).canCatch(rxCursor, rxSignal)) {
                            rxCursor.curjump = rxClause;
                            break block16;
                        }
                        --n2;
                        ++n;
                    }
                }
                this.endblock(rxCursor);
            } else if (rxCursor.curacttype == 3) {
                if ((NrBlock)rxClauseParser == rxCursor.curactblock) {
                    rxCursor.curacttype = 0;
                }
                this.endblock(rxCursor);
            } else if (rxCursor.curacttype == 4) {
                if ((NrBlock)rxClauseParser == rxCursor.curactblock) {
                    rxCursor.curacttype = 0;
                }
                this.endBody(rxCursor);
            } else if (rxCursor.curacttype == 1) {
                this.endblock(rxCursor);
            } else {
                throw new NoOtherwiseException();
            }
        }
    }

    public NrLevel pushlevel(RxCursor rxCursor) {
        NrLevel nrLevel = new NrLevel(rxCursor.curclause);
        nrLevel.prev = rxCursor.curlevel;
        rxCursor.curlevel = nrLevel;
        return nrLevel;
    }

    public void poplevel(RxCursor rxCursor) {
        rxCursor.curlevel = rxCursor.curlevel.prev;
    }
}

