/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.canvasled;

import eu.hansolo.enzo.canvasled.Led;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.paint.Color;

public class LedBuilder<B extends LedBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected LedBuilder() {
    }

    public static final LedBuilder create() {
        return new LedBuilder();
    }

    public final LedBuilder styleClass(String STYLE_CLASS) {
        this.properties.put("styleClass", (Property)new SimpleStringProperty(STYLE_CLASS));
        return this;
    }

    public final LedBuilder ledColor(Color LED_COLOR) {
        this.properties.put("ledColor", (Property)new SimpleObjectProperty((Object)LED_COLOR));
        return this;
    }

    public final LedBuilder on(boolean ON) {
        this.properties.put("on", (Property)new SimpleBooleanProperty(ON));
        return this;
    }

    public final LedBuilder blinking(boolean BLINKING) {
        this.properties.put("blinking", (Property)new SimpleBooleanProperty(BLINKING));
        return this;
    }

    public final LedBuilder frameVisible(boolean FRAME_VISIBLE) {
        this.properties.put("frameVisible", (Property)new SimpleBooleanProperty(FRAME_VISIBLE));
        return this;
    }

    public final LedBuilder interval(int INTERVAL) {
        this.properties.put("interval", (Property)new SimpleIntegerProperty(INTERVAL));
        return this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final Led build() {
        Led CONTROL = new Led();
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("styleClass".equals(key)) {
                CONTROL.getStyleClass().setAll((Object[])new String[]{"led", (String)((StringProperty)this.properties.get(key)).get()});
                continue;
            }
            if ("ledColor".equals(key)) {
                CONTROL.setLedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("on".equals(key)) {
                CONTROL.setOn(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("blinking".equals(key)) {
                CONTROL.setBlinking(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("interval".equals(key)) {
                CONTROL.setInterval(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"frameVisible".equals(key)) continue;
            CONTROL.setFrameVisible(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

