/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.lcd;

import eu.hansolo.enzo.lcd.Lcd;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;

public class LcdBuilder<B extends LcdBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected LcdBuilder() {
    }

    public static final LcdBuilder create() {
        return new LcdBuilder();
    }

    public final B styleClass(String STYLE_CLASS) {
        this.properties.put("styleClass", (Property)new SimpleStringProperty(STYLE_CLASS));
        return (B)this;
    }

    public final B textMode(boolean TEXT_MODE) {
        this.properties.put("textMode", (Property)new SimpleBooleanProperty(TEXT_MODE));
        return (B)this;
    }

    public final B text(String TEXT) {
        this.properties.put("text", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B value(double VALUE) {
        this.properties.put("value", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B minValue(double MIN_VALUE) {
        this.properties.put("minValue", (Property)new SimpleDoubleProperty(MIN_VALUE));
        return (B)this;
    }

    public final B maxValue(double MAX_VALUE) {
        this.properties.put("maxValue", (Property)new SimpleDoubleProperty(MAX_VALUE));
        return (B)this;
    }

    public final B animated(boolean ANIMATED) {
        this.properties.put("animated", (Property)new SimpleBooleanProperty(ANIMATED));
        return (B)this;
    }

    public final B animationDurationInMs(double ANIMATION_DURATION_IN_MS) {
        this.properties.put("animationDuration", (Property)new SimpleDoubleProperty(ANIMATION_DURATION_IN_MS));
        return (B)this;
    }

    public final B threshold(double THRESHOLD) {
        this.properties.put("threshold", (Property)new SimpleDoubleProperty(THRESHOLD));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B keepAspect(boolean KEEP_ASPECT) {
        this.properties.put("keepAspect", (Property)new SimpleBooleanProperty(KEEP_ASPECT));
        return (B)this;
    }

    public final B noFrame(boolean NO_FRAME) {
        this.properties.put("noFrame", (Property)new SimpleBooleanProperty(NO_FRAME));
        return (B)this;
    }

    public final B backgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.properties.put("backgroundVisible", (Property)new SimpleBooleanProperty(BACKGROUND_VISIBLE));
        return (B)this;
    }

    public final B crystalOverlayVisible(boolean CRYSTAL_OVERLAY_VISIBLE) {
        this.properties.put("crystalOverlayVisible", (Property)new SimpleBooleanProperty(CRYSTAL_OVERLAY_VISIBLE));
        return (B)this;
    }

    public final B mainInnerShadowVisible(boolean MAIN_INNER_SHADOW_VISIBLE) {
        this.properties.put("mainInnerShadowVisible", (Property)new SimpleBooleanProperty(MAIN_INNER_SHADOW_VISIBLE));
        return (B)this;
    }

    public final B foregroundShadowVisible(boolean FOREGROUND_SHADOW_VISIBLE) {
        this.properties.put("foregroundShadowVisible", (Property)new SimpleBooleanProperty(FOREGROUND_SHADOW_VISIBLE));
        return (B)this;
    }

    public final B minMeasuredValueVisible(boolean MIN_MEASURED_VALUE_VISIBLE) {
        this.properties.put("minMeasuredValueVisible", (Property)new SimpleBooleanProperty(MIN_MEASURED_VALUE_VISIBLE));
        return (B)this;
    }

    public final B minMeasuredValueDecimals(int MIN_MEASURED_VALUE_DECIMALS) {
        this.properties.put("minMeasuredValueDecimals", (Property)new SimpleIntegerProperty(MIN_MEASURED_VALUE_DECIMALS));
        return (B)this;
    }

    public final B maxMeasuredValueVisible(boolean MAX_MEASURED_VALUE_VISIBLE) {
        this.properties.put("maxMeasuredValueVisible", (Property)new SimpleBooleanProperty(MAX_MEASURED_VALUE_VISIBLE));
        return (B)this;
    }

    public final B maxMeasuredValueDecimals(int MAX_MEASURED_VALUE_DECIMALS) {
        this.properties.put("maxMeasuredValueDecimals", (Property)new SimpleIntegerProperty(MAX_MEASURED_VALUE_DECIMALS));
        return (B)this;
    }

    public final B lowerCenterText(String LOWER_CENTER_TEXT) {
        this.properties.put("lowerCenterText", (Property)new SimpleStringProperty(LOWER_CENTER_TEXT));
        return (B)this;
    }

    public final B lowerCenterTextVisible(boolean LOWER_CENTER_TEXT_VISIBLE) {
        this.properties.put("lowerCenterTextVisible", (Property)new SimpleBooleanProperty(LOWER_CENTER_TEXT_VISIBLE));
        return (B)this;
    }

    public final B formerValueVisible(boolean FORMER_VALUE_VISIBLE) {
        this.properties.put("formerValueVisible", (Property)new SimpleBooleanProperty(FORMER_VALUE_VISIBLE));
        return (B)this;
    }

    public final B title(String TITLE) {
        this.properties.put("title", (Property)new SimpleStringProperty(TITLE));
        return (B)this;
    }

    public final B titleVisible(boolean TITLE_VISIBLE) {
        this.properties.put("titleVisible", (Property)new SimpleBooleanProperty(TITLE_VISIBLE));
        return (B)this;
    }

    public final B unit(String UNIT) {
        this.properties.put("unit", (Property)new SimpleStringProperty(UNIT));
        return (B)this;
    }

    public final B unitVisible(boolean UNIT_VISIBLE) {
        this.properties.put("unitVisible", (Property)new SimpleBooleanProperty(UNIT_VISIBLE));
        return (B)this;
    }

    public final B lowerRightText(String LOWER_RIGHT_TEXT) {
        this.properties.put("lowerRightText", (Property)new SimpleStringProperty(LOWER_RIGHT_TEXT));
        return (B)this;
    }

    public final B lowerRightTextVisible(boolean LOWER_RIGHT_TEXT_VISIBLE) {
        this.properties.put("lowerRightTextVisible", (Property)new SimpleBooleanProperty(LOWER_RIGHT_TEXT_VISIBLE));
        return (B)this;
    }

    public final B upperLeftText(String UPPER_LEFT_TEXT) {
        this.properties.put("upperLeftText", (Property)new SimpleStringProperty(UPPER_LEFT_TEXT));
        return (B)this;
    }

    public final B upperLeftTextVisible(boolean UPPER_LEFT_TEXT_VISIBLE) {
        this.properties.put("upperLeftTextVisible", (Property)new SimpleBooleanProperty(UPPER_LEFT_TEXT_VISIBLE));
        return (B)this;
    }

    public final B upperRightText(String UPPER_RIGHT_TEXT) {
        this.properties.put("upperRightText", (Property)new SimpleStringProperty(UPPER_RIGHT_TEXT));
        return (B)this;
    }

    public final B upperRightTextVisible(boolean UPPER_RIGHT_TEXT_VISIBLE) {
        this.properties.put("upperRightTextVisible", (Property)new SimpleBooleanProperty(UPPER_RIGHT_TEXT_VISIBLE));
        return (B)this;
    }

    public final B trendVisible(boolean TREND_VISIBLE) {
        this.properties.put("trendVisible", (Property)new SimpleBooleanProperty(TREND_VISIBLE));
        return (B)this;
    }

    public final B trend(Lcd.Trend TREND) {
        this.properties.put("trend", (Property)new SimpleObjectProperty((Object)TREND));
        return (B)this;
    }

    public final B batteryCharge(double BATTERY_CHARGE) {
        this.properties.put("batteryCharge", (Property)new SimpleDoubleProperty(BATTERY_CHARGE));
        return (B)this;
    }

    public final B batteryVisible(boolean BATTERY_VISIBLE) {
        this.properties.put("batteryVisible", (Property)new SimpleBooleanProperty(BATTERY_VISIBLE));
        return (B)this;
    }

    public final B signalStrength(double SIGNAL_STRENGTH) {
        this.properties.put("signalStrength", (Property)new SimpleDoubleProperty(SIGNAL_STRENGTH));
        return (B)this;
    }

    public final B signalVisible(boolean SIGNAL_VISIBLE) {
        this.properties.put("signalVisible", (Property)new SimpleBooleanProperty(SIGNAL_VISIBLE));
        return (B)this;
    }

    public final B alarmVisible(boolean ALARM_VISIBLE) {
        this.properties.put("alarmVisible", (Property)new SimpleBooleanProperty(ALARM_VISIBLE));
        return (B)this;
    }

    public final B thresholdVisible(boolean THRESHOLD_VISIBLE) {
        this.properties.put("thresholdVisible", (Property)new SimpleBooleanProperty(THRESHOLD_VISIBLE));
        return (B)this;
    }

    public final B thresholdBehaviorInverted(boolean THRESHOLD_BEHAVIOR_INVERTED) {
        this.properties.put("thresholdBehaviorInverted", (Property)new SimpleBooleanProperty(THRESHOLD_BEHAVIOR_INVERTED));
        return (B)this;
    }

    public final B numberSystem(Lcd.NumberSystem NUMBER_SYSTEM) {
        this.properties.put("numberSystem", (Property)new SimpleObjectProperty((Object)NUMBER_SYSTEM));
        return (B)this;
    }

    public final B numberSystemVisible(boolean NUMBER_SYSTEM_VISIBLE) {
        this.properties.put("numberSystemVisible", (Property)new SimpleBooleanProperty(NUMBER_SYSTEM_VISIBLE));
        return (B)this;
    }

    public final B titleFont(String TITLE_FONT) {
        this.properties.put("titleFont", (Property)new SimpleStringProperty(TITLE_FONT));
        return (B)this;
    }

    public final B unitFont(String UNIT_FONT) {
        this.properties.put("unitFont", (Property)new SimpleStringProperty(UNIT_FONT));
        return (B)this;
    }

    public final B valueFont(Lcd.LcdFont VALUE_FONT) {
        this.properties.put("valueFont", (Property)new SimpleObjectProperty((Object)VALUE_FONT));
        return (B)this;
    }

    public final B smallFont(String SMALL_FONT) {
        this.properties.put("smallFont", (Property)new SimpleStringProperty(SMALL_FONT));
        return (B)this;
    }

    public final B lcdDesign(Lcd.LcdDesign LCD_DESIGN) {
        this.properties.put("lcdDesign", (Property)new SimpleObjectProperty((Object)LCD_DESIGN));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final Lcd build() {
        Lcd CONTROL = new Lcd();
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("styleClass".equals(key)) {
                CONTROL.getStyleClass().setAll((Object[])new String[]{"lcd", (String)((StringProperty)this.properties.get(key)).get()});
                continue;
            }
            if ("textMode".equals(key)) {
                CONTROL.setTextMode(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("text".equals(key)) {
                CONTROL.setText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("value".equals(key)) {
                CONTROL.setValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minValue".equals(key)) {
                CONTROL.setMinValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxValue".equals(key)) {
                CONTROL.setMaxValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("animated".equals(key)) {
                CONTROL.setAnimated(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("animationDuration".equals(key)) {
                CONTROL.setAnimationDuration(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("threshold".equals(key)) {
                CONTROL.setThreshold(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("decimals".equals(key)) {
                CONTROL.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("keepAspect".equals(key)) {
                CONTROL.setKeepAspect(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("noFrame".equals(key)) {
                CONTROL.setNoFrame(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundVisible".equals(key)) {
                CONTROL.setBackgroundVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("crystalOverlayVisible".equals(key)) {
                CONTROL.setCrystalOverlayVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mainInnerShadowVisible".equals(key)) {
                CONTROL.setMainInnerShadowVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("foregroundShadowVisible".equals(key)) {
                CONTROL.setForegroundShadowVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minMeasuredValueVisible".equals(key)) {
                CONTROL.setMinMeasuredValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minMeasuredValueDecimals".equals(key)) {
                CONTROL.setMinMeasuredValueDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxMeasuredValueVisible".equals(key)) {
                CONTROL.setMaxMeasuredValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxMeasuredValueDecimals".equals(key)) {
                CONTROL.setMaxMeasuredValueDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("formerValueVisible".equals(key)) {
                CONTROL.setFormerValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("title".equals(key)) {
                CONTROL.setTitle((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("titleVisible".equals(key)) {
                CONTROL.setTitleVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("unit".equals(key)) {
                CONTROL.setUnit((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("unitVisible".equals(key)) {
                CONTROL.setUnitVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerCenterText".equals(key)) {
                CONTROL.setLowerCenterText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerCenterTextVisible".equals(key)) {
                CONTROL.setLowerCenterTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerRightText".equals(key)) {
                CONTROL.setLowerRightText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerRightTextVisible".equals(key)) {
                CONTROL.setLowerRightTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("upperLeftText".equals(key)) {
                CONTROL.setUpperLeftText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("upperLeftTextVisible".equals(key)) {
                CONTROL.setUpperLeftTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("upperRightText".equals(key)) {
                CONTROL.setUpperRightText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("upperRightTextVisible".equals(key)) {
                CONTROL.setUpperRightTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("trendVisible".equals(key)) {
                CONTROL.setTrendVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("trend".equals(key)) {
                CONTROL.setTrend((Lcd.Trend)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("batteryCharge".equals(key)) {
                CONTROL.setBatteryCharge(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("batteryVisible".equals(key)) {
                CONTROL.setBatteryVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("signalStrength".equals(key)) {
                CONTROL.setSignalStrength(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("signalVisible".equals(key)) {
                CONTROL.setSignalVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alarmVisible".equals(key)) {
                CONTROL.setAlarmVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("thresholdVisible".equals(key)) {
                CONTROL.setThresholdVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("thresholdBehaviorInverted".equals(key)) {
                CONTROL.setThresholdBehaviorInverted(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("numberSystem".equals(key)) {
                CONTROL.setNumberSystem((Lcd.NumberSystem)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("numberSystemVisible".equals(key)) {
                CONTROL.setNumberSystemVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("unitFont".equals(key)) {
                CONTROL.setUnitFont((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("titleFont".equals(key)) {
                CONTROL.setTitleFont((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("valueFont".equals(key)) {
                CONTROL.setValueFont((Lcd.LcdFont)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("smallFont".equals(key)) {
                CONTROL.setSmallFont((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"lcdDesign".equals(key)) continue;
            CONTROL.setLcdDesign((Lcd.LcdDesign)((Object)((ObjectProperty)this.properties.get(key)).get()));
        }
        return CONTROL;
    }
}

