/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.ledbargraph;

import eu.hansolo.enzo.led.Led;
import eu.hansolo.enzo.ledbargraph.LedBargraph;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Orientation;
import javafx.scene.paint.Color;

public class LedBargraphBuilder<B extends LedBargraphBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected LedBargraphBuilder() {
    }

    public static final LedBargraphBuilder create() {
        return new LedBargraphBuilder();
    }

    public final B noOfLeds(int NO_OF_LEDS) {
        this.properties.put("noOfLeds", (Property)new SimpleIntegerProperty(NO_OF_LEDS));
        return (B)this;
    }

    public final B ledType(Led.LedType LED_TYPE) {
        this.properties.put("ledType", (Property)new SimpleObjectProperty((Object)LED_TYPE));
        return (B)this;
    }

    public final B orientation(Orientation ORIENTATION) {
        this.properties.put("orientation", (Property)new SimpleObjectProperty((Object)ORIENTATION));
        return (B)this;
    }

    public final B peakValueVisible(boolean PEAK_VALUE_VISIBLE) {
        this.properties.put("peakValueVisible", (Property)new SimpleBooleanProperty(PEAK_VALUE_VISIBLE));
        return (B)this;
    }

    public final B ledSize(double LED_SIZE) {
        this.properties.put("ledSize", (Property)new SimpleDoubleProperty(LED_SIZE));
        return (B)this;
    }

    public final B ledColors(Color ... LED_COLORS) {
        this.properties.put("ledColorsArray", (Property)new SimpleObjectProperty((Object)LED_COLORS));
        return (B)this;
    }

    public final B ledColors(LinkedList<Color> LED_COLORS) {
        this.properties.put("ledColorsList", (Property)new SimpleObjectProperty(LED_COLORS));
        return (B)this;
    }

    public final B ledColor(int INDEX, Color COLOR) {
        this.properties.put("ledColorIndex", (Property)new SimpleIntegerProperty(INDEX));
        this.properties.put("ledColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B value(double VALUE) {
        this.properties.put("value", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final LedBargraph build() {
        LedBargraph CONTROL = new LedBargraph();
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("noOfLeds".equals(key)) {
                CONTROL.setNoOfLeds(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("ledType".equals(key)) {
                CONTROL.setLedType((Led.LedType)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("orientation".equals(key)) {
                CONTROL.setOrientation((Orientation)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("peakValueVisible".equals(key)) {
                CONTROL.setPeakValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("ledSize".equals(key)) {
                CONTROL.setLedSize(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("ledColorsArray".equals(key)) {
                CONTROL.setLedColors((Color[])((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("ledColorsList".equals(key)) {
                CONTROL.setLedColors((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("ledColor".equals(key)) {
                CONTROL.setLedColor(((IntegerProperty)this.properties.get("ledColorIndex")).get(), (Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"value".equals(key)) continue;
            CONTROL.setValue(((DoubleProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

