/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.Rexx;
import org.netrexx.process.RxClauseParser;
import org.netrexx.process.RxCode;
import org.netrexx.process.RxConvert;
import org.netrexx.process.RxConverter;
import org.netrexx.process.RxCursor;
import org.netrexx.process.RxError;
import org.netrexx.process.RxExpr;
import org.netrexx.process.RxParser;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxType;
import org.netrexx.process.RxWarn;

public class NrReturn
implements RxClauseParser {
    private static final Rexx $01 = Rexx.toRexx("return");
    private static final Rexx $02 = new Rexx(';');
    private static final String $0 = "NrReturn.nrx";
    private RxTranslator rxt;
    private RxParser parser;
    private RxCursor pcursor;
    private RxToken[] tokens;
    private RxExpr expr;

    public NrReturn(RxTranslator rxTranslator) {
        this.rxt = rxTranslator;
        this.parser = this.rxt.program.parser;
        this.pcursor = this.parser.cursor;
        this.tokens = this.pcursor.curclause.tokens;
    }

    @Override
    public void scan(int n) {
        int n2 = 0;
        RxConvert rxConvert = null;
        if (n < 2) {
            throw new RxQuit(this.rxt, this.tokens[0], "internal.error", Rexx.toRexx("NrReturn"), new Rexx(n));
        }
        RxConverter rxConverter = this.rxt.converter;
        this.parser.thislevel.terminal = true;
        if (this.tokens[1].type == ';') {
            if (!this.pcursor.curmethod.methodrettype.equals(RxType.VOID_TYPE) && !this.pcursor.curmethod.methodconstructor) {
                throw new RxError(this.rxt, this.tokens[1], "return.expression.expected", this.rxt.program.babel.typeString(this.pcursor.curmethod.methodrettype));
            }
            this.expr = null;
            return;
        }
        if (this.pcursor.curmethod.methodconstructor) {
            if (this.tokens[1].type == 'B' && this.tokens[2].type == 'S' && this.parser.iskey(this.tokens[2].value, "THIS")) {
                this.expr = null;
                return;
            }
            throw new RxError(this.rxt, this.tokens[2], "constructor.can.only.return.this");
        }
        n2 = this.tokens[1].type == 'B' ? 2 : 1;
        if (this.pcursor.curmethod.methodrettype.equals(RxType.VOID_TYPE)) {
            throw new RxError(this.rxt, this.tokens[n2], "method.cannot.return.value", Rexx.toRexx(this.pcursor.curmethod.toConciseString()));
        }
        RxCode rxCode = this.rxt.eparser.parseexpr(this.pcursor, false, n2, null, null);
        this.expr = new RxExpr(this.rxt, this.pcursor, 12, rxCode);
        if (this.pcursor.curmethod.methodrettype.equals(rxCode.type)) {
            rxConvert = null;
        } else {
            rxConvert = rxConverter.assigncost(this.pcursor, this.pcursor.curmethod.methodrettype, rxCode.type);
            if (rxConvert.cost > this.rxt.program.flag.maxassign) {
                throw new RxError(this.rxt, this.tokens[n2], "cannot.assign.to.return.type", this.rxt.program.babel.typeString(rxCode.type), this.rxt.program.babel.typeString(this.pcursor.curmethod.methodrettype));
            }
            rxConverter.convertcode(this.pcursor, this.pcursor.curmethod.methodrettype, rxConvert.proc, rxCode);
        }
        this.expr.type = this.pcursor.curmethod.methodrettype;
        this.expr.conv = rxConvert;
    }

    @Override
    public String[] getAssigns() {
        return null;
    }

    @Override
    public void generate() {
        if (this.expr == null) {
            this.rxt.program.streamer.out(Rexx.toRexx("return;"));
        } else {
            this.rxt.program.streamer.out($01.OpCcblank(null, this.expr.code.javacode).OpCc(null, $02));
        }
    }

    @Override
    public void interpret(RxCursor rxCursor) {
        RxCode rxCode = null;
        if (rxCursor.curacttype == 1) {
            new RxWarn(this.rxt, this.tokens[0], "return.already.active");
        }
        if (this.expr != null) {
            rxCode = this.expr.evaluate(rxCursor);
            rxCursor.curreturn = rxCode.value;
        }
        rxCursor.curact = true;
        rxCursor.curacttype = 1;
    }
}

